/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <stdlib.h>
#include <xpl.h>

#include <mwtempl.h>
#include <webadmin.h>

#include <mdb.h>

#include <wastdobj.tok>
#include <wastdobj.ary>

WAAPIDefine;

/* General stuff */
struct {
    BOOL unload;

    struct {
        XplThreadID main;
        XplThreadID group;
    } id;

    struct {
        XplSemaphore shutdown;
    } sem;
} WAStandardObject;

/*
    prototypes for registration functions
*/
unsigned long WASTDOBJSaveGroupFunc(SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, unsigned char *Name, unsigned char *Value, void *ModuleData);
unsigned long WASTDOBJSaveUserFunc(SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, unsigned char *Name, unsigned char *Value, void *ModuleData);
unsigned long WASTDOBJUserCreateFunc(SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *ObjectName, const unsigned char *ParentDN, MDBValueStruct *Name, MDBValueStruct *Value, void *ModuleData);

/* Save handling for group object */
unsigned long
WASTDOBJSaveGroupFunc(SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, unsigned char *Name, unsigned char *Value, void *ModuleData)
{
    if (!Name || !Value) {
        return(0);
    }

    switch (toupper(Name[0])) {
        case 'G':    {                            /* Group Membership */
            unsigned char        *ptr = Value;
            unsigned char        *ptr2;
            unsigned char        ObjectBuffer[MDB_MAX_OBJECT_CHARS+1];

            /* Since we will be rewriting all the groups, remove them all first */
            if (MDBReadDN(DN, A_MEMBER, Session->V)) {
                unsigned long        i;

                for (i = 0; i < Session->V->Used; i++) {
                    MDBRemoveDN(Session->V->Value[i], A_GROUP_MEMBERSHIP, DN, Session->V);
                }
                MDBFreeValues(Session->V);

                MDBClear(DN, A_MEMBER, Session->V);
            }

            if (Value && *Value) {
                do {
                    ptr2 = strchr(ptr, '\n');
                    if (ptr2) {
                        ptr2[0] = '\0';
                        if (ptr2[-1] == '\r') {
                            ptr2[-1] = '\0';
                        }
                    }

                    WAX500toMDB(ptr, ObjectBuffer, Session->V);
                    if (MDBAddDN(ObjectBuffer, A_GROUP_MEMBERSHIP, DN, Session->V)) {
                        MDBAddDN(DN, A_MEMBER, ObjectBuffer, Session->V);
                    }

                    if (ptr2) {
                        ptr = ptr2 + 1;
                    } else {
                        ptr = NULL;
                    }
                } while (ptr);
            }
        }
    }
    return(WAERR_SHOW_SUCCESS);
}

/* Save handling for user object */
unsigned long
WASTDOBJSaveUserFunc(SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *DN, unsigned char *Name, unsigned char *Value, void *ModuleData)
{
    if (!Name || !Value) {
        return(0);
    }

    switch (toupper(Name[0])) {
        case 'G':    {                            /* Group Membership */
            unsigned char        *ptr = Value;
            unsigned char        *ptr2;
            unsigned char        ObjectBuffer[MDB_MAX_OBJECT_CHARS+1];

            /* Since we will be rewriting all the groups, remove them all first */
            if (MDBReadDN(DN, A_GROUP_MEMBERSHIP, Session->V)) {
                unsigned long        i;

                for (i = 0; i < Session->V->Used; i++) {
                    MDBRemoveDN(Session->V->Value[i], A_MEMBER, DN, Session->V);
                }
                MDBFreeValues(Session->V);

                MDBClear(DN, A_GROUP_MEMBERSHIP, Session->V);
            }

            if (Value && *Value) {
                do {
                    ptr2 = strchr(ptr, '\n');
                    if (ptr2) {
                        ptr2[0] = '\0';
                        if (ptr2[-1] == '\r') {
                            ptr2[-1] = '\0';
                        }
                    }

                    WAX500toMDB(ptr, ObjectBuffer, Session->V);
                    if (MDBAddDN(ObjectBuffer, A_MEMBER, DN, Session->V)) {
                        MDBAddDN(DN, A_GROUP_MEMBERSHIP, ObjectBuffer, Session->V);
                    }

                    if (ptr2) {
                        ptr = ptr2 + 1;
                    } else {
                        ptr = NULL;
                    }
                } while (ptr);
            }
        }
    }
    return(WAERR_SHOW_SUCCESS);
}

/* Create a user object */
unsigned long    
WASTDOBJUserCreateFunc(SessionStruct *Session, const unsigned char *ObjectClass, const unsigned char *ObjectName, const unsigned char *ParentDN, MDBValueStruct *Name, MDBValueStruct *Value, void *ModuleData)
{
    MDBValueStruct    *AttrName;
    MDBValueStruct    *AttrValue;
    unsigned long    RetVal = WAERR_SHOW_SUCCESS;
    unsigned long    i;
    unsigned char    *Password = NULL;
    unsigned char    *SurName = NULL;
    unsigned char    *FullName = NULL;
    unsigned char    *FirstName = NULL;

    BOOL                PasswordsMatch = FALSE;

    AttrName = MDBCreateValueStruct(Session->AuthHandle, ParentDN);
    AttrValue = MDBShareContext(AttrName);

    for (i = 0; i < Name->Used; i++) {
        if (WAQuickCmp(Name->Value[i], "FullName")) {
            if (Value->Value[i][0] != '\0') {
                if (FullName) {
                    free(FullName);
                    FullName = NULL;
                }
                FullName = strdup(Value->Value[i]);
            }
	} else if (WAQuickCmp(Name->Value[i], "SurName")) {
            if (Value->Value[i][0] != '\0') {
                if (SurName) {
                    free(SurName);
                    SurName = NULL;
                }
                SurName = strdup(Value->Value[i]);
            }
	} else if (WAQuickCmp(Name->Value[i], "FirstName")) {
            if (Value->Value[i][0] != '\0') {
                if (FirstName) {
                    free(FirstName);
                    FirstName = NULL;
                }
                FirstName = strdup(Value->Value[i]);
            }
        } else if ((Name->Value[i][0] == 'S') && (Name->Value[i][0] == '-')) {
            MDBAddStringAttribute(Name->Value[i] + 2, Value->Value[i], AttrName, AttrValue);
        } else if ((Name->Value[i][0]=='D') && (Name->Value[i][0] == '-')) {
            MDBAddDNAttribute(Name->Value[i] + 2, Value->Value[i], AttrName, AttrValue);
        } else if (toupper(Name->Value[i][0]) == 'P') {
            if (!Password) {
                if (Value->Value[i][0] != '\0') {
                    Password = strdup(Value->Value[i]);
                }
            } else {
                if (Value->Value[i][0] != '\0') {
                    if (strcmp(Password, Value->Value[i]) == 0) {
                        PasswordsMatch = TRUE;
                    }
                }
            }
        }
    }

    if (FullName) {
        unsigned char        *ptr;

        /* Build a last name to give to MDB */
        ptr=strrchr(FullName, ' ');
        if (ptr && *(ptr + 1)) {
            MDBAddStringAttribute(A_FULL_NAME, ptr+1, AttrName, AttrValue);
        } else {
            if (FullName[0]!='\0') {
                MDBAddStringAttribute(A_FULL_NAME, FullName, AttrName, AttrValue);
            } else {
                MDBAddStringAttribute(A_FULL_NAME, " ", AttrName, AttrValue);
            }
        }
    }

    /* Make sure that the User Name was entered */
    if (WAQuickCmp(ObjectName, "\001")) {
        RetVal = WAERR_MISSING_NAME; 
    }

    if (!SurName) {
        RetVal = WAERR_FULLNAME_REQUIRED;
    } else {
        unsigned char        *ptr;

        /* Build a last name to give to MDB */

        /* if we find a comma, the name format is assumed to be "Bartok, Peter", otherwise it's "Peter Bartok" */
        if ((ptr = strchr(SurName, ',')) != NULL) {
            ptr[0]='\0';
            MDBAddStringAttribute(A_SURNAME, SurName, AttrName, AttrValue);
            ptr[0]=',';
        } else {
            ptr=strrchr(SurName, ' ');
            if (ptr && *(ptr + 1)) {
                MDBAddStringAttribute(A_SURNAME, ptr+1, AttrName, AttrValue);
            } else {
                if (SurName[0]!='\0') {
                    MDBAddStringAttribute(A_SURNAME, SurName, AttrName, AttrValue);
                } else {
                    MDBAddStringAttribute(A_SURNAME, " ", AttrName, AttrValue);
                }
            }
        }
    }
    if (FirstName) {
       /* Build a first name to give to MDB */
       MDBAddStringAttribute(A_GIVEN_NAME,FirstName, AttrName, AttrValue);
    }

    if (RetVal == WAERR_SUCCESS || RetVal == WAERR_SHOW_SUCCESS) {
#if 0
        if (!Password) {
            PasswordsMatch = TRUE;
        }
#endif

        if (PasswordsMatch) {
            if (strlen(ObjectName) <= 63) {
                if (!MDBCreateObject(ObjectName, ObjectClass, AttrName, AttrValue, AttrName)) {
                    RetVal = WAERR_OBJECT_NOT_CREATED;
                }

                if (Password) {
                    MDBChangePasswordEx(ObjectName, "", Password, AttrName);
                }
            } else {
                RetVal = WAERR_ILLEGAL_NAME;
            }
        } else {
            RetVal = WAERR_PASSWORDS_DONT_MATCH;
        }
    } 

    /* Make sure we have the names right */
    MDBFreeValues(AttrName);

    if (RetVal == WAERR_SUCCESS || RetVal == WAERR_SHOW_SUCCESS) {
        if (FullName) {
            /* Just add the full name */

            MDBAddValue(FullName, AttrName);
            MDBWrite(ObjectName, A_FULL_NAME, AttrName);
            MDBFreeValues(AttrName);
        }
    }

    /* Mop up */
    if (FullName) {
        free(FullName);
    }
    if (SurName) {
        free(SurName);
    }
    if (FirstName) {
        free(FirstName);
    }
    if (Password) {
        free(Password);
    }

    MDBDestroyValueStruct(AttrValue);
    MDBDestroyValueStruct(AttrName);

    if (RetVal == WAERR_SUCCESS) {
        RetVal = WAERR_SHOW_SUCCESS;
    }    
    return(RetVal);
}

/************************************************************************
    Now comes the "stock" stuff any modweb module needs
*************************************************************************/

EXPORT BOOL
LIBWASTDOBJInit(WAAPIArg)
{
    ModuleRegisterStruct    Register;

    WAStandardObject.unload = FALSE;

    WAAPISet;

    /* Register user handler */
    memset(&Register, 0, sizeof(ModuleRegisterStruct));
    Register.ModuleType                            = MODULE_OBJECT;
    Register.Module.Object.ObjectClass        = C_USER;
    Register.Module.Object.Flags                = WAOBJ_PRIMARY_HANDLER;
    Register.Module.Object.CreateFunction    = WASTDOBJUserCreateFunc;
    WARegisterModule(&Register);

    memset(&Register, 0, sizeof(ModuleRegisterStruct));
    Register.ModuleType                            = MODULE_SAVE;
    Register.Module.Save.ObjectClass            = C_USER;
    Register.Module.Save.SaveFunction        = WASTDOBJSaveUserFunc;
    WARegisterModule(&Register);

    memset(&Register, 0, sizeof(ModuleRegisterStruct));
    Register.ModuleType                            = MODULE_SAVE;
    Register.Module.Save.ObjectClass            = C_GROUP;
    Register.Module.Save.SaveFunction        = WASTDOBJSaveGroupFunc;
    WARegisterModule(&Register);

    return(TRUE);
}

EXPORT BOOL
LIBWASTDOBJShutdown(void)
{
    WAStandardObject.unload = TRUE;
    return(TRUE);
}

/************************************************************************
    Below are all the things that make loading and unloading possible :-)
*************************************************************************/

#if defined(NETWARE) || defined(LIBC)
int
RequestUnload(void)
{

    if (!WAStandardObject.unload) {
        int    OldTGid;

        OldTGid=XplSetThreadGroupID(WAStandardObject.id.group);

        XplConsolePrintf("\rThis NLM will automatically be unloaded by the thread that loaded it.\n");
        XplConsolePrintf("\rIt does not allow manual unloading.\n");
        SetCurrentScreen(CreateScreen("System Console", 0));
        XplUngetCh('n');

        XplSetThreadGroupID(OldTGid);

        return(1);
    }

    return(0);
}


void
WAStdObjSigHandler(int Signal)
{
    int    OldTGid;

    OldTGid=XplSetThreadGroupID(WAStandardObject.id.group);

    XplSignalLocalSemaphore(WAStandardObject.sem.shutdown);    /* The signal will release main() */
    XplWaitOnLocalSemaphore(WAStandardObject.sem.shutdown);    /* The wait will wait until main() is gone */

    /* Do any required cleanup */
    
    XplCloseLocalSemaphore(WAStandardObject.sem.shutdown);
    XplSetThreadGroupID(OldTGid);
}


int
main(int argc, char *argv[])
{
    WAStandardObject.unload = TRUE;
    WAStandardObject.id.group = XplGetThreadGroupID();

    signal(SIGTERM, WAStdObjSigHandler);

    MDBInit();

    XplOpenLocalSemaphore(WAStandardObject.sem.shutdown, 0);
    XplWaitOnLocalSemaphore(WAStandardObject.sem.shutdown);
    XplSignalLocalSemaphore(WAStandardObject.sem.shutdown);
    return(0);
}
#endif
