#ifndef _HASHMGR_HXX_
#define _HASHMGR_HXX_

#include "htypes.hxx"

enum flag { FLAG_CHAR, FLAG_LONG, FLAG_NUM };

class HashMgr
{
  int             tablesize;
  struct hentry * tableptr;
  int	          userword;
  flag            flag_mode;

public:
  HashMgr(const char * tpath, const char * apath);
  ~HashMgr();

  struct hentry * lookup(const char *);
  int hash(const char *);
  struct hentry * walk_hashtable(int & col, struct hentry * hp) const;

  int put_word(const char * word, int wl, char * ap);
  int put_word_pattern(const char * word, int wl, const char * pattern);
  int decode_flags(unsigned short ** result, char * flags);
  unsigned short        decode_flag(const char * flag);
  char *                encode_flag(unsigned short flag);
  
private:
  int load_tables(const char * tpath);
  int add_word(const char * word, int wl, unsigned short * ap, int al, const char * desc);
  int load_config(const char * affpath);

};

#endif
