#ifndef _SUGGESTMGR_HXX_
#define _SUGGESTMGR_HXX_

#define MAXSWL 100
#define MAXACCENT 5
#define MAX_ROOTS 10
#define MAX_WORDS 500
#define MAX_GUESS 10

#define NGRAM_IGNORE_LENGTH 0
#define NGRAM_LONGER_WORSE  1
#define NGRAM_ANY_MISMATCH  2

#include "atypes.hxx"
#include "affixmgr.hxx"
#include "hashmgr.hxx"
#include "langnum.hxx"

class SuggestMgr
{
  char *          ctry;
  int             ctryl;
  w_char *        ctry_utf;

  AffixMgr*       pAMgr;
  int             maxSug;
  int		  cpdsuggest; // XXX not stateless
  int checknum;
  struct cs_info * csconv;
  int             nosplitsugs;
  int             nomapsugs;
 
public:
  SuggestMgr(const char * tryme, int maxn, AffixMgr *aptr);
  ~SuggestMgr();

  int suggest(char*** slst, const char * word, int nsug);
  int ngsuggest(char ** wlst, char * word, HashMgr* pHMgr);
  int suggest_auto(char*** slst, const char * word, int nsug);
  int suggest_stems(char*** slst, const char * word, int nsug);
  int suggest_pos_stems(char*** slst, const char * word, int nsug);
  int check(const char *, int);
  int check_forbidden(const char *, int);

  char * suggest_morph(const char * word);
  char * suggest_morph_for_spelling_error(const char * word);

private:
   int replchars(char**, const char *, int);
   int doubledsyllable(char**, const char *, int);
   int permuteaccent(char **, char *, int, int, int, replentry *, int);
   int forgotaccent(char **, const char *, int);
   int forgotchar(char **, const char *, int);
   int swapchar(char **, const char *, int);
   int extrachar(char **, const char *, int);
   int badchar(char **, const char *, int);
   int twowords(char **, const char *, int);
   int fixstems(char **, const char *, int);

   int forgotchar_utf(char**, const w_char *, int wl, int);
   int extrachar_utf(char**, const w_char *, int wl, int);
   int badchar_utf(char **, const w_char *, int wl, int);
   int swapchar_utf(char **, const w_char *, int wl, int);

   int mapchars(char**, const char *, int);
   int map_related(const char *, int, char ** wlst, int, const mapentry*, int);
   int ngram(int n, char * s1, const char * s2, int uselen);
   void bubblesort( char ** rwd, int * rsc, int n);

};

#endif

