#define version "2.6; Jul 20 1990"
/*
 * Enhanced dd, Double bufferrd.
 * 
 * (C) Copyright 1989 SAITOH,Akinori saitoh@osaka-u.ac.jp 
 *
 * Permit anyone to use, modify, re-distribute this software.
 * $B$3$N%=%U%H%&%'%"$r:#8eL54|8B$K<+M3$KMxMQ!"2~B$!":FG[I[$9$k;v$r5v$7$^(B
 * $B$9!#(B
 * $B$3$N%=%U%H%&%'%"$O!"(BAT&T System V $B5Z$S(BUCB 4.3BSD $B$N%=!<%9%3!<%I%i%$%;(B
 * $B%s%9$r<hF@$7$F$$$k7W;;5!$r;H$C$F3+H/$7$^$7$?!#$7$+$7!"$3$N%=%U%H%&%'(B
 * $B%"$O!"(BAT&T ,BSD $B$K8B$i$:!"B><T$NCx:n8"$,5Z$V%=!<%9%W%m%0%i%`$OMxMQ$7(B
 * $B$F$$$^$;$s!#(B
 * ver 2.0  Sat Jan  6  1990
 * correct termination protocol to shut up illegal error message
 * ver 2.1  Tue Jan  9 1990
 * Bug fix
 * Ver 2.2 Thu Apr 12 1990
 * System V port
 * On BSD or SUN OS: cc edd.c -o edd
 * On System V : cc -DSYSV -DNBPG=4096 edd.c -o edd.c 
 * 4096 should be changed to your virtual memory page size
 * ver 2.3 Jun  24 1990; bug(hung on abort) fix + message change
 * ver 2.4 Jul 4   1990; add bytes report;
 * ver 2.5 Jul 5   1990; fake SUN rst media end
 * ver 2.6 Jul 20  1990; add padunit option
 */
static char *copyright[]={
"(C) Copyright 1989 SAITOH,Akinori saitoh@ics.osaka-u.ac.jp\n",
"Permit anyone to use, modify, re-distribute this software.\n"};

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#ifdef SYSV
#include <fcntl.h>
#include <string.h>
#else
#include <sys/file.h>
#include <strings.h>
#endif
#include <sys/errno.h>
extern int errno;


usage(s)
	char           *s;
{
	fputs(s,stderr);
	fprintf(stderr,"edd version %s\n",version);
	fputs(
"edd [if=file] [of=file] [ibs=inblk] [obs=outblk] [bs=bufsiz] \\\n\
\t[pad] [padunit=unit] [rewind] [volume=size] [concat=n]\n",
stderr);
	fputs("Obs must be a multiple of ibs.\n", stderr);
	xerror(s);
}

extern char    *valloc();	/* page aligned alloc */
char           *databuf;
int             infd = 0, outfd = 1, volcount = 0, involcount=0, notty;
int             pipein = -1, pipeout = -1, parent = -1;
FILE           *ftty;
int		inbytes=0,outbytes=0;

#define WHOAMI (parent ? "parent" : "child")
#define IN_OK 'I'
#define OUT_OK 'O'
#define EOF_APPEAR 'E'

/* int buffer= 0; */
long	obs = 0, ibs = 0, bs = 0;
int	concat = 1, verbose = 0, noss=0;
unsigned long volume = 0;
int	bunit;
char	*infile = NULL;
char	*outfile = NULL;
char	*inproc = NULL;
char	*outproc = NULL;
int	rewindtape = 0;
int	dopadding = 0;
int	padunit = 0;

#define INFILE ((infile==NULL)?"stdin":infile)
#define OUTFILE ((outfile==NULL)?"stdout":outfile)

struct {
	char           *name;
	enum { NUM, STR, BOOL }attrib;
	char           *objptr;
}options[] = {
{ "of", STR, (char *) &outfile },
{ "if", STR, (char *) &infile },
{ "op", STR, (char *) &outproc },
{ "ip", STR, (char *) &inproc },
{ "obs", NUM, (char *) &obs },
{ "ibs", NUM, (char *) &ibs },
{ "bs", NUM, (char *) &bs },
{ "concat", NUM, (char *) &concat },
{ "volume", NUM, (char *) &volume },
{ "verbose", BOOL, (char *) &verbose },
{ "noss", BOOL, (char *) &noss },
{ "rewind", BOOL, (char *) &rewindtape },
{ "pad", BOOL, (char *) &dopadding },
{ "padunit", NUM, (char *) &padunit },
{ "", NUM, NULL },
};

#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

char *progname;

main(argc, argv)
	int             argc;
	char           *argv[];
{
	int i;
	char *s;

	progname=argv[0];
	while((s=index(progname, '/'))!=NULL)
		progname= s+1;
	if(argc<2)
		usage("");
	notty = 0;
	setbuf(stderr,NULL);
	if ((ftty = fopen("/dev/tty", "r")) == NULL) {
		notty = 1;
		if ((ftty = fopen("/dev/null", "r")) == NULL) {
			perror("/dev/null");
			xerror("/dev/null open failed\n");
		}
	} else if (freopen("/dev/tty", "w", stderr) == NULL) {
		perror("/dev/tty");
		xerror("control tty open failed\n");
	}
	argparse(argc, argv);
	optioncheck();
	if (volume == 0) {
		volume = (1024 * 1024 * 1024) / bs;
		volume *= bs;
	}
	if ((databuf = valloc((unsigned) bs)) == NULL) {
		xerror("can not alloc buffer\n");
	}
	if (verbose) {
		fprintf(stderr, "ibs=%db obs=%db bs=%db\n",
			ibs / 512, obs / 512, bs / 512);
	}
	signal(SIGPIPE, SIG_IGN);
	volcount = 1;
	involcount = 1;
	if (infile != NULL)
		openinput();
	if (infd < 0)
		xerror("input open failed\n");
	if(outfile != NULL)
		outfd = -1;
	else
		outfd = 1;
	for (; concat > 0;) {
		register int    nin, nout;
		register unsigned long   ebs,rest;

		if (infd <0 ) {
			involcount++;
			openinput();
			inbytes=0;
			if (infd < 0)
				xerror("input open failed\n");
		}
		if (outfd <0 ) { /* end of out volume */
			openoutput();
			outbytes=0;
		}
		setup_pipe();
		bzero(databuf, bs);
		if( noss)
			ebs = bs ;
		else {
			for(ebs=bunit; ebs < bs/16;ebs *= 2)
				;
		}
		for (rest = volume; rest > 0;) {
			if( ebs > bs)
				ebs = bs;
			if(!parent) {
				inbytes += ebs;
				outbytes += ebs;
			}
			if (get_token(IN_OK, EOF_APPEAR)== EOF_APPEAR) {
				nin=0;
				if(!parent)
					break;
				/* wait child writecomplete */
				(void)get_token(OUT_OK,OUT_OK); 
				break;
			}
			nin = fillbuffer(infd, databuf, ebs, ibs);

			if (nin < 0) {
				if( rest < volume)
					xerror("read error\n");
				/* fake eof */
				put_token( EOF_APPEAR);
				goto read_error_at_top;
			}
			inbytes += nin;
			if (nin == 0 && rest == volume && inproc!=NULL){
				fprintf(stderr,
					"%s:%s:Got null input from program\n",progname,
						progname);
				/* fake eof */
				put_token( EOF_APPEAR);
				goto read_error_at_top;
			}
			if (verbose) {
				fprintf(stderr, "%s:%s:got %d bytes\n",progname,
					WHOAMI , nin);
			}
			if( nin==ebs && rest >0)  /* not outvolume end */
				put_token(IN_OK );
			else {
				if (!parent)
					put_token( EOF_APPEAR);
				if(ftty != NULL)
					fprintf(stderr,"%d blks+%d bytes in\n",
						inbytes / ibs, inbytes % ibs);
			}
			if (nin >= 0) {
				if(nin % obs) {
					bzero(databuf+nin,obs-(nin%obs));
				}
				(void)get_token(OUT_OK,OUT_OK);
				nout = ewrite(outfd, databuf, nin, obs);
				if( nout <0) {	
					if(ftty != NULL)
					fprintf(stderr,"%d blks+%d bytes out\n",
						outbytes / obs, outbytes % obs);
					xerror("aborting\n");
				}
				if(( nin==ebs && rest>0) || !parent)
					put_token(OUT_OK);
				if (verbose) {
					fprintf(stderr, "%s:%s:wrote %d bytes\n",
					 progname, WHOAMI, nout);
					fflush(stderr);
				}
				outbytes += nout;
				if(nout < nin) {
					if( parent  && rest>0)
						break;
				}
			}
			if (nin < ebs) {
				if(ftty != NULL)
					fprintf(stderr,"%d blks+%d bytes out\n",
						outbytes / obs, outbytes % obs);
				break;
			}
			if (parent) {
				rest -= 2*ebs;
			}
			if(parent) {
				inbytes += ebs;
				outbytes += ebs;
			}
			ebs *= 2;
		}
		if(nout <nin && parent && rest>0 && nin==bs ) {
			get_token(IN_OK, EOF_APPEAR);
			(void)get_token(OUT_OK,OUT_OK);
			concat=0;
			if(inproc!=NULL)
				xerror("output write error");
		}
		if (!parent) 
			child_exit(0);
		if(nin != bs) { /* input eof */
			closeinput();
			infd = -1;
			concat--;
		}
		if(rest<=0 || concat<=0 ) { /* end of out volume */
			closeoutput();
			outfd = -1;
			volcount++;
		}
		disconnect_child();
		continue;

read_error_at_top:
		disconnect_child();
		reopeninput();
		inbytes=0;
	}
	close(pipein);
	close(pipeout);
	if (parent)
		wait(0);
	exit(0);
}

disconnect_child()
{
	put_token( EOF_APPEAR);
	close(pipein);
	close(pipeout);
	{
		int             st;
		while ((st = wait(0)) > 0 && st != parent);
	}
}

child_exit(e)
{
	if (verbose)
		fprintf(stderr, "%s:child pid=%d: exiting\n",progname, getpid());
		/* wait parent done */
	if(get_token(EOF_APPEAR, -1) == EOF_APPEAR)
		(void)get_token(EOF_APPEAR, -1);
	if (verbose)
		fprintf(stderr, "%s:child pid=%d: exit\n",progname, getpid());
	exit(e);
}

optioncheck()
{
	long i;

	if(inproc != NULL ) {
		infile = inproc;
	}
	if ((infile == NULL) && (concat != 1)) {
		xerror("Can not concat stdin");
	}
	if(outproc != NULL ) {
		outfile = outproc;
	}
	if ((outfile == NULL) && (volume != 0)) {
		xerror("Can not split stdout");
	}
	if (concat < 1)
		xerror("Illegai concat value");
	if (bs <= 0) {
		bs = MAX(ibs, obs);
	}
	if (ibs <= 0) {
		ibs = obs > 0 ? obs : bs;
	}
	if (obs <= 0) {
		obs = ibs > 0 ? ibs : bs;
	}
	if (bs <= 0 || bs < obs || bs < ibs)
		usage("Illegal buffersize\n");
	if (ibs <= 0)
		usage("illegal ibs\n");
	if (obs <= 0)
		usage("illegal obs\n");
	{
	int x,y;
	
	x=ibs;
	y=obs;
	while(x != y)
		if( x>y)
			x -= y;
		else
			y -= x;
	bunit = ( ibs / x) * obs ;
	}
	if( bs % ibs ||   bs % obs ) {
		bs=((bs/bunit)+1)*bunit;
		fprintf(stderr,"%s:Buffer size rounded up to %d\n",progname,bs);
	}
	if (bs % ibs) {
		usage("bs bust be a multiple of ibs\n");
	}
	if (bs % obs) {
		usage("bs bust be a multiple of obs\n");
	}
	if ( dopadding && padunit == 0)
		padunit = obs;
}

/*
 * read(infd) (ibs * count)bytes try to get ibs bytes on each read except
 * last flagment.
 * 
 * return:	read BYTES if no error -1 on read error
 */
fillbuffer(infd, buf, bytes, ibs)
	char           *buf;
	register        bytes, ibs;
{
	register char  *bufp;
	register int    n;

	for (bufp = buf; bytes > 0;) {
		n = read(infd, bufp, bytes < ibs ? bytes : ibs);
		if (n < 0) {
			char msg[BUFSIZ];
			sprintf(msg,"%s:%s read %s",progname,WHOAMI,INFILE);
			perror(msg);
			break;
		}
		if (n == 0)
			break;
		bufp += n;
		bytes -= n;
	}
	if (n >= 0 || buf != bufp)
		return (bufp - buf);
	else
		return -1;
}

closeinput()
{
	if (verbose) {
		fprintf(stderr, "%s:%s:closing input\n",progname, parent ? "parent" : "child");
		fflush(stderr);
	}
	if (infile == NULL)
		return;
	if (close(infd) < 0 && parent)
		perror("close");
	if ( inproc !=NULL ) {
		int             st;
		st = wait(0) ;
	}
	if (!rewindtape || !parent)
		return;
	if ((infd = open(infile, O_RDONLY)) >= 0)
		close(infd);
}

closeoutput()
{
	if (verbose) {
		fprintf(stderr, "%s:%s:closing output\n",
		progname, parent ? "parent" : "child");
		fflush(stderr);
	}
	if (outfile == NULL)
		return;
	if (close(outfd) < 0 && parent)
		perror("close");
	if (!rewindtape || !parent)
		return;
	if ((outfd = open(outfile, O_RDONLY)) >= 0)
		close(outfd);
}

reopenoutput()
{
	closeoutput();
	fprintf(stderr, "%s:write error on the top of media\n",progname);
	fprintf(stderr, "%s:remount and try again\n",progname);
	return (openoutput());

}

reopeninput()
{
	closeinput();
	fprintf(stderr, "%s:read error on top of media\n",progname);
	fprintf(stderr, "%s:remount and try again\n",progname);
	return (openinput());

}

askyes(msg)
	char           *msg;
{
	char            s[BUFSIZ];
	if (notty)
		return -1;
	for (;;) {
		fprintf(stderr, "%s\n", msg);
		fprintf(stderr, "OK? (y/n/q)");
		fflush(stderr);
		if (s != fgets(s, BUFSIZ - 1, ftty)) {
			perror("control tty read");
			xerror("job aborting");
		}
		if (*s == 'y' || *s == 'Y')
			return 0;
		if (*s == 'q' || *s == 'Q') {
			if(parent>0) /* kill child */
				kill(parent, SIGKILL);
			xerror("abort\n");
		}
	}
}

openoutput()
{
	char            s[BUFSIZ];

	if (outfile == NULL)
		return 1;
	sprintf(s, "%s:mount %d%s volume on %s\n",progname
		,volcount
		,volcount < 3 ? (volcount == 1 ? "st" : "nd")
		: (volcount == 3 ? "rd" : "th"), outfile);
	if (!notty && volcount > 1)
		askyes(s);
	for (;; askyes(s)) {
		if (rewindtape) {
			if ((outfd = open(outfile, O_RDWR)) > 0)
				close(outfd);
			else {
				perror(outfile);
				if (!notty)
					continue;
			}
		}
		if(outproc!=NULL)
			outfd=procopen(outproc,"w");
		else
		    outfd = open(outfile, O_WRONLY|O_CREAT|O_TRUNC|O_APPEND, 0777);
		if (outfd <0) {
			perror(outfile);
		} else {
			return outfd;
		}
		if (notty)
			xerror("job aborted\n");
	}
}

procopen(prog,rw)
	char *prog;
	char *rw;
{
	int p[2];
	int pid;

	if(pipe(p)<0)
		return -1;
	if((pid=fork())<0)
		return -1;
	if(pid==0) {
		if(*rw == 'w') {
			close(0);
			dup(p[0]);
			close(p[1]);
			close(p[0]);
			close(1);
			open("/dev/null",O_WRONLY);
		} else {
			close(1);
			dup(p[1]);
			close(p[1]);
			close(p[0]);
			close(0);
			open("/dev/null",0);
		}
		execl("/bin/sh","sh","-c",prog,0);
		perror("exec");
		exit(1);
	}
	if(*rw == 'w') {
		close(p[0]);
		return(p[1]);
	} else {
		close(p[1]);
		return(p[0]);
	}
}

setup_pipe()
{
	int             p1[2], p2[2];
	if (pipe(p1) < 0 || pipe(p2) < 0) {
		perror("pipe");
		xerror("");
	}
	if ((parent = fork()) < 0) {
		perror("fork");
		xerror("");
	}
	if (parent) {
		if (verbose)
			fprintf(stderr, "%s:forked child %d\n",progname, parent);
		close(p1[0]);
		pipeout = p1[1];
		pipein = p2[0];
		close(p2[1]);
	} else {
		static char     s[2] = {IN_OK, OUT_OK};
		fclose(ftty);
		if (!notty) {
			freopen("/dev/tty", "w", stderr);
		}
		pipein = p1[0];
		close(p1[1]);
		close(p2[0]);
		pipeout = p2[1];
		if (write(pipeout, s, 2) != 2) {
			perror("child cntrl pipe write");
			xerror("");
		}
	}
}

openinput()
{
	char            s[BUFSIZ];

	if (infile == NULL)
		return (0);
	sprintf(s, inproc==NULL ? 
	"%s:mount %d%s volume on %s\n" : "%s:%d%s invocation of '%s'\n"
		,progname
		,involcount
		,involcount < 3 ? (involcount == 1 ? "st" : "nd")
		: (involcount == 3 ? "rd" : "th")
		,infile);
	if (!notty && involcount > 1 )
		askyes(s);
	for (;; askyes(s)) {
		if (rewindtape) {
			if ((infd = open(infile, O_RDONLY)) < 0) {
				perror(infile);
				if (notty)
					break;
				else
					continue;
			}
			close(infd);
		}
		if(inproc != NULL ) 
			infd=procopen(inproc,"r");
		else
			infd = open(infile, O_RDONLY);
		if(infd>0)
			break;
		perror(infile);
		if (notty)
			break;
	}
	if(infd <0)
		xerror("job aborted\n");
	return (infd);
}

numparse(str)
	char           *str;
{
	register char  *s = str;
	register int    i = 0;

	if (!isdigit(*s))
		goto err;
	while (isdigit(*s))
		i = i * 10 + *s++ - '0';
	if (*s != '\0') {
		switch (*s++) {
		case 'b':
		case 'B':
			i *= 512;
			break;
		case 'k':
		case 'K':
			i *= 1024;
			break;
		case 'm':
		case 'M':
			i *= 1024 * 1024;
			break;
		case '+':
			return (i + numparse(s));
		default:
			goto err;
		}
	}
	if (*s == '+')
		return (i + numparse(s + 1));
	if (*s == '\0')
		return (i);
err:	{
		char            buf[256];

		(void) sprintf(buf, "%s:Unparsable number:%s\n",progname, str);
		xerror(buf);
	}
	return (-1);		/* to shut up LINT */
}

xerror(errstr)
	char           *errstr;
{
	if(errstr != NULL)
	    fputs(errstr, stderr);
	closeinput();
	closeoutput();
	close(pipein);
	close(pipeout);
	close(0);
	close(1);
	if (parent > 0)
		kill(parent, SIGINT);
	wait(0);
	exit(1);
}

argparse(argc, argv)
	int             argc;
	char           *argv[];
{
	register char  *pa, *po;
	register int    i;

	for (argc--, argv++; argc > 0; argc--, argv++) {
		for (i = 0; options[i].objptr != NULL; i++) {
			for (pa = *argv, po = options[i].name;
			     *pa && *po && *pa == *po;
			     pa++, po++);
			if (*po == '\0' && !isalpha(*pa))
				break;
		}
		if (options[i].objptr == NULL) {
			usage("unknown option\n");
		}
		switch (options[i].attrib) {
		case NUM:
			if (*pa != '=')
				xerror("illegal option format\n");
			*(int *) options[i].objptr = numparse(pa + 1);
			break;
		case STR:
			if (*pa != '=')
				xerror("illegal option format\n");
			*(char **) options[i].objptr = pa + 1;
			break;
		case BOOL:
			{
				int            *p;
				p = (int *) options[i].objptr;
				if (*pa == '\0')
					*p = !*p;
				else if (*pa == '+')
					*p = 1;
				else if (*pa == '-')
					*p = 0;
				else
					xerror("illegal arg format\n");
			} break;
		}
	}
}

ewrite(fd, buf, cnt, obs)
	register int fd,obs;
	int cnt;
	register char *buf;
{
	register int rest, n;

	for (rest = cnt; rest > 0; rest -= n, buf += n) {
		if(rest < obs ) {
			if(padunit == 0)
				obs=rest;
			else 
				obs =rest + padunit -1 - ((rest-1) % padunit) ;
		}
		if ((n = write(fd, buf, obs))>0)
			continue;
		if(n == 0 ) {
			if((n = write(fd, buf, obs)) > 0)
				continue;
			if(n==0){
			    fprintf(stderr,"May be tape end\n");
			return(-1);
			}
		}
		if (n < 0) {
			char msg[BUFSIZ];

			sprintf(msg,"%s write %s",WHOAMI,OUTFILE);
			perror(msg);
			if( errno == EPIPE)
				break;
			return -1;
		}
	}
	return cnt - rest;
}

get_token(t1,t2)
{
	char c =0;
	if (verbose) {
		fprintf(stderr, "%s:%s:waiting '%c'\n",progname,
			WHOAMI, t1);
		fflush(stderr);
	}
	if (read(pipein, &c, 1) != 1) {
		char msg[BUFSIZ];
		if(t2 == -1) {
			if (verbose) 
				fprintf(stderr, "%s:%s:got eof\n",progname, WHOAMI);
			return -1;
			
		}
		sprintf(msg,"%s:%s:control pipe ",progname,WHOAMI);
		perror(msg);
		xerror("");
	}else if (verbose) {
		fprintf(stderr, "%s:%s:got %c\n",progname,
			WHOAMI, c);
	}
	if( c!= t1 && c != t2 ) {
		fprintf(stderr, "%s:%s Syncronization error\n",progname,WHOAMI);
		xerror("");
	}
	return c & 0xFF;
}

put_token(t)
{
	char c;
	c = t;
	if (verbose) {
		fprintf(stderr, "%s:%s:write '%c' \n",progname,
			WHOAMI, c);
	}
	if (write(pipeout, &c, 1) != 1) {
		perror("Control pipe write");
		xerror("");
	}
}

#ifdef SYSV
#ifndef NBPG
#define NBPG 4096
#endif
char *valloc(sz)
	unsigned sz;
{
	char *p;

	if((p=malloc(sz+NBPG))==NULL)
		return NULL;
	return (char * ) ( ~(NBPG-1) & (NBPG + (long)p));
}
#endif
#if 0
termination protocol


CASE 1.

parent		child

	OUT_OK ->
	IN_OK  <-
read input
DETECT EOF
			write last-1 output
	OUT_OK <-
write last output
close input & output
	EOF_APPEAR->
			enter termination mode
close pipe
			SIGPIPE & exit

CASE 2.

parent		child

	OUT_OK  <-
	IN_OK  ->
write last-1 output
		read input
		DETECT EOF
	DETECT_EOF <-
	OUT_OK ->
			write last output
	OUT_OK <-
			enter termination mode
close input & output
	EOF_APPEAR->
			discarded
close pipe
			& exit

	
#endif
