#include "hx_types.h"
#include "htlc.h"
#include "screen.h"
#include "hxlib.h"
#include <stdlib.h>
#include <string.h>

int cmd_nick (int argc, char *const *argv);
int cmd_icon (int argc, char *const *argv);

int
cmd_nick (int argc, char *const *argv)
{
	register char *nick = 0;
	register int i, icon = hx_prefs.icon;

	for (i = 1; i < argc; i++)
		if (argv[i][0] == '-' && argv[i][1] == 'i') {
			if (argv[i][2])
				icon = atou16(&(argv[i][2]));
			else {
				if (!argv[++i])
					break;
				icon = atou16(argv[i]);
			}
		} else {
			nick = argv[i];
		}

	if (!nick) {
		curscr_printf("\nusage: %s <nick> [-i icon]", argv[0]);
		return 0;
	}
	if (strcmp(nick, hx_prefs.nick) || icon != hx_prefs.icon) {
		strncpy(hx_prefs.nick, nick, sizeof hx_prefs.nick - 1);
		hx_prefs.nick[sizeof hx_prefs.nick - 1] = 0;
		hx_prefs.icon = (u_int16_t)icon;
		htlc_snd_user_change((u_int8_t *)nick, (u_int16_t)strlen(nick), hx_prefs.icon);
		curscr->draw(curscr);
	}

	return 0;
}

int
cmd_icon (int argc, char *const *argv)
{
	if (argc < 2) {
		curscr_printf("\nusage: %s <icon>", argv[0]);
		return 0;
	}
	hx_prefs.icon = atoi(argv[1]);
	htlc_snd_user_change((u_int8_t *)hx_prefs.nick, (u_int16_t)strlen(hx_prefs.nick), hx_prefs.icon);
	curscr->draw(curscr);

	return 0;
}
