/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#ifndef _HYANTES_REFERENCE_H
#define _HYANTES_REFERENCE_H

#include  <stddef.h>
#include "hyantes.h"

/** 
* @brief structure containing the coordiante and value of a stock 
*/
typedef struct stock
{
    double lat; /**< latitude of the stock */
    double lon; /**< longitude of the stock */
    double pot; /**< value of the stock */
} Stock;

/* allocates the STOCKS description, its size and max visualisation window from PFILE dataset */
/*@null@*/ Stock *read_input(
   FILE * pFile,
   hs_coord_t * CInit, size_t * stocks_count, double *pStockTotal)
/*@modifies pFile@*/
/*@modifies CInit@*/
/*@modifies stocks_count@*/
/*@modifies pStockTotal@*/ ;

#endif
