/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#ifndef _HYANTES_OPTIONS_H
#define _HYANTES_OPTIONS_H

#include <stdio.h>

/* interpolation fonction prototype */
typedef double (*func_interpolation) (double);

/* G_INTER is used to perform smoothing, once set by set_fonc_inter */
extern /*@null@ */ func_interpolation g_inter;

/* G_FILENAME is used to serialize the quadtree in a file */
extern /*@null@ */ FILE *g_file_serialize;

/* G_THRESHOLD is used to know when to cut a minor area */
extern double g_threshold;

/* G_IS_RAW_DATA is set to one when input data use raw format, to 0 when they use precomputed format */
extern int g_is_raw_data;

#endif
