/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: DrumkitManager.cpp,v 1.19 2004/01/26 11:17:48 comix Exp $
 *
 */


#include "DrumkitManager.h"

#include "HydrogenApp.h"

#include "lib/Song.h"
#include "lib/Hydrogen.h"
#include "lib/LocalFileMng.h"
#include "lib/PreferencesMng.h"


/**
 * Constructor
 */
DrumkitManager::DrumkitManager( QWidget* parent ) : DrumkitManager_UI( parent ) {
//	cout << "DrumkitManager INIT" << endl;

	setMinimumSize( width(), height() );	// not resizable
	setMaximumSize( width(), height() );	// not resizable

	setCaption( trUtf8( "Drumkit manager" ) );
	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );


	// Load drumkit tab
	loadTab_loadDrumkitBtn->setEnabled( false );
	// disabled until is ready
	loadTab_deleteDrumkitBtn->setEnabled( false );


	// save tab
	saveTab_saveBtn->setEnabled( false );


	// import tab
	PreferencesMng *pref = PreferencesMng::getInstance();
	string importInfo = "The drumkit will be installed in " + pref->getUserHome() + "/.hydrogen/data/";
	importTab_infoLbl->setText( importInfo.c_str() );
	importTab_importBtn->setEnabled( false );


	updateDrumkitList();

}





/**
 * Destructor
 */
DrumkitManager::~DrumkitManager() {
//	cout << "DrumkitManager DESTROY" << endl;

	for (uint i = 0; i < drumkitInfoList.size(); i++ ) {
		DrumkitInfo* info = drumkitInfoList[i];
		delete info;
	}
	drumkitInfoList.clear();
}




/**
 *
 */
void DrumkitManager::updateDrumkitList() {
	loadTab_drumkitListBox->clear();
	exportTab_drumkitList->clear();

	for (uint i = 0; i < drumkitInfoList.size(); i++ ) {
		DrumkitInfo* info = drumkitInfoList[i];
		delete info;
	}
	drumkitInfoList.clear();

	PreferencesMng *pref = PreferencesMng::getInstance();
	LocalFileMng mng;
	vector<string> userList = mng.listUserDrumkits();
	for (uint i = 0; i < userList.size(); i++) {
		string absPath = pref->getUserHome() + "/.hydrogen/data/" + userList[i];
		DrumkitInfo *info = mng.loadDrumkit( absPath );
		if (info) {
			drumkitInfoList.push_back( info );
			loadTab_drumkitListBox->insertItem( (info->getName()).c_str() );
			exportTab_drumkitList->insertItem( (info->getName()).c_str() );
		}
	}


	vector<string> systemList = mng.listSystemDrumkits();
	for (uint i = 0; i < systemList.size(); i++) {
		string absPath = string( IMG_PATH ) + "/data/drumkits/" + systemList[i];
		DrumkitInfo *info = mng.loadDrumkit( absPath );
		if (info) {
			drumkitInfoList.push_back( info );
			loadTab_drumkitListBox->insertItem( (info->getName()).c_str() );
			exportTab_drumkitList->insertItem( (info->getName()).c_str() );
		}
	}

	loadTab_drumkitListBox->sort();
	// FIXME: sort in exportTab_drumkitList
//	exportTab_drumkitList->sort();

	loadTab_drumkitListBox->setSelected( 0, true );
	exportTab_drumkitList->setCurrentItem( 0 );
}





/**
 *
 */
void DrumkitManager::okBtnClicked() {
	hide();
}




/**
 *
 */
void DrumkitManager::loadTab_selectionChanged() {
/*	int nSel = loadTab_drumkitListBox->currentItem();

	if (nSel != -1) {
		DrumkitInfo *info = drumkitInfoList[nSel];
		if (info != NULL) {
			string name = "Name: <b>" + drumkitInfoList[nSel]->getName() + "</b>";
			loadTab_drumkitNameLbl->setText( name.c_str() );

			string author = "Author: " + drumkitInfoList[nSel]->getAuthor();
			loadTab_drumkitAuthorLbl->setText( author.c_str() );

			string info = "Info: <br>" + drumkitInfoList[nSel]->getInfo();
			loadTab_drumkitInfoLbl->setText( info.c_str() );

			loadTab_loadDrumkitBtn->setEnabled( true );

			loadTab_deleteDrumkitBtn->setEnabled( true );
		}
	}
*/
	QString sSelectedDrumkitName = loadTab_drumkitListBox->currentText();
	// find the drumkit in the list
	for ( uint i = 0; i < drumkitInfoList.size(); i++ ) {
		DrumkitInfo *drumkitInfo = drumkitInfoList[i];
		if ( QString( drumkitInfo->getName().c_str() ) == sSelectedDrumkitName ) {
			loadTab_drumkitNameLbl->setText( trUtf8( "Name: <b>%1</b>").arg( drumkitInfo->getName().c_str() ) );
			loadTab_drumkitAuthorLbl->setText( trUtf8( "Author: %1" ).arg( drumkitInfo->getAuthor().c_str() ) );
			loadTab_drumkitInfoLbl->setText( trUtf8( "Info: <br>%1").arg( drumkitInfo->getInfo().c_str() ) );

			loadTab_loadDrumkitBtn->setEnabled( true );

			// disabled!!
//			loadTab_deleteDrumkitBtn->setEnabled( true );
			break;
		}
	}
}




/**
 *
 */
void DrumkitManager::loadTab_loadDrumkitBtnClicked() {
//	int nSel = loadTab_drumkitListBox->currentItem();
//	DrumkitInfo *drumkit = drumkitInfoList[ nSel ];

	QString sSelectedDrumkitName = loadTab_drumkitListBox->currentText();
	// find the drumkit in the list
	for ( uint i = 0; i < drumkitInfoList.size(); i++ ) {
		DrumkitInfo *drumkitInfo = drumkitInfoList[i];
		if ( QString( drumkitInfo->getName().c_str() ) == sSelectedDrumkitName ) {
			( Hydrogen::getInstance() )->loadDrumkit( drumkitInfo );
			( Hydrogen::getInstance() )->getSong()->setModified( true );
			( HydrogenApp::getInstance() )->setStatusBarMessage( trUtf8( "Drumkit loaded: [%1]" ).arg( drumkitInfo->getName().c_str() ), 2000 );

			// update drumkit info in save tab
			saveTab_nameTxt ->setText( QString( drumkitInfo->getName().c_str() ) );
			saveTab_authorTxt->setText( QString( drumkitInfo->getAuthor().c_str() ) );
			saveTab_infoTxt->setText( QString( drumkitInfo->getInfo().c_str() ) );

			( HydrogenApp::getInstance() )->getPatternEditor()->getPatternEditor()->updateEditor( true );
			( HydrogenApp::getInstance() )->getPatternEditor()->getInstrumentList()->updateEditor();
			break;
		}
	}

}





/**
 *
 */
void DrumkitManager::importTab_browseBtnClicked() {
	QFileDialog *fd = new QFileDialog(this, "File Dialog", TRUE);
	fd->setMode(QFileDialog::ExistingFile);
	fd->setFilter( "Hydrogen drumkit (*.h2drumkit)" );

	fd->setCaption( trUtf8( "Import drumkit" ) );
	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );

	QString filename = "";
	if (fd->exec() == QDialog::Accepted) {
		filename = fd->selectedFile();
	}

	if (filename != "") {
		importTab_drumkitPathTxt->setText( filename );
	}
}




/**
 *
 */
void DrumkitManager::importTab_importBtnClicked() {

	string dataDir = ( PreferencesMng::getInstance() )->getUserHome() + string( "/.hydrogen/data/" );
	LocalFileMng fileMng;
	fileMng.installDrumkit( string( importTab_drumkitPathTxt->text().latin1() ) );

	QMessageBox::information( this, "Hydrogen", "Drumkit imported in " + QString( dataDir.c_str() )  );

	updateDrumkitList();
}





/**
 *
 */
void DrumkitManager::saveTab_saveBtnClicked() {

	DrumkitInfo *info = new DrumkitInfo();
	info->setName( ( saveTab_nameTxt->text() ).latin1() );
	info->setAuthor( ( saveTab_authorTxt->text() ).latin1() );
	info->setInfo( ( saveTab_infoTxt->text() ).latin1() );

	LocalFileMng fileMng;
	Hydrogen *engine = Hydrogen::getInstance();
	Song *song = engine->getSong();
	InstrumentList *songInstrList = song->getInstrumentList();
	InstrumentList *list = new InstrumentList();

	for ( uint i = 0; i < songInstrList->getSize(); i++ ) {
		Instrument *oldInstr = songInstrList->get( i );
		Sample *sample = oldInstr->getSample();
		string instrDrumkit = oldInstr->getDrumkitName();

		string filename = "";
		if (instrDrumkit == "") {	// external sample
			filename = sample->getFilename();
		}
		else {	// the sample is in another drumkit
			filename = fileMng.getDrumkitDirectory( instrDrumkit ) + instrDrumkit + string( "/" ) + sample->getFilename();
		}
		Instrument *newInstr = Instrument::load( filename );
		if ( newInstr == NULL ) {
			cerr << "[DrumkitManager::saveTab_saveBtnClicked()] Error loading " << filename << endl;

			cerr << "[DrumkitManager::saveTab_saveBtnClicked()] NULL sample, now using emptySample.wav" << endl;
			newInstr = new Instrument( "dummy", "dummy", "no author", 0, 0 );
			Sample* newSample = Sample::load( string(IMG_PATH) + "/data/emptySample.wav" );
			newSample->setFilename( string(IMG_PATH) + "/data/emptySample.wav" );
			newInstr->setSample( newSample );

		}
		newInstr->setId( oldInstr->getId() );
		newInstr->setVolume( oldInstr->getVolume() );
		newInstr->setName( oldInstr->getName() );
		newInstr->setPan_L( oldInstr->getPan_L() );
		newInstr->setPan_R( oldInstr->getPan_R() );
		newInstr->setMuted( oldInstr->isMuted() );
		newInstr->excludeVectId = oldInstr->excludeVectId;

		list->add ( newInstr );
	}

	info->setInstrumentList( list );

	int err = fileMng.saveDrumkit( info );
	if (err != 0) {
		QMessageBox::information( this, "Hydrogen", "Error saving drumkit" );
	}

	// delete the drumkit info
	delete info;
	info = NULL;

	updateDrumkitList();
}





/**
 *
 */
void DrumkitManager::tabChanged() {
/*
	QWidget *page = tabWidget->currentPage();
	string pageStr = ( tabWidget->tabLabel( page ) ).latin1();
	cout << "tab changed " << pageStr << endl;
*/
}





void DrumkitManager::exportTab_browseBtnClicked() {

	QFileDialog *fd = new QFileDialog(this, "File Dialog", TRUE);
//	fd->setMode(QFileDialog::DirectoryOnly);
	fd->setMode(QFileDialog::Directory);
	fd->setFilter( "Hydrogen drumkit (*.h2drumkit)" );

	fd->setCaption( trUtf8( "Export drumkit" ) );
	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );

	QString filename = "";
	if (fd->exec() == QDialog::Accepted) {
		filename = fd->selectedFile();
	}

	if (filename != "") {
		exportTab_drumkitPathTxt->setText( filename );
	}


}




/**
 *
 */
void DrumkitManager::exportTab_exportBtnClicked() {
	string drumkitName = exportTab_drumkitList->currentText().latin1();

	LocalFileMng fileMng;
	string drumkitDir = fileMng.getDrumkitDirectory( drumkitName );

	string saveDir = exportTab_drumkitPathTxt->text().latin1();
	string cmd = string( "cd " ) + drumkitDir + string( "; tar czf " ) + saveDir + drumkitName + string( ".h2drumkit " ) + drumkitName;

	system( cmd.c_str() );
	QMessageBox::information( this, "Hydrogen", "Drumkit exported." );
}




/**
 *
 */
void DrumkitManager::exportTab_drumkitPathChanged() {
	string path = exportTab_drumkitPathTxt->text().latin1();
	if (path == "") {
		exportTab_exportBtn->setEnabled( false );
	}
	else {
		exportTab_exportBtn->setEnabled( true );
	}
}




/**
 *
 */
void DrumkitManager::importTab_drumkitPathChanged() {
	string path = importTab_drumkitPathTxt->text().latin1();
	if (path == "") {
		importTab_importBtn->setEnabled( false );
	}
	else {
		importTab_importBtn->setEnabled( true );
	}
}





/**
 *
 */
void DrumkitManager::saveTab_nameChanged() {
	string name = saveTab_nameTxt->text().latin1();
	if (name == "") {
		saveTab_saveBtn->setEnabled( false );
	}
	else {
		saveTab_saveBtn->setEnabled( true );
	}
}




/**
 *
 */
void DrumkitManager::loadTab_deleteDrumkitBtnClicked() {
	QMessageBox::information( this, "Hydrogen", "Not implemented yet" );

	// verificare che nessun suono del drumkit sia utilizzato correntemente
}



