/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: SplashScreen.cpp,v 1.19 2004/02/27 13:17:58 comix Exp $
 *
 */


#include "SplashScreen.h"

//SplashScreen::SplashScreen() : QWidget( 0, "HydrogenSplashScreen", Qt::WStyle_Splash ) {
SplashScreen::SplashScreen() : QWidget( 0, "HydrogenSplashScreen", Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop| Qt::WX11BypassWM ), Object("SplashScreen")
{
	setMinimumSize(width, height);
	setMaximumSize(width, height);
	resize(width, height);

	setCaption( trUtf8( "Hydrogen" ) );
	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );

	string logo_path = string( IMG_PATH ) + string( "/img/splash/splash.png" );
	QPixmap logo = QPixmap(logo_path.c_str());

	QFont font;
	font.setPointSize( 10 );
	font.setBold( true );

	QPainter p( &logo );
	p.setFont( font );
	p.setPen( QColor( 70, 70, 70 ) );

	string version = string(VERSION) + " (" + string(__DATE__) + ")";
	p.drawText( 20, 100, QString( version.c_str() ) );

	//p.drawText( 20, 130, trUtf8("Alpha Version ") );
	p.drawText( 20, 293, trUtf8( QString("Modules: %1").arg( COMPILED_FEATURES ) ) );

	QLabel *logoLbl = new QLabel(this);
	logoLbl->move(0, 0);
	logoLbl->resize(400, 300);
	logoLbl->setPixmap(logo);

	QTimer::singleShot( 2000, this, SLOT( closeSplash() ) );
}




/**
 * Destructor
 */
SplashScreen::~SplashScreen() {
//	cout << "destroy splashscreen" << endl;
}



/**
 * Close the splash screen
 */
void SplashScreen::closeSplash() {
//	infoLog( "[closeSplash]" );
	hide();
}



