/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: DiskWriterDriver.h,v 1.6 2004/01/26 11:16:58 comix Exp $
 *
 */

#ifndef DISK_WRITER_DRIVER_H
#define DISK_WRITER_DRIVER_H


#include <inttypes.h>
#include <audiofile.h>
#include "GenericDriver.h"
#include "Hydrogen.h"
#include "Object.h"

typedef int  (*audioProcessCallback)(uint32_t, void *);

//----------------------------------------------------------------------------
/**
 * Driver for export audio to disk
 */
class DiskWriterDriver : public GenericDriver {
	public:
		/** Constructor */
		DiskWriterDriver(audioProcessCallback processCallback);

		/** Destructor */
		~DiskWriterDriver();

		int init(uint nBufferSize);

		int connect();
		void disconnect();

		void write(float* buffer_L, float* buffer_R, unsigned int bufferSize);

		/** Get buffer size */
		uint getBufferSize();

		void setFilename(string filename) {	this->filename = filename;	}
		uint getSampleRate();
		float* getOut_L();
		float* getOut_R();

		virtual void play();
		virtual void stop();
		virtual void locate( unsigned long nFrame );
		virtual void updateTransportInfo();
		virtual void setBpm(float fBPM);

	private:
		audioProcessCallback processCallback;
		AFfilehandle outputFile;
		uint bufferSize;
		short *saveBuffer;
		string filename;

		float* out_L;
		float* out_R;
};



#endif
