#! /bin/sh
#
# Version:	@(#)skeleton  1.8  03-Mar-1998  miquels@cistron.nl
#
# This file was automatically customized by dh-make on Tue, 17 Dec 2002 20:50:15 +0100

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/iacd
NAME=iacd
DESC=iacd

test -f $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: $NAME"
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON -- -d -v -p /var/run/$NAME.pid -u irc -g irc
	echo "."
	;;
  stop)
	echo -n "Stopping $DESC: $NAME"
	start-stop-daemon --oknodo --stop --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON
	echo "."
	;;
  reload|force-reload)
	echo "Reloading $DESC configuration files."
	start-stop-daemon --stop --signal HUP --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
  ;;
  restart)
	echo -n "Restarting $DESC: $NAME"
	start-stop-daemon --stop --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
	sleep 1
	start-stop-daemon --start --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
	echo "."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
