#ifndef IAC_IRC_H_
#define IAC_IRC_H_

#include "types.h"

void iac_irc_parse(iac_client_conn_t *src);
void iac_irc_channel_bcast(iac_client_conn_t *src, iac_channel_t *chan, const char *fmt, ...);
void iac_irc_real_quit(iac_client_conn_t *src);
void iac_irc_check_pong(const char *);
void iac_irc_check_auto_away(const char *);
void iac_irc_send_ping(iac_client_conn_t *src);
void iac_irc_send_ping_name(const char *name);
void iac_irc_read_motd(const char *);
void iac_irc_notice_user(iac_client_conn_t *dst, const char *fmt, ...);
void iac_irc_notice_ops(const char *fmt, ...);

void iac_irc_msg(iac_client_conn_t *src);
void iac_irc_join(iac_client_conn_t *src);
void iac_irc_topic(iac_client_conn_t *src);
void iac_irc_part(iac_client_conn_t *src);
void iac_irc_quit(iac_client_conn_t *src);

#endif
