#ifndef __TI_UTIL_H_
#define __TI_UTIL_H_

/*
 * Make it useable for C++ compilers
 */
#ifdef __BEGIN_DECLS
#undef __BEGIN_DECLS
#endif
#ifdef __END_DECLS
#undef __END_DECLS
#endif
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS
# define __END_DECLS
#endif


/*
 * make code possible for ANSI-C aswell for Non-ANSI-C compilers
 */
#ifdef __P
#   undef __P
#endif
#if defined (__STDC__) || defined (_AIX) \
        || (defined (__mips) && defined (_SYSTYPE_SRV4)) \
        || defined (WIN32) || defined (__cplusplus)
#   define __P(protos) protos
#else
#   define __P(protos) ()
#endif


__BEGIN_DECLS


#include "config.h"
#include <stdarg.h>


#ifndef TRUE
#   define TRUE 1
#endif

#ifndef FALSE
#   define FALSE 0
#endif

#ifndef RL_MALLOC
#   define RL_MALLOC(p, t, n) {                          \
       if ((p = (t *) malloc(sizeof(t)*n)) == NULL) {    \
           fprintf(stderr, "Error: Out of memory!\n");   \
           exit(-1);                                     \
       }                                                 \
    }
#endif

#ifndef RL_FREE
#   define RL_FREE(p) {                                  \
       if (p) {                                          \
           free(p);                                      \
           p = NULL;                                     \
       }                                                 \
   }
#endif

#ifdef ERR_CHECKS
#   ifndef ERRCHECK
#       define ERRCHECK(v) {                                          \
            if (v == NULL) {                                          \
                fprintf(stderr, "Error: %s:%d: pointer is NULL.\n",   \
                    __FILE__, __LINE__);                              \
                fflush(stderr);                                       \
                assert(0);                                            \
            }                                                         \
        }
#   endif
#else
#   ifndef ERRCHECK
#       define ERRCHECK(v)
#   endif
#endif

#ifndef HAVE_STRDUP
char *strdup(const char *);
#endif

#ifndef HAVE_VASPRINTF
int vasprintf(char **strp, const char *fmt, va_list ap);
#endif

#ifndef HAVE_ASPRINTF
int asprintf(char **strp, const char *fmt, ...);
#endif


char *ti_trim __P((char *));
__inline__ char *ti_tolower __P((char *));

int rs_parse_match_fword(const char *str, const char *word);


int rl_stricmp __P((const char *s1, const char *s2));
void rl_remove_eol __P((char *));
__inline__ int rl_tolower __P((int f));

char *iac_safe_strncpy(char *dest, const char *src, size_t n);
char *iac_astrcat(char **dest, const char *src);
int iac_match_mask(const char *mask, const char *str);

/* --------------------------------------------------------------------- *
 * RL Hashtable                                                          *
 *                                                                       *
 * simple but powerfull hashtable implementation                         *
 * --------------------------------------------------------------------- */

#define RL_HTABLE_DEFAULT 0x00
#define RL_HTABLE_DONT_FREE_DATA 0x01

/*
 * hashtable entry
 */
typedef struct rl_htable_entry_s
{
   char *                       rhe_key;                          /* key */
   void *                       rhe_data;                /* data pointer */
   struct rl_htable_entry_s *   rhe_next;       /* pointer to next entry */

} rl_htable_entry_t;

/*
 * hashtable chain
 */
typedef struct rl_htable_chain_s
{
   rl_htable_entry_t *           rhc_el;              /* list of entries */
   
} rl_htable_chain_t;

/*
 * rl_hashtable handle
 */
typedef struct rl_htable_s
{
   rl_htable_chain_t *           rh_symtab;           /* hashtable array */
   unsigned int                  rh_stsize;                /* array size */
   unsigned int                  rh_multiplier;   /* see hash() function */
   unsigned long                 rh_entries;                /* # entries */
   int                           rh_free_data;    /* free data on remove */

} rl_htable_t;


/*
 * create new hashtable with given size and multiplier, both values
 * cannot be changed later because this would cause that all entries
 * needs to be reinserted. returns a hashtable handle or NULL on error.
 */
rl_htable_t * rl_hashtable_new __P((unsigned int size,
                                    unsigned int multiplier,
                                    int flags));

/*
 * delete a hashtable
 */
void rl_hashtable_del __P((rl_htable_t *htable));

/*
 * return value for given key or NULL if not present.
 */
void * rl_hashtable_get __P((rl_htable_t *htable, const char *id));

/*
 * add key/value pair to hashtable
 */
void rl_hashtable_add __P((rl_htable_t *, const char *id, void *data));

/*
 * remove key/value pair from hashtable.
 */
int rl_hashtable_rem __P((rl_htable_t *htable, const char *id));

/*
 * generate hashtable for given string.
 */
unsigned int rl_hashtable_hash __P((rl_htable_t *, const char *id));


/* --------------------------------------------------------------------- *
 * RL List                                                               *
 *                                                                       *
 * Very simple double linked list with simple navigation support. This   *
 * list if used if the size various very much on runtime and you don't   *
 * want to waste any memory or you don't have an identifier besides the  *
 * pointer to the data.                                                  *
 * --------------------------------------------------------------------- */

/*
 * list item
 */
typedef struct rl_list_item_s
{
    void *                    rli_data;               /* pointer to data */
    struct rl_list_item_s *   rli_next;          /* pointer to next item */
    struct rl_list_item_s *   rli_prev;      /* pointer to previous item */
    int                       rli_freeable;    /* is the data free'able? */

} rl_list_item_t;

/*
 * list handle
 */
typedef struct rl_list_s
{
    rl_list_item_t * rl_list_start;          /* pointer to first element */
    rl_list_item_t * rl_list_end;             /* pointer to last element */
    rl_list_item_t * rl_current;           /* pointer to current element */

} rl_list_t;

/*
 * create a new list, returns handle or NULL on error.
 */
rl_list_t * rl_list_new __P((void));

/*
 * delete a list.
 */
void rl_list_del __P((rl_list_t *));

/*
 * add an item to the list, if `freeable' is set, the pointer
 * will be free'ed when it is deleted.
 */
void rl_list_add __P((rl_list_t *, void *, int freeable));

/*
 * remove an item from the list
 */
void rl_list_rem __P((rl_list_t *, void *));

/*
 * set current item to list start.
 */
void rl_list_reset_to_start __P((rl_list_t *));

/*
 * set current item to list end.
 */
void rl_list_reset_to_end __P((rl_list_t *));

/*
 * return current item
 */
void * rl_list_get_current __P((rl_list_t *));

/*
 * set current item to next item
 */
void rl_list_set_next __P((rl_list_t *));

/*
 * set current item to previous item
 */
void rl_list_set_prev __P((rl_list_t *));


/* --------------------------------------------------------------------- *
 * RL tokenizer                                                          *
 *                                                                       *
 * splits a string into tokens with an interface that no other library   *
 * provides ;-)                                                          *
 * --------------------------------------------------------------------- */

/*
 * tokenlist item
 */
typedef struct rl_token_list_item_s
{
    char *rtli_val;                                       /* token value */
    struct rl_token_list_item_s *rtli_next;      /* pointer to next item */

} rl_token_list_item_t;

/*
 * tokenlist, this is a list of tokens which got splitted.
 */
typedef struct rl_token_list_s
{
    rl_token_list_item_t *rtl_list;                /* list of all tokens */
    int rtl_ntokens;                                 /* number of tokens */
    rl_token_list_item_t *rtl_current;                 /* internaly used */

} rl_token_list_t;

/*
 * split a given string into tokens describes by the `fmt' string. the
 * `fmt' is a list of characters which represents the delimiters for
 * the tokens. as you can see, maximum delimiter length is one ;)
 */
rl_token_list_t * rl_token_split __P((char *str, char *fmt));

/*
 * return next token from the token list.
 */
char * rl_token_get_next __P((rl_token_list_t *));

/*
 * delete token list
 */
void rl_token_del_token_list __P((rl_token_list_t *));


__END_DECLS

#endif
