<?php
// File           admin.php / ibWebAdmin
// Purpose        panels for database administration tasks, gsec, gbak etc.
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <02/10/02 08:47:06 lb>
//
// $Id: admin.php,v 1.22 2004/03/07 16:10:16 lbrueckner Exp $


require('./inc/script_start.inc.php');


// execute a delayed external command
if ($HTTP_SERVER_VARS['REQUEST_METHOD'] == 'GET'  &&  !empty($s_adm_command)) {

    list($binary_output, $binary_error) = exec_command($s_adm_command['command'],
                                                       $s_adm_command['parameters'],
                                                       $s_adm_command['stderr']);
    $s_adm_command = array();
}


//
// interface for the gfix command
//
$idx = get_panel_index($s_admin_panels, 'adm_gfix');
if ($s_admin_panels[$idx][2] == 'open') {

    if ($HTTP_SERVER_VARS['REQUEST_METHOD'] == 'POST') {
        $s_sysdba_pw = get_sysdba_pw();
    
        $s_housekeeping        = isset($HTTP_POST_VARS['adm_housekeeping'])    ? $HTTP_POST_VARS['adm_housekeeping']   : '';
        $s_adm_dialect         = isset($HTTP_POST_VARS['adm_sql_dialect'])     ? $HTTP_POST_VARS['adm_sql_dialect']    : '';
        $s_adm_buffers         = isset($HTTP_POST_VARS['adm_buffers'])         ? $HTTP_POST_VARS['adm_buffers']        : '';
        $s_access_mode         = isset($HTTP_POST_VARS['adm_access_mode'])     ? $HTTP_POST_VARS['adm_access_mode']    : '';
        $s_write_mode          = isset($HTTP_POST_VARS['adm_write_mode'])      ? $HTTP_POST_VARS['adm_write_mode']     : '';
        $s_shut_secs           = isset($HTTP_POST_VARS['adm_shut_secs'])       ? $HTTP_POST_VARS['adm_shut_secs']      : '';
        $s_adm_sweep_ignore    = isset($HTTP_POST_VARS['adm_sweep_ignore'])    ? $HTTP_POST_VARS['adm_sweep_ignore']   : '';
        $s_adm_validate_ignore = isset($HTTP_POST_VARS['adm_validate_ignore']) ? $HTTP_POST_VARS['adm_validate_ignore']: '';
        $s_adm_validate        = isset($HTTP_POST_VARS['adm_validate'])        ? $HTTP_POST_VARS['adm_validate']       : '';
        $s_adm_validate_option = isset($HTTP_POST_VARS['adm_validate_option']) ? $HTTP_POST_VARS['adm_validate_option']: '';
        $s_adm_transaction     = isset($HTTP_POST_VARS['adm_transaction'])     ? $HTTP_POST_VARS['adm_transaction']    : '';
        $s_adm_shut_noconns    = isset($HTTP_POST_VARS['adm_shut_noconns'])    ? $HTTP_POST_VARS['adm_shut_noconns']   : '';
        $s_adm_shut_notrans    = isset($HTTP_POST_VARS['adm_shut_notrans'])    ? $HTTP_POST_VARS['adm_shut_notrans']   : '';
        $s_adm_shut_force      = isset($HTTP_POST_VARS['adm_shut_force'])      ? $HTTP_POST_VARS['adm_shut_force']     : '';
        $s_adm_shut_reconnect  = isset($HTTP_POST_VARS['adm_shut_reconnect'])  ? $HTTP_POST_VARS['adm_shut_reconnect'] : ''; 
    }

    if (empty($warning)) {

        $parameters = '';
        $disconnect = $logout = $redirect = FALSE;

        // set cache buffers
        if (isset($HTTP_POST_VARS['adm_gfix_buffers'])  &&  !empty($HTTP_POST_VARS['adm_buffers'])) {
            $parameters .= ' -buffers '.$HTTP_POST_VARS['adm_buffers'];
        }

        // set dialect
        if (isset($HTTP_POST_VARS['adm_gfix_dialect'])  &&  !empty($HTTP_POST_VARS['adm_sql_dialect'])) {
            $parameters .= ' -sql_dialect '.$HTTP_POST_VARS['adm_sql_dialect'];
        }

        // set access mode
        if (isset($HTTP_POST_VARS['adm_gfix_access_mode'])  &&  !empty($HTTP_POST_VARS['adm_access_mode'])) {
            $mode = ($HTTP_POST_VARS['adm_access_mode'] == $adm_strings['ReadWrite']) ? 'read_write' : 'read_only';
            $parameters .= ' -mode '.$mode;
            $disconnect = TRUE;
            $redirect = TRUE;
        }

        // set write mode
        if (isset($HTTP_POST_VARS['adm_gfix_write_mode'])  &&  !empty($HTTP_POST_VARS['adm_write_mode'])) {
            $mode = ($HTTP_POST_VARS['adm_write_mode'] == $adm_strings['Sync']) ? 'sync' : 'async';
            $parameters .= ' -write '.$mode;
        }

        // set housekeeping interval
        if (isset($HTTP_POST_VARS['adm_gfix_housekeeping'])  &&  trim($HTTP_POST_VARS['adm_housekeeping']) != '') {
            $parameters .= ' -housekeeping '.$HTTP_POST_VARS['adm_housekeeping'];
        }

        // execute database sweep
        if (isset($HTTP_POST_VARS['adm_gfix_sweep'])) {
            $parameters .= ' -sweep';
            $parameters .= (isset($HTTP_POST_VARS['adm_sweep_ignore'])  &&  $HTTP_POST_VARS['adm_sweep_ignore'] == 'ignore') 
                         ? ' -ignore' : '';
        }

        // perform data repair
        if (isset($HTTP_POST_VARS['adm_gfix_validate'])) {
            if (isset($HTTP_POST_VARS['adm_validate'])) {
                if ($HTTP_POST_VARS['adm_validate'] == 'mend') {
                    $parameters .= ' -mend';
                }
                if ($HTTP_POST_VARS['adm_validate'] == 'validate') {
                    $parameters .= ' -validate';
                    $parameters .= (isset($HTTP_POST_VARS['adm_validate_option'])) ? ' -'.$HTTP_POST_VARS['adm_validate_option'] : '';
                }
            }
            $parameters .= (isset($HTTP_POST_VARS['adm_validate_ignore'])) ? ' -ignore' : '';
            $disconnect = TRUE;
            $redirect = TRUE;
        }

        // transaction recovery
        if (isset($HTTP_POST_VARS['adm_gfix_trans'])  &&  isset($HTTP_POST_VARS['adm_transaction'])) {
            $parameters .= ' -'.$HTTP_POST_VARS['adm_transaction'].' all';
        }

        // execute shutdown
        if (isset($HTTP_POST_VARS['adm_gfix_shutdown'])) {
            $seconds = (trim($HTTP_POST_VARS['adm_shut_secs']) == '') ? ' 0' : ' '.$HTTP_POST_VARS['adm_shut_secs'];
            $parameters .= (isset($HTTP_POST_VARS['adm_shut_noconns'])) ? ' -attach'.$seconds : '';
            $parameters .= (isset($HTTP_POST_VARS['adm_shut_notrans'])) ? ' -tran'.$seconds   : '';
            $parameters .= (isset($HTTP_POST_VARS['adm_shut_force']))   ? ' -force'.$seconds  : '';
            if (strlen($parameters) > 0) {
                $parameters = ' -shut'.$parameters;
            }
            $disconnect = TRUE;
            $redirect = (isset($HTTP_POST_VARS['adm_shut_noconns']))   ? TRUE  : FALSE;
            $logout   = (isset($HTTP_POST_VARS['adm_shut_reconnect'])) ? FALSE : TRUE;
        }

        // rescind shutdown
        if (isset($HTTP_POST_VARS['adm_gfix_rescind'])) {
            $parameters .= ' -online';
        }

        if (strlen($parameters) > 0) {
            $usr_str = !empty($s_sysdba_pw) ? ' -user SYSDBA' : ' -user '.ibwa_escapeshellarg($s_login['user']);
            $pw_str  = !empty($s_sysdba_pw) ? ' -password ' . ibwa_escapeshellarg($s_sysdba_pw) : ' -password ' . ibwa_escapeshellarg($s_login['password']);
            $db_str  = !empty($s_login['host']) ? ' ' . ibwa_escapeshellarg($s_login['host'].':'.$s_login['database']) : ' ' . ibwa_escapeshellarg($s_login['database']);

            $parameters .= $usr_str . $pw_str . $db_str ;

            if ($disconnect == TRUE) {
                ibase_close($dbhandle);
            }

            if ($logout == TRUE) {
                remove_edit_panels();
                cleanup_session();
                $s_connected = FALSE;
            }

            if ($redirect == TRUE) {
                $s_adm_command = array('command'    => 'gfix',
                                       'parameters' => $parameters,
                                       'stderr'     => TRUE);
                globalize_session_vars();

                $script = (!empty($HTTP_SERVER_VARS['PHP_SELF'])) ? $HTTP_SERVER_VARS['PHP_SELF'] : $HTTP_SERVER_VARS['SCRIPT_NAME'];
                redirect(url_session($script.'?unconnected=1'));
            }

            list($binary_output, $binary_error) = exec_command('gfix', $parameters, TRUE);
        }
    }
}


//
// get database statistics via gstat
//
$idx = get_panel_index($s_admin_panels, 'adm_dbstat');
if ($s_admin_panels[$idx][2] == 'open'  &&  $s_connected) {

    list($gstat_output, $binary_error) = exec_command('gstat', ' -user '.ibwa_escapeshellarg($s_login['user']).' -password '.ibwa_escapeshellarg($s_login['password']).' '.ibwa_escapeshellarg($s_login['database']));
}


//
// get server statistics via gds_lock_print / iblockpr
//
$idx = get_panel_index($s_admin_panels, 'adm_server');
if ($s_admin_panels[$idx][2] == 'open') {

    if (stristr(php_uname(), 'wind') !== FALSE) {
        $exe = $s_login['server'] == 'FB_1.5' ? 'fb_lock_print' : 'iblockpr';
    }
    else {
        $exe = $s_login['server'] == 'FB_1.5' ? 'fb_lock_mgr' : 'gds_lock_print';
    }

    // get the LOCK_HEADER BLOCK 
    list($iblockpr_output, $binary_error) = exec_command($exe, ' -o');

    $lock_header = '';
    unset($iblockpr_output[0]);
    foreach ($iblockpr_output as $line) {
        if (strlen(trim($line)) == 0) {
            break;
        }
        $lock_header .= $line."<br>\n";
    }


    // get the server statistics
    list($iblockpr_output, $binray_error) = exec_command($exe, ' -i');

    if (count($iblockpr_output) > 3) {
        $iblock['names'] = preg_split('/[\s,]+/', $iblockpr_output[0]);
        $iblock['last']  = preg_split('/[\s,]+/', $iblockpr_output[1]);
        $iblock['avg']   = preg_split('/[\s,]+/', $iblockpr_output[3]);
    }
}


//
// backup the current database
//
$idx = get_panel_index($s_admin_panels, 'adm_backup');
if ($s_admin_panels[$idx][2] == 'open') {

    if ($HTTP_SERVER_VARS['REQUEST_METHOD'] == 'POST') {
        $s_backup['target']     = isset($HTTP_POST_VARS['adm_bu_target'])     ? trim($HTTP_POST_VARS['adm_bu_target'])     : '';
        $s_backup['servicemgr'] = isset($HTTP_POST_VARS['adm_bu_servicemgr']) ? trim($HTTP_POST_VARS['adm_bu_servicemgr']) : '';
        $s_backup['bfactor']    = isset($HTTP_POST_VARS['adm_bu_bfactor'])    ? trim($HTTP_POST_VARS['adm_bu_bfactor'])    : 0;
        $s_backup['mdonly']     = isset($HTTP_POST_VARS['adm_bu_mdonly'])     ? $HTTP_POST_VARS['adm_bu_mdonly']     : '';
        $s_backup['mdoldstyle'] = isset($HTTP_POST_VARS['adm_bu_mdoldstyle']) ? $HTTP_POST_VARS['adm_bu_mdoldstyle'] : '';
        $s_backup['create']     = isset($HTTP_POST_VARS['adm_bu_create'])     ? $HTTP_POST_VARS['adm_bu_create']     : '';
        $s_backup['transport']  = isset($HTTP_POST_VARS['adm_bu_transport'])  ? $HTTP_POST_VARS['adm_bu_transport']  : '';
        $s_backup['convert']    = isset($HTTP_POST_VARS['adm_bu_convert'])    ? $HTTP_POST_VARS['adm_bu_convert']    : '';
        $s_backup['nogc']       = isset($HTTP_POST_VARS['adm_bu_nogc'])       ? $HTTP_POST_VARS['adm_bu_nogc']       : '';
        $s_backup['ignorecs']   = isset($HTTP_POST_VARS['adm_bu_ignorecs'])   ? $HTTP_POST_VARS['adm_bu_ignorecs']   : '';
        $s_backup['ignorelt']   = isset($HTTP_POST_VARS['adm_bu_ignorelt'])   ? $HTTP_POST_VARS['adm_bu_ignorelt']   : ''; 
    }

    if (isset($HTTP_POST_VARS['adm_backup_doit'])  &&  !empty($s_backup['target'])) {

        $s_sysdba_pw = get_sysdba_pw();

        $parameters = ' -backup_database';

        // invoke a service manager
        if (!empty($s_backup['servicemgr'])) {
            $parameters .= ' -service '.$s_backup['servicemgr'];
        }
    
        // use blocking factor n for a tape device
        if (!empty($s_backup['bfactor'])) {
            $parameters .= ' -factor '.$s_backup['bfactor'];
        }

        // backup metadata only
        if (!empty($s_backup['mdonly'])) {
            $parameters .= ' -metadata';
        }

        // metadata in old-style format
        if (!empty($s_backup['mdoldstyle'])) {
            $parameters .= ' -old_descriptions';
        }

        // create a non compressed backup
        if (!empty($s_backup['create'])) {
            $parameters .= ' -expand';
        }

        // create backup in non transportable format
        if (!empty($s_backup['transport'])) {
            $parameters .= ' -nt';
        }

        // convert external files as internal tables
        if (!empty($s_backup['convert'])) {
            $parameters .= ' -convert';
        }

        // do not run garbage collection
        if (!empty($s_backup['nogc'])) {
            $parameters .= ' -garbage_collect';
        }

        // ignore checksums
        if (!empty($s_backup['ignorecs'])) {
            $parameters .= ' -ignore';
        }

        // ignore limbo transactions
        if (!empty($s_backup['ignorelt'])) {
            $parameters .= ' -limbo';
        }

        // call the gbak command to create the backup
        $usr_str = !empty($s_sysdba_pw) ? ' -user SYSDBA' : ' -user '.ibwa_escapeshellarg($s_login['user']);
        $pw_str  = !empty($s_sysdba_pw) ? ' -password '.ibwa_escapeshellarg($s_sysdba_pw) : ' -password '.ibwa_escapeshellarg($s_login['password']);
        $db_str  = !empty($s_login['host']) ? ' ' . ibwa_escapeshellarg($s_login['host'].':'.$s_login['database']) : ' ' . ibwa_escapeshellarg($s_login['database']);
        $backup_filename = ibwa_escapeshellarg(get_backup_filename($s_backup['target']));

        $parameters .= $usr_str . $pw_str . $db_str .' '.$backup_filename;

        list($binary_output, $binary_error) = exec_command('gbak', $parameters, TRUE);
    }
}


//
// restore database
//
$idx = get_panel_index($s_admin_panels, 'adm_restore');
if ($s_admin_panels[$idx][2] == 'open') {

    if ($HTTP_SERVER_VARS['REQUEST_METHOD'] == 'POST') {
        $s_restore['source']     = isset($HTTP_POST_VARS['adm_re_source'])     ? trim($HTTP_POST_VARS['adm_re_source'])     : '';
        $s_restore['servicemgr'] = isset($HTTP_POST_VARS['adm_re_servicemgr']) ? trim($HTTP_POST_VARS['adm_re_servicemgr']) : '';
        $s_restore['target']     = isset($HTTP_POST_VARS['adm_re_target'])     ? trim($HTTP_POST_VARS['adm_re_target'])     : '';
        $s_restore['overwrite']  = isset($HTTP_POST_VARS['adm_re_overwrite'])  ? $HTTP_POST_VARS['adm_re_overwrite']        : 'no';
        $s_restore['pagesize']   = isset($HTTP_POST_VARS['adm_re_pagesize'])   ? $HTTP_POST_VARS['adm_re_pagesize']         : '';
        $s_restore['buffers']    = isset($HTTP_POST_VARS['adm_re_buffers'])    ? trim($HTTP_POST_VARS['adm_re_buffers'])    : '';
        $s_restore['amode']      = isset($HTTP_POST_VARS['adm_re_amode'])      ? $HTTP_POST_VARS['adm_re_amode']            : '';
        $s_restore['inactive']   = isset($HTTP_POST_VARS['adm_re_inactive'])   ? $HTTP_POST_VARS['adm_re_inactive']         : '';
        $s_restore['oneattime']  = isset($HTTP_POST_VARS['adm_re_oneattime'])  ? $HTTP_POST_VARS['adm_re_oneattime']        : '';
        $s_restore['useall']     = isset($HTTP_POST_VARS['adm_re_useall'])     ? $HTTP_POST_VARS['adm_re_useall']           : '';
        $s_restore['novalidity'] = isset($HTTP_POST_VARS['adm_re_novalidity']) ? $HTTP_POST_VARS['adm_re_novalidity']         : ''; 
        $s_restore['kill']       = isset($HTTP_POST_VARS['adm_re_kill'])       ? $HTTP_POST_VARS['adm_re_kill']             : '';
        $s_restore['connect']    = isset($HTTP_POST_VARS['adm_re_connect'])    ? $HTTP_POST_VARS['adm_re_connect']          : 'no';
    }

    if (isset($HTTP_POST_VARS['adm_restore_doit'])  &&  !empty($s_restore['source'])) {

        $parameters = ($s_restore['overwrite'] == 'yes') ? ' -replace_database' : ' -create_database';

        // invoke a service manager
        if (!empty($s_restore['servicemgr'])) {
            $parameters .= ' -service '.$s_restore['servicemgr'];
        }

        // set the page size
        if (!empty($s_restore['pagesize'])) {
            $parameters .= ' -page_size '.$s_restore['pagesize'];
        }

        // set the cache size
        if (!empty($s_restore['buffers'])) {
            $parameters .= ' -buffers '.$s_restore['buffers'];
        }

        // set the access mode
        if (!empty($s_restore['amode'])) {
            $parameters .= ' -mode '. ($s_restore['amode'] == $adm_strings['ReadWrite'] ? 'read_write' : 'read_only');
        }

        // make indexes inactive upon restore
        if (!empty($s_restore['inactive'])) {
            $parameters .= ' -inactive';
        }

        // restore one table at time
        if (!empty($s_restore['oneattime'])) {
            $parameters .= ' -one_at_a_time';
        }

        // restore database with 100% fill ratio
        if (!empty($s_restore['useall'])) {
            $parameters .= ' -use_all_space';
        }

        // delete validity constraintsfrom restored metadata
        if (!empty($s_restore['novalidity'])) {
            $parameters .= ' -no_validity';
        }

        // do not create shodow files
        if (!empty($s_restore['kill'])) {
            $parameters .= ' -kill';
        }

        if (!have_db_suffix($s_restore['target'])) {
            $error = sprintf($ERRORS['WRONG_DB_SUFFIX'], "'".implode("', '", $DATABASE_SUFFIXES)."'");
        }
        elseif (!is_allowed_db($s_restore['target'])) {
            $error = sprintf($ERRORS['DB_NOT_ALLOWED'], $s_restore['target']);
        }

        // call the gbak command to restore the database
        if (empty($error)) {
            $usr_str = !empty($s_sysdba_pw) ? ' -user SYSDBA' : ' -user ' . ibwa_escapeshellarg($s_login['user']);
            $pw_str  = !empty($s_sysdba_pw) ? ' -password ' . ibwa_escapeshellarg($s_sysdba_pw) : ' -password ' . ibwa_escapeshellarg($s_login['password']);
            $backup_filename = ibwa_escapeshellarg(get_backup_filename($s_restore['source']));

            $parameters .= $usr_str . $pw_str . ' ' . $backup_filename . ' ' . ibwa_escapeshellarg($s_restore['target']);

            list($binary_output, $binary_error) = exec_command('gbak', $parameters, TRUE);

            // try to connect the restored database
            if ($s_restore['connect'] == 'yes') {

                $s_login['database'] = $s_restore['target'];
                if (!empty($s_sysdba_pw)) {
                    $s_login['user'] = 'SYSDBA';
                    $s_login['password'] = $s_sysdba_pw;
                }

                if ($dbhandle = db_connect()) {
                    // connected successfully  
                    $s_connected = TRUE;
                    remove_edit_panels();
                }
                else {
                    // connect failed 
                    $ib_error = ibase_errmsg();
                    $s_login['password'] = '';
                    $s_connected = FALSE;
                }
            }
            cleanup_session();        
        }
    }
}


// print out all the panels
//
$active = 'Admin';
$panels = $s_admin_panels;

require('./inc/script_end.inc.php');



function get_backup_filename($pname) {

    return (defined('BACKUP_DIR')  &&  BACKUP_DIR !== '') 
        ?  BACKUP_DIR . basename($pname)
        : $pname;
}

?>