<?php
// File           jsrs/detail_close.php / ibWebAdmin
// Purpose        mark a detail in the session as closed
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <17/01/03 21:33:54 lb>
//
// $Id: detail_close.php,v 1.6 2003/02/04 19:47:42 lbrueckner Exp $

require('../inc/configuration.inc.php');
require('../inc/session.inc.php');
require('../inc/functions.inc.php');
require('jsrsServer.php.inc');

if (DEBUG === TRUE) {
    include('../inc/debug_funcs.inc.php');
}

session_start();
localize_session_vars();

$dbhandle = db_connect();


// answer to the request with the result of get_fk_values()
jsrsDispatch('close_detail');


// close the requested detail in the session
function close_detail($type, $name) {

    switch ($type) {
        case 'table':
        case 'view':
            $GLOBALS['s_tables'][$name]['status'] = 'close';
            break;
        case 'trigger':
            $GLOBALS['s_triggers'][$name]['display'] = 'close';
            break;
        case 'procedure':
            $GLOBALS['s_procedures'][$name]['status'] = 'close';
            break;
    }

    globalize_session_vars();

    return '';
}

?>
