/*
        IcuKrell 2.0.0-pre0.1 - drJeckyll <drJeckyll@hotmail.com>
*/

#include "icukrell.h"

GtkWidget *exec_entry,
          *auto_start_entry,
	  *auto_hide_entry,
	  *online_users_entry,
	  *scroll_direction_entry,
	  *auto_detect_ppp_entry,
	  *blink_spin,
	  *scroll_spin;

GtkObject *blink_spin_adj, *scroll_spin_adj;

void start_gnomeicu_func()
{
        FILE *f;
	gchar *exec_this;

	exec_this = g_strdup_printf("%s -a &", icukrell_exec_command);
        f = popen(exec_this, "r");
	if (!f)
	    gkrellm_message_window("IcuKrell Error", "Couldn't launch GnomeICU...", NULL);
	else
	    pclose(f);
	g_free(exec_this);
}

void kill_gnomeicu_func()
{
	FILE *f;

	do_action("status offline", NULL);
	usleep(1000);

	f = popen("killall -TERM gnomeicu", "r");
	if (!f)
	    gkrellm_message_window("IcuKrell Error", "Couldn't kill IcuKrell...", NULL);
        else pclose(f);
}

void start_gnomeicu(GtkWidget *w, gpointer data)
{
	first_start = TRUE;
}
  
void kill_gnomeicu(GtkWidget *w, gpointer data)
{
	kill_gnomeicu_func();
}

void set_status(GtkWidget *w, gpointer data)
{
	gchar ucmd[100];

	switch (GPOINTER_TO_INT(data))
	{
	    case STATUS_ONLINE:
		sprintf(ucmd, "status online");
		break;
	    case STATUS_AWAY:
		sprintf(ucmd, "status away");
		break;
	    case STATUS_NA:
		sprintf(ucmd, "status na");
		break;
	    case STATUS_FREE_CHAT:
		sprintf(ucmd, "status freechat");
		break;
	    case STATUS_OCCUPIED:
		sprintf(ucmd, "status occupied");
		break;
	    case STATUS_DND:
		sprintf(ucmd, "status dnd");
		break;
	    case STATUS_INVISIBLE:
		sprintf(ucmd, "status invisible");
		break;
	    case STATUS_OFFLINE:
		sprintf(ucmd, "status offline");
		break;
	}

	do_action(ucmd, NULL);
}

void show_window(GtkWidget *w, gpointer data)
{
	gchar ucmd[100];
	
	switch (GPOINTER_TO_INT(data))
	{
	    case 1:
		sprintf(ucmd, "show");
		break;
	    case 0:
		sprintf(ucmd, "hide");
		break;
	    case 100:
		sprintf(ucmd, "addcontact");
		break;
	    case 101:
		sprintf(ucmd, "showprefs");
		break;
	    case 102:
		sprintf(ucmd, "groupadmin");
		break;
	    case 103:
		sprintf(ucmd, "changeinfo");
		break;
	    case 200:
		sprintf(ucmd, "ignorelist");
		break;
	    case 201:
		sprintf(ucmd, "visiblelist");
		break;
	    case 202:
		sprintf(ucmd, "invisiblelist");
		break;
	    case 203:
		sprintf(ucmd, "notifylist");
		break;
	}

	do_action(ucmd, NULL);
}

static GtkItemFactoryEntry icukrell_factory[] =
{
        {"/-",                               NULL, NULL,          0               , "<Separator>"},
	{"/Main Window...",                  NULL, NULL,          0               , "<Branch>"},
	{"/Main Window.../Show",             NULL, show_window,   1               , "<Item>"},
	{"/Main Window.../Hide",             NULL, show_window,   0               , "<Item>"},
	{"/-",                               NULL, NULL,          0               , "<Separator>"},
        {"/Set Status...",                   NULL, NULL,          0               , "<Branch>"},
	{"/Set Status.../Online",            NULL, set_status,    STATUS_ONLINE   , "<Item>"},
	{"/Set Status.../Away",              NULL, set_status,    STATUS_AWAY     , "<Item>"},
	{"/Set Status.../Not Available",     NULL, set_status,    STATUS_NA       , "<Item>"},
	{"/Set Status.../Free for Chat",     NULL, set_status,    STATUS_FREE_CHAT, "<Item>"},
	{"/Set Status.../Occupied",          NULL, set_status,    STATUS_OCCUPIED , "<Item>"},
	{"/Set Status.../Do not Disturb",    NULL, set_status,    STATUS_DND      , "<Item>"},
	{"/Set Status.../Invisible",         NULL, set_status,    STATUS_INVISIBLE, "<Item>"},
	{"/Set Status.../-",                 NULL, NULL,          0               , "<Separator>"},
	{"/Set Status.../Offline",           NULL, set_status,    STATUS_OFFLINE  , "<Item>"},
	{"/-",                               NULL, NULL,          0               , "<Separator>"},
	{"/ICQ...",                          NULL, NULL,          0               , "<Branch>"},
	{"/ICQ.../Add Contact...",           NULL, show_window,   100             , "<Item>"},
	{"/ICQ.../Group Manager...",         NULL, show_window,   102             , "<Item>"},
	{"/ICQ.../Preferences...",           NULL, show_window,   101             , "<Item>"},
	{"/ICQ.../Change User Info...",      NULL, show_window,   103             , "<Item>"},
	{"/-",                               NULL, NULL,          0               , "<Separator>"},
	{"/Lists...",                        NULL, NULL,          0               , "<Branch>"},
	{"/Lists.../Ignore List...",         NULL, show_window,   200             , "<Item>"},
	{"/Lists.../Visible List...",        NULL, show_window,   201             , "<Item>"},
	{"/Lists.../Invisible List...",      NULL, show_window,   202             , "<Item>"},
	{"/Lists.../Online Notify List...",  NULL, show_window,   203             , "<Item>"},
	{"/-",                               NULL, NULL,          0               , "<Separator>"},
	{"/Kill gnomeICU",                   NULL, kill_gnomeicu, 0               , "<Item>"},
	{"/-",                               NULL, NULL,          0               , "<Separator>"},
};

static GtkItemFactoryEntry icukrell_factory_norun[] =
{
	{"/-",                           NULL, NULL,          0,    "<Separator>"},
	{"/Launch gnomeICU",             NULL, start_gnomeicu,0,    "<Item>"},
	{"/-",                           NULL, NULL,          0,    "<Separator>"},
};

GtkItemFactory *options_menu_factory(gint run_menu)
{
	int n;
	GtkItemFactory *music_factory;
	GtkAccelGroup  *axel;

        axel = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(gkrellm_get_top_window()), axel);

	music_factory = gtk_item_factory_new(GTK_TYPE_MENU, "<Main>", axel);
	    
	if (run_menu)
	{
		n = sizeof(icukrell_factory) / sizeof(GtkItemFactoryEntry);
		gtk_item_factory_create_items(music_factory, n, icukrell_factory, NULL);
	} else
	{
		n = sizeof(icukrell_factory_norun) / sizeof(GtkItemFactoryEntry);
		gtk_item_factory_create_items(music_factory, n, icukrell_factory_norun, NULL);
	}

	return music_factory;
}

void options_menu(GdkEventButton *ev)
{
	gtk_menu_popup(GTK_MENU(icukrell_running ?
			running_factory->widget : not_running_factory->widget),
			NULL, NULL, NULL, NULL,
			ev->button, ev->time);
}

void create_icukrell_config(GtkWidget *tab)
{
	gint i;
	GtkWidget *notebook,
	          *frame,
	          *label,
		  *info_label,
		  *hbox2,
		  *help_text,
		  *vbox, *hbox, *zbox;
	gchar *icukrell_about_text = NULL;
	gchar *icukrell_help_text[] = 
	{
	    "<h>IcuKrell\n",
	    "<b>gKrellM plugin which can set/display status of gnomeICU\n" \
	    "\n",
	    "<b>Features: \n",
	    "- Display popup menu with online users and send messages\n" \
	    "- Display gnomeICU status\n" \
	    "- Display number of online users\n" \
	    "- Display number of messages\n" \
	    "- Set gnomeICU status\n" \
	    "- popup response dialog\n" \
	    "- show/hide gnomeICU main window\n" \
	    "- edit gnomeICU preferencies\n" \
	    "- search/add new contacts\n" \
	    "- change user info\n" \
	    "- deal with gnomeICU lists (ignore, visible, invisible, notify)\n" \
	    "- apply gnomeICU themes !\n" \
	    "- and some more ;'))\n" \
	    "\n",
	    "<b>Mouse actions:\n",
	    "- Right click will popup menu\n" \
	    "- Middle button will popup menu with online users\n" \
	    "- Left click will make show hide gnomeICU main window\n if there no message\n" \
	    "  else will popup response dialog\n" \
	    "- If gnomeICU not running double left click will start gnomeICU\n" \
	};
	
	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(tab), notebook, TRUE, TRUE, 0);
	
	/* options tab */
	frame = gtk_frame_new(NULL);
	gtk_container_border_width(GTK_CONTAINER(frame), 3);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(vbox), 3);
	
	hbox = gtk_hbox_new(FALSE, 5);
	zbox = gtk_vbox_new(FALSE, 0);
	label = gtk_label_new("IcuKrell Executable:");
	gtk_box_pack_start(GTK_BOX(zbox), label, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), zbox, FALSE, FALSE, 0);

	zbox = gtk_vbox_new(FALSE, 0);
	exec_entry = gtk_entry_new_with_max_length(255);
	gtk_entry_set_text(GTK_ENTRY(exec_entry), icukrell_exec_command);
	gtk_entry_set_editable(GTK_ENTRY(exec_entry), TRUE);
	gtk_box_pack_start(GTK_BOX(zbox), exec_entry, TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), zbox, FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);

	// <hr>
	zbox = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), zbox, FALSE, FALSE, 0);
	
	// auto launch check box 
	auto_start_entry = gtk_check_button_new_with_label("Auto launch gnomeICU on IcuKrell startup");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(auto_start_entry), icukrell_auto_start);
	gtk_container_add(GTK_CONTAINER(vbox), auto_start_entry);
	
	// auto hide/show check box
	auto_hide_entry = gtk_check_button_new_with_label("Auto hide/show gnomeICU on IcuKrell start/stop");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(auto_hide_entry), icukrell_auto_hide);
	gtk_container_add(GTK_CONTAINER(vbox), auto_hide_entry);

	// autodetect PPP check box
	auto_detect_ppp_entry = gtk_check_button_new_with_label("Autodect PPP line");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(auto_detect_ppp_entry), auto_detect_ppp);
	gtk_container_add(GTK_CONTAINER(vbox), auto_detect_ppp_entry);

	// <hr>
	zbox = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), zbox, FALSE, FALSE, 0);

	// show OnLine Users panel
	online_users_entry = gtk_check_button_new_with_label("Show OnLine users scroll panel");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(online_users_entry), online_users_panel);
	gtk_container_add(GTK_CONTAINER(vbox), online_users_entry);

	// scroll direction check box
	scroll_direction_entry = gtk_check_button_new_with_label("Reverse scroll direction");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(scroll_direction_entry), online_panel_scroll_direction);
	gtk_container_add(GTK_CONTAINER(vbox), scroll_direction_entry);

	// scroll speed
	hbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);
	
	label = gtk_label_new("Scroll speed: ");
	gtk_box_pack_start(GTK_BOX(hbox),label, FALSE, FALSE, 0);

	scroll_spin_adj = gtk_adjustment_new(icukrell_scroll_speed, 1, 20, 1, 5, 5);
	scroll_spin = gtk_spin_button_new(GTK_ADJUSTMENT(scroll_spin_adj), 1, 0);
	gtk_box_pack_start(GTK_BOX(hbox), scroll_spin, FALSE, FALSE, 0);
	
	label = gtk_label_new(" (Default is 2 - lower is slow, higher is fast)");
	gtk_box_pack_start(GTK_BOX(hbox),label, FALSE, FALSE, 0);

	// <hr>
	zbox = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), zbox, FALSE, FALSE, 0);

	/* blink spin */
	hbox2 = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(vbox), hbox2);

	label = gtk_label_new("Blink speed: ");
	gtk_box_pack_start(GTK_BOX(hbox2),label, FALSE, FALSE, 0);

	blink_spin_adj = gtk_adjustment_new(icukrell_blink_speed, 1, 20, 1, 5, 5);
	blink_spin = gtk_spin_button_new(GTK_ADJUSTMENT(blink_spin_adj), 1, 0);
	gtk_box_pack_start(GTK_BOX(hbox2), blink_spin, FALSE, FALSE, 0);
	
	label = gtk_label_new(" (Default is 2 - lower is fast, higher is slow)");
	gtk_box_pack_start(GTK_BOX(hbox2),label, FALSE, FALSE, 0);
	
	label = gtk_label_new("Options");
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);
	
	/* help tab */
	vbox = gkrellm_gtk_framed_notebook_page(notebook, "Help");
	
	help_text = gkrellm_gtk_scrolled_text_view(vbox, NULL, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	for (i = 0; i < sizeof(icukrell_help_text)/sizeof(gchar *); ++i)
	    gkrellm_gtk_text_view_append(help_text, icukrell_help_text[i]);
		
	/* about tab */
	icukrell_about_text = g_strdup_printf
	(
	    "IcuKrell %d.%d.%d%s\n" \
	    "gKrellM plugin dealing with gnomeICU\n" \
	    "\n"
	    "(c) Copyright 2002 by drJeckyll\n" \
	    "drJeckyll@hotmail.com\n" \
	    "http://icukrell.sourceforge.net\n" \
	    "\n" \
	    "Released under the GNU Public License\n",
	    ICUKRELL_VERSION_MAJOR, ICUKRELL_VERSION_MINOR, ICUKRELL_VERSION_REV, ICUKRELL_VERSION_STAGE
	);
	info_label = gtk_label_new(icukrell_about_text);
	g_free(icukrell_about_text);
	label = gtk_label_new("About");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), info_label, label);
}						     

void icukrell_apply_config()
{
	int scroll_panel;

	g_free(icukrell_exec_command);
	icukrell_exec_command = g_strdup(gtk_entry_get_text(GTK_ENTRY(exec_entry)));
	
	scroll_panel = online_users_panel;
	
	icukrell_auto_hide = GTK_TOGGLE_BUTTON(auto_hide_entry)->active;
	icukrell_auto_start = GTK_TOGGLE_BUTTON(auto_start_entry)->active;
	online_users_panel = GTK_TOGGLE_BUTTON(online_users_entry)->active;
	online_panel_scroll_direction = GTK_TOGGLE_BUTTON(scroll_direction_entry)->active;
	auto_detect_ppp = GTK_TOGGLE_BUTTON(auto_detect_ppp_entry)->active;
	icukrell_blink_speed = atoi(gkrellm_gtk_entry_get_text(&blink_spin));
	icukrell_scroll_speed = atoi(gkrellm_gtk_entry_get_text(&scroll_spin));

	if (online_users_panel != scroll_panel)
	{
#ifdef TEMP
	    fprintf(stderr, "config destroy\n");
#endif
	}
	    
}

void icukrell_save_config(FILE *f)
{
	fprintf(f, "%s icukrell_exec_command %s\n", CONFIG_KEYWORD, icukrell_exec_command);
	fprintf(f, "%s gnomeicu_auto_start %d\n", CONFIG_KEYWORD, icukrell_auto_start);
	fprintf(f, "%s gnomeicu_auto_hide %d\n", CONFIG_KEYWORD, icukrell_auto_hide);
	fprintf(f, "%s online_users_panel %d\n", CONFIG_KEYWORD, online_users_panel);
	fprintf(f, "%s online_panel_scroll_direction %d\n", CONFIG_KEYWORD, online_panel_scroll_direction);
	fprintf(f, "%s auto_detect_ppp %d\n", CONFIG_KEYWORD, auto_detect_ppp);
	fprintf(f, "%s icukrell_scroll_speed %d\n", CONFIG_KEYWORD, icukrell_scroll_speed);
	fprintf(f, "%s icukrell_blink_speed %d\n", CONFIG_KEYWORD, icukrell_blink_speed);
}

void icukrell_load_config(gchar *arg)
{
	gchar config[64], item[256], command[256];
	gint n;

#ifdef TEST_MODE
	fprintf(stderr, "start load_config\n");
#endif
        n = sscanf(arg, "%s %[^\n]", config, item);
	if (n == 2)
	{
	    if (strcmp(config, "icukrell_exec_command") == 0)
	    {
		    sscanf(item, "%s\n", command);
		    g_free(icukrell_exec_command);
		    icukrell_exec_command = g_strdup(command);
	    }
	    else
	    if (strcmp(config, "gnomeicu_auto_start") == 0) sscanf(item, "%d\n", &icukrell_auto_start);
	    else
	    if (strcmp(config, "gnomeicu_auto_hide") == 0) sscanf(item, "%d\n", &icukrell_auto_hide);
	    else
	    if (strcmp(config, "online_users_panel") == 0) sscanf(item, "%d\n", &online_users_panel);
	    else
	    if (strcmp(config, "online_panel_scroll_direction") == 0) sscanf(item, "%d\n", &online_panel_scroll_direction);
	    else
	    if (strcmp(config, "auto_detect_ppp") == 0) sscanf(item, "%d\n", &auto_detect_ppp);
	    else
	    if (strcmp(config, "icukrell_scroll_speed") == 0) sscanf(item, "%d\n", &icukrell_scroll_speed);
	    else
	    if (strcmp(config, "icukrell_blink_speed") == 0) sscanf(item, "%d\n", &icukrell_blink_speed);
	}
	
	if (icukrell_blink_speed == 0) icukrell_blink_speed = 2;
	if (icukrell_scroll_speed == 0) icukrell_scroll_speed = 2;

#ifdef TEST_MODE
	fprintf(stderr, "end load_config\n");
#endif
}
