/*
#   dsp.h: DSP routines for the IDJC mixer.
#   Copyright (C) 2005-2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* Use the same format for the DSP routines as JACK uses for its audio format */

#include <stdlib.h>
#include <jack/jack.h>

/* typedef jack_default_audio_sample_t dfilter_t; */
typedef double dfilter_t;

struct digital_filter
   {
   int siz;
   dfilter_t *y;
   dfilter_t *x;
   dfilter_t *a;
   dfilter_t *b;
   dfilter_t gain;
   };

/* digital filter creation function which copies the input buffers */
struct digital_filter *new_digital_filter(size_t siz_a, dfilter_t *co_a, size_t siz_b, dfilter_t *co_b, dfilter_t gain);

/* frees up memory used by the digital filter */
void free_digital_filter(struct digital_filter *self);

/* the actual digital filter function - and a function in the mathematical sense too */
dfilter_t digital_filter(struct digital_filter *self, dfilter_t newx);
