/*
#   metaqueue.c: stores up new metadata for timely transmission
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include "metaqueue.h"

struct metaqueue *metaqueue_init()
   {
   return (struct metaqueue *)calloc(1, sizeof (struct metaqueue));
   }
   
int metaqueue_add(struct metaqueue *self, char **songname, char **title, char **artist)
   {
   struct metaqueue *new;
      
   while (self->next != NULL)
      self = self->next;
   if (!(new = (struct metaqueue *)calloc(1, sizeof (struct metaqueue))))
      return 0;
   self->songname = *songname;
   *songname = NULL;		/* prevent the data from being freed */
   self->title = *title;
   *title = NULL;
   self->artist = *artist;
   *artist = NULL;
   new->prev = self;
   self->next = new;		/* self->next != NULL signifies this one can be read */
   return 1;
   }

/* a successful call to this function should be followed with a call to metadata_remove_current once you are done with the metadata */
int metaqueue_get_current_metadata(struct metaqueue *self, char **songname, char **title, char **artist)
   {
   if (self->next)	/* this varible being set guarantees that the others have too */
      {
      *songname = self->songname;
      *title = self->title;
      *artist = self->artist;
      return 1;
      }
   return 0;
   }

int metaqueue_remove_current(struct metaqueue **self)
   {
   if ((*self)->next == NULL)
      {
      fprintf(stderr, "metaqueue_remove_current: usage error - can't remove current - exiting\n");
      exit(5);
      }
   *self = (*self)->next;
   free((*self)->prev->songname);
   free((*self)->prev->title);
   free((*self)->prev->artist);
   free((*self)->prev);
   (*self)->prev = NULL;
   return 1;
   }

/* this function disposes of the queue */
void metaqueue_cleanup(struct metaqueue *self)
   {
   if (self->next)
      metaqueue_cleanup(self->next);		/* n.b. recursive! */
   if (self->songname)
      free(self->songname);
   if (self->title)
      free(self->title);
   if (self->artist)
      free(self->artist);
   free(self);
   return;
   }
