/*
#   sndfileinfo.c: Provide information on wav files
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <stdio.h>
#include <sndfile.h>
#include "sndfileinfo.h"

int sndfileinfo(char *pathname)
   {
   SF_INFO sfinfo;
   SNDFILE *handle;
   const char *artist, *title;

   if (!(handle = sf_open(pathname, SFM_READ, &sfinfo)))
      {
      fprintf(stderr, "sndfileinfo failed to open file %s\n", pathname);
      return 0;
      }
   artist = sf_get_string(handle, SF_STR_ARTIST);
   title = sf_get_string(handle, SF_STR_TITLE);
 
   printf("idjcmixer: sndfileinfo length=%d\n", (int)(sfinfo.frames / sfinfo.samplerate));
   if (artist && title)
      {
      printf("idjcmixer: sndfileinfo artist=%s\n", artist);
      printf("idjcmixer: sndfileinfo title=%s\n", title);
      }
   printf("idjcmixer: sndfileinfo end\n");
   sf_close(handle);
   fflush(stdout);
   return 1;
   }
