/*
#   vorbinfo.c: Provide information on vorbis files without doing a full test on the file
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <vorbis/vorbisfile.h>
#include <vorbis/codec.h>

int vorbinfo(char *pathname, char **artist, char **title, double *length)
   {
   FILE *fp;
   OggVorbis_File vf;
   vorbis_comment *vc;
   int i;
   char *line = NULL;

   fp = fopen(pathname, "r");
   if (fp == NULL)
      {
      fprintf(stderr, "idjcmixer: vorbinfo: could not open file %s\n", pathname);
      return 0;
      }
   if (ov_open(fp, &vf, NULL, 0))
      {
      fprintf(stderr, "idjcmixer: vorbinfo: ov_test_failed - possibly not a valid vorbis file\n");
      fclose(fp);
      return 0;
      }
   *length = ov_time_total(&vf, -1);
   *artist = realloc(*artist, 1);
   *artist[0] = '\0';
   *title = realloc(*title, 1);
   *title[0] = '\0';
   if (*artist == NULL || *title == NULL)
      {
      fprintf(stderr, "idjcmixer: vorbinfo: malloc failure\n");
      exit(1);
      }
   vc = ov_comment(&vf, -1);
   for (i = 0; i < vc->comments; i++)
      {
      line = realloc((void *)line, vc->comment_lengths[i] + 1);
      if (line == NULL)
         {
         fprintf(stderr, "idjcmixer: vorbinfo: malloc failure allocating line\n");
         exit(1);
         }
      snprintf(line, vc->comment_lengths[i] +1, "%s", vc->user_comments[i]);
      if (!strncmp(line, "ARTIST=", 7) || !strncmp(line, "artist=", 7))
         {
         *artist = realloc((void *)*artist, strlen(line) - 6);
         if (!*artist)
            {
            fprintf(stderr, "idjcmixer: vorbinfo: malloc failure\n");
            exit(1);
            }
         strcpy(*artist, line + 7);
         }
      if (!strncmp(line, "TITLE=", 6) || !strncmp(line, "title=", 6))
         {
         *title = realloc((void *)*title, strlen(line) - 5);
         if (!*title)
            {
            fprintf(stderr, "idjcmixer: vorbinfo: malloc failure\n");
            exit(1);
            }
         strcpy(*title, line + 6);
         }
      }
   if (line)
      free(line);
   ov_clear(&vf);
   return 1;
   }
