/*
#   metaqueue.h: stores up new metadata for timely transmission
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

struct metaqueue
   {
   struct metaqueue *next;
   struct metaqueue *prev;
   char *songname;		/* the song title in latin-1 encoding for mp3 */
   char *title;			/* the song title encoded in utf-8 for ogg */
   char *artist;		/* the song artist encoded in utf-8 for ogg */
   };

struct metaqueue *metaqueue_init();
int metaqueue_add(struct metaqueue *self, char **songtitle, char **title, char **artist);
int metaqueue_get_current_metadata(struct metaqueue *self, char **songtitle, char **title, char **artist);
int remove_current(struct metaqueue **self);
void metaqueue_cleanup(struct metaqueue *self);
