#   IDJCmedia.py: GUI code for main media players in IDJC
#   Copyright (C) 2005 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk
import gobject
import os
import sys
import time
import random
import signal
import eyeD3
from stat import *
from IDJCmultitagger import*
from IDJCfree import *
from idjc_config import *
from langheader import *

# Arrow button creation helper function
def make_arrow_button(self, arrow_type, shadow_type, data):
   button = gtk.Button();
   arrow = gtk.Arrow(arrow_type, shadow_type);
   button.add(arrow)
   button.connect("clicked", self.callback, data)
   button.show()
   arrow.show()
   return button

def get_number_for(token, string):
   try:
      end = string.rindex(token)
      start = end - 1
      while start >= 0 and (string[start].isdigit() or string[start] == "."):
         start = start - 1
      return int(float(string[start+1:end]))
   except ValueError:
      return 0
   
class nice_listen_togglebutton(gtk.ToggleButton):
   def __init__(self, label = None, use_underline = True):
      gtk.ToggleButton.__init__(self, label, use_underline)
   def __str__(self):
      return gtk.ToggleButton.__str__() + " auto inconsistent when insensitive"
   def set_sensitive(self, bool):
      if bool is False:
         gtk.ToggleButton.set_sensitive(self, False)
         gtk.ToggleButton.set_inconsistent(self, True)
      else:
         gtk.ToggleButton.set_sensitive(self, True)
         gtk.ToggleButton.set_inconsistent(self, False)
         
class IDJC_Media_Player:
   def get_media_metadata(self, filename):
      # This is the third incarnation of this function.
   
      artist = u""
      title = u""
      length = 0
      artist_retval = u""
      title_retval = u""
      
      # Strip away any file:// prefix
      if filename.count("file://", 0, 7):
         filename = filename[7:]
      elif filename.count("file:", 0, 5):
         filename = filename[5:]
      # Attempt to get the file extension
      try:
         filext = os.path.splitext(filename)[1]
         if [ ".mp3", ".ogg", ".flac", ".wma", ".m4a", ".wav", ".avi", ".mp4" ].count(filext) != 1:
            raise
         if os.path.isfile(filename) == False:
            raise
      except:
         return [ "Not a valid file", filename, 0, "", "latin1", "", "" ]   
      
      # Use this name for metadata when we can't get anything from the ID3 tags
      # The name will also appear grey
      meta_name = os.path.basename(filename)
      enclist = self.parent.fenc.split(",")
      for each in enclist:
         each = each.strip()
         if each == "@locale":
            each = self.parent.denc
         try:
            meta_name = unicode(os.path.splitext(meta_name)[0], each)
         except:
            pass
         else:
            encoding = each
            rsmeta_name = u'<span foreground="gray">' + rich_safe(meta_name) + '</span>'
            title_retval = rsmeta_name
            break
      else:
         encoding = "latin1"		# Have to default to something.
         meta_name = u'Unknown'
         rsmeta_name = u'<span foreground="gray">Unknown encoding</span>'
         title_retval = rsmeta_name
         
      filext = filext.lower()
      if filext == ".mp3" or filext == ".flac" or filext == ".wma" or filext == ".ogg":
         try:
            if eyeD3.isMp3File(filename):
               audiofile = eyeD3.Mp3AudioFile(filename, eyeD3.ID3_V2)
               length = audiofile.getPlayTime()
               tag = audiofile.getTag()
            else:
               tag = eyeD3.Tag()		# Attempt to read an id3 tag from a flac file
               tag.link(filename, eyeD3.ID3_V2)
            artist = unicode(tag.getArtist())
            title = unicode(tag.getTitle())
         except:
            print "Problem with reading ID3v2 tag"
         try:
            if eyeD3.isMp3File(filename) and length == 0:
               audiofile = eyeD3.Mp3AudioFile(filename, eyeD3.ID3_V1)
               length = audiofile.getPlayTime()
               tag = audiofile.getTag()
            else:
               tag = eyeD3.Tag()		# Attempt to read an id3 tag from a flac file
               tag.link(filename, eyeD3.ID3_V1)
         except eyeD3.tag.TagException:
            if length == 0:
               print "Could not get length for the file", filename, "Using a length of zero instead"
         except eyeD3.tag.InvalidAudioFormatException:
            return [ "Not a valid file", filename, 0, "", "latin1", "", "" ]  
         if tag is not None and (artist == u"" or title == u""):
            artist = unicode(tag.getArtist())
            title = unicode(tag.getTitle())
            
         while artist != u"" and artist[-1] == u"\x00":
            artist = artist[:-1]
         artist = artist.strip()
         while title != u"" and title[-1] == u"\x00":
            title = title[:-1]
         title = title.strip()
         if artist != u"" and title != u"":
            rsmeta_name = meta_name = artist + u" - " + title
      	    title_retval = title
            artist_retval = artist
      
      if filext == ".ogg" and os.environ.get("ogginfo") != "missing":
         self.parent.mixer_write("OGGP=%s\nACTN=ogginforequest\nend\n" % filename, True)
         while 1:
            line = self.parent.mixer_read()
            if line == "OIR:NOT VALID\n" or line == "":
               return [ "Not a valid file", filename, 0, "", "latin1", "", "" ]
            if line.startswith("OIR:ARTIST="):
               artist = line[11:].strip()
            if line.startswith("OIR:TITLE="):
               title = line[10:].strip()
            if line.startswith("OIR:LENGTH="):
               length = int(float(line[11:].strip()))
            if line == "OIR:end\n":
	       break

         if artist != "" and title != "":
            artist = artist.decode("utf-8")
            title = title.decode("utf-8")
            rsmeta_name = meta_name = artist + u" - " + title
            title_retval = title
            artist_retval = artist

      elif filext == ".flac" and os.environ.get("metaflac") != "missing":
         (stdin,stdout)=os.popen2([ os.environ.get("metaflac") ,"--no-utf8-convert", "--show-sample-rate","--show-total-samples", "--show-tag=TITLE", "--show-tag=ARTIST",filename])
         stdin.close()
         data = unicode(stdout.read())
         stdout.close
         data = data.splitlines()
         try:
            length = int(data[1]) / int(data[0]) 
         except:
            return [ "Not a valid file", filename, 0, "", "latin1", "", "" ]
         artist = title = u""
         for each in data:
            if each[:7] == "ARTIST=" or each[:7] == "artist":
               artist = each[7:].strip()
            if each[:6] == "TITLE=" or each[:6] == "title":
               title = each[6:].strip()
         if artist != u"" and title != u"":
            rsmeta_name = meta_name = artist + " - " + title
            title_retval = title
            artist_retval = artist
      elif (filext == ".mp4" or filext == ".m4a") and mp4enabled:
         print "getting info for mp4 file"
         self.parent.mixer_write("MP4P=%s\nACTN=mp4inforequest\nend\n" % filename, True)
         while 1:
            line = self.parent.mixer_read()
            if line == "idjcmixer: mp4fileinfo Not Valid\n" or line == "":
               return [ "Not a valid file", filename, 0, "", "latin1", "", "" ]
            if line.startswith("idjcmixer: mp4fileinfo artist="):
               artist = line[30:].strip()
            if line.startswith("idjcmixer: mp4fileinfo title="):
               title = line[29:].strip()
            if line.startswith("idjcmixer: mp4fileinfo length="):
               length = int(float(line[30:].strip()))
            if line == "idjcmixer: mp4fileinfo end\n":
	       break
         if artist != "" and title != "":
            artist = artist.decode("utf-8")
            title = title.decode("utf-8")
            rsmeta_name = meta_name = artist + u" - " + title
            title_retval = title
            artist_retval = artist
      else: 
         self.parent.mixer_write("PLRP=%s\nACTN=askxine\nend\n" % filename, True)
         while 1:
            line = self.parent.mixer_read()
            if line == "":
               return [ "Not a valid file", filename, 0, "", "latin1", "", "" ] 
            if line == "askxine: done\n":
               break
            if line == "askxine: error\n":
               length = None
            if line.startswith("askxine: length="):
               length = int(line[16:-1])
            if line.startswith("askxine: artist="):
               artist = line[16:-1]
            if line.startswith("askxine: title="):
               title = line[15:-1]
         if length == None:
            return [ "Not a valid file", filename, 0, "", "latin1", "", "" ]
         if artist != "" and title != "":
            artist = artist.decode("utf-8")
            title = title.decode("utf-8")
            rsmeta_name = meta_name = artist + u" - " + title
            artist_retval = artist
            title_retval = title

      if rsmeta_name == meta_name:
         return [ rich_safe(rsmeta_name), filename, length, meta_name, encoding, title_retval, artist_retval ]
      else:
         return [ rsmeta_name, filename, length, meta_name, encoding, title_retval, artist_retval ]
      
   # Update playlist entries for a given filename e.g. when tag has been edited
   def update_playlist(self, newdata):
      update = False
      for item in self.liststore:
         if item[1] == newdata[1]:
            if item[0][:3] == "<b>":
               item[0] = u"<b>" + newdata[0] + u"</b>"
               update = True
            else:
               item[0] = newdata[0]
            item[3] = newdata[3]
            item[5] = newdata[5]
            item[6] = newdata[6]
      if update:
         self.songname = newdata[3]	# update metadata on server
         self.title = newdata[5].encode("utf-8")
         self.artist = newdata[6].encode("utf-8")
         self.parent.send_new_mixer_stats()
      
   # Shut down our media players when we exit.
   def cleanup(self):
      if self.player_is_playing:
         self.stop.clicked()
      self.save_session()

   def save_session(self):
      fh = open(self.session_filename, "w")
      fh.write("digiprogress_type=" + str(int(self.digiprogress_type)) + "\n")
      fh.write("stream_button=" + str(int(self.stream.get_active())) + "\n")
      fh.write("listen_button=" + str(int(self.listen.get_active())) + "\n")
      fh.write("playlist_mode=" + str(self.pl_mode.get_active()) + "\n")
      for entry in self.liststore:
         fh.write("pe=")
         entry = list(entry)
         for item in entry:
            if type(item) == int:
               item = str(item)
               fh.write("i")
            else:
               fh.write("s")
            fh.write(str(len(item)) + ":" + item)
         fh.write("\n")
      model, iter = self.treeview.get_selection().get_selected()
      if iter is not None:
         fh.write("select=" + str(model.get_path(iter)[0]) + "\n")
      fh.close()

   def restore_session(self):
      try:
         fh = open(self.session_filename, "r")
      except:
         return
      while 1:
         try:
            line = fh.readline()
            if line == "":
               break
         except:
            break
         try:
            if line.startswith("digiprogress_type="):
               if int(line[18]) != self.digiprogress_type:
                  self.digiprogress_click()
            if line.startswith("stream_button="):
               self.stream.set_active(int(line[14]))
            if line.startswith("listen_button="):
               self.listen.set_active(int(line[14]))
            if line.startswith("playlist_mode="):
               self.pl_mode.set_active(int(line[14]))
            if line.startswith("pe="):
               playlist_entry = self.pl_unpack(line[3:])
               try:
                  self.liststore.append(playlist_entry)
               except:		# playlist data may not be compatible across IDJC versions
                  playlist_entry = self.get_media_metadata(playlist_entry[1])
                  if playlist_entry[0] != "Not a valid file":
                     self.liststore.append(playlist_entry)
            if line.startswith("select="):
               path = line[7:-1]
               try:
                  self.treeview.get_selection().select_path(path)
                  self.treeview.scroll_to_cell(path, None, False) 
               except:
                  pass
         except ValueError:
            pass

   def pl_unpack(self, text):		# converts a string encoded list to a python list
      start = 0	
      item = 0	
      reply = list()
      while text[start] != "\n":
         end = start
         while text[end] != ":":
            end = end + 1				
         nextstart = int(text[start + 1 : end]) + end + 1
         if (text[start] == "s"):
            reply.append(text[ end+1 : nextstart ])
         elif (text[start] == "i"):
            try:
               reply.append(int(text[ end+1 : nextstart ]))
            except:
               print "pl_unpack: bad integer data"
               return []
         else:
            print "pl_unpack: unknown data type:", text[start]
            return []
         start = nextstart
      return reply
             
   def handle_stop_button(self, widget):
      self.restart_cancel = True
      if self.is_playing == True:
         self.is_playing = False
	 if self.timeout_source_id:
	    gobject.source_remove(self.timeout_source_id)
	 # This will make our play button code branch to its shutdown code.
	 self.is_stopping = True
	 # This will emit a signal which will trigger the play button handler code.
	 self.play.set_active(False)
	 # Must do pause as well if it is pressed.
	 if self.pause.get_active() == True:
	    self.pause.set_active(False)
	 self.parent.send_new_mixer_stats()
         
   def handle_pause_button(self, widget, selected):
      if self.is_playing == True:
         if self.is_paused == False:
            # Player pause code goes here
	    print "Player paused"
	    self.is_paused = True
	    self.parent.send_new_mixer_stats()
	 else:
	    # Player unpause code goes here
	    print "Player unpaused"
	    self.is_paused = False
	    self.parent.send_new_mixer_stats()
      else:
         # Prevent the pause button going into its on state when not playing.
	 if selected:
	    # We must unselect it.
	    widget.set_active(False)
	 else:
	    self.is_paused = False
   
   def handle_play_button(self, widget, selected):
      if selected == False:
         # Prevent the button from being toggled off by clicking on a selected play button.
	 # This emits a toggled signal so we will handle this eventuality too.
	 # Note that when flag is_stopping is set we don't want to reactivate this button.
         if self.is_stopping == False:
	    widget.set_active(True)
	 else:
	    self.is_stopping = False
            if self.player_is_playing == True:
               self.player_shutdown()
      else:
         if self.is_playing == True:
	    if self.new_title == True:
	       self.new_title = False
               self.player_shutdown()
	       self.parent.send_new_mixer_stats()
	       self.player_is_playing = self.player_startup()
	       if self.player_is_playing == False:
                  self.player_is_playing = True
	          #self.next.clicked()
                  #self.invoke_end_of_track_policy()
	       if self.is_paused:
	          self.pause.set_active(False)
	    else:    
	       print "Someone probably clicked Play when we were already playing"
	 else:
            self.is_playing = True
	    self.new_title = False
	    if self.player_startup():
	       self.player_is_playing = True
               print "Player has started"
	    else:
	       # Make our buttons match the player's state
               self.player_is_playing = True
	       self.next.clicked()
   
   def player_startup(self):
      if self.player_is_playing == True:
         # Use the current song if one is playing.
	 model = self.model_playing
	 iter = self.iter_playing
      else:
         # Get our next playlist item.
         treeselection = self.treeview.get_selection()
         (model, iter) = treeselection.get_selected()
      if iter == None:
         print "Nothing selected in the playlist - trying the first entry."
	 try:
            iter = model.get_iter(0)
	 except:
	    print "Playlist is empty"
	    return False
         print "We start at the beginning"
	 treeselection.select_iter(iter)
         
      self.treeview.scroll_to_cell(model.get_path(iter)[0], None, False)

      # Songname is used for metadata for mp3	 
      self.songname = unicode(model.get_value(iter, 3))
      # These two are used for ogg metadata
      self.title = unicode(model.get_value(iter, 5)).encode("utf-8", "replace")
      self.artist = unicode(model.get_value(iter, 6)).encode("utf-8", "replace")
      self.parent.send_new_mixer_stats() 	 
      self.music_filename = model.get_value(iter, 1)
      # rt is the run time in seconds of our song
      rt = model.get_value(iter, 2)
      if rt < 0:
         rt = 0		# playlist controls have negative numbers
      # Calculate our seek time scaling from old slider settings.
      # Used for when seek is moved before play is pressed.
      if os.path.isfile(self.music_filename):
         try:
            self.start_time = int(self.progressadj.get_value() / self.max_seek * float(rt))
         except ZeroDivisionError:
            self.start_time = 0
      else:
         self.start_time = rt	# Seek to the end when file is missing - looks very slick in action.
      print "Seek time is %d seconds" % self.start_time
           
      # Now we recalibrate the progress bar to the current song length
      self.digiprogress_f = True
      self.progressadj.set_all(float (self.start_time) , 0.0, rt, rt/1000.0, rt/100.0, 0.0)
      self.progressadj.emit("changed")
      # Set the stop figure used by the progress bar's timeout function
      self.progress_stop_figure = model.get_value(iter, 2)
      self.progress_current_figure = self.start_time
      
      self.player_is_playing = True
      
      # Bold highlight the file we are playing
      text = model.get_value(iter, 0)
      text = "<b>" + text + "</b>"
      model.set_value(iter, 0, text)
      self.iter_playing = iter
      self.model_playing = model
      self.max_seek = rt
      self.silence_count = 0
      
      if self.music_filename != "":
         if self.gapless == False:
            self.parent.mixer_write("PLRP=%s\nSEEK=%d\nACTN=play%s\nend\n" % (
                                 self.music_filename, self.start_time, self.playername), True)
         else:
            print "playing without flush"
            self.parent.mixer_write("PLRP=%s\nSEEK=%d\nACTN=playnoflush%s\nend\n" % (
                                 self.music_filename, self.start_time, self.playername), True)
         while 1:
            line = self.parent.mixer_read()
            if line.startswith("context_id="):
               self.player_cid = int(line[11:-1])
               break
            if line == "":
               self.player_cid = -1
               break
      else:
         print "skipping play for empty filename"
         self.player_cid = -1
      if self.player_cid == -1:
         print "player startup was unsuccessful for file", self.music_filename
         #return False
      print "player context id is %d\n" % self.player_cid
      self.timeout_source_id = gobject.timeout_add(100, self.cb_play_progress_timeout, self.player_cid)
      return True

   def player_shutdown(self):
      print "player shutdown code was called"
      
      if self.iter_playing:
         # Unhighlight this track
         text = self.model_playing.get_value(self.iter_playing, 0)
         if text[:3] == "<b>":
            text = text[3:-4]
            self.model_playing.set_value(self.iter_playing, 0, text)
         self.file_iter_playing = 0

      self.player_is_playing = False
      if self.timeout_source_id:
         gobject.source_remove(self.timeout_source_id)
         
      self.playtime_elapsed.set_value(0)
      self.progressadj.set_value(0.0)
      self.progressadj.value_changed()
      
      if self.gapless == False:
         self.parent.mixer_write("ACTN=stop%s\nend\n" % self.playername, True)
      
      self.digiprogress_f = False
      self.other_player_initiated = False
      self.crossfader_initiated = False
   
   def player_restart(self):
      gobject.source_remove(self.timeout_source_id)
      self.start_time = int (self.progressadj.get_value())
      self.silence_count = 0
      self.parent.mixer_write("PLRP=%s\nSEEK=%d\nACTN=play%s\nend\n" % (
      				self.music_filename, self.start_time, self.playername), True)
      while 1:
         line = self.parent.mixer_read()
         if line.startswith("context_id="):
            self.player_cid = int(line[11:-1])
            break
         if line == "":
            self.player_cid = -1
            break
      if self.player_cid == -1:
         print "player startup was unsuccessful for file", self.music_filename
         return False
      
      print "player context id is %d\n" % self.player_cid
      
      # Restart a callback to update the progressbar.
      self.timeout_source_id = gobject.timeout_add(100,	self.cb_play_progress_timeout, self.player_cid)
      return True

   def invoke_end_of_track_policy(self):
      # This is where we implement the playlist modes.
      mode_text = self.pl_mode.get_active_text()
      if self.is_playing == False:
         print "Assertion failed in: invoke_end_of_track_policy"
	 return
      
      if mode_text == manual_text:
         # For Manual mode just stop the player at the end of the track.
	 print "Stopping in accordance with manual mode"
         self.stop.clicked()
      elif mode_text == play_all_text:
         if self.music_filename == "":
            self.handle_playlist_control()
         else:
            self.next.clicked()
            treeselection = self.treeview.get_selection()
            if self.is_playing == False:
               treeselection.select_path(0) # park on the first menu item
      elif mode_text == loop_all_text or mode_text == cue_up_text:
     	 path = self.model_playing.get_path(self.iter_playing)[0]+1
	 self.stop.clicked()
         try:
	    self.model_playing.get_iter(path)
	    print "Picking the next element in the playlist"
	 except:
	    print "We are at the bottom. Picking the first element"
	    path = 0
         treeselection = self.treeview.get_selection()
	 treeselection.select_path(path)
         if mode_text == loop_all_text or (mode_text == cue_up_text and self.model_playing[path][0][0] == ">"):
            self.play.clicked()
      elif mode_text == random_text:
	 # Count the number of tracks
	 self.stop.clicked()	
	 count = 0
         while 1:
	    try:
               self.model_playing.get_iter(count)
               count = count + 1 
	    except:
               break
         
	 print "There are", count, "elements in the playlist"
         # Pick a new track almost at random
	 
         new_path = random.randint(0, count -1)
	 if count > 3:
	    # Prevent repetition of songs when there are more than 3 in the playlist
	    current_path = self.model_playing.get_path(self.iter_playing)[0]
	    while new_path == current_path:
	       # Must try again
	       new_path = random.randint(0, count -1)
	 
	 print "New track is:", new_path
         treeselection = self.treeview.get_selection()	 
	 treeselection.select_path(new_path)
	 self.play.clicked()
      else:
	 print 'The mode "%s" is not currently supported - stopping' % mode_text
	 self.stop.clicked()

   def handle_playlist_control(self):
      treeselection = self.treeview.get_selection()
      model = self.model_playing
      iter = self.iter_playing
      control = model.get_value(iter, 0)
      print "control is", control
      if control == "<b>>stopplayer</b>":
         print "player", self.playername, "stopping due to playlist control"
         self.stop.clicked()
         if model.iter_next(iter):
            treeselection.select_iter(model.iter_next(iter))
         else:
            treeselection.select_iter(model.get_iter_first())
      if control == "<b>>crossfade</b>":
         print "player", self.playername, "stopping, crossfade complete"
         self.stop.clicked()
         if model.iter_next(iter):
            treeselection.select_iter(model.iter_next(iter))
         else:
            treeselection.select_path(0)
      if control == "<b>>stopstreaming</b>":
         self.next.clicked()
         if self.parent.server_window.connect_button.get_active():
            print "stopping streaming due to", self.playername, "playlist control"
            self.parent.server_window.connect_button.set_active(False)
         if self.is_playing == False:
            treeselection.select_path(0)
      if control == "<b>>stoprecording</b>":
         self.next.clicked()
         if self.parent.server_window.record_button.get_active():
            print "stopping recording due to", self.playername, "playlist control"
            self.parent.server_window.stop_button.clicked()
         if self.is_playing == False:
            treeselection.select_path(0)
      if control == "<b>>transfer</b>":
         if self.playername == "left":
            otherplayer = self.parent.player_right
            self.parent.passright.clicked()
         else:
            otherplayer = self.parent.player_left
            self.parent.passleft.clicked()
         print "transferring to player", otherplayer.playername
         otherplayer.play.clicked()
         self.stop.clicked()
         if model.iter_next(iter):
            treeselection.select_iter(model.iter_next(iter))
         else:
            treeselection.select_path(0)

   def get_pl_block_size(self, iter):
      size = 0
      while iter is not None:
         length = self.liststore.get_value(iter, 2)
         if length == -11:
            break
         if length >= 0:
            size += length
         iter = self.liststore.iter_next(iter)
      return size

   def update_time_stats(self):
      if self.pl_mode.get_active() != 0:		# optimisation -- this function uses a lot of cpu
         return
      if self.is_playing:
         tr = int(self.max_seek - self.progressadj.value)
         model = self.model_playing
         iter = model.iter_next(self.iter_playing)
         tr += self.get_pl_block_size(iter)
      else:
         tr = 0
      selection = self.treeview.get_selection()
      model, iter = selection.get_selected()
      if iter is None:
         if self.is_playing:
            bs = 0
         else:
            iter = model.get_iter_first()
            bs = self.get_pl_block_size(iter)
      else:
         if model.get_value(iter, 0)[0:3] == "<b>":
            bs = 0
         else:
            bs = self.get_pl_block_size(iter)
      bss = bs % 60
      bsm = (bs - bss) / 60
      if self.is_playing:
         trs = tr % 60
         trm = (tr - trs) / 60
         tm_end = time.localtime(int(time.time()) + tr)
         tm_end_h = tm_end[3]
         tm_end_m = tm_end[4]
         tm_end_s = tm_end[5]
         if bs == 0:
            self.statusbar_update("%s -%2d:%02d | %s %02d:%02d:%02d" % (remaining_text, trm, trs, finish_text, tm_end_h, tm_end_m, tm_end_s))
         else:
            self.statusbar_update("%s -%2d:%02d | %s %02d:%02d:%02d | %s %2d:%02d" % (remaining_text, trm, trs, finish_text, tm_end_h, tm_end_m, tm_end_s, block_size_text, bsm, bss))
      else:
         if bs == 0:
            self.statusbar_update("")
         else:
            bft = time.localtime(time.time() + bs)
            bf_h = bft[3]
            bf_m = bft[4]
            bf_s = bft[5]
            self.statusbar_update("%s %2d:%02d | %s %02d:%02d:%02d" % (block_size_text, bsm, bss, finish_text, bf_h, bf_m, bf_s))
            
   def statusbar_update(self, newtext):		# optimisation -- only update the status bars when the text changes
      if newtext != self.oldstatusbartext:
         self.pl_statusbar.push(1, newtext)
         self.oldstatusbartext = newtext

   def check_mixer_signal(self):
      if self.progress_press == False and self.progressadj.upper - self.progress_current_figure < 5.0 and self.progressadj.upper > 10.0:
         if self.mixer_signal_f.value == 0 and int(self.mixer_cid) == self.player_cid:
            print "termination by check mixer signal"
            self.invoke_end_of_track_policy()

   def cb_play_progress_timeout(self, cid):
      gtk.gdk.threads_enter()
      if self.reselect_cursor_please:
         treeselection = self.treeview.get_selection()
         (model, iter) = treeselection.get_selected()
         if iter is not None:
            self.treeview.scroll_to_cell(model.get_path(iter)[0], None, False)
         else:
            self.reselect_please = True
         self.reselect_cursor_please = False
      if self.reselect_please:
         print "Set cursor on track playing"
         # This code reselects the playing track after a drag operation.
	 treeselection = self.treeview.get_selection()
         try:
            treeselection.select_iter(self.iter_playing)
         except:
	    print "Iter was cancelled probably due to song dragging"
         self.reselect_please = False
      if self.progress_press == False:
         if self.runout.value and self.is_paused == False and self.mixer_cid.value > self.player_cid:
            self.gapless = True
            print "termination due to end of track"
            self.invoke_end_of_track_policy()
            self.gapless = False
            gtk.threads_leave()
            return False
         if self.mixer_signal_f.value == False:
            self.silence_count += 1
            if self.silence_count == 50:
               print "termination due to excessive silence"
               self.invoke_end_of_track_policy()
               gtk.gdk.threads_leave()
               return False
         else:
            self.silence_count = 0
         self.progress_current_figure = self.playtime_elapsed.value
         self.progressadj.set_value(self.playtime_elapsed.value)
         if self.max_seek == 0:
            self.progressadj.emit("value_changed")
         self.update_time_stats()
      else:
         # we stop monitoring the play progress during the progress bar drag operation
         # by cancelling this timeout
         gtk.gdk.threads_leave()
         return False
      # Calclulate when to sound the DJ alarm (end of music notification)
      # Bugs: does not deep scan the playlist controls for >stopplayer so the alarm will not sound if
      # preceeded by another playlist control
      if self.progress_current_figure == self.progress_stop_figure -9 and self.progressadj.upper > 10 and self.parent.prefs_window.djalarm.get_active():
         if ((self.playername == "left" and self.parent.crossadj.get_value() < 50) or (self.playername == "right" and self.parent.crossadj.get_value() >= 50)) and (self.pl_mode.get_active() == 3 or self.pl_mode.get_active() == 4 or (self.pl_mode.get_active() == 0 and (self.model_playing.iter_next(self.iter_playing) is None or (self.pl_mode.get_active() == 0 and self.model_playing.get_value(self.model_playing.iter_next(self.iter_playing), 0) == ">stopplayer")))):
            self.parent.alarm = True
            self.parent.send_new_mixer_stats()
      # Initial autocrossfade -- start the other player.
      if self.model_playing.iter_next(self.iter_playing) is not None and self.model_playing.get_value(self.model_playing.iter_next(self.iter_playing), 0) == ">crossfade" and self.pl_mode.get_active() == 0 and int(self.progress_current_figure) >= int(self.progress_stop_figure) -15:
         if self.other_player_initiated == False:
            if self.playername == "left":
               self.parent.player_right.play.clicked()
            else:
               self.parent.player_left.play.clicked()
            self.other_player_initiated = True
      # Now we do the crossfade
      if self.model_playing.iter_next(self.iter_playing) is not None and self.model_playing.get_value(self.model_playing.iter_next(self.iter_playing), 0) == ">crossfade" and self.pl_mode.get_active() == 0 and int(self.progress_current_figure) >= int(self.progress_stop_figure) -9:
         if self.crossfader_initiated == False:
            self.parent.passbutton.clicked()
            self.crossfader_initiated = True
            desired_direction = (self.playername == "left")
            if desired_direction != self.parent.crossdirection:
               self.parent.passbutton.clicked()
      
      gtk.gdk.threads_leave()
      return True

   def islastinplaylist(self):
      ifself.model_playing.iter_next(self.iter_playing)
      if iter == None:
         return False
      else:
         return True
          
   def arrow_up(self):
      treeselection = self.treeview.get_selection()
      (model, iter) = treeselection.get_selected()
      if iter == None:
         print "Nothing is selected"
      else:
         path = model.get_path(iter)
         if path[0]:
            other_iter = model.get_iter(path[0]-1)
            self.liststore.swap(iter, other_iter)
            self.treeview.scroll_to_cell(path[0]-1, None, False)
            
   def arrow_down(self):
      treeselection = self.treeview.get_selection()
      (model, iter) = treeselection.get_selected()
      if iter == None:
         print "Nothing is selected"
      else:
         path = model.get_path(iter)
         try:
            other_iter = model.get_iter(path[0]+1)
            self.liststore.swap(iter, other_iter)
            self.treeview.scroll_to_cell(path[0]+1, None, False)
         except ValueError:
            pass
          
   def advance(self):
      if self.is_playing:
         path = self.model_playing.get_path(self.iter_playing)[0]+1
         self.stop.clicked()
         treeselection = self.treeview.get_selection()
         treeselection.select_path(path)
         self.treeview.scroll_to_cell(path, None, False)
      else:
         self.play.clicked()
          
   def callback(self, widget, data):
      print "%s was pressed on player %s" % (data, self.playername)

      if data == "Arrow Up":
         self.arrow_up()
      
      if data == "Arrow Dn":
         self.arrow_down()
	       
      if data == "Stop":
         self.handle_stop_button(widget)
	 
      if data == "Next":
         if self.is_playing:
	    path = self.model_playing.get_path(self.iter_playing)[0]+1
            if self.is_paused:
               self.stop.clicked()
            try:
	       self.model_playing.get_iter(path)
	    except:
	       self.stop.clicked()
	       return
            treeselection = self.treeview.get_selection()	    
	    treeselection.select_path(path)
	    self.new_title = True
            self.play.clicked()	       
	       
      if data == "Prev":
         if self.is_playing:
            treeselection = self.treeview.get_selection()
	    path = self.model_playing.get_path(self.iter_playing)
            if self.is_paused:
	       self.stop.clicked()
	    treeselection.select_path(path[0]-1)
	    self.new_title = True
	    self.play.clicked()
       	       
      # This is for adding files to the playlist using the file requester.
      if data == "Add Files":
         if self.showing_file_requester == False:
            if self.playername == "left":
               filerqtext = left_playlist_addition_text
            else:
               filerqtext = right_playlist_addition_text
            self.filerq = gtk.FileSelection(filerqtext)
            self.filerq.set_select_multiple(True)
	    self.filerq.set_icon_from_file(pkgdatadir + "icon" + gfext)
            self.filerq.set_filename(str(self.file_requester_start_dir))
	    self.filerq.hide_fileop_buttons()
	    self.filerq.ok_button.connect("clicked", self.file_ok_sel)
	    self.filerq.cancel_button.connect("clicked", self.file_notok)
	    self.filerq.connect("destroy", self.file_destroy)
	    self.filerq.show()
	    self.showing_file_requester = True
	 else:
	    print "refused to open file requester"
	 
   def file_ok_sel(self, widget):
      chosenfiles = self.filerq.get_selections()
      # Destroy the requester window as soon as possible to make our app look snappy :)
      self.filerq.destroy()
      if len (chosenfiles) == 1 and os.path.splitext(chosenfiles[0])[1] == ".m3u":
         self.parse_m3u(chosenfiles[0])
      else:
         for chosenfile in chosenfiles:
            if os.path.isdir(chosenfile):
               files = os.listdir(chosenfile)
               files.sort()
               for each in files:
                  path = chosenfile + "/" + each
                  media_data = self.get_media_metadata(path)
                  if media_data[0] != "Not a valid file":
                     self.liststore.append(media_data)
                     while gtk.events_pending():
                        gtk.main_iteration()
            else:
               media_data = self.get_media_metadata(chosenfile)
               if media_data[0] != "Not a valid file":
                  self.liststore.append(media_data)
      # Set the directories start path to be the same next time around.
      chosenfile = chosenfiles[0]
      if os.path.isdir(chosenfile):
         # make sure there is a trailing slash
         if chosenfile[-1:] == '/':
	    self.file_requester_start_dir.set_text(chosenfile)
	 else:
	    self.file_requester_start_dir.set_text(chosenfile + '/')
      else:
         chosenfile = os.path.dirname(chosenfile)
	 if os.path.isdir(chosenfile):
	    self.file_requester_start_dir.set_text(chosenfile + '/')
         # else the user typed in crap so we will reuse the current setting next time around
       
      # Clear the flag last to prevent signal handling problems
      self.showing_file_requester = False 
    
   def file_notok(self, widget):
      print "Cancel was clicked on player", self.playername
      self.filerq.destroy()
      self.showing_file_requester = False
 
   def file_destroy(self, widget):
      self.filerq.destroy()
      self.showing_file_requester = False
     
   def plfile_ok_sel(self, widget):
      chosenfile = self.plfilerq.get_filename()
      self.plfilerq.destroy()
      if chosenfile[-1] == "/":
         chosenfile = chosenfile + "idjcplaylist.m3u"
      elif os.path.splitext(chosenfile)[1] != ".m3u":
         chosenfile = chosenfile + ".m3u"
      print "Chosenfile is", chosenfile
      try:
         pl = open(chosenfile, "w")
      except IOError:
         print "Can't open file for writing.  Permissions problem?"
      else:
         try:
            extm3u = self.parent.prefs_window.extm3u.get_active()
            if extm3u:
	       pl.write("#EXTM3U\n")
	    count = 0
	    while 1:
               if self.liststore[count][0][0] != ">":
                  if extm3u:
                     pl.write("#EXTINF:%d,%s\n" % (self.liststore[count][2], self.liststore[count][3]))
                  pl.write(self.liststore[count][1] + "\n")
	       count = count + 1
	 except IndexError:
	    pl.close()
	 except IOError:
	    pl.close()
	    print "That was odd\n"
      self.showing_pl_save_requester = False 
    
   def plfile_notok(self, widget):
      print "Cancel was clicked"
      self.plfilerq.destroy()
      self.showing_pl_save_requester = False
 
   def plfile_destroy(self, widget):
      self.plfilerq.destroy()
      self.showing_pl_save_requester = False     
         
   def cb_toggle(self, widget, data):
      print "Toggle %s recieved for signal: %s" % (("OFF","ON")[widget.get_active()], data)
      # Delete mode is for removing items from the playlist.    
      if data == "Delete":
         self.delete_mode = widget.get_active()
	 # This indirectly selects our song after delete mode is cancelled
	 if self.delete_mode == 0:
	    self.reselect_please = True   
	 
      if data == "Play":
         self.handle_play_button(widget, widget.get_active())
      if data == "Pause":
         self.handle_pause_button(widget, widget.get_active())
      if data == "Stream":
         self.parent.send_new_mixer_stats();
      if data == "Listen":
         self.parent.send_new_mixer_stats();
   
   def cb_progress(self, progress):
      if self.digiprogress_f:
         if self.max_seek > 0:
            if self.digiprogress_type == 0 or self.player_is_playing == False:
               count = int(progress.value)
            else:
               count = self.max_seek - int(progress.value)
         else:
            count = self.progress_current_figure
         hours = int(count / 3600)
         count = count - (hours * 3600)
         minutes = count / 60
         seconds = count - (minutes * 60)
	 if self.digiprogress_type == 0:
	    self.digiprogress.set_text("%d:%02d:%02d" % (hours, minutes, seconds))
	 else:
            if self.max_seek != 0:
	       self.digiprogress.set_text(" -%02d:%02d " % (minutes, seconds))
            else:
               self.digiprogress.set_text(" -00:00 ")
      if self.handle_motion_as_drop:
         self.handle_motion_as_drop = False
         if self.player_restart() == False:
            self.next.clicked()
         else:
            if self.pause.get_active():
               self.pause.set_active(False)

   def digiprogress_click(self):    
      self.digiprogress_type = not self.digiprogress_type
      if not self.digiprogress_f:
         if self.digiprogress_type == 0:
	    self.digiprogress.set_text("0:00:00")
	 else:
	    self.digiprogress.set_text(" -00:00 ")
      else:
	 self.cb_progress(self.progressadj)

   def cb_event(self, widget, event, callback_data):
      # This handles clicks to the progress bar
      if callback_data == "ProgressPress":
         self.progress_press = True
	 if self.timeout_source_id:
	    gobject.source_remove(self.timeout_source_id)
         return False
      elif callback_data == "ProgressRelease":
         self.progress_press = False
         if self.player_is_playing:
            self.progress_current_figure = self.progressadj.get_value()
            self.handle_motion_as_drop = True
            gobject.idle_add(self.player_progress_value_changed_emitter)
         return False
      elif callback_data == "DigitalProgressPress":
         self.digiprogress_click()
         return True				# Prevent any focus therefore any cursor appearing
      return False
      
   # This is really a very convoluted workaround to achieve the effect of a connect_after
   # method on a button_release_event on the player progress bar to run player_restart
   # I tried using connect_after but no such luck hence this retarded idle function.
   def player_progress_value_changed_emitter(self):
      gtk.gdk.threads_enter()
      self.progressadj.emit("value_changed")
      gtk.gdk.threads_leave()
      return False

   def cb_menu_select(self, widget, data):
      print "The %s was chosen from the %s menu" % (data, self.playername)   

   def delete_event(self, widget, event, data=None):
      return False

   def parse_m3u(self, filename):
      try:
         file = open(filename, "r")
	 data = file.read()
	 file.close()
      except IOError:
         print "Problem reading file", filename
         return
      basepath = os.path.split(filename)[0] + "/"
      data = data.splitlines()
      if data[0].rstrip() == "#EXTM3U" and self.parent.prefs_window.extm3u.get_active():
         print "Playlist is extended"
         try:
            index = 1
	    while 1:
	       if data[index][:8] == "#EXTINF:":
	          line1 = data[index][8:].split(",")
	          line2 = data[index+1]
		  if line2[0] != "/":
		     line2 = basepath + line2
		  if [ ".mp3", ".ogg", ".flac", ".wma", ".wav", ".m4a" ].count(os.path.splitext(line2)[1]) == 1:
	             self.liststore.append([rich_safe(line1[1]), line2, int(line1[0]), line1[1], self.parent.denc, "", line1[1]])
	          index = index + 2
	       else:
	          break
         except IndexError:
	    pass
	 except ValueError:
	    print "Invalid play duration value"
      else:
         for each in data:
	    if each[0] != "/":
	       each = basepath + each
	    meta = self.get_media_metadata(each)
	    if meta[0] != "Not a valid file":
	       self.liststore.append(meta)
            while gtk.events_pending():
	       gtk.main_iteration()
    
   def drag_data_delete(self, treeview, context):
      if context.action == gtk.gdk.ACTION_MOVE:
         treeselection = treeview.get_selection()
         model, iter = treeselection.get_selected()
         data = model.get_value(iter, 0)
         if data[:3] == "<b>":
            self.iter_playing = 0
            self.stop.clicked()

   def drag_data_get_data(self, treeview, context, selection, target_id, etime):
      treeselection = treeview.get_selection()
      model, iter = treeselection.get_selected()
      if model.get_value(iter, 1) != "":
         data = "file://" + model.get_value(iter, 1)
      else:
         data = "idjcplayercontrol://" + model.get_value(iter, 0)
      print "data for drag_get =", data
      selection.set(selection.target, 8, data)
      self.reselect_please = True
      return True

   def drag_data_received_data(self, treeview, context, x, y, dragged, info, etime):
      if info != 0:
         text = str(dragged.data)
         if text.count("\x00"):	# OMG where did these come from!!!
            try:
               # Strip out any Null characters which may be due to the dragged
               # text being composed of unicode and convert back to the 
               # filesystem encoding.
               # If fenc is wrong dnd will likely fail on filenames with non ASCII.
               # The names must ultimately match what is written on your hard drive.
               # This can be a problem when you have multiple encodings registered.
               text = unicode(text)
               fe = self.parent.fenc.split(",")
               for each in fe:
                  if each == "@locale" or each == "locale":
                     each = self.parent.de
                  try:
                     result = text.encode(each, "strict")
                  except:
                     continue		# failed to encode text with the encoding in each
                  else:
                     text = result	# encoding succeeded even if it is wrong
                     break
               else:
                  print "Unable to encode drag and drop filenames with the supplied list:", self.parent.fenc
            except:
               pass		# Not unicode aparrently or we wouldn't be here.
            # Finally a blanket removal of any NULLs because they really need to go
            text = text.replace("\x00", "") 
         if text[:20] == "idjcplayercontrol://":
            drop_info = treeview.get_dest_row_at_pos(x, y)
            model = treeview.get_model()
            if drop_info == None:
               model.append([ text[20:], "", -11, "" ,"", "", "" ])
            else:
               path, position = drop_info
               dest_iter = model.get_iter(path)
               if(position == gtk.TREE_VIEW_DROP_BEFORE or position == 			   gtk.TREE_VIEW_DROP_INTO_OR_BEFORE):
                  model.insert_before(dest_iter, [ text[20:], "", -11, "" ,"", "", "" ])
               else:
                  model.insert_after(dest_iter, [ text[20:], "", -11, "" ,"", "", "" ])
            if context.action == gtk.gdk.ACTION_MOVE:
               context.finish(True, True, etime)
         else:
            if context.action == gtk.gdk.ACTION_MOVE:
               context.finish(True, True, etime)
            gobject.idle_add(self.drag_data_received_data_idle, treeview, x, y, text)
      else:
         treeselection = treeview.get_selection()
         model, iter = treeselection.get_selected()
       	 drop_info = treeview.get_dest_row_at_pos(x, y)
         if drop_info == None:
            self.liststore.move_before(iter, None)
         else:
            path, position = drop_info
            dest_iter = model.get_iter(path)
            if(position == gtk.TREE_VIEW_DROP_BEFORE or position == 			   gtk.TREE_VIEW_DROP_INTO_OR_BEFORE):
               self.liststore.move_before(iter, dest_iter)
            else:
               self.liststore.move_after(iter, dest_iter)
         if context.action == gtk.gdk.ACTION_MOVE:
            context.finish(False, False, etime)
      return True
   
   def drag_data_received_data_idle(self, treeview, x, y, dragged):
      gtk.gdk.threads_enter()
      model = treeview.get_model()
      gtk.gdk.threads_leave()

      dragged = url_unescape(dragged)	# parse out %xx escape sequences
      if dragged.count("\n") == 1:	# for nautilus compat
         dragged = dragged.rstrip()	# konqeror omits \n for single entity drag 'n drop
      
      if dragged.count("\n") == 0:
         filename = dragged.replace("file://", "")
         filename = filename.replace("file:", "")
         # This will produce a list of sorted directory contents
         if os.path.isdir(filename):
            selection = os.listdir(filename)
            selection.sort()
            for value in range (len (selection)):
               selection[value] = filename + "/" + selection[value]
         # This will attempt to parse m3u files provided they are the only thing dragged
         elif os.path.splitext(filename)[1] == ".m3u":
            path = os.path.split(filename)[0] + "/"
            file = open(filename, "r")
            if file:
               selection = ""
               while 1:
                  line = file.readline()
                  if line == "":
                     break
                  if line[0] == "/" or line[0] == "#":
                     selection = selection + line		# handle absolute path m3u files
                  else:
                     selection = selection + (path + line)	# handle relocatable m3u files
               file.close()
            else:
               selection = "wtf\n"
            selection = selection.splitlines()
         else:
            selection = dragged.splitlines()
      else:
         selection = dragged.splitlines()

      if len(selection) > 0 and selection[0].rstrip() == "#EXTM3U" and self.parent.prefs_window.extm3u.get_active():
         index = 1
	 try:
	    while 1:
	       if selection[index][:8] == "#EXTINF:":
	          line1 = selection[index][8:].split(",")
	          line2 = selection[index+1]
		  if [ ".mp3", ".ogg", ".flac", ".wma", ".wav", ".m4a" ].count(os.path.splitext(line2)[1]) == 1:
		     media_data = [rich_safe(line1[1]), line2, int(line1[0]), line1[1], self.parent.denc, "", line1[1]]
                     gtk.gdk.threads_enter()
	             drop_info = treeview.get_dest_row_at_pos(x, y)
                     gtk.gdk.threads_leave()
                     if drop_info:
                        path, position = drop_info
                        gtk.gdk.threads_enter()
	                iter = model.get_iter(path)
                        gtk.gdk.threads_leave()
	                if(position == gtk.TREE_VIEW_DROP_BEFORE or position == 			   gtk.TREE_VIEW_DROP_INTO_OR_BEFORE):
                           gtk.gdk.threads_enter()
	                   model.insert_before(iter, media_data)
                           gtk.gdk.threads_leave()
	                else:
                           gtk.gdk.threads_enter()
	                   model.insert_after(iter, media_data)
                           gtk.gdk.threads_leave()
                     else:
                        gtk.gdk.threads_enter()
                        model.append(media_data)
                        gtk.gdk.threads_leave()
	       index = index + 2
	 except IndexError:
	    pass 
	 except ValueError:
	    print "Bad value for duration"
            gtk.gdk.threads_leave()     
      else: 
         first = True
	 for line in selection:
            media_data = self.get_media_metadata(line)
            if media_data[0] != 'Not a valid file':
               if first:
                  gtk.gdk.threads_enter()
	          drop_info = treeview.get_dest_row_at_pos(x, y)
                  gtk.gdk.threads_leave()
                  if drop_info:
                     path, position = drop_info
                     gtk.gdk.threads_enter()
	             iter = model.get_iter(path)
                     gtk.gdk.threads_leave()
	             if(position == gtk.TREE_VIEW_DROP_BEFORE or position == 							   gtk.TREE_VIEW_DROP_INTO_OR_BEFORE):
                        gtk.threads_enter()
	                iter = model.insert_before(iter, media_data)
                        gtk.threads_leave()
	             else:
                        gtk.threads_enter()
	                iter = model.insert_after(iter, media_data)
                        gtk.threads_leave()
                  else:
                     gtk.threads_enter()
                     iter = model.append(media_data)
                     gtk.threads_leave()
		  first = False
	       else:
                  gtk.gdk.threads_enter()
	          iter = model.insert_after(iter, media_data)
                  gtk.gdk.threads_leave()
            gtk.gdk.threads_enter()
            while gtk.events_pending():
               gtk.gdk.threads_leave()
               gtk.gdk.threads_enter()
	       gtk.main_iteration()
               gtk.threads_leave()
               gtk.threads_enter()
            gtk.gdk.threads_leave()
      self.reselect_please = True
      return False
     
   TARGETS = [
      ('MY_TREE_MODEL_ROW', gtk.TARGET_SAME_WIDGET, 0),
      ('text/plain', 0, 1),
      ('TEXT', 0, 2),
      ('STRING', 0, 3),
      ]
      
   def cb_doubleclick(self, treeview, path, tvcolumn, user_data):
      if self.delete_mode == 0:
         # Our play button handler will manage to get the song title.
	 # All we need to do is set a flag and issue a play button started signal.
	 if self.is_playing:
            # The new_title flag allows a new song to be played when the player is going.
            self.new_title = True
            self.play.clicked()
	 else:
	    self.play.clicked()
      else:
         print "Double click does nothing in delete mode"
	                   
   def cb_singleclick(self, treeview):
      treeselection = treeview.get_selection()
      (model, iter) = treeselection.get_selected()
      if iter:
         if self.delete_mode == 1:
	    treeselection.unselect_all()
	    # Include a debouce delay for deletion of list entries
	    if time.time() > self.last_time + 0.1:
               deleted_text = model.get_value(iter, 0)
	       if deleted_text[:3] == "<b>":
	          print "We deleted the song we are playing - stopping"
	          self.file_iter_playing = 0
	          self.stop.clicked()
	       else:
	          print "We deleted a song"
	       model.remove(iter)
	       self.last_time = time.time()
	    else:
	       print "Was protected by my debounce code"
	 self.update_time_stats()
         
   def menu_activate(self, widget, event):
      if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
         self.menu_model = self.treeview.get_model()
	 row_info = self.treeview.get_dest_row_at_pos(int(event.x + 0.5), int(event.y + 0.5))
         if row_info:
	    sens = True
	    path, position = row_info
	    selection = self.treeview.get_selection()
	    selection.select_path(path)
            self.menu_iter = self.menu_model.get_iter(path)	# store the context of the menu action
            self.item_tag.set_sensitive(multitag.is_supported(multitag(), self.menu_model.get_value(self.menu_iter, 1)) != False)
	 else:
            self.menu_iter = None
	    sens = False
	 self.item_duplicate.set_sensitive(sens)
	 self.remove_this.set_sensitive(sens)
	 self.remove_from_here.set_sensitive(sens)
	 self.remove_to_here.set_sensitive(sens)
         model = self.treeview.get_model()
	 if model.get_iter_first() == None:
	    sens2 = False
	 else:
	    sens2 = True
	 self.pl_menu_item.set_sensitive(sens2)
	 self.playlist_save.set_sensitive(sens2)
         self.playlist_copy.set_sensitive(sens2)
	 self.playlist_transfer.set_sensitive(sens2)
	 self.playlist_empty.set_sensitive(sens2)
         if self.pl_mode.get_active() != 0:
            self.pl_menu_control.set_sensitive(False)
         else:
            self.pl_menu_control.set_sensitive(True)
	 
	 if self.playername == "left":	# determine if anything is selected in the other playlist
	    tv = self.parent.player_right.treeview.get_selection()
	 else:
	    tv = self.parent.player_left.treeview.get_selection()
	 model, iter = tv.get_selected()
	 if iter:
	    sens3 = True
	 else:
	    sens3 = False
	 self.copy_append_cursor.set_sensitive(sens3)
	 self.copy_prepend_cursor.set_sensitive(sens3)
	 self.transfer_append_cursor.set_sensitive(sens3)
	 self.transfer_prepend_cursor.set_sensitive(sens3)   
	    
	 widget.popup(None, None, None, event.button, event.time)
	 return True
      return False
      
   def menuitem_response(self, widget, text):
      print "The %s menu option was chosen" % text
      model = self.menu_model
      iter = self.menu_iter
      
      dict = {
             "Stop Control"		 : ">stopplayer",
             "Transfer Control"		 : ">transfer",
             "Crossfade Control"	 : ">crossfade",
             "Stream Disconnect Control" : ">stopstreaming",
             "Stop Recording Control"	 : ">stoprecording"
      }
      if dict.has_key(text):
         if iter is not None:
            iter = model.insert_after(iter)
         else:
            iter = model.append()
         model.set_value(iter, 0, dict[text])
         model.set_value(iter, 1, "")
         model.set_value(iter, 2, -11)
         model.set_value(iter, 3, "")
         model.set_value(iter, 4, "")
         model.set_value(iter, 5, "")
         model.set_value(iter, 6, "")
         self.treeview.get_selection().select_iter(iter)
         return
      
      if text == "MetaTag":
         try:
            pathname = model.get_value(iter, 1)
         except TypeError:
            pass
         else:
            multitag(pathname, model.get_value(iter, 4) , self.parent)
      
      if text == "Add File":
         if self.showing_file_requester == False:
            if self.playername == "left":
               filerqtext = left_playlist_addition_text
            else:
               filerqtext = right_playlist_addition_text
            self.filerq = gtk.FileSelection(filerqtext)
            self.filerq.set_select_multiple(True)
	    self.filerq.set_icon_from_file(pkgdatadir + "icon" + gfext)
	    self.filerq.set_filename(str(self.file_requester_start_dir))
	    self.filerq.hide_fileop_buttons()
	    self.filerq.ok_button.connect("clicked", self.file_ok_sel)
	    self.filerq.cancel_button.connect("clicked", self.file_notok)
	    self.filerq.connect("destroy", self.file_destroy)
	    self.filerq.show()
	    self.showing_file_requester = True
	 else:
	    print "refused to open file requester"
	    
      if text == "Playlist Save":
         if self.showing_pl_save_requester == False:
            if self.playername == "left":
               filerqtext = left_playlist_save_text
            else:
               filerqtext = right_playlist_save_text
            self.plfilerq = gtk.FileSelection(filerqtext)
	    self.plfilerq.set_icon_from_file(pkgdatadir + "icon" + gfext)
            self.plfilerq.set_filename(self.home + "/idjcplaylist.m3u")
	    self.plfilerq.hide_fileop_buttons()
	    self.plfilerq.ok_button.connect("clicked", self.plfile_ok_sel)
	    self.plfilerq.cancel_button.connect("clicked", self.plfile_notok)
	    self.plfilerq.connect("destroy", self.plfile_destroy)
	    self.plfilerq.show()
	    self.showing_pl_save_requester = True
	 else:
	    print "refused to open file requester"
       
      if text == "Remove All":
         if self.is_playing:
	    self.stop.clicked()
         self.liststore.clear()   
      
      if text == "Remove This" and iter != None:
	 name = model.get_value(iter, 0)
	 if name[:3] == "<b>":
	    self.stop.clicked()
	 self.liststore.remove(iter)
	 
      if text == "Remove From Here" and iter != None:	 
	 path = model.get_path(iter)
	 try:
	    while 1:
	       iter = model.get_iter(path)
	       if model.get_value(iter, 0)[:3] == "<b>":
	          self.stop.clicked()
	       self.liststore.remove(iter)
	 except:
	    print "Nothing more to delete"
	 
      if text == "Remove To Here" and iter != None:
	 path = model.get_path(iter)[0] -1
	 while path >= 0:
	    iter = model.get_iter(path)
	    if model.get_value(iter, 0)[:3] == "<b>":
	       self.stop.clicked()
	    self.liststore.remove(iter)
	    path = path -1

      if text == "Duplicate" and iter != None:
         row = list(model[model.get_path(iter)])
         if row[0][:3] == "<b>":		# strip off any bold tags
            row[0] = row[0][3:-4]
         model.insert_after(iter, row)
      
      if text == "Playlist Exchange":
         if self.playername == "left":
	    opposite = self.parent.player_right
	 else:
	    opposite = self.parent.player_left
         self.stop.clicked()
	 opposite.stop.clicked()
	 i = 0
	 try:
	    while 1:
	       self.templist.append(self.liststore[i])
	       i = i + 1
	 except IndexError:
	    pass
	 self.liststore.clear()
	 i = 0
	 try:
	    while 1:
	       self.liststore.append(opposite.liststore[i])
	       i = i + 1
	 except IndexError:
	    pass
	 opposite.liststore.clear()
	 i = 0
	 try:
	    while 1:
	       opposite.liststore.append(self.templist[i])
	       i = i + 1
	 except IndexError:
	    pass
	 self.templist.clear()
	 
      if text == "Copy Append":
         self.copy_playlist("end")
	 
      if text == "Transfer Append":
         self.copy_playlist("end")
	 self.stop.clicked()
	 self.liststore.clear()
	 	 
      if text == "Copy Prepend":
         self.copy_playlist("start")
	 
      if text == "Transfer Prepend":
         self.copy_playlist("start")
	 self.stop.clicked()
	 self.liststore.clear()
	 
      if text == "Copy Append Cursor":
         self.copy_playlist("after")
	 
      if text == "Transfer Append Cursor":
         self.copy_playlist("after")
	 self.stop.clicked()
	 self.liststore.clear()
	 
      if text == "Copy Prepend Cursor":
         self.copy_playlist("before")
	 
      if text == "Transfer Prepend Cursor":
         self.copy_playlist("before")
	 self.stop.clicked()
	 self.liststore.clear()
	
      if text == "ToJingles":
         source = model.get_value(iter, 1)
	 dest = self.parent.idjc + "jingles/" + os.path.split(source)[1]
	 try:
	    source = open(source, "r")
	    dest = open(dest, "w")
	    while True:
	       data = source.read(4096)
	       dest.write(data)
	       if len(data) < 4096:
	          break;
	 except IOError:
	    print "IOError occurred"
	 source.close
	 dest.close
         self.parent.jingles.refresh.clicked()
	       
      if self.player_is_playing:	# put the cursor on the file playing after a brief pause.
         self.reselect_please = True

   def stripbold(self, playlist_item):
      copy = list(playlist_item)
      if copy[0][:3] == "<b>":
         copy[0] = copy[0][3:-4]
      return copy
	 	 
   def copy_playlist(self, dest):
      if self.playername == "left":
         other = self.parent.player_right
      else:
         other = self.parent.player_left
      i = 0
      try:
         if dest == "start":
	    while 1:
	       other.liststore.insert(i, self.stripbold(self.liststore[i]))
               i = i + 1
         if dest == "end":
	    while 1:
	       other.liststore.append(self.stripbold(self.liststore[i]))
	       i = i + 1
         
	 (model, iter) = other.treeview.get_selection().get_selected()	       
         
	 if dest == "after":
	    while 1:
	       iter = other.liststore.insert_after(iter, self.stripbold(self.liststore[i]))
	       i = i + 1
         if dest == "before":
	    while 1:
	       other.liststore.insert_before(iter, self.stripbold(self.liststore[i]))
	       i = i + 1
      except IndexError:
	 pass
            
   def cb_keypress(self, widget, event):
      if self.delete.get_active():
         print "Keyboard shortcuts disabled in delete mode"
         return True
      # Handle shifted arrow keys for rearranging stuff in the playlist.
      if event.state & gtk.gdk.SHIFT_MASK:
         if event.keyval == 65362:
            self.arrow_up()
            return True
         if event.keyval == 65364:
            self.arrow_down()
            return True
         if event.keyval == 65361 and self.playername == "right":
            if self.parent.player_left.delete.get_active() == False:
               treeselection = widget.get_selection()
               s_model, s_iter = treeselection.get_selected()
               if s_iter is not None:
                  name = s_model.get_value(s_iter, 0)
                  if name[:3] == "<b>":
                     self.stop.clicked()
                  otherselection = self.parent.player_left.treeview.get_selection()
                  d_model, d_iter = otherselection.get_selected()
                  row = list(s_model[s_model.get_path(s_iter)])
                  path = s_model.get_path(s_iter)
                  s_model.remove(s_iter)
                  treeselection.select_path(path)
                  if d_iter is None:
                     d_iter = d_model.append(row)
                  else:
                     d_iter = d_model.insert_after(d_iter, row)
                  otherselection.select_iter(d_iter)
                  self.parent.player_left.treeview.set_cursor(d_model.get_path(d_iter))
                  self.parent.player_left.treeview.scroll_to_cell(d_model.get_path(d_iter), None, False)
            else:
               print "Cannot transfer to the other playlist in delete mode"
            return True
         if event.keyval == 65363 and self.playername == "left":
            if self.parent.player_left.delete.get_active() == False:
               treeselection = widget.get_selection()
               s_model, s_iter = treeselection.get_selected()
               if s_iter is not None:
                  name = s_model.get_value(s_iter, 0)
                  if name[:3] == "<b>":
                     self.stop.clicked()
                  otherselection = self.parent.player_right.treeview.get_selection()
                  d_model, d_iter = otherselection.get_selected()
                  row = list(s_model[s_model.get_path(s_iter)])
                  path = s_model.get_path(s_iter)
                  s_model.remove(s_iter)
                  treeselection.select_path(path)
                  if d_iter is None:
                     d_iter = d_model.append(row)
                  else:
                     d_iter = d_model.insert_after(d_iter, row)
                  otherselection.select_iter(d_iter)
                  self.parent.player_right.treeview.set_cursor(d_model.get_path(d_iter))
                  self.parent.player_right.treeview.scroll_to_cell(d_model.get_path(d_iter), None, False)
            else:
               print "Cannot transfer to the other playlist in delete mode"
            return True
      if event.keyval == 65361 and self.playername == "right":
         if self.parent.player_left.delete.get_active() == False:
            treeselection = self.parent.player_left.treeview.get_selection()
            model, iter = treeselection.get_selected()
            if iter is not None:
               self.parent.player_left.treeview.set_cursor(model.get_path(iter))
            else:
               treeselection.select_path(0)
            self.parent.player_left.treeview.grab_focus()
         else:
            print "Cannot switch to other player in delete mode"
         return True
      if event.keyval == 65363 and self.playername == "left":
         if self.parent.player_right.delete.get_active() == False:
            treeselection = self.parent.player_right.treeview.get_selection()
            model, iter = treeselection.get_selected()
            if iter is not None:
               self.parent.player_right.treeview.set_cursor(model.get_path(iter))
            else:
               treeselection.select_path(0)
            self.parent.player_right.treeview.grab_focus()
         else:
            print "Cannot switch to other player in delete mode"
         return True
      if event.keyval == 65535 or event.keyval == 65439:	 # The Main and NK Delete keys
         treeselection = widget.get_selection()		# Delete to cause playlist entry removal
         model, iter = treeselection.get_selected()
         if iter is not None:
            path = model.get_path(iter)
            if path[0] > 0:
               prev = model.get_iter(path[0]-1)
            else:
               prev = None
            try:
               next = model.get_iter(path[0]+1)
            except:
               next = None
            name = model.get_value(iter, 0)
            if name[:3] == "<b>":
               self.stop.clicked()
            self.liststore.remove(iter)
            if next is not None:
               treeselection.select_iter(next)
               widget.set_cursor(model.get_path(next))
               self.treeview.scroll_to_cell(model.get_path(next), None, False)
            elif prev is not None:
               treeselection.select_iter(prev)
               widget.set_cursor(model.get_path(prev))
               self.treeview.scroll_to_cell(model.get_path(prev), None, False)
         else:
            print "Playlist is empty!"
         return True
      if event.string == "1":
         self.parent.passleft.clicked()
         return True
      if event.string == "2":
         self.parent.passright.clicked()
         return True
      if event.string == "c" or event.string == "C":
         self.parent.passbutton.clicked()
         return True
      if (event.string == "m" or event.string == "M") and self.parent.mic_select.flags() & gtk.VISIBLE:
         self.parent.mic_select.set_active(not self.parent.mic_select.get_active())
         return True
      if (event.string == "<" or event.string == ",") and not self.parent.mic_select.flags() & gtk.VISIBLE:
         self.parent.mic_lselect.set_active(not self.parent.mic_lselect.get_active())
         return True
      if (event.string == ">" or event.string == ".") and not self.parent.mic_select.flags() & gtk.VISIBLE:
         self.parent.mic_rselect.set_active(not self.parent.mic_rselect.get_active())
         return True
      if event.keyval == 65288:		# backspace key stops the player
         self.stop.clicked()
      if event.string == "t" or event.string == "T":	# t key does metadata tagging
         model, iter = self.treeview.get_selection().get_selected()
         if iter is not None:
            pathname = model.get_value(iter, 1)
            if multitag.is_supported(multitag(), pathname):
               multitag(pathname, model.get_value(iter, 4), self.parent)
            else:
               print "File type is not supported by the idjc metadata tagger"
      if (event.string == "s" or event.string == "S") and self.pl_mode.get_active() == 0:
         self.menu_model, self.menu_iter = self.treeview.get_selection().get_selected()
         self.menuitem_response(None, "Stop Control")
         return True
      if (event.string == "a" or event.string == "A") and self.pl_mode.get_active() == 0:
         self.menu_model, self.menu_iter = self.treeview.get_selection().get_selected()
         self.menuitem_response(None, "Transfer Control")
         return True
      if (event.string == "f" or event.string == "F") and self.pl_mode.get_active() == 0:
         self.menu_model, self.menu_iter = self.treeview.get_selection().get_selected()
         self.menuitem_response(None, "Crossfade Control")
         return True
         
      # Allow certain key presses to work but not allow a text entry box to appear.
      if event.string ==" " or event.string =="\r":
         self.stop.clicked()
         self.play.clicked()
         return True
      if event.string == "":
         return False
      return True
	    
   def playtimerowconfig(self, tv_column, cell_renderer, model, iter):
      playtime = model.get_value(iter, 2)
      self.rowconfig(tv_column, cell_renderer, model, iter)
      if playtime == -11:
         cell_renderer.set_property("text", "")
      else:   
         secs = playtime % 60
         playtime -= secs
         mins = playtime / 60
         text = "%d:%02d" % (mins, secs)
         cell_renderer.set_property("xalign", 1.0)
         cell_renderer.set_property("text", text)

   def rowconfig(self, tv_column, cell_renderer, model, iter):
      celltext = model.get_value(iter, 0)
      if celltext[:4] == "<b>>":
         celltext = celltext[3:-4]
      if celltext[0] == ">" and self.pl_mode.get_active() == 0:
         cell_renderer.set_property("xalign", 0.40)
         cell_renderer.set_property("ypad", 0)
         cell_renderer.set_property("scale", 0.65)
         cell_renderer.set_property("cell-background-set", True)
         cell_renderer.set_property("background-set", True)
         cell_renderer.set_property("foreground-set", True)
         if celltext == ">stopplayer":
            cell_renderer.set_property("cell-background", "red")
            cell_renderer.set_property("background", "gray")
            cell_renderer.set_property("foreground", "red")
            cell_renderer.set_property("text", stop_control_element_text)
         if celltext == ">stopstreaming":
            cell_renderer.set_property("cell-background", "black")
            cell_renderer.set_property("background", "gray")
            cell_renderer.set_property("foreground", "black")
            cell_renderer.set_property("text", stream_disconnect_element_text)
         if celltext == ">stoprecording":
            cell_renderer.set_property("cell-background", "black")
            cell_renderer.set_property("background", "gray")
            cell_renderer.set_property("foreground", "black")
            cell_renderer.set_property("text", stop_recording_element_text)
         if celltext == ">transfer":
            cell_renderer.set_property("cell-background", "magenta")
            cell_renderer.set_property("background", "gray")
            cell_renderer.set_property("foreground", "magenta")
            if self.playername == "left":
               cell_renderer.set_property("text", transfer_control_ltr_element_text)
            else:
               cell_renderer.set_property("text", transfer_control_rtl_element_text)
         if celltext == ">crossfade":
            cell_renderer.set_property("cell-background", "blue")
            cell_renderer.set_property("background", "gray")
            cell_renderer.set_property("foreground", "blue")
            if self.playername == "left":
               cell_renderer.set_property("text", crossfade_control_ltr_element_text)
            else:
               cell_renderer.set_property("text", crossfade_control_rtl_element_text)
      else:
         if celltext[0] == ">":
            cell_renderer.set_property("visible", False)
         else:
            cell_renderer.set_property("visible", True)
         cell_renderer.set_property("foreground-set", False)
         cell_renderer.set_property("cell-background-set", False)
         cell_renderer.set_property("background-set", False)
         cell_renderer.set_property("scale", 1.0)
         cell_renderer.set_property("xalign", 0.0)
         cell_renderer.set_property("ypad", 2)
            
   def cb_playlist_mode(self, widget):
      # uses a side effect that the entire playlist is re-rendered
      self.tvcolumn.add_attribute(self.cellrender, "markup", 0)
      if widget.get_active() == 0:
         self.pl_statusbar.show()
      else:
         self.pl_statusbar.hide()
      
   def __init__(self, pbox, name, parent):
      
      # A box for the Stop/Start/Pause widgets
      self.hbox1 = gtk.HBox(True, 0)
      self.hbox1.set_border_width(2)
      self.hbox1.set_spacing(3)
      frame = gtk.Frame()
      frame.set_border_width(3)
      frame.set_shadow_type(gtk.SHADOW_IN)
      frame.add(self.hbox1)
      frame.show()
      pbox.pack_start(frame, False, False, 0)

      # A box for the progress bar, which may at a later date contain other stuff
      # Like an elapsed timer for instance.
      self.progressbox = gtk.HBox(False, 0)
      self.progressbox.set_border_width(3)
      self.progressbox.set_spacing(4)
      pbox.pack_start(self.progressbox, False, False, 0)
           
      # The numerical play progress box
      self.digiprogress = gtk.Entry(7)
      self.digiprogress.set_text("0:00:00")
      self.digiprogress.set_width_chars(6)
      self.digiprogress.set_editable(False)
      self.digiprogress.connect("button_press_event", self.cb_event, "DigitalProgressPress")
      self.progressbox.pack_start(self.digiprogress, False, False, 1)
      self.digiprogress.show()      
      
      # The play progress bar and "needle shifter"
      self.progressadj = gtk.Adjustment(0.0, 0.0, 100.0, 0.1, 1.0, 0.0)
      self.progressadj.connect("value_changed", self.cb_progress)
      self.progressbar = gtk.HScale(self.progressadj)
      self.progressbar.set_update_policy(gtk.UPDATE_CONTINUOUS)
      self.progressbar.set_digits(1)
      self.progressbar.set_value_pos(gtk.POS_TOP)
      self.progressbar.set_draw_value(False)
      # These events may not be the best ones to use. Others may work better.
      self.progressbar.connect("button_press_event", self.cb_event, "ProgressPress")
      self.progressbar.connect("button_release_event", self.cb_event, "ProgressRelease")
      self.progressbox.pack_start(self.progressbar, True, True, 0)
      self.progressbar.show()
      
      # Finished filling the progress box so lets show it.
      self.progressbox.show()
     
      # A frame for our playlist
      if name == "left":
         plframe = gtk.Frame(" " + playlist_text + " 1 ")
      else:
         plframe = gtk.Frame(" " + playlist_text + " 2 ")	 
      plframe.set_border_width(4)
      plframe.set_shadow_type(gtk.SHADOW_ETCHED_IN)
      plframe.show()
      plvbox = gtk.VBox()
      plframe.add(plvbox)
      plvbox.show()
      # The scrollable window box that will contain our playlist.
      self.scrolllist = gtk.ScrolledWindow()
      self.scrolllist.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
      self.scrolllist.set_size_request(-1, 217)
      self.scrolllist.set_border_width(4)
      self.scrolllist.set_shadow_type(gtk.SHADOW_IN)
      # A liststore object for our playlist
      # The first one gets rendered and is derived from id3 tags or just is the filename
      # when the id3 tag is not sufficient.
      # The second one always is the filename and is passed to the player.
      self.liststore = gtk.ListStore(str, str, int, str, str, str, str)
      self.templist = gtk.ListStore(str, str, int, str, str, str, str)
      self.treeview = gtk.TreeView(self.liststore)
      self.playtimecellrender = gtk.CellRendererText()
      self.cellrender = gtk.CellRendererText()
      self.playtimetvcolumn = gtk.TreeViewColumn("Time", self.playtimecellrender)
      self.tvcolumn = gtk.TreeViewColumn("Playlist", self.cellrender)
      self.playtimetvcolumn.set_cell_data_func(self.playtimecellrender, self.playtimerowconfig)
      self.tvcolumn.set_cell_data_func(self.cellrender, self.rowconfig)
      self.playtimetvcolumn.add_attribute(self.playtimecellrender, 'text', 2)
      self.playtimetvcolumn.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)
      self.tvcolumn.add_attribute(self.cellrender, 'markup', 0)
      self.tvcolumn.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
      self.tvcolumn.set_expand(True)
      self.treeview.append_column(self.tvcolumn)
      self.treeview.append_column(self.playtimetvcolumn)
      self.treeview.set_search_column(0)
      self.treeview.set_headers_visible(False)
      self.treeview.enable_model_drag_source( gtk.gdk.BUTTON1_MASK,
      						self.TARGETS,
	      					gtk.gdk.ACTION_DEFAULT |
      						gtk.gdk.ACTION_MOVE)
      self.treeview.enable_model_drag_dest( self.TARGETS,
      						gtk.gdk.ACTION_DEFAULT)
	
      self.treeview.connect("drag_data_get", self.drag_data_get_data)
      self.treeview.connect("drag_data_received", self.drag_data_received_data)
      self.treeview.connect("drag_data_delete", self.drag_data_delete)
      
      self.treeview.connect("row_activated", self.cb_doubleclick, "Double click")
      self.treeview.connect("cursor_changed", self.cb_singleclick)
      
      self.treeview.connect("key_press_event", self.cb_keypress)
      
      self.scrolllist.add(self.treeview)
      self.treeview.show()
      
      plvbox.pack_start(self.scrolllist, True, True, 0)
      self.scrolllist.show()
      
      # An information display for playlist stats
      self.pl_statusbar = gtk.Statusbar()
      self.pl_statusbar.set_has_resize_grip(False)
      plvbox.pack_start(self.pl_statusbar, False, False, 0)
      self.pl_statusbar.show()

      pbox.pack_start(plframe, True, True, 0) 
      
      # The box for the mute widgets.
      self.hbox2 = gtk.HBox(False, 0)
      self.hbox2.set_border_width(4)
      pbox.pack_start(self.hbox2, False, False, 0)

      # A set of buttons for hbox1 namely Prev/Play/Pause/Stop/Next/Playlist : XMMS order
      image = gtk.Image()
      image.set_from_file(pkgdatadir + "prev" + gfext)
      image.show()
      self.prev = gtk.Button()
      self.prev.add(image)
      self.prev.connect("clicked", self.callback, "Prev")
      self.hbox1.add(self.prev)
      self.prev.show()
      
      pixbuf = gtk.gdk.pixbuf_new_from_file(pkgdatadir + "play2" + gfext)
      pixbuf = pixbuf.scale_simple(14, 14, gtk.gdk.INTERP_BILINEAR)
      image=gtk.Image()
      image.set_from_pixbuf(pixbuf)
      image.show()
      self.play = gtk.ToggleButton()
      self.play.add(image)
      self.play.connect("toggled", self.cb_toggle, "Play")
      self.hbox1.add(self.play)
      self.play.show()
      
      image=gtk.Image()
      image.set_from_file(pkgdatadir + "pause" + gfext)
      image.show()
      self.pause = gtk.ToggleButton()
      self.pause.add(image)
      self.pause.connect("toggled", self.cb_toggle, "Pause")
      self.hbox1.add(self.pause)
      self.pause.show()
      
      image=gtk.Image()
      image.set_from_file(pkgdatadir + "stop" + gfext)
      image.show()
      self.stop = gtk.Button()
      self.stop.add(image)
      self.stop.connect("clicked", self.callback, "Stop")
      self.hbox1.add(self.stop)
      self.stop.show()
            
      image=gtk.Image()
      image.set_from_file(pkgdatadir + "next" + gfext)
      image.show()
      self.next = gtk.Button()
      self.next.add(image)
      self.next.connect("clicked", self.callback, "Next")
      self.hbox1.add(self.next)
      self.next.show()
      
      pixbuf = gtk.gdk.pixbuf_new_from_file(pkgdatadir + "add3" + gfext)
      pixbuf = pixbuf.scale_simple(14, 14, gtk.gdk.INTERP_HYPER)
      image = gtk.Image()
      image.set_from_pixbuf(pixbuf)
      image.show()
      self.add = gtk.Button()
      self.add.add(image)
      self.add.connect("clicked", self.callback, "Add Files")
      self.hbox1.add(self.add)
      self.add.show()
      
      # hbox1 is done so it is time to show it
      self.hbox1.show()

      # The playlist mode dropdown menu.
      self.pl_mode = gtk.combo_box_new_text()
      self.pl_mode.append_text(play_all_text)
      self.pl_mode.append_text(loop_all_text)
      self.pl_mode.append_text(random_text)
      self.pl_mode.append_text(manual_text)
      self.pl_mode.append_text(cue_up_text)
      self.pl_mode.set_active(0)
      self.pl_mode.connect("changed", self.cb_playlist_mode)
      
      self.hbox2.pack_start(self.pl_mode, True, True, 0)
      self.pl_mode.show()
      
      # Up and Down arrows for moving items in the playlist
      self.uparrow = make_arrow_button(self, gtk.ARROW_UP, gtk.SHADOW_IN, "Arrow Up")
      self.hbox2.pack_start(self.uparrow, True, True, 0)
      
      self.dnarrow = make_arrow_button(self, gtk.ARROW_DOWN, gtk.SHADOW_IN, "Arrow Dn")
      self.hbox2.pack_start(self.dnarrow, True, True, 0)
      
      # Delete mode toggle button for playlist
      image = gtk.Image()
      image.set_from_file(pkgdatadir + "del" + gfext)
      image.show()
      self.delete = gtk.ToggleButton()
      self.delete.add(image)
      self.delete_mode = self.delete.get_active()
      self.delete.connect("toggled", self.cb_toggle, "Delete")
      self.hbox2.pack_start(self.delete, True, True, 0)
      self.delete.show()
      
      # Mute buttons
      self.stream = gtk.ToggleButton(stream_text)
      self.stream.set_active(True)
      self.stream.connect("toggled", self.cb_toggle, "Stream")
      self.hbox2.pack_start(self.stream, True, True, 0)
      self.stream.show()
            
      self.listen = nice_listen_togglebutton(listen_text)
      self.listen.set_active(True)
      self.listen.connect("toggled", self.cb_toggle, "Listen")
      self.hbox2.pack_start(self.listen, True, True, 0)
      self.listen.show()
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      sizegroup.add_widget(self.stream)
      sizegroup.add_widget(self.listen)
      
      # hbox2 is now filled so lets show it
      self.hbox2.show()
      
      # Popup menu code here
      
      # Main popup menu
      self.pl_menu = gtk.Menu()

      self.pl_menu_control = gtk.MenuItem(control_menu_text)
      self.pl_menu.append(self.pl_menu_control)
      self.pl_menu_control.show()

      separator = gtk.SeparatorMenuItem()
      self.pl_menu.append(separator)
      separator.show()
      
      self.pl_menu_item = gtk.MenuItem(item_menu_text)
      self.pl_menu.append(self.pl_menu_item)
      self.pl_menu_item.show()
      
      self.pl_menu_playlist = gtk.MenuItem(playlist_menu_text)
      self.pl_menu.append(self.pl_menu_playlist)
      self.pl_menu_playlist.show()
      
      self.pl_menu.show()
      
      # Control element submenu of main popup menu
      
      self.control_menu = gtk.Menu()
      
      self.control_menu_stop_control = gtk.MenuItem(stop_control_menu_text)
      self.control_menu_stop_control.connect("activate", self.menuitem_response, "Stop Control")
      self.control_menu.append(self.control_menu_stop_control)
      self.control_menu_stop_control.show()
      
      self.control_menu_transfer_control = gtk.MenuItem(transfer_control_menu_text)
      self.control_menu_transfer_control.connect("activate", self.menuitem_response, "Transfer Control")
      self.control_menu.append(self.control_menu_transfer_control)
      self.control_menu_transfer_control.show()
      
      self.control_menu_crossfade_control = gtk.MenuItem(crossfade_control_menu_text)
      self.control_menu_crossfade_control.connect("activate", self.menuitem_response, "Crossfade Control")
      self.control_menu.append(self.control_menu_crossfade_control)
      self.control_menu_crossfade_control.show()
      
      separator = gtk.SeparatorMenuItem()
      self.control_menu.append(separator)
      separator.show()
      
      self.control_menu_stream_disconnect_control = gtk.MenuItem(stream_disconnect_menu_text)
      self.control_menu_stream_disconnect_control.connect("activate", self.menuitem_response, "Stream Disconnect Control")
      self.control_menu.append(self.control_menu_stream_disconnect_control)
      self.control_menu_stream_disconnect_control.show()
      
      self.control_menu_stop_recording_control = gtk.MenuItem(stop_recording_menu_text)
      self.control_menu_stop_recording_control.connect("activate", self.menuitem_response, "Stop Recording Control")
      self.control_menu.append(self.control_menu_stop_recording_control)
      self.control_menu_stop_recording_control.show()    
        
      self.pl_menu_control.set_submenu(self.control_menu)
      self.control_menu.show()
      
      # Item submenu of main popup menu
      self.item_menu = gtk.Menu()
      
      self.item_tag = gtk.MenuItem(meta_tag_text)
      self.item_tag.connect("activate", self.menuitem_response, "MetaTag")
      self.item_menu.append(self.item_tag)
      self.item_tag.show()
      
      self.item_duplicate = gtk.MenuItem(duplicate_text)
      self.item_duplicate.connect("activate", self.menuitem_response, "Duplicate")
      self.item_menu.append(self.item_duplicate)
      self.item_duplicate.show()
      
      self.item_remove = gtk.MenuItem(remove_text)
      self.item_menu.append(self.item_remove)
      self.item_remove.show()
      
      self.item_tojingles = gtk.MenuItem(add_to_jingles_text)
      self.item_tojingles.connect("activate", self.menuitem_response, "ToJingles")
      self.item_menu.append(self.item_tojingles)
      self.item_tojingles.show()
      
      self.pl_menu_item.set_submenu(self.item_menu)
      self.item_menu.show()
      
      # Remove submenu of Item submenu
      self.remove_menu = gtk.Menu()

      self.remove_this = gtk.MenuItem(this_text)
      self.remove_this.connect("activate", self.menuitem_response, "Remove This")
      self.remove_menu.append(self.remove_this)
      self.remove_this.show()
      
      self.remove_all = gtk.MenuItem(all_text)
      self.remove_all.connect("activate", self.menuitem_response, "Remove All")
      self.remove_menu.append(self.remove_all)
      self.remove_all.show()
      
      self.remove_from_here = gtk.MenuItem(from_here_text)
      self.remove_from_here.connect("activate", self.menuitem_response, "Remove From Here")
      self.remove_menu.append(self.remove_from_here)
      self.remove_from_here.show()
      
      self.remove_to_here = gtk.MenuItem(to_here_text)
      self.remove_to_here.connect("activate", self.menuitem_response, "Remove To Here")
      self.remove_menu.append(self.remove_to_here)
      self.remove_to_here.show()
      
      self.item_remove.set_submenu(self.remove_menu)
      self.remove_menu.show()
      
      # Playlist submenu of main popup menu.
      self.playlist_menu = gtk.Menu()
      
      self.playlist_add_file = gtk.MenuItem(add_file_text)
      self.playlist_add_file.connect("activate", self.menuitem_response, "Add File")
      self.playlist_menu.append(self.playlist_add_file)
      self.playlist_add_file.show()
      
      self.playlist_save = gtk.MenuItem(save_text)
      self.playlist_save.connect("activate", self.menuitem_response, "Playlist Save")
      self.playlist_menu.append(self.playlist_save)
      self.playlist_save.show()
      
      separator = gtk.SeparatorMenuItem()
      self.playlist_menu.append(separator)
      separator.show()
      
      self.playlist_copy = gtk.MenuItem(copy_text)
      self.playlist_menu.append(self.playlist_copy)
      self.playlist_copy.show()
      
      self.playlist_transfer = gtk.MenuItem(transfer_text)
      self.playlist_menu.append(self.playlist_transfer)
      self.playlist_transfer.show()
      
      self.playlist_exchange = gtk.MenuItem(exchange_text)
      self.playlist_exchange.connect("activate", self.menuitem_response, "Playlist Exchange")
      self.playlist_menu.append(self.playlist_exchange)
      self.playlist_exchange.show()
      
      self.playlist_empty = gtk.MenuItem(empty_text)
      self.playlist_empty.connect("activate", self.menuitem_response, "Remove All")
      self.playlist_menu.append(self.playlist_empty)
      self.playlist_empty.show()
      
      self.pl_menu_playlist.set_submenu(self.playlist_menu)
      self.playlist_menu.show()
      
      # Position Submenu of Playlist-Copy menu item
      
      self.copy_menu = gtk.Menu()
      
      self.copy_append = gtk.MenuItem(append_text)
      self.copy_append.connect("activate", self.menuitem_response, "Copy Append")
      self.copy_menu.append(self.copy_append)
      self.copy_append.show()
      
      self.copy_prepend = gtk.MenuItem(prepend_text)
      self.copy_prepend.connect("activate", self.menuitem_response, "Copy Prepend")
      self.copy_menu.append(self.copy_prepend)
      self.copy_prepend.show()
      
      separator = gtk.SeparatorMenuItem()
      self.copy_menu.append(separator)
      separator.show()
      
      self.copy_append_cursor = gtk.MenuItem(append_cursor_text)
      self.copy_append_cursor.connect("activate", self.menuitem_response, "Copy Append Cursor")
      self.copy_menu.append(self.copy_append_cursor)
      self.copy_append_cursor.show()
      
      self.copy_prepend_cursor = gtk.MenuItem(prepend_cursor_text)
      self.copy_prepend_cursor.connect("activate", self.menuitem_response, "Copy Prepend Cursor")
      self.copy_menu.append(self.copy_prepend_cursor)
      self.copy_prepend_cursor.show()

      self.playlist_copy.set_submenu(self.copy_menu)
      self.copy_menu.show()
      
      # Position Submenu of Playlist-Transfer menu item
      
      self.transfer_menu = gtk.Menu()
      
      self.transfer_append = gtk.MenuItem(append_text)
      self.transfer_append.connect("activate", self.menuitem_response, "Transfer Append")
      self.transfer_menu.append(self.transfer_append)
      self.transfer_append.show()
      
      self.transfer_prepend = gtk.MenuItem(prepend_text)
      self.transfer_prepend.connect("activate", self.menuitem_response, "Transfer Prepend")
      self.transfer_menu.append(self.transfer_prepend)
      self.transfer_prepend.show()
      
      separator = gtk.SeparatorMenuItem()
      self.transfer_menu.append(separator)
      separator.show()
      
      self.transfer_append_cursor = gtk.MenuItem(append_cursor_text)
      self.transfer_append_cursor.connect("activate", self.menuitem_response, "Transfer Append Cursor")
      self.transfer_menu.append(self.transfer_append_cursor)
      self.transfer_append_cursor.show()
      
      self.transfer_prepend_cursor = gtk.MenuItem(prepend_cursor_text)
      self.transfer_prepend_cursor.connect("activate", self.menuitem_response, "Transfer Prepend Cursor")
      self.transfer_menu.append(self.transfer_prepend_cursor)
      self.transfer_prepend_cursor.show()

      self.playlist_transfer.set_submenu(self.transfer_menu)
      self.transfer_menu.show()      
 
 
      self.treeview.connect_object("event", self.menu_activate, self.pl_menu)

      # Initialisations
      self.playername = name 
      self.showing_file_requester = False
      self.showing_pl_save_requester = False

      # Get the users home directory and test that the environment variable is okay.
      # Actually this is more than bullet proof because when HOME is wrong I cant even run it.
      self.home = os.getenv("HOME")
      if os.path.exists(self.home):
         if os.path.isdir(self.home) == False:
	    self.home = os.path.basename(self.home)
	 else:
	    # Make sure there is a trailing slash or the filerequester will mess up a bit.
	    if self.home[-1:] != '/':
	       self.home = self.home + '/'
               
      self.file_requester_start_dir = int_object(self.home)
      
      # This is used for mouse-click debounce when deleting files in the playlist.
      self.last_time = time.time()
      
      # This flag symbolises if we are playing music or not.
      self.is_playing = False
      self.is_paused = False
      self.is_stopping = False
      self.player_is_playing = False
      self.new_title = False
      self.timeout_source_id = 0
      self.progress_press = False
      random.seed()
      # The maximum value from the progress bar at startup
      self.max_seek = 100.0
      self.reselect_please = False
      self.reselect_cursor_please = False
      self.parent = parent
      self.songname = u""
      self.flush = False
      self.title = ""
      self.artist = ""
      self.gapless = False
      self.seek_file_valid = False
      self.digiprogress_type = 0
      self.digiprogress_f = 0
      self.handle_motion_as_drop = False
      self.tag = eyeD3.Tag()
      self.other_player_initiated = False
      self.crossfader_initiated = False
      self.music_filename = ""
      self.session_filename = self.parent.idjc + self.playername + "_session"
      self.oldstatusbartext = ""
