/*
#   rms_calc.h: generate a running rms count of the signal level
#   Copyright (C) 2006 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.
*/

#include <jack/jack.h>

typedef jack_default_audio_sample_t rmsaudio_t;

struct rms_calc
   {
   rmsaudio_t *buffer;
   rmsaudio_t *end;
   rmsaudio_t *ptr;
   rmsaudio_t sum;
   rmsaudio_t newsum;		/* provides drift correction */
   rmsaudio_t multiplier;
   };
   
rmsaudio_t rms_calc(struct rms_calc *, rmsaudio_t);
struct rms_calc *rms_calc_create(int sr, float length);
void rms_calc_destroy(struct rms_calc *);
