/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "ieditor.h"
#ifndef I_NO_HIGHLITE_SYNTAX
	#include "isyntaxhighlighter.h"
#endif


//
// Constructs a iEditor and connect Syntax Highliter
//

iEditor::iEditor(QWidget *parent, const char *name) : QTextEdit(parent, name)
{
	static QFont f;
	
	f.setFamily("courier");
	f.setPointSize(10);
	f.setFixedPitch(true);
    this->setFont(f);

	this->setTextFormat(PlainText);

	highlighter = 0;

#ifndef I_NO_HIGHLITE_SYNTAX
	highlighter = new iSyntaxHighlighter;
	this->document()->setPreProcessor(highlighter);
#endif

}


void iEditor::setPointSize(int s)
{
#ifndef I_NO_HIGHLITE_SYNTAX
	highlighter->setPointSize(s);
#endif
	QTextEdit::setPointSize(s);
}


iEditor::~iEditor()
{
//	if(highlighter != 0) delete highlighter;
}

void iEditor::setKeywords(QStringList k)
{
#ifndef I_NO_HIGHLITE_SYNTAX
	highlighter->setKeywords(k);
#endif
}


void iEditor::setVariables(QStringList v)
{
#ifndef I_NO_HIGHLITE_SYNTAX
	highlighter->setVariables(v);
#endif
}


void iEditor::setParameters(QStringList p)
{
#ifndef I_NO_HIGHLITE_SYNTAX
	highlighter->setParameters(p);
#endif
}


void iEditor::activateHighlighter(bool s)
{
#ifndef I_NO_HIGHLITE_SYNTAX
	highlighter->activate(s);
#endif
}


void iEditor::keyPressEvent(QKeyEvent *e)
{

	QTextEdit::keyPressEvent(e);

	switch(e->key())
	{
	case Qt::Key_Tab:
		{
			emit tabPressed();
			break;
		}
	}
}


QPoint iEditor::getTextCursorPos() const
{
	int para, index;
	this->getCursorPosition(&para,&index);
	return mapToGlobal(QPoint(textCursor()->x(),textCursor()->y()+paragraphRect(para).bottom()));
}



