/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*=========================================================================

	A replacement for vtkStreamLine which is VERY SLOW and takes all of the memory

=========================================================================*/

#ifndef ISTREAMLINE_H
#define ISTREAMLINE_H

class vtkStructuredPoints;
class vtkPoints;


#include <vtkStructuredPointsToPolyDataFilter.h>

class iStreamLine : public vtkStructuredPointsToPolyDataFilter
{
public:

	vtkTypeMacro(iStreamLine,vtkStructuredPointsToPolyDataFilter);
	
	// Description:
	// Construct object to extract all of the input data.
	static iStreamLine *New();

	virtual void setSource(vtkPoints *s);
	virtual void setScalars(vtkStructuredPoints *s){ scalars = s; this->Modified(); }
	virtual void setLength(float d) { if(d > 0.0) { length = d; this->Modified(); } }
	virtual void setComputeVorticity(bool d) { computeVort = d; this->Modified(); }
	virtual void setComputeDivergence(bool d) { computeDiv = d; this->Modified(); }
	virtual void setMinimumSpeed(float v) { vmin = v; this->Modified(); }
	virtual void setDirection(int d) { if(d>=0 && d<5) { dir = d; this->Modified(); } }
	virtual void setAxisDirection(int d) { if(d>=0 && d<3) { axisDir = d; this->Modified(); } }
	virtual void setSplitLines(bool s){ if(s != splitLines){ splitLines = s; this->Modified(); } }
	virtual void setQuality(int q);

	inline float getLength(){ return length; }
	inline bool getComputeVorticity(){ return computeVort; }
	inline bool getComputeDivergence(){ return computeDiv; }
	inline float getMinimumSpeed(){ return vmin; }
	inline int getDirection(){ return dir; }
	inline int getAxisDirection(){ return axisDir; }
	inline bool getSplitLines(){ return splitLines; }
	inline int getQuality(){ return quality; }

	virtual float getMemorySize();

//	static void computeVorticity(float x[3], float *ptrdata, int dims[3], float origin[3], float spacing[3], float vort[3]);
//	static void computeDivergence(float x[3], float *ptrdata, int dims[3], float origin[3], float spacing[3], float &diverg);
	
	static vtkIdType getVector(double x[3], float v[3], float *ptrdata, int dims[3], vtkFloat origin[3], vtkFloat spacing[3], float *vort = 0, float *div = 0);

protected:
	
	iStreamLine();
	virtual ~iStreamLine();
	
	virtual vtkIdType getVector(double x[3], float v[3], float *vort = 0, float *div = 0);
	virtual int followLine(double x[3], double &d, float &h, float eps, vtkIdType l);
	
	virtual bool definePointers(vtkStructuredPoints *input);
	virtual void assignScalars(float *p, int i, vtkIdType l);
	virtual void getDmin(vtkIdType l, float &ddmin, float &dx);

	virtual void ExecuteData(vtkDataObject *out);

	float vmin, dmin, eps;
	float length;
	bool computeVort, computeDiv;
	int dir;
	int quality, itMax;
	int axisDir;
	bool splitLines;

	vtkPoints *source;
	vtkStructuredPoints *scalars;

	vtkIdType scalarSize;
	int dims[3], nadd;
	float *ptrvec, *ptrsca;
	vtkFloat org[3], spa[3];

};

#endif  // ISTREAMLINE_H


