/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IMEASURINGBOX_H
#define IMEASURINGBOX_H

class vtkPolyDataMapper;
class vtkCubeSource;

class iTextActor;

#include <vtkOpenGLActor.h>
#include <vtkProperty.h>


class iMeasuringBox: public vtkOpenGLActor
{
	
public:
	
	static iMeasuringBox *New();
	
	virtual void ReleaseGraphicsResources(vtkWindow *win);

	virtual int RenderOverlay(vtkViewport*);
	virtual int RenderOpaqueGeometry(vtkViewport*);
	virtual int RenderTranslucentGeometry(vtkViewport *);

	virtual void setSize(float s){ if(s > 0.0){ size = s; this->Modified(); } }
	virtual void setOpacity(float s);
	virtual void setColor(float r, float g, float b);
	virtual void setInitialScale(float s);

	inline float getOpacity(){ return this->GetProperty()->GetOpacity(); }
	inline float getSize(){ return size; }
	
	virtual iTextActor *getTextActor(){ return itext; }

	virtual vtkFloat *GetBounds(){ return 0; }  // set to zero so that the text is always displayed
	virtual float GetLength();

protected:
	
	iMeasuringBox();
	~iMeasuringBox();
	
private:

	vtkPolyDataMapper *cubeMapper;
	vtkPolyDataMapper *cubeFrameMapper;
	vtkCubeSource *cubeSource;
	vtkActor *cubeFrame;

	iTextActor *itext;

	bool started;
	float size, scale;
	float cFactor1r, cFactor1g, cFactor1b, cFactor2;

};

#endif // IMEASURINGBOX_H
