/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*=========================================================================

  Ifrit data filter: takes StructuredPoints data of type float and converts them into
  StructuredPoints data of type char using lower and upper bounds.

=========================================================================*/

#ifndef IPARTICLESSPLITTER_H
#define IPARTICLESSPLITTER_H

class iHistogramMaker;

#include <vtkPolyDataToPolyDataFilter.h>
#include "iobject.h"
#include "idatachannelsource.h"

#define MAXINSTANCE 256


class iParticlesSplitter : public iObject, public vtkPolyDataToPolyDataFilter, public iDataChannelSource
{
	
public:
	
	static iParticlesSplitter *New(iVTK *m);
	
	virtual void getAttributeLimits(int n, float &amin, float &amax);
	inline void getAttributeMinMax(float &amin, float &amax){ amin = attMin; amax = attMax; }
	inline int getAttribute(){ return att; }
	inline int getNumberOfPieces(){ return nPieces; }

	virtual void setAttributeMinMax(float amin, float amax);
	virtual void setAttributeLimits(int n, float amin, float amax);
	virtual void setAttribute(int a);

	inline bool getLogScale(){ return logScale; }
	virtual void setLogScale(bool s){ logScale = s; }

	virtual void resetLimits(){ limitsSet = false; }

	virtual int createNewPiece(){ return this->createNewPiece(-1.0e30,1.0e30); }
	virtual int createNewPiece(float amin, float amax);
	
	virtual void deletePiece(int n);

	inline iHistogramMaker *getHistogramMaker(){ return histogramMaker; }

	virtual void packState(iString &s);
	virtual void unpackState(iString s);

protected:
	
	virtual void ExecuteData(vtkDataObject *out);
	iParticlesSplitter(iVTK *m);
	virtual ~iParticlesSplitter();
	
	virtual void updateLimits();

private:
	
	bool limitsSet, logScale;

	int att;
	int nPieces;
	float attMin, attMax;
	float attPieceLo[MAXINSTANCE];
	float attPieceHi[MAXINSTANCE];

	bool sorted;

	iHistogramMaker *histogramMaker;

	unsigned long sortingMTime;

};

#endif


