/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iglobals.h"
#include "itextbitmap.h"
#include "ivtk.h"

#include <vtkViewport.h>
#include <vtkProperty2D.h>
#include <vtkTextMapper.h>
#include <vtkScaledTextActor.h>
#ifndef I_VTK_VERSION_40
#include <vtkTextProperty.h>
#endif


void reportNullPointer(int);


iTextBitmap::iTextBitmap()
{

	textMapper = vtkTextMapper::New();
	if(textMapper == 0) reportNullPointer(6001);
	textActor = vtkScaledTextActor::New();
	if(textActor == 0) reportNullPointer(6002);
	textActor->SetMapper(textMapper);

#ifndef I_VTK_VERSION_40
	textMapper->GetTextProperty()->SetFontFamilyToArial();
	textMapper->GetTextProperty()->ShadowOn();
	textMapper->GetTextProperty()->SetJustificationToLeft(); 
	textMapper->GetTextProperty()->SetVerticalJustificationToBottom();
#else
	textMapper->ShadowOn();
	textMapper->SetJustificationToLeft(); 
	textMapper->SetVerticalJustificationToBottom();
#endif

}


iTextBitmap::~iTextBitmap()
{

	textMapper->Delete();
	textActor->Delete();

}


void iTextBitmap::getSize(vtkViewport *viewport, float s[2])
{

	textMapper->SetInput(text);

#ifndef I_VTK_VERSION_40
	textMapper->GetTextProperty()->SetFontSize(fontSize);
	if(bold) textMapper->GetTextProperty()->BoldOn(); else textMapper->GetTextProperty()->BoldOff();
#else
	textMapper->SetFontSize(fontSize);
	if(bold) textMapper->BoldOn(); else textMapper->BoldOff();
#endif

	vtkFloat w = (float)textMapper->GetWidth(viewport);
	vtkFloat h = (float)textMapper->GetHeight(viewport);
	viewport->DisplayToNormalizedDisplay(w,h);

	size[0] = s[0] = w; size[1] = s[1] = h;

}


void iTextBitmap::ReleaseGraphicsResources(vtkWindow *win)
{
	textActor->ReleaseGraphicsResources(win);
	this->iText::ReleaseGraphicsResources(win);
}


int iTextBitmap::RenderOverlay(vtkViewport* viewport)
{
	textActor->RenderOverlay(viewport);
	return 1;
}


int iTextBitmap::RenderOpaqueGeometry(vtkViewport* viewport)
{

	iVTK *vtk = iVTK::convertFromViewport(viewport);
	int mag = vtk->getRenderingMagnification();

	if(mag == 1)
	{
		
		this->getSize(viewport,s);

		p[0] = pos[0] - 0.5*hJust*s[0];
		p[1] = pos[1] - 0.5*vJust*s[1];

		textActor->GetProperty()->SetColor(red,green,blue);

		textActor->SetPosition(p[0],p[1]);
		textActor->SetPosition2(s[0],s[1]);

	}
	else
	{
		int winij[2];
		vtk->computePositionShiftsUnderMagnification(winij,viewport);
		
		textActor->SetPosition(mag*p[0]-winij[0],mag*p[1]-winij[1]);
		textActor->SetPosition2(mag*s[0],mag*s[1]);

#ifndef I_VTK_VERSION_40
		textMapper->GetTextProperty()->SetFontSize(mag*fontSize);
#else
		textMapper->SetFontSize(mag*fontSize);
#endif

	}

	textActor->RenderOpaqueGeometry(viewport);
	
	return 1;
				
}
