/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iqt.h"
#include "ivtk.h"
#include "ivtkwindow.h"
#include "iqtwindow.h"
#include "iqtextension.h"
#include "iqtdefs.h"
#include "iqt_tens.h"
#include "iqt_view.h"

#include "imath.h"
#include "itensor.h"
#include "ilimits.h"
#include "ipalette.h"
#include "idatareader.h"
#include "ierror.h"

#include <qaction.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcolordialog.h> 
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qtabwidget.h>


#define CURRENT_LIMITS	iVTKWindow::getCurrentWindow()->getReader()->getLimits(CURRENT_TENSOR->getDataChannel())


//
// *********************************************************************************
//
//  
//   Tensor field panel widgets
//
//
// *********************************************************************************
//
void iQT_Tens::init()
{

	myQT = (iQT *)parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget();
	if(strcmp(myQT->name(),"iQT") != 0)
	{
		iQTWindow::getCurrentWindow()->popupError("Incorrect parenting in Tab Pages",IFRITERROR_INCORRECT_PARENTING_IN_TABS);
		exit(1);
	}

	//
	//  Make sliders look better
	//
	LayoutTensMagnitude->setStretchFactor(LayoutTensMagnitudeLeft,3);
	LayoutTensMagnitude->addStretch(1);
	
	LayoutTensMaterial->setStretchFactor(Tens_Paint_MaterialGroupBox,3);
	LayoutTensMaterial->addStretch(1);
	
}


void iQT_Tens::doRender()
{
        myQT->doRender();
}


void iQT_Tens::updateTens_Widgets()
{
	float f;

	//
	//  Variable names
	//
	Tens_Paint_PaintVar1->setText(CURRENT_LIMITS->getVarName(1));
    Tens_Paint_PaintVar2->setText(CURRENT_LIMITS->getVarName(2));
    Tens_Paint_PaintVar3->setText(CURRENT_LIMITS->getVarName(3));
	//
	//  Main panel wisgets
	//
	myQT->TabWidgetView->updateSwitchesTens();

	CALL_FUNCTION1(Tens_Main_Mode,setButton,0);
	
	//	Tens_Main_GlyphScalingBox->setChecked(CURRENT_TENSOR->isScalingOn());
	
	CALL_FUNCTION1(Tens_Main_GlyphSizeSlider,setValue,round(10*log10(CURRENT_TENSOR->getGlyphSize())));
    CALL_FUNCTION1(Tens_Main_GlyphColorLabel,setPaletteBackgroundColor,CURRENT_TENSOR->getColor());
	
	f = CURRENT_LIMITS->getTenHigh();
	CALL_FUNCTION1(Tens_Main_MagnitudeSlider,setValue,round(10.0*log10(f/CURRENT_LIMITS->getTenMax())));
	Tens_Main_MagnitudeLCD->display(f);

	CALL_FUNCTION1(Tens_Main_ResampleSlider,setValue,round(log10((double)CURRENT_TENSOR->getSampleRate())/log10(2.0)));
	Tens_Main_ResampleLCD->display(CURRENT_TENSOR->getSampleRate());
	//
	//  Paint panel
	//
	CALL_FUNCTION1(Tens_Paint_PaintWithButtons,setButton,CURRENT_TENSOR->getColorBy());

    CALL_FUNCTION1(Tens_Paint_PaletteList,setCurrentItem,CURRENT_TENSOR->getPal());
    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(CURRENT_TENSOR->getPal()),&myQT->pixmapPaint);
    Tens_Paint_PalettePixmap->setPixmap(myQT->pixmapPaint);
	//
	//  Material panel widgets
	//    
    f = CURRENT_TENSOR->getDiffuse();
    CALL_FUNCTION1(Tens_Paint_MaterialDiffuseSlider,setValue,round(100.0*f));
    Tens_Paint_MaterialDiffuseLCD->display((double)f);
    
    f = CURRENT_TENSOR->getAmbient();
    CALL_FUNCTION1(Tens_Paint_MaterialAmbientSlider,setValue,round(100.0*f));
    Tens_Paint_MaterialAmbientLCD->display((double)f);
    
    f = CURRENT_TENSOR->getSpecular();
    CALL_FUNCTION1(Tens_Paint_MaterialSpecularSlider,setValue,round(100.0*f));
    Tens_Paint_MaterialSpecularLCD->display((double)f);
    
    f = CURRENT_TENSOR->getSpecularPower();
    CALL_FUNCTION1(Tens_Paint_MaterialSpecularPowerSlider,setValue,round(f));
    Tens_Paint_MaterialSpecularPowerLCD->display((double)f);
	
    if(myQT->ext != NULL) myQT->ext->updateWidgets(DISPLAYPAGE_VECT);
	myQT->updateDataChannelComboBox(DISPLAYPAGE_TENS);

}


void iQT_Tens::updateTens_Main_Mode( int vtkNotUsed(n) )
{

/*	if(n != CURRENT_TENSOR->getMode()){
		CURRENT_TENSOR->setMode(n);
		myQT->startTask();
		myQT->render(true);
		myQT->endTask();
	}*/

}


void iQT_Tens::updateTens_Main_Resample( int n )
{

	int rr = round(pow(2.0,n));
	Tens_Main_ResampleLCD->display(rr);
	CURRENT_TENSOR->setSampleRate(rr);
    if(myQT->sliderRenderTracking) myQT->render(false);

}


void iQT_Tens::updateTens_Main_GlyphSize( int n )
{

	CURRENT_TENSOR->setGlyphSize(pow10(0.1*n));
    if(myQT->sliderRenderTracking) myQT->render(false);

}


void iQT_Tens::updateTens_Main_GlyphScalingBox( bool s )
{

	myQT->startTask();
	CURRENT_TENSOR->setScalingOn(s);
	myQT->render(true);
	myQT->endTask();

}


void iQT_Tens::updateTens_Main_GlyphColor()
{

    QColor c = QColorDialog::getColor(); 
	if(c.isValid())
	{
		myQT->startTask();
		CALL_FUNCTION1(Tens_Main_GlyphColorLabel,setPaletteBackgroundColor,c);
		CURRENT_TENSOR->setColor(c);
		myQT->render(true);
		myQT->endTask();
	}

}


void iQT_Tens::updateTens_Main_Magnitude( int n )
{

	float f = CURRENT_LIMITS->getTenMax()*pow10(0.1*n);
	CURRENT_LIMITS->setTenHigh(1,f);
	Tens_Main_MagnitudeLCD->display(f);
	CURRENT_TENSOR->updatePipeline();
    if(myQT->sliderRenderTracking) myQT->render(false);

}


void iQT_Tens::updateTens_Paint_PaintWithButtons( int n )
{

	myQT->startTask();
	CURRENT_TENSOR->setColorBy(n);
	this->updateTens_Widgets();  // needed for the colorbars to work properly
    myQT->render(true);
	myQT->endTask();

}


void iQT_Tens::updateTens_Paint_PalettePixmap(int n)
{
    
    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(n),&myQT->pixmapPaint);
    Tens_Paint_PalettePixmap->setPixmap(myQT->pixmapPaint);
    
}


void iQT_Tens::updateTens_Paint_PalettePixmapFinal( int n )
{

	myQT->startTask();
    updateTens_Paint_PalettePixmap(n);
    CURRENT_TENSOR->setPal(n);
	updateTens_Widgets(); // needed for colorbars
    myQT->render(true);
	myQT->endTask();
    
}


void iQT_Tens::updateTens_Paint_MaterialAmbientSlider( int n )
{

	CURRENT_TENSOR->setAmbient(0.01*n);
	Tens_Paint_MaterialAmbientLCD->display(0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);

}


void iQT_Tens::updateTens_Paint_MaterialDiffuseSlider( int n )
{

	CURRENT_TENSOR->setDiffuse(0.01*n);
	Tens_Paint_MaterialDiffuseLCD->display(0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);

}


void iQT_Tens::updateTens_Paint_MaterialSpecularSlider( int n )
{

	CURRENT_TENSOR->setSpecular(0.01*n);
	Tens_Paint_MaterialSpecularLCD->display(0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);

}


void iQT_Tens::updateTens_Paint_MaterialSpecularPower( int n )
{

	CURRENT_TENSOR->setSpecularPower(0.01*n);
	Tens_Paint_MaterialSpecularPowerLCD->display(0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);

}


void iQT_Tens::launchPaletteEditor()
{
	
	myQT->launchPaletteEditor(Tens_Paint_PaletteList->currentItem());
	
}


void iQT_Tens::updateTabPageChanged(QWidget *)
{
	myQT->updateDataChannelComboBox(DISPLAYPAGE_TENS);
}

