/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"

#ifdef IEXTENSION

#include "iextensionfactory.h"


#include "ianimatorscript.h"
#include "icontrolmodule.h"
#include "icrosssectionviewsubject.h"
#include "idata.h"
#include "idataexplorer.h"
#include "idatareader.h"
#include "iedition.h"
#include "iparticlegroup.h"
#include "iparticlesviewsubject.h"
#include "ipicker.h"
#include "irendertool.h"
#include "isurfaceviewsubject.h"
#include "itensorfieldviewsubject.h"
#include "ivectorfieldviewsubject.h"
#include "iviewmodule.h"
#include "iviewobject.h"
#include "iviewobjectfamily.h"
#include "ivolumeviewsubject.h"

#if IEXTENSION_INCLUDED(IEXTENSION_HART)
#include "hobjects.h"
#endif

#if IEXTENSION_INCLUDED(IEXTENSION_MV)
#include "imultiviewrendertool.h"
#endif

//
// **************************************************************************
//
//  IMPORTANT: Factory methods do not need to be checked for null pointers
//             since they are only called from within New() functions
//
// **************************************************************************
//

iAnimatorScript* iExtensionFactory::CreateAnimatorScript(iAnimator *m)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	return new hAnimatorScript(m);
#else
	return new iAnimatorScript(m);
#endif
}


iViewObject* iExtensionFactory::CreateViewObject(iViewObjectParent *parent)
{
	iViewModule *vm(parent->GetViewModule());
	const iObjectType &type(parent->GetObjectType());
	
	//
	//  Particles are special - they are not single-type
	//
	iViewObject *obj = new iViewObject(parent,false,!type.IsMatch(iParticlesViewSubject::Type()));
	if(obj == 0) return 0;

	//
	//  View objects
	//
	if(type.IsMatch(iCrossSectionViewSubject::Type()))
	{
		obj->AddSubject(new iCrossSectionViewSubject(vm,iData::UniformScalars(),"Cross Section"));
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj->AddSubject(new hCrossSectionViewSubject(vm,iData::HARTVariables(),"Cross Section"));
#endif
	}

	if(type.IsMatch(iParticlesViewSubject::Type()))
	{
		obj->AddSubject(new iParticlesViewSubject(vm,iData::BasicParticles(),"Particles"));
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj->AddSubject(new iParticlesViewSubject(vm,iData::HARTParticles(0),"HART Particles"));
		obj->AddSubject(new iParticlesViewSubject(vm,iData::HARTParticles(1),"HART Stellar Particles"));
		obj->AddSubject(new iParticlesViewSubject(vm,iData::HARTParticles(2),"HART Black Hole Particles"));
#endif
	}

	if(type.IsMatch(iSurfaceViewSubject::Type()))
	{
		obj->AddSubject(new iSurfaceViewSubject(vm,iData::UniformScalars(),"Surface"));
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj->AddSubject(new hSurfaceViewSubject(vm,iData::HARTVariables(),"Surface"));
#endif
	}

	if(type.IsMatch(iTensorFieldViewSubject::Type()))
	{
		obj->AddSubject(new iTensorFieldViewSubject(vm,iData::UniformTensors(),"Tensor Field"));
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj->AddSubject(new hTensorFieldViewSubject(vm,iData::HARTVariables(2),"Tensor Field"));
#endif
	}

	if(type.IsMatch(iVectorFieldViewSubject::Type()))
	{
		obj->AddSubject(new iVectorFieldViewSubject(vm,iData::UniformVectors(),"Vector Field"));
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj->AddSubject(new hVectorFieldViewSubject(vm,iData::HARTVariables(1),"Vector Field"));
#endif
	}

	if(type.IsMatch(iVolumeViewSubject::Type()))
	{
		obj->AddSubject(new iVolumeViewSubject(vm,iData::UniformScalars(),"Volume"));
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj->AddSubject(new hVolumeViewSubject(vm,iData::HARTVariables(),"Volume"));
#endif
	}

#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	if(type.IsMatch(hMeshViewSubject::Type()))
	{
		obj->AddSubject(new hMeshViewSubject(vm,iData::HARTVariables(),"HART Adaptive Mesh"));
	}
#endif

	obj->Verify();

	iEdition::ApplySettings(obj,type);

	return obj;
}


iRenderTool* iExtensionFactory::CreateRenderTool(iViewModule *vm)
{
#if IEXTENSION_INCLUDED(IEXTENSION_MV)
	return new iMultiViewRenderTool(vm);
#else
	return new iRenderTool(vm);
#endif
}


void iExtensionFactory::InstallExtensions(iControlModule *cm)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	cm->InstallExtension(new hControlModuleExtension(cm,"HART"));
#endif
}


void iExtensionFactory::InstallExtensions(iDataReader *dr)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	dr->InstallExtension(new hDataReaderExtension(dr,"HART"));
#endif
}


void iExtensionFactory::InstallExtensions(iPicker *picker)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	picker->InstallExtension(new hPickerExtension(picker,"HART"));
#endif
}


void iExtensionFactory::InstallExtensions(iViewModule *vm)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	vm->InstallExtension(new hViewModuleExtension(vm,"HART"));
#endif
}

#endif
