/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggdialogperformancemeter.h"


#include "icontrolmodule.h"
#include "ieventobserver.h"
#include "iimagefactory.h"
#include "ishell.h"
#include "isystem.h"
#include "iviewmodule.h"

#include "iggframe.h"
#include "iggmainwindow.h"
#include "iggwidgetarea.h"
#include "iggwidgetmisc.h"

#include "ibgwidgethelper.h"

#include "iggparameter.h"
using namespace iggParameter;


namespace iggDialogPerformanceMeter_Private
{
	class ValueDisplay : public iggWidgetNumberDisplay
	{

	public:
		
		ValueDisplay(iggDialogPerformanceMeter *dialog, bool max, int mode, iggFrame *parent) : iggWidgetNumberDisplay("",parent)
		{
			mDialog = dialog;
			mIsMax = max;
			mMode = mode;
			mValue = 0.0f;

			mWarning = 0;
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			float v;
			int p = 0;

			switch(mMode)
			{
			case 0:
				{
					v = this->GetShell()->GetControlModule()->GetViewModule()->GetAbortRenderEventObserver()->GetRenderTime();
					p = 2;
					break;
				}
			case 1:
				{
					v = this->GetShell()->GetControlModule()->GetUpdateTime();
					p = 1;
					break;
				}
			case 2:
				{
					v = 0.001f*this->GetShell()->GetControlModule()->GetMemorySize();
					p = 1;
					//
					//  50% threshold
					//
					mWidgetHelper->UnSetBackgroundColor();
					if(v > 0.5f*iSystem::GetMemoryLimit())
					{
						mWidgetHelper->SetBackgroundColor(iColor(200,200,0));
						if(mWarning < 1)
						{
							mWarning = 1;
							if(mDialog != 0) mDialog->Show(true);
						}
					}
					if(v > 0.9f*iSystem::GetMemoryLimit())
					{
						mWidgetHelper->SetBackgroundColor(iColor(255,0,0));
						if(mWarning < 2)
						{
							mWarning = 2;
							if(mDialog != 0) mDialog->Show(true);
						}
					}
					break;
				}
			}

			float prev = mValue, acc = pow10(-(float)p);

			if(mIsMax)
			{
				if(mValue < v) mValue = v;  
			}
			else
			{
				mValue = v;
			}

			if(fabs(mValue-prev) > acc) this->Display(mValue,p);
		}

		int mWarning;
		bool mIsMax;
		int mMode;
		float mValue;
		iggDialogPerformanceMeter *mDialog;
	};
};


using namespace iggDialogPerformanceMeter_Private;


iggDialogPerformanceMeter::iggDialogPerformanceMeter(iggMainWindow *parent) : iggDialog(parent,0U,iImageFactory::FindIcon("perf.png"),"Performance Meter",0,7)
{
	iggWidgetNumberDisplay *tm = new iggWidgetNumberDisplay("",mFrame);
	tm->Display(iSystem::GetMemoryLimit(),1);

	mFrame->AddLine((iggWidget *)0,1,new iggWidgetTextArea("Render time",mFrame),2,new iggWidgetTextArea("Update time",mFrame),2,new iggWidgetTextArea("Memory used",mFrame),2);
	mFrame->AddLine(new iggWidgetTextArea("Current",mFrame),new ValueDisplay(this,false,0,mFrame),new iggWidgetTextArea("sec",mFrame),new ValueDisplay(this,false,1,mFrame),new iggWidgetTextArea("sec",mFrame),new ValueDisplay(this,false,2,mFrame),new iggWidgetTextArea("MB",mFrame));
	mFrame->AddLine(new iggWidgetTextArea("Maximum",mFrame),(iggWidget *)0,(iggWidget *)0,new ValueDisplay(this,true,1,mFrame),new iggWidgetTextArea("sec",mFrame),new ValueDisplay(this,true,2,mFrame),new iggWidgetTextArea("MB",mFrame));
	mFrame->AddLine(new iggWidgetTextArea("Available",mFrame),1,(iggWidget *)0,4,tm,1,new iggWidgetTextArea("MB",mFrame),1);
	mFrame->AddSpace(10);

	mFrame->SetColStretch(0,10);
}


const iString& iggDialogPerformanceMeter::GetToolTip() const
{
	static iString tmp = "Report the amount of used memory and rendering times";
	return tmp;
}

