/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggframehistogramareaextra.h"


#include "ierror.h"

#include "iggwidgetarea.h"
#include "iggwidgetmisc.h"
#include "iggwidgetotherbutton.h"

#include "ibgwidgetbuttonsubject.h"

#include "iggsubjectfactory.h"
#include "iggparameter.h"
using namespace iggParameter;


namespace iggFrameHistogramAreaExtra_Private
{
	class ShowInLogCheckBox : public iggWidget
	{

	public:

		ShowInLogCheckBox(iggWidgetHistogramArea *area, iggFrame *parent) : iggWidget(parent)
		{
			mArea = area;
			mSubject = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypeCheckBox,"Show Y-axis in log",1);

			this->SetBaloonHelp("Show histogram in log scale");
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			mSubject->SetDown(mArea->GetLogScale());
		}

		virtual void OnVoid1Body()
		{
			mArea->SetLogScale(mSubject->IsDown());
			mArea->UpdateWidget();
		}

		ibgWidgetButtonSubject *mSubject;
		iggWidgetHistogramArea *mArea;
	};


	class ShowInFullResolutionCheckBox : public iggWidget
	{

	public:

		ShowInFullResolutionCheckBox(iggWidgetHistogramArea *area, iggFrame *parent) : iggWidget(parent)
		{
			mArea = area;
			mSubject = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypeCheckBox,"Full resoluton (may be slow)",1);

			this->SetBaloonHelp("Show histogram with full resolution (slow for large data sets)");
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			this->Show(mArea->SupportsFullResolution());
			mSubject->SetDown(mArea->GetFullResolution());
		}

		virtual void OnVoid1Body()
		{
			mArea->SetFullResolution(mSubject->IsDown());
			mArea->UpdateWidget();
		}

		ibgWidgetButtonSubject *mSubject;
		iggWidgetHistogramArea *mArea;
	};
};


using namespace iggFrameHistogramAreaExtra_Private;


//
//  Main class
//
iggFrameHistogramAreaExtra::iggFrameHistogramAreaExtra(iggWidgetHistogramArea *area, iggFrame *parent, bool withFull) : iggFrame(parent,4)
{
	mArea = area; IERROR_ASSERT(area);
	mArea->AddExtra(this);

	mDisplayMin = new iggWidgetNumberDisplay("",this);
	mDisplayMax = new iggWidgetNumberDisplay("",this);
	this->AddLine(mDisplayMin,new iggWidgetTextArea("<-- range -->",this),mDisplayMax);
	iggFrame *tmp = new iggFrame(this,3);
	if(withFull)
	{
		tmp->AddLine(new ShowInLogCheckBox(area,tmp),static_cast<iggWidget*>(0),new ShowInFullResolutionCheckBox(area,tmp));
	}
	else
	{
		tmp->AddLine(new ShowInLogCheckBox(area,tmp));
	}
	tmp->SetColStretch(1,10);
	this->AddLine(tmp,3);
	this->SetColStretch(1,10);
}


void iggFrameHistogramAreaExtra::UpdateWidgetBody()
{
	float min = 0.0, max = 0.0;
	mArea->GetHistogramRange(min,max);
	mDisplayMin->Display(min);
	mDisplayMax->Display(max);

	this->iggFrame::UpdateWidgetBody();
}
