/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iartifactcorrector.h"


#include <vtkRenderer.h>

//
//  Templates
//
#include "igenericfiltertemplate.h"


bool iArtifactCorrector::mIsEnabled = false;


iArtifactCorrector::iArtifactCorrector(iViewSubject *vo) : iGenericPolyDataToPolyDataFilter<vtkDepthSortPolyData>(vo,1,true,false)
{
	mIsActive = false;
}


iArtifactCorrector::~iArtifactCorrector()
{
}


void iArtifactCorrector::Enable(bool s)
{
	mIsEnabled = s;
}


bool iArtifactCorrector::HasArtifacts(vtkRenderer * /* ren */, vtkProperty * /* prop */)
{
	//
	//  Do nothing by default
	//
	return false;
}


void iArtifactCorrector::ProduceOutput()
{
	if(mIsEnabled && mIsActive && this->GetCamera()!=0)
	{
		this->ExecuteParent();
#ifdef I_DEBUG
		iConsole::PrintDebugMessage("Executing iArtifactCorrector...");
#endif
	}
	else
	{
		this->GetOutput()->ShallowCopy(this->GetInput());
	}
}



void iArtifactCorrector::CorrectArtifacts(vtkRenderer *ren, vtkProperty *prop)
{
	if(!mIsEnabled) return;

	this->SetCamera(ren->GetActiveCamera());

	bool s = this->HasArtifacts(ren,prop);
	if(s != mIsActive)
	{
		mIsActive = s;
		this->Modified();
	}
}

