/* GIMLET: GNOME Input Method Language Enabing Tool
 *
 * Copyright (C) 2001, 2002 Havoc Pennington
 * Copyright (C) 2002 Red Hat, Inc.
 * Copyright (C) 2003 Sun Microsystems
 * Copyright (C) 2003 Mariano Suarez-Alvarez
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIMLET_LANGUAGE_H
#define __GIMLET_LANGUAGE_H

typedef struct _GimletLanguage GimletLanguage;

#include "gnome-im-switcher.h"

void gimlet_language_init (GimletWindow *gimlet);
GtkWidget *gimlet_langmenu_dialog_new (GtkWindow *transient_parent,
				       GimletWindow *gimlet);
void gimlet_language_free (GimletLanguage *language);

char *gimlet_language_get_name (GimletLanguage *data);
char *gimlet_language_get_iiim_lang_name (GimletLanguage *data);
char *gimlet_language_get_conversion_mode (char *iiim_lang_name);

GSList *gimlet_language_get_active_languages (void);
void gimlet_language_add_active_language (GimletWindow *gimlet,
					  char *iiim_lang_name);
#endif
