/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package com.sun.iiim;

import java.util.Vector;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.text.CharacterIterator;

public class IIIMEvent {

    protected boolean consumed = false;
	
    protected int id = AWT;

    public int getID() {
	return id;
    }

    /*
     * The type is unique only in one kind of IIIMEvent.
     */
    protected int type;

    public int getType() {
	return type;
    }

    // IIIMEvent id need to be unique only in IIIMEvent, because
    // EventQueue which is used to post/dispatch only handle
    // the subclass of IIIMEvent.
    //
    public final static int AWT			= 0;
    public final static int ACTION 		= 1;
    public final static int PREEDIT 		= 2;
    public final static int COMMITTED 		= 3;
    public final static int LOOKUP		= 4;
    public final static int STATUS		= 5;
    public final static int AUX			= 6;
    public final static int KEY			= 7;

    private AWTEvent awtEvent;
    private Vector listeners;

    public IIIMEvent(int id) {
	this.id = id;
	listeners = new Vector();
    }

    public IIIMEvent(AWTEvent e) {
	this(AWT);
	
	awtEvent = e;
    }

    public AWTEvent getAWTEvent() {
	return awtEvent;
    }

    public void processedBy(IIIMListener listener) {
	listeners.add(listener);
    }

    public boolean isProcessedBy(IIIMListener listener) {
	return listeners.contains(listener);
    }

    public void consume() {
	consumed = true;
	if (awtEvent != null && awtEvent instanceof InputEvent) {
	    ((InputEvent)awtEvent).consume();
	}
    } 

    public boolean isConsumed() {
	return consumed;
    }

    /**
     * convinience method
     */
    public static String iteratorToString(CharacterIterator iterator) {
	StringBuffer sb = new StringBuffer();
	for (char c = iterator.first(); c != CharacterIterator.DONE;
	     c = iterator.next()) {
	    sb.append(c);
	}
	return sb.toString();
    }
}
