/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "xiiimp.h"
#include "guiIMPre.h"
#include "XimpIm.h"
#include "trace_message.h"

#if 0 /* 4281121: htt_xbe dumps core in DestroyFilter() at client is exiting */
static Bool
DestroyFilter(Display *d /*unused*/,
	      Window w /* unused */,
	      XEvent *ev, XPointer client_data) {
  /* focus window is destroyed, so preedit windows, which
     are children of the focus window, has been destroyed already
   */
  XicCommon ic = (XicCommon)client_data;
  PreeditWin preedit;

  if (ic->gui_icpart) {
    preedit = (PreeditWin)ic->gui_icpart->preedit;
  } else {
    return False;
  }
  /* unselect focus win mask */
  ic->ximp_icpart->proto4_mask &= ~XIMP_FOCUS_WIN_MASK4;

  /* discard preedit win data */
  if (!preedit) return True;

  if (preedit->preedit_areas) Xfree(preedit->preedit_areas);
  preedit->preedit_areas = 0;
  preedit->alloc_areas = 0;
  preedit->active_areas = 0;
  return True;
}
#endif /* 0 */

/* ChangePreedit Methods */
static void
create(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)ic->gui_icpart->preedit;

  TRACE_MESSAGE('p', ("iiimpPrePos:create\n"));
  if (!preedit) {
    SetupPreeditExt(ic);
    preedit = (PreeditWin)ic->gui_icpart->preedit;
  }

  if (!XIMP_CHK_FOCUSWINMASK(ic)) return;

  if (preedit->parent == ic->core.focus_window &&
      preedit->preedit_areas) {
    /* same parent window */
    return;
  }

  SetupPreeditWindow(ic, ic->core.focus_window);
#if 0 /* 4281121: htt_xbe dumps core in DestroyFilter() at client is exiting */
  /* register destroy filter for focus_window */
  _XRegisterFilterByType(ic->core.im->core.display, ic->core.focus_window,
			 DestroyNotify, DestroyNotify,
			 DestroyFilter, (XPointer)ic);
#endif /* 0 */
  return;
}

#if !defined(OLD_SET_WINDOW)

static int
preedit_line_num(unsigned short * wcstr_width, int len,
		 int area_width, int first_line_x_offset) {
  int i;
  int max_line_width;
  int line_width;
  int line_width_new;
  int line_num;

  for (i = 0, line_num = 0; i < len; line_num++) {
    if (0 == line_num) {
      max_line_width = (area_width - first_line_x_offset);
    } else {
      max_line_width = area_width;
    }
    line_width = 0;
    for (; i < len; i++) {
      line_width_new = (line_width + *(wcstr_width + i));
      if (max_line_width < line_width_new) {
	if ((0 == line_width) && (area_width < line_width_new)) {
	  /* If the width of a character is wider than area_width,
	   * it consists one line.
	   */
	  i += 1;
	}
	break;
      }
      line_width = line_width_new;
    }
  }

  return line_num;
}

static int
preedit_line_num_rev(unsigned short * wcstr_width, int len, int area_width) {
  int i;
  int line_width;
  int line_width_new;
  int line_num;

  for (i = (len - 1), line_num = 0; 0 <= i; line_num++) {
    line_width = 0;
    for (; 0 <= i; --i) {
      line_width_new = (line_width + *(wcstr_width + i));
      if (area_width < line_width_new) {
	if (0 == line_width) {
	  /* If the width of a character is wider than area_width,
	   * it consists one line.
	   */
	  i -= 1;
	}
	break;
      }
      line_width = line_width_new;
    }
  }

  return line_num;
}

static Bool
PreeditWindowChanged(XicCommon ic, PreeditArea preedit_area) {
    int char_offset;
    int char_len;
    int char_offset_backup;
    int char_len_backup;
    int i;
    int j;
    PreeditWin preedit;
    PreeditChars preedit_chars;
    PreeditChars preedit_chars_backup;
    wchar_t *	wc;
    wchar_t *	wc_backup;
    IMFeedbackList *fbl;
    IMFeedbackList *fbl_backup;
    IMFeedback  *fb;
    IMFeedback  *fb_backup;
    XIMFeedback *xfb;
    XIMFeedback *xfb_backup;

    preedit = ic->gui_icpart->preedit;
    preedit_chars = &(preedit->preedit_chars);
    preedit_chars_backup = &(preedit->preedit_chars_backup);

    if (((NULL == preedit_chars->feedback) &&
	 (NULL != preedit_chars_backup->feedback)) ||
	((NULL != preedit_chars->feedback) &&
	 (NULL == preedit_chars_backup->feedback))) {
      return True;
    }

    char_offset = preedit_area->char_offset;
    char_len = preedit_area->char_len;

    char_offset_backup = preedit_area->char_offset_backup;
    char_len_backup = preedit_area->char_len_backup;

    wc = (preedit_chars->wchar + char_offset);
    wc_backup = (preedit_chars_backup->wchar + char_offset_backup);

    fbl = (preedit_chars->feedback_list + char_offset);
    fbl_backup = (preedit_chars_backup->feedback_list + char_offset_backup);

    xfb = (preedit_chars->feedback + char_offset);
    xfb_backup = (preedit_chars_backup->feedback + char_offset_backup);

    for (i = 0; i < preedit_area->char_len; i++) {
      if (*(wc + i) != *(wc_backup + i)) {
	return True;
      }

      if (*(xfb + i) != *(xfb_backup + i)) {
	return True;
      }

      if (fbl->count_feedbacks != fbl_backup->count_feedbacks) {
	return True;
      }

      fb = fbl->feedbacks;
      fb_backup = fbl_backup->feedbacks;

      for (j = 0; j < fbl->count_feedbacks; j++) {
	if (((fb + j)->type != (fb_backup + j)->type) ||
	    ((fb + j)->value != (fb_backup + j)->value)) {
	  return True;
	}
      }
    }

    return False;
}

static void
ConfigurePreeditWindow(XicCommon ic, PreeditArea preedit_area,
		       int x, int y, int width, int height) {
  XWindowChanges changes;
  int	mask;
  mask = None;

  if (preedit_area->win_config.x != x) {
    mask |= CWX;
    changes.x = x;
    preedit_area->win_config.x = x;
  }
  if (preedit_area->win_config.y != y) {
    mask |= CWY;
    changes.y = y;
    preedit_area->win_config.y = y;
  }
  if (preedit_area->win_config.height != height) {
    mask |= CWHeight;
    changes.height = height;
    if (preedit_area->win_config.height < height) {
      XIC_GUI(ic, preedit)->discard_expose_event = True;
    }
    preedit_area->win_config.height = height;
  }
  if (preedit_area->win_config.width != width) {
    mask |= CWWidth;
    changes.width = width;
    if (preedit_area->win_config.width < width) {
      XIC_GUI(ic, preedit)->discard_expose_event = True;
    }
    preedit_area->win_config.width = width;
  }
  if (None != mask) {
    XConfigureWindow(ic->core.im->core.display, preedit_area->window,
		     mask, &changes);
    preedit_area->configured = True;
  } else if (True == PreeditWindowChanged(ic, preedit_area)) {
    /* force UpdatePreedit() to update preedit */
    preedit_area->configured = True;
  }

  return;
}

static int
set_window_forward(XicCommon ic, int len,
		   int area_width, int area_x, int first_line_x_offset,
		   int spot_loc_x, int spot_loc_y,
		   int line_spacing) {
  PreeditWin preedit;
  PreeditArea preedit_area;
  PreeditChars preedit_chars;
  unsigned short * wcstr_width;
  int i;
  int max_line_width;
  int line_width;
  int line_width_new;
  int line_height;
  int line_num;
  XFontSetExtents *fse;
  int font_logical_height;
  int char_offset;
  int x;
  int y;

  preedit = ic->gui_icpart->preedit;
  preedit_area = preedit->preedit_areas;
  preedit_chars = &(preedit->preedit_chars);
  wcstr_width = preedit_chars->wchar_width;
  fse = preedit->fse;
  font_logical_height = (-fse->max_ink_extent.y);
  line_height = (fse->max_logical_extent.height + 1);

  for (i = 0, line_num = 0; i < len; line_num++) {
    char_offset = i;

    if (0 == line_num) {
      max_line_width = (area_width - first_line_x_offset);
      x = spot_loc_x;
    } else {
      max_line_width = area_width;
      x = area_x;
    }
    y = spot_loc_y - font_logical_height + (line_spacing * line_num);

    line_width = 0;
    for (; i < len; i++) {
      line_width_new = (line_width + *(wcstr_width + i));
      if (max_line_width < line_width_new) {
	if ((0 == line_width) && (area_width < line_width_new)) {
	  /* If the width of a character is wider than area_width,
	   * it consists one line.
	   */
	  i += 1;
	  line_width = max_line_width;
	}
	break;
      }
      line_width = line_width_new;
    }

    if (preedit->alloc_areas <= line_num) {
      if (False == NewPreeditWindow(ic)) return line_num;
      preedit_area = preedit->preedit_areas;
    }

    preedit_area[line_num].x = 0;
    preedit_area[line_num].y = font_logical_height;
    preedit_area[line_num].char_offset_backup =
	    preedit_area[line_num].char_offset;
    preedit_area[line_num].char_len_backup = preedit_area[line_num].char_len;
    preedit_area[line_num].char_offset = char_offset;
    preedit_area[line_num].char_len = (i - char_offset);

    if ((0 == line_width) || (0 == line_height)) {
      UnmapPreeditWindow(ic, preedit_area + line_num);
    } else {
      ConfigurePreeditWindow(ic, preedit_area + line_num,
			     x, y, line_width, line_height);
    }
  }

  return line_num;
}

static int
set_window_backward(XicCommon ic, int len,
		    int area_width, int area_height, int area_x, int area_y,
		    int spot_loc_y, int line_spacing, int line_num) {
  PreeditWin preedit;
  PreeditArea preedit_area;
  PreeditChars preedit_chars;
  unsigned short * wcstr_width;
  int i;
  int line_width;
  int line_width_new;
  int line_height;
  int area_height_low;
  XFontSetExtents *fse;
  int font_logical_height;
  int char_tail;
  int x;
  int y;
  int num;

  preedit = ic->gui_icpart->preedit;
  preedit_chars = &(preedit->preedit_chars);
  wcstr_width = preedit_chars->wchar_width;
  fse = preedit->fse;
  font_logical_height = (-fse->max_ink_extent.y);
  line_height = (fse->max_logical_extent.height + 1);

  x = area_x;

  while (preedit->alloc_areas <= line_num) {
    if (False == NewPreeditWindow(ic)) return 0;
  }
  preedit_area = preedit->preedit_areas;

  area_height_low = ((area_height + area_y) -
		     (spot_loc_y - (-fse->max_logical_extent.y)));
  area_height_low = (line_spacing * (area_height_low / line_spacing));
  y = (spot_loc_y + area_height_low - font_logical_height);

  for (i = (len - 1), num = (line_num - 1); (0 <= i) && (0 <= num); --num) {
    char_tail = i;

    y -= line_spacing;

    line_width = 0;
    for (; 0 <= i; --i) {
      line_width_new = (line_width + *(wcstr_width + i));
      if (area_width < line_width_new) {
	if (0 == line_width) {
	  /* If the width of a character is wider than area_width,
	   * it consists one line.
	   */
	  i -= 1;
	  line_width = area_width;
	}
	break;
      }
      line_width = line_width_new;
    }

    x = (area_x + area_width - line_width);

    preedit_area[num].x = 0;
    preedit_area[num].y = font_logical_height;
    preedit_area[num].char_offset_backup = preedit_area[num].char_offset;
    preedit_area[num].char_len_backup = preedit_area[num].char_len;
    preedit_area[num].char_offset = (i + 1);
    preedit_area[num].char_len = (char_tail - i);

    if ((0 == line_width) || (0 == line_height)) {
      UnmapPreeditWindow(ic, preedit_area + num);
    } else {
      ConfigurePreeditWindow(ic, preedit_area + num,
			     x, y, line_width, line_height);
    }
  }

  return line_num;
}

static int
set_window_full(XicCommon ic, int len,
		int area_width, int area_x,
		int spot_loc_x, int spot_loc_y,
		int line_spacing) {
  int line_num;

  spot_loc_y = (spot_loc_y - (line_spacing * (spot_loc_y / line_spacing)));

  line_num = set_window_forward(ic, len, area_width, area_x, area_x,
				area_x, spot_loc_y, line_spacing);

  return line_num;
}

static void
set_window(XicCommon ic, XPointer call_data) {
  PreeditWin preedit;
  PreeditArea preedit_area;
  PreeditChars preedit_chars;
  XPoint * spot_location;
  XRectangle * preedit_attr_area;
  XFontSetExtents *fse;
  int line_spacing;
  int font_logical_height;
  int x, y, height = 0;
  int area_width;
  int area_height;
  int first_line_x_offset;
  int len;
  wchar_t *wcstr;
  unsigned short *wcstr_width;
  int line_num;

  if (!XIMP_CHK_FOCUSWINMASK(ic)) return;

  preedit = (PreeditWin)ic->gui_icpart->preedit;

  if (NULL == preedit) {
    create(ic, NULL);
    preedit = (PreeditWin)ic->gui_icpart->preedit;
    if (NULL == preedit) return;
  }

  preedit_area = preedit->preedit_areas;
  preedit_chars = &(preedit->preedit_chars);

  if (preedit_chars->wchar_len == 0) return;

  if (NULL == preedit->fontset) {
    SetPreeditFont(ic, NULL);
    if (NULL == preedit->fontset) return;
  }

  spot_location = &(ic->core.preedit_attr.spot_location);
  preedit_attr_area = &(ic->core.preedit_attr.area);

  height = 0;

  fse = preedit->fse;
  font_logical_height = fse->max_logical_extent.height;
  height = font_logical_height;
  height += (fse->max_ink_extent.height + fse->max_ink_extent.y);

  if (spot_location->x > preedit_attr_area->x) {
    x = spot_location->x;
  } else {
    x = preedit_attr_area->x;
  }
  y = (spot_location->y - font_logical_height);

  /* calculate area width */
  if (XIMP_CHK_PREAREAMASK(ic)) {
    area_width = preedit_attr_area->width;
    area_height = preedit_attr_area->height;
    first_line_x_offset = (spot_location->x - preedit_attr_area->x);

  } else {
    area_width = XIC_GUI(ic, preedit)->client_window_width;
    area_height = XIC_GUI(ic, preedit)->client_window_height;
    first_line_x_offset = spot_location->x;
  }

  TRACE_MESSAGE('p', ("set_window: width=%d height=%d\n",
		area_width, area_height));

  if (XIMP_CHK_PRELINESPMASK(ic)) {
    line_spacing = ic->core.preedit_attr.line_spacing;
    if (line_spacing > area_height)
      /* line_spacing is too large */
      line_spacing = font_logical_height;
  } else {
    line_spacing = font_logical_height;
  }

  len = preedit_chars->wchar_len;
  wcstr = preedit_chars->wchar;
  wcstr_width = preedit_chars->wchar_width;

  line_num = preedit_line_num(wcstr_width, preedit_chars->wchar_len,
			      area_width, first_line_x_offset);

  if ((line_spacing * line_num) <=
      ((area_height + preedit_attr_area->y) -
       (spot_location->y - font_logical_height))) {
    set_window_forward(ic, len, area_width, preedit_attr_area->x,
		       first_line_x_offset, 
		       spot_location->x, spot_location->y, line_spacing);
  } else {
    line_num = preedit_line_num_rev(wcstr_width, len, area_width);
    if ((line_spacing * line_num) <= area_height) {
      set_window_backward(ic, len, area_width, area_height,
			  preedit_attr_area->x, preedit_attr_area->y,
			  spot_location->y, line_spacing, line_num);
    } else {
      set_window_full(ic, len, area_width,
		      preedit_attr_area->x,
		      spot_location->x, spot_location->y, line_spacing);
    }
  }
  preedit->active_areas = line_num;

  return;
}
#else /* OLD_SET_WINDOW */

static void
set_window(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)ic->gui_icpart->preedit;
  PreeditArea preedit_area;
  PreeditChars preedit_chars;

  /* This is necessary to avoid erasing botom parts of preedit lines */
  int bottom_margin;

  if (!preedit) {
    create(ic, NULL);
    preedit = (PreeditWin)ic->gui_icpart->preedit;
    if (!preedit) return;
  }
  preedit_area = (PreeditArea)(preedit->preedit_areas);

  if (!XIMP_CHK_FOCUSWINMASK(ic)) return;

  preedit_chars = (PreeditChars)&(preedit->preedit_chars);
  if (preedit_chars->wchar_len == 0) return;

  if (!preedit->fontset) {
    SetPreeditFont(ic, NULL);
  }
  /* Nothing to do until fontset is ready */
  if (preedit->fontset) {
    XFontSetExtents *fse;
    CacheRec *preedit_cache = (CacheRec*)&(preedit->preedit_cache);
    int x, y, width = 0, height = 0;
    int wrap_width, wrap_xmargin;

    width = XwcTextEscapement(preedit->fontset,
			      preedit_chars->wchar,
			      preedit_chars->wchar_len);

#if 0
    fse = XExtentsOfFontSet(preedit->fontset);
#else /* !0 */
    fse = preedit->fse;
#endif /* !0 */
    height = fse->max_logical_extent.height;
    height += (fse->max_ink_extent.height + fse->max_ink_extent.y);

    if (ic->core.preedit_attr.spot_location.x >
	ic->core.preedit_attr.area.x) {
      x = ic->core.preedit_attr.spot_location.x;
    } else {
      x = ic->core.preedit_attr.area.x;
    }
    y = ic->core.preedit_attr.spot_location.y;
    y -= fse->max_logical_extent.height;

    TRACE_MESSAGE('p', ("set_window: width=%d height=%d\n", width, height));

    bottom_margin = fse->max_logical_extent.height/4;

    /* calculate wrap width */
    if (XIMP_CHK_PREAREAMASK(ic)) {
      wrap_width = ic->core.preedit_attr.area.width;
    } else {
      wrap_width = XIC_GUI(ic, preedit)->client_window_width;
#if 0
      XWindowAttributes fwin_attr;
      XGetWindowAttributes(ic->core.im->core.display,
			   ic->core.focus_window,
			   &fwin_attr);
      wrap_width = fwin_attr.width;
#endif /* 0 */
    }

    wrap_xmargin = wrap_width > fse->max_logical_extent.width ?
		      	(fse->max_logical_extent.width)/4 : 1;

    if (x + width + wrap_xmargin <= wrap_width) {
      /* can draw all chars in one window */
      preedit->active_areas = 1;
      preedit_area[0].x = 0;
      preedit_area[0].y = fse->max_logical_extent.height - bottom_margin;
      preedit_area[0].char_offset = 0;
      preedit_area[0].char_len = preedit_chars->wchar_len;

      if (preedit_cache->win_x == x &&
	  preedit_cache->win_y == y &&
	  preedit_cache->win_width == width &&
	  preedit_cache->win_height == height) {
	return;
      }
      if (width == 0 || height == 0) {
	UnmapPreeditWindow(ic, preedit_area + 0);
      } else {
#if 0
	XMoveResizeWindow(ic->core.im->core.display,
			  preedit_area[0].window,
			  x, y + bottom_margin, width, height);
#endif /* 0 */
	XWindowChanges changes;
	int	mask;
	mask = None;
	if (preedit_cache->win_x != x) {
		mask |= CWX;
		changes.x = x;
	}
	if (preedit_cache->win_y != y) {
		mask |= CWY;
		changes.y = (y + bottom_margin);
	}
	if (preedit_cache->win_height != height) {
		mask |= CWHeight;
		changes.height = height;
		if (preedit_area[0].win_config.height < height) {
		  XIC_GUI(ic, preedit)->discard_expose_event = True;
		}
	}
	if (preedit_cache->win_width != width) {
		mask |= CWWidth;
		changes.width = width;
		if (preedit_area[0].win_config.width < width) {
		  XIC_GUI(ic, preedit)->discard_expose_event = True;
		}
	}
	if (None != mask) {
	  XConfigureWindow(ic->core.im->core.display, preedit_area[0].window,
			   mask, &changes);
	  preedit_area[0].configured = True;
	}
	preedit_area[0].win_config.x = x;
	preedit_area[0].win_config.y = y;
	preedit_area[0].win_config.height = height;
	preedit_area[0].win_config.width = width;
      }
      /* data cache */
      preedit_cache->win_x = x;
      preedit_cache->win_y = y;
      preedit_cache->win_width = width;
      preedit_cache->win_height = height;
    } else {
      /* draw more than two windows */
      int left;
      wchar_t *wcstr;
      int n;

      /* initial values */
      left = preedit_chars->wchar_len;
      wcstr = preedit_chars->wchar;
      n = 0;
      while (left) {
	wchar_t *p = wcstr;
	int cur_width = 0, prev_width;
	int i;
	if (n == 0) {
	  if (ic->core.preedit_attr.spot_location.x >
	      ic->core.preedit_attr.area.x) {
	    x = ic->core.preedit_attr.spot_location.x;
	  } else {
	    x = ic->core.preedit_attr.area.x;
	  }
	} else {
	  x = ic->core.preedit_attr.area.x + wrap_xmargin;
	}
	prev_width = XwcTextEscapement(preedit->fontset,
				       wcstr, 1);
	for (i = 1; i <= left; i++) {
	  cur_width += XwcTextEscapement(preedit->fontset, p++, 1);
	  if (x + cur_width + wrap_xmargin > wrap_width) break;
	  prev_width = cur_width;
	}
	if (!XIMP_CHK_PRELINESPMASK(ic))
	  ic->core.preedit_attr.line_spacing = fse->max_logical_extent.height;
	y = ic->core.preedit_attr.spot_location.y - 
	  fse->max_logical_extent.height +
	  ic->core.preedit_attr.line_spacing * n;

	TRACE_MESSAGE('p', ("set_window: prev_width=%d height=%d\n",
			    prev_width, height));

	preedit_area[n].x = 0;
	preedit_area[n].y = fse->max_logical_extent.height - bottom_margin;
	preedit_area[n].char_offset = wcstr - preedit_chars->wchar;
	preedit_area[n].char_len = i - 1;
	if (prev_width == 0 || height == 0) {
	  UnmapPreeditWindow(ic, preedit_area + n);
	} else {
#if 0
	  XMoveResizeWindow(ic->core.im->core.display,
			    preedit_area[n].window,
			    x, y + bottom_margin, prev_width, height);
#endif /* 0 */
	  XWindowChanges changes;
	  int	mask;
	  mask = None;
	  if (preedit_area[n].win_config.x != x) {
	    mask |= CWX;
	    changes.x = x;
	  }
	  if (preedit_area[n].win_config.y != y) {
	    mask |= CWY;
	    changes.y = (y + bottom_margin);
	  }
	  if (preedit_area[n].win_config.height != height) {
	    mask |= CWHeight;
	    changes.height = height;
	    if (preedit_area[n].win_config.height < height) {
	      XIC_GUI(ic, preedit)->discard_expose_event = True;
	    }
	  }
	  if (preedit_area[n].win_config.width != prev_width) {
	    mask |= CWWidth;
	    changes.width = prev_width;
	    if (preedit_area[n].win_config.width < prev_width) {
	      XIC_GUI(ic, preedit)->discard_expose_event = True;
	    }
	  }
	  if (None != mask) {
	    XConfigureWindow(ic->core.im->core.display, preedit_area[n].window,
			     mask, &changes);
	    preedit_area[n].configured = True;
	  }
	  preedit_area[n].win_config.x = x;
	  preedit_area[n].win_config.y = y;
	  preedit_area[n].win_config.height = height;
	  preedit_area[n].win_config.width = prev_width;
	}
	n++;
	left -= (i - 1);
	wcstr += i - 1;
	/* need to create a new preedit window */
	if (left > 0) {
	  if (n == preedit->alloc_areas) {
	    if (!NewPreeditWindow(ic)) return;
	    preedit_area = preedit->preedit_areas;
	  } else {
	    continue;
	  }
	}
      }	/* end of while loop */
      preedit->active_areas = n;

      /* clear cache */
      preedit_cache->win_x = -1;
      preedit_cache->win_y = -1;
      preedit_cache->win_width = -1;
      preedit_cache->win_height = -1;
    }
  }
  return;
}
#endif /* OLD_SET_WINDOW */

static void
move(XicCommon ic, XPointer call_data) {
  set_window(ic, NULL);
  if (NULL != XIC_GUI(ic, preedit)) {
    XIC_GUI(ic, preedit)->discard_expose_event = False;
  }
  return;
}

static PreeditCB preedit_pos_methods[] = {
  create,			/* PREEDIT_CREATE */
  set_window,			/* PREEDIT_WIN */
  SetPreeditForeground,		/* PREEDIT_FG */
  SetPreeditBackground,		/* PREEDIT_BG */
  SetPreeditFont,		/* PREEDIT_FONT */
  move,				/* PREEDIT_MOVE */
  PreeditStart,			/* PREEDIT_START */
  PreeditDrawText,		/* PREEDIT_DRAW */
  PreeditCaret,			/* PREEDIT_CARET */
  PreeditDone,			/* PREEDIT_DONE */
  DestroyPreedit		/* PREEDIT_DESTROY */
};

void
ChangePreeditPosition(XIC xic, PreeditAttr reason, XPointer call_data) {
  XicCommon ic = (XicCommon)xic;
  if (reason > PREEDIT_DESTROY) return;
  preedit_pos_methods[reason](ic, call_data);
  return;
}
