/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/*
 * Copyright (c) 1996-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 *
 * @(#)LookupAux.h	1.1 01/08/14
 *
 */

#ifndef _LOOKUPAUX_H_
#define _LOOKUPAUX_H_

#include "encode.h"

#define SINGLEBYTE	1
#define DOUBLEBYTES	1 << 1
#define FOURBYTES	1 << 2

#define UNICODE	6

#define CHARSET_PAGE 0
#define SYMBOLS_PAGE 1

#define DOUBLE_CLICK_TIME 500

#define START_X     5
#define START_Y     5
#define CHAR_SPACE  0

#define DEFAULTFONT	"-sun-song-medium-r-normal--16-140-75-75-c-70-iso8859-1, \
			 -sun-song-medium-r-normal--16-140-75-75-c-140-gbk-0, \
			 -sun-song-medium-r-*--16-140-75-75-c-70-sunudczh.gbk.1997-0"

#define GB2312FONT	"-*-*-medium-r-normal--16-*-*-*-c-*-iso8859-1, \
			 -*-*-medium-r-normal--16-*-*-*-c-*-gb2312.1980-0, \
			 -*-*-medium-r-normal--16-*-*-*-c-*-sunudczh.1997-0"

#define GBKFONT		"-*-*-medium-r-normal--16-*-*-*-c-*-sunudczh.gbk.1997-0, \
			 -*-*-medium-r-normal--16-*-*-*-c-*-iso8859-1, \
			 -*-*-medium-r-normal--16-*-*-*-c-*-gbk-0"

#define GB18030FONT	"-*-*-medium-r-normal--16-*-*-*-c-*-iso8859-1, \
			 -*-*-medium-r-normal--16-*-*-*-c-*-gb18030.2000-0, \
			 -*-*-medium-r-normal--16-*-*-*-c-*-gb18030.2000-1"

#define TWEUCFONT	"-*-*-*-r-normal--16-*-*-*-c-*-cns11643-0, \
			 -*-*-*-r-normal--16-*-*-*-c-*-iso8859-1, \
			 -*-*-*-r-normal--16-*-*-*-c-*-cns11643-1, \
			 -*-*-*-r-normal--16-*-*-*-c-*-cns11643-2, \
			 -*-*-*-r-normal--16-*-*-*-c-*-cns11643-3"

#define BIG5FONT	"-*-*-medium-r-normal--16-*-*-*-*-big5-0,\
			 -*-*-medium-r-normal--16-*-*-*-*-iso8859-1, \
			 -*-*-medium-r-normal--16-*-*-*-*-big5-1"

#define BIG5HKFONT	"-*-*-medium-r-normal--16-*-*-*-*-big5-0,\
			 -*-*-medium-r-normal--16-*-*-*-*-iso8859-1, \
			 -*-*-medium-r-normal--16-*-*-*-*-big5-1, \
			 -*-*-*-r-normal--16-*-*-*-*-hkscs-1"
	
typedef struct _SubSet {
	char	name[16];
	unsigned int	range[10];
}SubSet;

typedef struct _CharSet {
	char*		CharSetID;
	unsigned char	ByteNum;
	char		IsEUC;
	char		Include8090;
	char		LinePerArea;    /* Characters per area / 16 */
	char		* fontname;

	/* single byte */
	unsigned char	SingleByteBegin;
	unsigned char	SingleByteEnd;

	/* double bytes */ 
	unsigned char	HighByteBegin;
	unsigned char	HighByteEnd;
	unsigned char	LowByteBegin;
	unsigned char	LowByteEnd;
	
	/* four bytes */
	unsigned char	FirstByteBegin;
	unsigned char	FirstByteEnd;
	unsigned char	SecondByteBegin;
	unsigned char	SecondByteEnd;
	unsigned char	ThirdByteBegin;
	unsigned char	ThirdByteEnd;
	unsigned char	ForthByteBegin;
	unsigned char	ForthByteEnd;
	SubSet		*subsets;
	unsigned char	SubsetNum;
	unsigned char	selectedsubset;
} CharSet;

static SubSet gb2312_subsets[1] = {
	{"All", 0x20, 0x7F, 0xA1A1, 0xF7FE}
	};

static SubSet gbk_subsets[1] = {
	{"All", 0x20, 0x7F, 0x8140, 0xFEFE}
	};

static SubSet gb18030_subsets[] = {
	{"All", 0x20, 0x7F, 0x8140, 0xFEFE, 0x81308130, 0x8439FE39},
	{"GB2312", 0xB0A1, 0xF7FE},
	{"GBK", 0x8140, 0xA0FE, 0xAA40, 0xFEA0},
 	{"GB18030", 0x8139EE30, 0x82358739},
	{"Symbols", 0xA1A1, 0xA9FE, 0xA840, 0xA940},
	{"Mongonlian", 0x8134D230, 0x8134E339},
	{"Tibetan", 0x8132E830, 0x8132FD39},
	{"Yi", 0x82359830, 0x82369439},
	{"Uigur", 0x81318130, 0x81319539, 0x8430BA30, 0x8430CB39, 0x84318930, 0x84319539},
	{"UDC", 0xAAA1, 0xAFFE, 0xF8A1, 0xFEFE, 0xA140, 0xA7A0}
};

static SubSet big5_subsets[1] = {
	{"All", 0x20, 0x7F, 0xA140, 0xC6FE, 0xC940, 0xF9FE}
	};

static SubSet euctw_subsets[1] = {
	{"All", 0x20, 0x7F, 0xA1A1, 0xFEFE, 0x8EA2A1A1, 0x8EA3FEFE}
	};

static SubSet big5hk_subsets[1] = {
	{"All", 0x20, 0x7F, 0x8140, 0xFEFE}
	};

static SubSet unicode_subsets[1] = {
	{"All", 0x00, 0xFF, 0x0100, 0xFFFF}
	};

static CharSet ChineseCharSets[7] = {
	{"EUC_CN",  3, 1, 1, 6,  GB2312FONT,  0x20, 0x7F, 0xA1, 0xF7, 0xA1, 0xFE, 
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, gb2312_subsets, 1, 0},
	{"GBK",     3, 0, 1, 12, GBKFONT,     0x20, 0x7F, 0x81, 0xFE, 0x40, 0xFE, 
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, gbk_subsets, 1, 0},
	{"GB18030", 7, 0, 1, 12, GB18030FONT, 0x20, 0x7F, 0x81, 0xFE, 0x40, 0xFE, 
		0x81, 0x84, 0x30, 0x39, 0x81, 0xFE, 0x30, 0x39, gb18030_subsets, 10, 0 },
	{"BIG5",    3, 0, 0, 10, BIG5FONT, 0x20, 0x7F, 0xA1, 0xF9, 0x40, 0xFE, 
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, big5_subsets, 1, 0},
	{"EUC_TW",  7, 1, 1, 6,  TWEUCFONT, 0x20, 0x7F, 0xA1, 0xFE, 0xA1, 0xFE, 
		0x8E, 0x8E, 0xA2, 0xA3, 0xA1, 0xFE, 0xA1, 0xFE, euctw_subsets, 1, 0},
	{"BIG5HK",  3, 0, 0, 10, BIG5HKFONT, 0x20, 0x7F, 0x81, 0xFE, 0x40, 0xFE, 
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, big5hk_subsets, 1, 0},
	{"UNICODE",  3, 0, 1, 16, DEFAULTFONT, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, unicode_subsets, 1, 0}
};

#define CS ChineseCharSets[CurrentLocale] 

/* structure defination for symbols */

#define MAX_SYMBOLS	100
#define MAX_GROUPS	24

typedef struct _SymbolGroup {
	unsigned char label[32];
	int number;
	unsigned char symbols[MAX_SYMBOLS][5];
} SymbolGroup;

SymbolGroup SymbolGroups[MAX_GROUPS];

#define LABEL_STR               "LABEL"
#define TYPE_STR                "TYPE"
#define ENCODE_STR              "ENCODE"
#define STRING_TYPE_STR         "COMMIT_AS_STRING"
#define KEY_TYPE_STR            "COMMIT_AS_KEY"
#define LIST_BEGIN_STR          "LIST_BEGIN"
#define LIST_END_STR            "LIST_END"

#define MAX_LINE_LEN        512
#define DEFAULT_SYMBOLS_CONFIG_FILE   "symbols.cfg"
#define DEFAULT_SYMBOLS_FILE   "common/symbols_common.txt"

/* messages */

typedef struct _Message {
	char *id;
	char *sch;
	char *tch;
} Message;

static Message msg[] = {
	{"Quit",    "关闭", "關閉"},
	{"About",   "关于", "關于"},
	{"Character Table", "字符查找表", "字符查找表"},
	{"Symbol Table", "常用符号表", "常用符號表"},
	{"Char Set", "字符集", "字符集"},
	{"Page Up", "上页", "上頁"},
	{"Page Down", "下页", "下頁"},
	{"Selected:", "选定:", "選定:"},
	{"Confirm", "     确  定     ", "     確  定     "},
	{"Start", "起始:", "起始:"},
	{"End", "结束:", "結束:"},
	{"OK", "确定", "確定"},
	{"Symbol Group", "常用符号", "常用符號"},
	{"All", "全集", "全集"},
	{"GB2312", "GB2312汉字", "GB2312汉字"},
	{"GBK", "GBK汉字", "GBK汉字"},
	{"GB18030", "GB18030汉字", "GB18030汉字"},
	{"Symbols", "符号", "符号"},
	{"Mongonlian", "蒙文", "蒙文"},
	{"Tibetan", "藏文", "藏文"},
	{"Yi", "彝文", "彝文"},
	{"Uigur", "维吾尔文", "维吾尔文"},
	{"UDC", "用户自定义字", "用户自定义字"}
	};
	
typedef struct tag_lookupauxdata
{
        Widget          wdtShell;

	int		x;
	int		y;
	int 		nLookupID;

} LookupAuxData;

#endif /* _LOOKUPAUX_H_ */
