/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/MwmUtil.h>
#include <locale.h>

#include "OptionAux.h"
#include "OptionConfig.h"

OptionAuxData 	gOptData;
int		gLocaleID;
Display		*gDisplay;
 		
void OptionAux_Hide();
void OptionAux_InitObjects();
void OptionAux_DestroyProc(Widget widget, XtPointer pClientData, XtPointer pCallData);
void OptionAux_OK_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void OptionAux_Apply_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void OptionAux_Reset_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void OptionAux_Cancel_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);

void OptionAux_Update_Status(int nInputMode_ID, int nKeyboard_ID);
void OptionAux_OptionValue_Changed_cb(Widget w, XtPointer client_data, XtPointer call_data);

int main(int argc, char **argv)
{
	XtAppContext    app;

	Widget shell, form, hint_label, separator, rowcol;
	Widget ok_button, apply_button, reset_button, cancel_button;
	XmString xmstr;
	Atom xa_ct;
	int nXPos, nYPos, nWidth, nHeight;
	int nFormWidth, nFormHeight;
	int nButtonWidth, nYLabelWidget;
	int i, nYDelta, nSpacing;

	/* creates all of the widgets in the dialog box. */
	Arg arrArg[24];
	int nArg;

	char *msg, *lpszTitle;
	char *locale_name = NULL;

	nFormWidth = 500;
	nFormHeight = 220;
	nButtonWidth = 20;
	nYDelta = 10;
	nSpacing = 8;
	nYLabelWidget = 13;

	XtSetLanguageProc((XtAppContext)0, (XtLanguageProc)0, (XtPointer)0) ;

	/* create but do NOT manage the container dialog. */
	nArg = 0;
	XtSetArg(arrArg[nArg], XmNx, 620); nArg++;
	XtSetArg(arrArg[nArg], XmNy, 420); nArg++;
	XtSetArg(arrArg[nArg], XmNinput, FALSE); nArg++;
	XtSetArg(arrArg[nArg], XmNdefaultPosition, FALSE); nArg++;
	XtSetArg(arrArg[nArg], XmNheight, nFormHeight); nArg++;
	XtSetArg(arrArg[nArg], XmNwidth, nFormWidth); nArg++;
	XtSetArg(arrArg[nArg], XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE); nArg++;
	shell = XtAppInitialize(&app, "OptionAux", NULL, 0, &argc, argv, NULL, arrArg, nArg);

	locale_name = setlocale(LC_CTYPE, NULL);
	if (locale_name == NULL) return;
	locale_name = (char *) strdup(locale_name);
	gLocaleID = get_encodeid_from_locale(locale_name);
	Msg_Init(locale_name);
	free(locale_name);

	XtAddCallback(shell, XmNdestroyCallback, OptionAux_DestroyProc, NULL);
	gOptData.wdtShell = shell;
	gDisplay = XtDisplay(shell);

	/* Set the window title */
	msg = (char *)get_msg_by_msgid(0, "Thai Options Setting");
	xa_ct = XmInternAtom(XtDisplay(shell), "COMPOUND_TEXT", FALSE);
	xmstr = XmStringCreateLocalized(msg);
	lpszTitle = XmCvtXmStringToCT(xmstr);
	XtVaSetValues(shell, XmNtitle, lpszTitle, XmNtitleEncoding, xa_ct, NULL);
	XmStringFree(xmstr);
	free(msg);

	form = XtVaCreateManagedWidget("Form", xmFormWidgetClass, shell,
		NULL);

	nXPos = 6;
	nYPos = nYLabelWidget;

	rowcol = XtVaCreateManagedWidget ("rowcol",
		xmRowColumnWidgetClass, form,
		XmNorientation, XmHORIZONTAL,
		XmNpacking, XmPACK_TIGHT,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		NULL);

	msg = (char *)get_msg_by_msgid(1, "Thai Input Sequence Check Mode:");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	hint_label = XtVaCreateManagedWidget ("label", 
		xmLabelGadgetClass,  rowcol, 
		XmNlabelString, xmstr,
		NULL);
	XmStringFree(xmstr);

	gOptData.wdtInputModeMenu = (Widget)XmCreateOptionMenu (rowcol, "_input_mode_menu", NULL, 0);
	XtManageChild (gOptData.wdtInputModeMenu);

	nYPos += 24;

	rowcol = XtVaCreateManagedWidget ("rowcol",
		xmRowColumnWidgetClass, form,
		XmNorientation, XmHORIZONTAL,
		XmNpacking, XmPACK_TIGHT,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		NULL);

	msg = (char *)get_msg_by_msgid(2, "Thai Keyboard Layout Mode:     ");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	hint_label = XtVaCreateManagedWidget ("label", 
		xmLabelGadgetClass,  rowcol, 
		XmNlabelString, xmstr,
		NULL);
	XmStringFree(xmstr);
		
	gOptData.wdtKeyboardMenu = (Widget)XmCreateOptionMenu (rowcol, "_keyboard_menu", NULL, 0);
	XtManageChild (gOptData.wdtKeyboardMenu);

	/* Create separator line */
	nYPos += 30;
	separator = XtVaCreateManagedWidget ("separator",
		xmSeparatorGadgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		NULL);
	
	/* Create 4 Buttons: OK/Apply/Reset/Cancel */
	nXPos = (100 - 2 * nSpacing - 3 * nButtonWidth) / 2;
	nYPos += nYDelta;
	msg = (char *)get_msg_by_msgid(3, "OK");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	ok_button = XtVaCreateWidget ("OK",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(ok_button);
	XtAddCallback(ok_button, XmNactivateCallback, OptionAux_OK_cb, 0);
	XmStringFree(xmstr);

	nXPos += nSpacing + nButtonWidth;
	msg = (char *)get_msg_by_msgid(4, "Apply");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	apply_button = XtVaCreateWidget ("rowcol",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(apply_button);
	XtAddCallback(apply_button, XmNactivateCallback, OptionAux_Apply_cb, 0);
	XmStringFree(xmstr);

	nXPos += nSpacing + nButtonWidth;
	msg = (char *)get_msg_by_msgid(5, "Cancel");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	cancel_button = XtVaCreateWidget ("Cancel",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(cancel_button);
	XtAddCallback(cancel_button, XmNactivateCallback, OptionAux_Cancel_cb, 0);
	XmStringFree(xmstr);

	XtSetMappedWhenManaged(shell, FALSE);
	XtRealizeWidget(shell);

	/* Make dtsession do not save the geometry information */
	XSetCommand(XtDisplay(shell), XtWindow(shell), NULL, 0);

	OptionAux_InitObjects();

	/* Register aux class */
	if (xaux_ext_register_classes(shell) == -1) {
		return(-1);
	}

	XtAppMainLoop(app);
}
	
void OptionAux_InitObjects()
{
	gOptData.nInputMode_Num = 0;
	gOptData.ppArrInputModeNames = NULL;

	gOptData.nKeyboard_Num = 0;
	gOptData.ppArrKeyboardNames = NULL;

	gOptData.nInputMode_ID = 0;
	gOptData.nKeyboard_ID = 0;
}

void OptionAux_FreeObjects()
{
	int i;

	if (gOptData.ppArrInputModeNames != NULL) {
		for (i = 0; i < gOptData.nInputMode_Num; i ++) {
			if (gOptData.ppArrInputModeNames[i]) free((char *)gOptData.ppArrInputModeNames[i]);
		}
		free((char *)gOptData.ppArrInputModeNames);
	}

	if (gOptData.ppArrKeyboardNames != NULL) {
		for (i = 0; i < gOptData.nKeyboard_Num; i ++) {
			if (gOptData.ppArrKeyboardNames[i]) free((char *)gOptData.ppArrKeyboardNames[i]);
		}
		free((char *)gOptData.ppArrKeyboardNames);
	}

	Msg_Done();
}

void OptionAux_DestroyProc(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	OptionAux_FreeObjects();
}

int OptionAux_SetMenuItems(Widget wdtMenu, char **menu_items, int num_menu_items, int arg_id)
{
	Widget menu, widget;
	int item_id, item_value;
	int i;

	XtVaGetValues(wdtMenu, XmNuserData, &menu, NULL);
	if (menu != 0) {
		XtUnmanageChild(menu);
	}

	menu = (Widget)XmCreatePulldownMenu (wdtMenu, "_pulldown", NULL, 0);
	XtVaSetValues (menu, XmNtearOffModel, XmTEAR_OFF_ENABLED, NULL);

	for (i=0; i<num_menu_items; i++) {
		char item_str[256];

		if (item_str == NULL) {
			widget = XtCreateManagedWidget("separator", xmSeparatorGadgetClass, menu, NULL, 0);
		} else {
			snprintf(item_str, 253, " %s ", menu_items[i]);
			widget = XtVaCreateManagedWidget (item_str,
				xmPushButtonGadgetClass, menu,
				NULL);

			item_value = 0;
			item_value |= ((arg_id & 0x00ff) << 8);
			item_value |= (i & 0x00ff);
			XtAddCallback(widget, XmNactivateCallback, 
				OptionAux_OptionValue_Changed_cb, (XtPointer)item_value);
		}
	}

	XtVaSetValues (wdtMenu, XmNsubMenuId, menu, XmNuserData, menu, NULL);
}

int OptionAux_SetMenuDefaultItem(Widget wdtMenu, int nMenu_id)
{
	Widget wdtPullDownMenu;
	WidgetList arrWidget;
	int num_menu_items;

	XtVaGetValues(wdtMenu, XmNuserData, &wdtPullDownMenu, NULL);
	if (wdtPullDownMenu == 0) {
		return(0);
	}

	XtVaGetValues(wdtPullDownMenu, XmNchildren, &arrWidget, NULL);

	num_menu_items = 0;
	while(arrWidget[num_menu_items]) {
		num_menu_items++;
	}
	
	if (nMenu_id < 0 || nMenu_id >= num_menu_items)
		return(0);

	XtVaSetValues (wdtMenu, XmNmenuHistory, arrWidget[nMenu_id], NULL);
}

void OptionAux_OptionValue_Changed_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
	int arg_data = (int) client_data;

	int nMenu_id = (arg_data >> 8) & 0x00ff;
	int nMenu_value = arg_data & 0x00ff;

	if (nMenu_id == MENUTYPE_INPUTMODE) {
		gOptData.nInputMode_ID = nMenu_value;
	} else if (nMenu_id == MENUTYPE_KEYBOARD) {
		gOptData.nKeyboard_ID = nMenu_value;
	}
}

void OptionAux_ApplyAndSave_Options(int nInputMode_ID, int nKeyboard_ID)
{
	TThaiOptions tThaiOptions;

	tThaiOptions.isc_mode_id = nInputMode_ID;
	tThaiOptions.keyboard_id = nKeyboard_ID;

	Save_ThaiOptions_To_Profile(&tThaiOptions);
	PaletteAux_Set_Default_Request(nInputMode_ID, nKeyboard_ID);
}

void OptionAux_OK_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	int bShow = False;

	DEBUG_printf(" OptionAux_OK_cb ===\n");

	OptionAux_ApplyAndSave_Options(gOptData.nInputMode_ID, gOptData.nKeyboard_ID);
	OptionAux_Change_Status_Request(bShow);
}

void OptionAux_Apply_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	DEBUG_printf(" OptionAux_Apply_cb ===\n");
	OptionAux_ApplyAndSave_Options(gOptData.nInputMode_ID, gOptData.nKeyboard_ID);
}

void OptionAux_Cancel_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	int bShow = False;

	DEBUG_printf(" OptionAux_Cancel_cb ===\n");

	OptionAux_Change_Status_Request(bShow);
}

void OptionAux_Update_Status(int nInputMode_ID, int nKeyboard_ID)
{
	Display *pDisplay = XtDisplay(gOptData.wdtShell);
	Window window = XtWindow(gOptData.wdtShell);

	if (nInputMode_ID >= 0 && nInputMode_ID < gOptData.nInputMode_Num) {
		OptionAux_SetMenuDefaultItem(gOptData.wdtInputModeMenu, nInputMode_ID);
		gOptData.nInputMode_ID = nInputMode_ID;
	}

	if (nKeyboard_ID >= 0 && nKeyboard_ID < gOptData.nKeyboard_Num) {
		OptionAux_SetMenuDefaultItem(gOptData.wdtKeyboardMenu, nKeyboard_ID);
		gOptData.nKeyboard_ID = nKeyboard_ID;
	}

	XtMapWidget(gOptData.wdtShell);
	XRaiseWindow(pDisplay, window);
	XFlush(pDisplay);
}

void OptionAux_Hide()
{
	XtUnmapWidget(gOptData.wdtShell);
}

