#ifndef _LOOKUP_BUFFER_H_
#define _LOOKUP_BUFFER_H_

#include "utfchar.h"
typedef struct _LookupBufferStruct LookupBufferStruct;
typedef struct _LookupBufferPage LookupBufferPage;

struct _LookupBufferStruct {
  int n_items_per_page;
  int n_candidates;
  LookupBufferPage *page_list;
  LookupBufferPage *p_current_page;
};
struct _LookupBufferPage {
  struct _LookupBufferPage *next;
  struct _LookupBufferPage *prev;
  int n_strings;
  int i_candidate;
  UTFCHAR **string_list;
};

/* function prototypes */
LookupBufferStruct *hangul_lookupbuf_new (int n_candidates, int count_per_page, UTFCHAR **string_list);
Bool hangul_lookupbuf_free (LookupBufferStruct *lub);
LookupBufferPage * hangul_lookupbuf_get_current_page (LookupBufferStruct *lub);
int hangul_lookupbuf_get_current_selection_index (LookupBufferStruct *lub);
void
hangul_lookupbuf_get_current_page_candidates (LookupBufferStruct *lub,
					      int *n_candidates_return,
					      int *n_current_candidate,
					      UTFCHAR ***candidates_list_return);

UTFCHAR * hangul_lookupbuf_get_candidate_string (LookupBufferStruct *lub, int i);
void hangul_lookupbuf_next_page (LookupBufferStruct *lub);
void hangul_lookupbuf_previous_page (LookupBufferStruct *lub); 
int hangul_lookupbuf_get_count_of_candidates_in_current_page (LookupBufferStruct *lub);
void hangul_lookupbuf_next_candidate (LookupBufferStruct *lub);

#endif /* _LOOKUP_BUFFER_H_ */

