/*
  keymapper.cpp
  Copyright (C) 2003 Free Standards Group

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL OPENI18N WG OR FREE STANDARDS GROUP. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

  Except as contained in this notice, the names of OpenI18N WG and/or
  Free Standards Group shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from OpenI18N WG and/or Free Standards Group
  as applicable.

  Author: ILGYOUNG PARK <Karl.Park@Sun.COM>
	  TuBo <Gavin.Tu@Sun.COM>

*/
#include <qnamespace.h>
#include <iiimcf.h>

#include "keymapper.h"
#include "debug.h"


KeyMapper::KeyMapper ()
{
}

int
KeyMapper::q2i (int keycode)
{
  switch (keycode){
  case Qt::Key_Escape : /* = 0x1000, */		// misc keys
    return IIIMF_KEYCODE_ESCAPE;
  case Qt::Key_Tab : /* = 0x1001, */
    return IIIMF_KEYCODE_TAB;

  case Qt::Key_Backspace : /* = 0x1003, */
  //case Qt::Key_BackSpace : /* = case Key_Backspace, : */
    return IIIMF_KEYCODE_BACK_SPACE;
  case Qt::Key_Return : /* = 0x1004, */
  case Qt::Key_Enter : /* = 0x1005, */
    return IIIMF_KEYCODE_ENTER;
  case Qt::Key_Insert : /* = 0x1006, */
    return IIIMF_KEYCODE_INSERT;
  case Qt::Key_Delete : /* = 0x1007, */
    return IIIMF_KEYCODE_DELETE;
  case Qt::Key_Pause : /* = 0x1008, */
    return IIIMF_KEYCODE_PAUSE;
  case Qt::Key_Print : /* = 0x1009, */
    return IIIMF_KEYCODE_PRINTSCREEN;
  case Qt::Key_Clear : /* = 0x100b, */
    return IIIMF_KEYCODE_CLEAR;
  case Qt::Key_Home : /* = 0x1010, */		// cursor movement
    return IIIMF_KEYCODE_HOME;
  case Qt::Key_End : /* = 0x1011, */
    return IIIMF_KEYCODE_END;
  case Qt::Key_Left : /* = 0x1012, */
    return IIIMF_KEYCODE_LEFT;
    return IIIMF_KEYCODE_KP_LEFT;
  case Qt::Key_Up : /* = 0x1013, */
    return IIIMF_KEYCODE_UP; /* = IIIMF_KEYCODE_KP_UP */
  case Qt::Key_Right : /* = 0x1014, */
    return IIIMF_KEYCODE_RIGHT; /* = IIIMF_KEYCODE_KP_RIGHT */

  case Qt::Key_Down : /* = 0x1015, */
    return IIIMF_KEYCODE_DOWN;
    return IIIMF_KEYCODE_KP_DOWN;
  case Qt::Key_PageUp : /* = case Key_Prior, : */
    return IIIMF_KEYCODE_PAGE_UP;
  case Qt::Key_PageDown : /* = case Key_Next, : */
    return IIIMF_KEYCODE_PAGE_DOWN;
  case Qt::Key_Shift : /* = 0x1020, */		// modifiers
    return IIIMF_KEYCODE_SHIFT;
  case Qt::Key_Control : /* = 0x1021, */
    return IIIMF_KEYCODE_CONTROL;
  case Qt::Key_Meta : /* = 0x1022, */
    return IIIMF_KEYCODE_META;
  case Qt::Key_Alt : /* = 0x1023, */
    return IIIMF_KEYCODE_ALT;
  case Qt::Key_CapsLock : /* = 0x1024, */
    return IIIMF_KEYCODE_CAPS_LOCK;
  case Qt::Key_NumLock : /* = 0x1025, */
    return IIIMF_KEYCODE_NUM_LOCK;
  case Qt::Key_ScrollLock : /* = 0x1026, */
    return IIIMF_KEYCODE_SCROLL_LOCK;
    
    // function keys
  case Qt::Key_F1 : /* = 0x1030, */
    return IIIMF_KEYCODE_F1;
  case Qt::Key_F2 : /* = 0x1031, */
    return IIIMF_KEYCODE_F2;
  case Qt::Key_F3 : /* = 0x1032, */
    return IIIMF_KEYCODE_F3;
  case Qt::Key_F4 : /* = 0x1033, */
    return IIIMF_KEYCODE_F4;
  case Qt::Key_F5 : /* = 0x1034, */
    return IIIMF_KEYCODE_F5;
  case Qt::Key_F6 : /* = 0x1035, */
    return IIIMF_KEYCODE_F6;
  case Qt::Key_F7 : /* = 0x1036, */
    return IIIMF_KEYCODE_F7;
  case Qt::Key_F8 : /* = 0x1037, */
    return IIIMF_KEYCODE_F8;
  case Qt::Key_F9 : /* = 0x1038, */
    return IIIMF_KEYCODE_F9;
  case Qt::Key_F10 : /* = 0x1039, */
    return IIIMF_KEYCODE_F10;
  case Qt::Key_F11 : /* = 0x103a, */
    return IIIMF_KEYCODE_F11;
  case Qt::Key_F12 : /* = 0x103b, */
    return IIIMF_KEYCODE_F12;
  case Qt::Key_F13 : /* = 0x103c, */
        return IIIMF_KEYCODE_F13;
  case Qt::Key_F14 : /* = 0x103d, */
        return IIIMF_KEYCODE_F14;
  case Qt::Key_F15 : /* = 0x103e, */
        return IIIMF_KEYCODE_F15;
  case Qt::Key_F16 : /* = 0x103f, */
        return IIIMF_KEYCODE_F16;
  case Qt::Key_F17 : /* = 0x1040, */
    return IIIMF_KEYCODE_F17;
  case Qt::Key_F18 : /* = 0x1041, */
        return IIIMF_KEYCODE_F18;
  case Qt::Key_F19 : /* = 0x1042, */
        return IIIMF_KEYCODE_F19;
  case Qt::Key_F20 : /* = 0x1043, */
        return IIIMF_KEYCODE_F20;
  case Qt::Key_F21 : /* = 0x1044, */
        return IIIMF_KEYCODE_F21;
  case Qt::Key_F22 : /* = 0x1045, */
        return IIIMF_KEYCODE_F22;
  case Qt::Key_F23 : /* = 0x1046, */
        return IIIMF_KEYCODE_F23;
  case Qt::Key_F24 : /* = 0x1047, */
        return IIIMF_KEYCODE_F24;
	
#if 0
  case Qt::Key_F25 : /* = 0x1048, */		// F25 .. F35 only on X11
  case Qt::Key_F26 : /* = 0x1049, */
  case Qt::Key_F27 : /* = 0x104a, */
  case Qt::Key_F28 : /* = 0x104b, */
  case Qt::Key_F29 : /* = 0x104c, */
  case Qt::Key_F30 : /* = 0x104d, */
  case Qt::Key_F31 : /* = 0x104e, */
  case Qt::Key_F32 : /* = 0x104f, */
  case Qt::Key_F33 : /* = 0x1050, */
  case Qt::Key_F34 : /* = 0x1051, */
  case Qt::Key_F35 : /* = 0x1052, */
#endif

  case Qt::Key_Help : /* = 0x1058, */
    return IIIMF_KEYCODE_HELP;
    // Misc Functions
  case Qt::Key_Mode_switch :         /* = 0x117e, */  // Character set switch
    //case Key_script_switch :       /* = 0x117e, */  // Alias for mode_switch
    return IIIMF_KEYCODE_MODECHANGE;


    // Japanese keyboard support
  case Qt::Key_Kanji :               /* = 0x1121, */  // Kanji, Kanji convert
  case Qt::Key_Muhenkan :            /* = 0x1122, */  // Cancel Conversion
    //case Key_Henkan_Mode :         /* = 0x1123, */  // Start/Stop Conversion
  case Qt::Key_Henkan :              /* = 0x1123, */  // Alias for Henkan_Mode
  case Qt::Key_Romaji :              /* = 0x1124, */  // to Romaji
  case Qt::Key_Hiragana :            /* = 0x1125, */  // to Hiragana
  case Qt::Key_Katakana :            /* = 0x1126, */  // to Katakana
  case Qt::Key_Hiragana_Katakana :   /* = 0x1127, */  // Hiragana/Katakana toggle
  case Qt::Key_Zenkaku :             /* = 0x1128, */  // to Zenkaku
  case Qt::Key_Hankaku :             /* = 0x1129, */  // to Hankaku
  case Qt::Key_Zenkaku_Hankaku :     /* = 0x112a, */  // Zenkaku/Hankaku toggle
  case Qt::Key_Touroku :             /* = 0x112b, */  // Add to Dictionary
  case Qt::Key_Massyo :              /* = 0x112c, */  // Delete from Dictionary
  case Qt::Key_Kana_Lock :           /* = 0x112d, */  // Kana Lock
  case Qt::Key_Kana_Shift :          /* = 0x112e, */  // Kana Shift
  case Qt::Key_Eisu_Shift :          /* = 0x112f, */  // Alphanumeric Shift
  case Qt::Key_Eisu_toggle :         /* = 0x1130, */  // Alphanumeric toggle
    //case Key_Kanji_Bangou :        /* = 0x1137, */  // Codeinput
    //case Key_Zen_Koho :            /* = 0x113d, */  // Multiple/All Candidate(s)
    //case Key_Mae_Koho :            /* = 0x113e, */  // Previous Candidate

    // Korean support
  case Qt::Key_Hangul :              /* = 0x1131, */  // Hangul start/stop(toggle)
  case Qt::Key_Hangul_Start :        /* = 0x1132, */  // Hangul start
  case Qt::Key_Hangul_End :          /* = 0x1133, */  // Hangul end, English start
  case Qt::Key_Hangul_Hanja :        /* = 0x1134, */  // Start Hangul->Hanja Conversion
  case Qt::Key_Hangul_Jamo :         /* = 0x1135, */  // Hangul Jamo mode
  case Qt::Key_Hangul_Romaja :       /* = 0x1136, */  // Hangul Romaja mode
    //case Qt::Key_Hangul_Codeinput :    /* = 0x1137, */  // Hangul code input mode
  case Qt::Key_Hangul_Jeonja :       /* = 0x1138, */  // Jeonja mode
  case Qt::Key_Hangul_Banja :        /* = 0x1139, */  // Banja mode
  case Qt::Key_Hangul_PreHanja :     /* = 0x113a, */  // Pre Hanja conversion
  case Qt::Key_Hangul_PostHanja :    /* = 0x113b, */  // Post Hanja conversion
    //case Qt::Key_Hangul_SingleCandidate :   /* = 0x113c, */  // Single candidate
    //case Qt::Key_Hangul_MultipleCandidate : /* = 0x113d, */  // Multiple candidate
    //case Qt::Key_Hangul_PreviousCandidate : /* = 0x113e, */  // Previous candidate
  case Qt::Key_Hangul_Special :      /* = 0x113f, */  // Special symbols
    //case Key_Hangul_switch :       /* = 0x117e, */  // Alias for mode_switch
    return IIIMF_KEYCODE_HANGUL;
    //return IIIMF_KEYCODE_HANJA;
    
  case Qt::Key_Space : /* = 0x20, */		// 7 bit printable ASCII
    //case Key_Any : /* = case Key_Space, : */
    return IIIMF_KEYCODE_SPACE;

  case Qt::Key_Exclam : /* = 0x21, */
    return IIIMF_KEYCODE_EXCLAMATION_MARK;
  case Qt::Key_QuoteDbl : /* = 0x22, */
    return IIIMF_KEYCODE_QUOTEDBL;
  case Qt::Key_NumberSign : /* = 0x23, */
    return IIIMF_KEYCODE_NUMBER_SIGN;
  case Qt::Key_Dollar : /* = 0x24, */
    return IIIMF_KEYCODE_DOLLAR;
  case Qt::Key_Percent : /* = 0x25, */
  case Qt::Key_Ampersand : /* = 0x26, */
  case Qt::Key_Apostrophe : /* = 0x27, */
  case Qt::Key_ParenLeft : /* = 0x28, */
    return IIIMF_KEYCODE_LEFT_PARENTHESIS;
  case Qt::Key_ParenRight : /* = 0x29, */
    return IIIMF_KEYCODE_RIGHT_PARENTHESIS;
  case Qt::Key_Asterisk : /* = 0x2a, */
    return IIIMF_KEYCODE_ASTERISK;
  case Qt::Key_Plus : /* = 0x2b, */
    return IIIMF_KEYCODE_PLUS;
  case Qt::Key_Comma : /* = 0x2c, */
    return IIIMF_KEYCODE_COMMA;
  case Qt::Key_Minus : /* = 0x2d, */
    return IIIMF_KEYCODE_MINUS;
  case Qt::Key_Period : /* = 0x2e, */
    return IIIMF_KEYCODE_PERIOD;
  case Qt::Key_Slash : /* = 0x2f, */
    return IIIMF_KEYCODE_SLASH;
  case Qt::Key_0 : /* = 0x30, */
    return IIIMF_KEYCODE_0;
  case Qt::Key_1 : /* = 0x31, */
    return IIIMF_KEYCODE_1;
  case Qt::Key_2 : /* = 0x32, */
    return IIIMF_KEYCODE_2;
  case Qt::Key_3 : /* = 0x33, */
    return IIIMF_KEYCODE_3;
  case Qt::Key_4 : /* = 0x34, */
    return IIIMF_KEYCODE_4;
  case Qt::Key_5 : /* = 0x35, */
    return IIIMF_KEYCODE_5;
  case Qt::Key_6 : /* = 0x36, */
    return IIIMF_KEYCODE_6;
  case Qt::Key_7 : /* = 0x37, */
    return IIIMF_KEYCODE_7;
  case Qt::Key_8 : /* = 0x38, */
    return IIIMF_KEYCODE_8;
  case Qt::Key_9 : /* = 0x39, */
    return IIIMF_KEYCODE_9;    
  case Qt::Key_Colon : /* = 0x3a, */
    return IIIMF_KEYCODE_COLON;
  case Qt::Key_Semicolon : /* = 0x3b, */
    return IIIMF_KEYCODE_SEMICOLON;
  case Qt::Key_Less : /* = 0x3c, */
    return IIIMF_KEYCODE_LESS;
  case Qt::Key_Equal : /* = 0x3d, */
    return IIIMF_KEYCODE_EQUALS;
  case Qt::Key_Greater : /* = 0x3e, */
    return IIIMF_KEYCODE_GREATER;
  case Qt::Key_Question : /* = 0x3f, */
    
  case Qt::Key_At : /* = 0x40, */
    return IIIMF_KEYCODE_AT;
  case Qt::Key_A : /* = 0x41, */
        return IIIMF_KEYCODE_A;
  case Qt::Key_B : /* = 0x42, */
        return IIIMF_KEYCODE_B;
  case Qt::Key_C : /* = 0x43, */
    return IIIMF_KEYCODE_C;
  case Qt::Key_D : /* = 0x44, */
    return IIIMF_KEYCODE_D;
  case Qt::Key_E : /* = 0x45, */
    return IIIMF_KEYCODE_E;
  case Qt::Key_F : /* = 0x46, */
    return IIIMF_KEYCODE_F;
  case Qt::Key_G : /* = 0x47, */
    return IIIMF_KEYCODE_G;
  case Qt::Key_H : /* = 0x48, */
    return IIIMF_KEYCODE_H;
  case Qt::Key_I : /* = 0x49, */
    return IIIMF_KEYCODE_I;
  case Qt::Key_J : /* = 0x4a, */
    return IIIMF_KEYCODE_J;
  case Qt::Key_K : /* = 0x4b, */
    return IIIMF_KEYCODE_K;
  case Qt::Key_L : /* = 0x4c, */
    return IIIMF_KEYCODE_L;
  case Qt::Key_M : /* = 0x4d, */
    return IIIMF_KEYCODE_M;
  case Qt::Key_N : /* = 0x4e, */
    return IIIMF_KEYCODE_N;
  case Qt::Key_O : /* = 0x4f, */
    return IIIMF_KEYCODE_O;
  case Qt::Key_P : /* = 0x50, */
    return IIIMF_KEYCODE_P;
  case Qt::Key_Q : /* = 0x51, */
    return IIIMF_KEYCODE_Q;
  case Qt::Key_R : /* = 0x52, */
    return IIIMF_KEYCODE_R;
  case Qt::Key_S : /* = 0x53, */
    return IIIMF_KEYCODE_S;
  case Qt::Key_T : /* = 0x54, */
    return IIIMF_KEYCODE_T;
  case Qt::Key_U : /* = 0x55, */
    return IIIMF_KEYCODE_U;
  case Qt::Key_V : /* = 0x56, */
    return IIIMF_KEYCODE_V;
  case Qt::Key_W : /* = 0x57, */
    return IIIMF_KEYCODE_W;
  case Qt::Key_X : /* = 0x58, */
    return IIIMF_KEYCODE_X;
  case Qt::Key_Y : /* = 0x59, */
    return IIIMF_KEYCODE_Y;
  case Qt::Key_Z : /* = 0x5a, */
    return IIIMF_KEYCODE_Z;
  case Qt::Key_BracketLeft : /* = 0x5b, */
    return IIIMF_KEYCODE_OPEN_BRACKET;
  case Qt::Key_Backslash : /* = 0x5c, */
    return IIIMF_KEYCODE_BACK_SLASH;
  case Qt::Key_BracketRight : /* = 0x5d, */
    return IIIMF_KEYCODE_CLOSE_BRACKET;
    
  case Qt::Key_AsciiCircum : /* = 0x5e, */
    
  case Qt::Key_Underscore : /* = 0x5f, */
    return IIIMF_KEYCODE_UNDERSCORE;
  case Qt::Key_QuoteLeft : /* = 0x60, */
    return IIIMF_KEYCODE_BACK_QUOTE;
  case Qt::Key_BraceLeft : /* = 0x7b, */
    return IIIMF_KEYCODE_BRACELEFT;
  case Qt::Key_Bar : /* = 0x7c, */
  case Qt::Key_BraceRight : /* = 0x7d, */
    return IIIMF_KEYCODE_BRACERIGHT;
  case Qt::Key_AsciiTilde : /* = 0x7e, */
    return IIIMF_KEYCODE_UNDEFINED;
    // Latin 1 codes adapted from X: keysymdef.h,v 1.21 94/08/28 16:17:06

  case Qt::Key_nobreakspace : /* = 0x0a0, */
    return IIIMF_KEYCODE_UNDEFINED;
  case Qt::Key_exclamdown : /* = 0x0a1, */
    return IIIMF_KEYCODE_INVERTED_EXCLAMATION_MARK;
    
  case Qt::Key_cent : /* = 0x0a2, */
  case Qt::Key_sterling : /* = 0x0a3, */
  case Qt::Key_currency : /* = 0x0a4, */
  case Qt::Key_yen : /* = 0x0a5, */
  case Qt::Key_brokenbar : /* = 0x0a6, */
  case Qt::Key_section : /* = 0x0a7, */
  case Qt::Key_diaeresis : /* = 0x0a8, */
  case Qt::Key_copyright : /* = 0x0a9, */
  case Qt::Key_ordfeminine : /* = 0x0aa, */
  case Qt::Key_guillemotleft : /* = 0x0ab, */	// left angle quotation mark
  case Qt::Key_notsign : /* = 0x0ac, */
  case Qt::Key_hyphen : /* = 0x0ad, */
  case Qt::Key_registered : /* = 0x0ae, */
  case Qt::Key_macron : /* = 0x0af, */
  case Qt::Key_degree : /* = 0x0b0, */
  case Qt::Key_plusminus : /* = 0x0b1, */
  case Qt::Key_twosuperior : /* = 0x0b2, */
  case Qt::Key_threesuperior : /* = 0x0b3, */
  case Qt::Key_acute : /* = 0x0b4, */
  case Qt::Key_mu : /* = 0x0b5, */
  case Qt::Key_paragraph : /* = 0x0b6, */
  case Qt::Key_periodcentered : /* = 0x0b7, */
  case Qt::Key_cedilla : /* = 0x0b8, */
  case Qt::Key_onesuperior : /* = 0x0b9, */
  case Qt::Key_masculine : /* = 0x0ba, */
  case Qt::Key_guillemotright : /* = 0x0bb, */	// right angle quotation mark
  case Qt::Key_onequarter : /* = 0x0bc, */
  case Qt::Key_onehalf : /* = 0x0bd, */
  case Qt::Key_threequarters : /* = 0x0be, */
  case Qt::Key_questiondown : /* = 0x0bf, */
  case Qt::Key_Agrave : /* = 0x0c0, */
  case Qt::Key_Aacute : /* = 0x0c1, */
  case Qt::Key_Acircumflex : /* = 0x0c2, */
  case Qt::Key_Atilde : /* = 0x0c3, */
  case Qt::Key_Adiaeresis : /* = 0x0c4, */
  case Qt::Key_Aring : /* = 0x0c5, */
  case Qt::Key_AE : /* = 0x0c6, */
  case Qt::Key_Ccedilla : /* = 0x0c7, */
  case Qt::Key_Egrave : /* = 0x0c8, */
  case Qt::Key_Eacute : /* = 0x0c9, */
  case Qt::Key_Ecircumflex : /* = 0x0ca, */
  case Qt::Key_Ediaeresis : /* = 0x0cb, */
  case Qt::Key_Igrave : /* = 0x0cc, */
  case Qt::Key_Iacute : /* = 0x0cd, */
  case Qt::Key_Icircumflex : /* = 0x0ce, */
  case Qt::Key_Idiaeresis : /* = 0x0cf, */
  case Qt::Key_ETH : /* = 0x0d0, */
  case Qt::Key_Ntilde : /* = 0x0d1, */
  case Qt::Key_Ograve : /* = 0x0d2, */
  case Qt::Key_Oacute : /* = 0x0d3, */
  case Qt::Key_Ocircumflex : /* = 0x0d4, */
  case Qt::Key_Otilde : /* = 0x0d5, */
  case Qt::Key_Odiaeresis : /* = 0x0d6, */
  case Qt::Key_multiply : /* = 0x0d7, */
  case Qt::Key_Ooblique : /* = 0x0d8, */
  case Qt::Key_Ugrave : /* = 0x0d9, */
  case Qt::Key_Uacute : /* = 0x0da, */
  case Qt::Key_Ucircumflex : /* = 0x0db, */
  case Qt::Key_Udiaeresis : /* = 0x0dc, */
  case Qt::Key_Yacute : /* = 0x0dd, */
  case Qt::Key_THORN : /* = 0x0de, */
  case Qt::Key_ssharp : /* = 0x0df, */
  case Qt::Key_agrave : /* = 0x0e0, */
  case Qt::Key_aacute : /* = 0x0e1, */
  case Qt::Key_acircumflex : /* = 0x0e2, */
  case Qt::Key_atilde : /* = 0x0e3, */
  case Qt::Key_adiaeresis : /* = 0x0e4, */
  case Qt::Key_aring : /* = 0x0e5, */
  case Qt::Key_ae : /* = 0x0e6, */
  case Qt::Key_ccedilla : /* = 0x0e7, */
  case Qt::Key_egrave : /* = 0x0e8, */
  case Qt::Key_eacute : /* = 0x0e9, */
  case Qt::Key_ecircumflex : /* = 0x0ea, */
  case Qt::Key_ediaeresis : /* = 0x0eb, */
  case Qt::Key_igrave : /* = 0x0ec, */
  case Qt::Key_iacute : /* = 0x0ed, */
  case Qt::Key_icircumflex : /* = 0x0ee, */
  case Qt::Key_idiaeresis : /* = 0x0ef, */
  case Qt::Key_eth : /* = 0x0f0, */
  case Qt::Key_ntilde : /* = 0x0f1, */
  case Qt::Key_ograve : /* = 0x0f2, */
  case Qt::Key_oacute : /* = 0x0f3, */
  case Qt::Key_ocircumflex : /* = 0x0f4, */
  case Qt::Key_otilde : /* = 0x0f5, */
  case Qt::Key_odiaeresis : /* = 0x0f6, */
  case Qt::Key_division : /* = 0x0f7, */
  case Qt::Key_oslash : /* = 0x0f8, */
  case Qt::Key_ugrave : /* = 0x0f9, */
  case Qt::Key_uacute : /* = 0x0fa, */
  case Qt::Key_ucircumflex : /* = 0x0fb, */
  case Qt::Key_udiaeresis : /* = 0x0fc, */
  case Qt::Key_yacute : /* = 0x0fd, */
  case Qt::Key_thorn : /* = 0x0fe, */
  case Qt::Key_ydiaeresis : /* = 0x0ff, */

    // multimedia/internet keys - ignored by default - see QKeyEvent c'tor

  case Qt::Key_Back :  /* = 0x1061, */
  case Qt::Key_Forward :  /* = 0x1062, */
  case Qt::Key_Stop :  /* = 0x1063, */
  case Qt::Key_Refresh :  /* = 0x1064, */

  case Qt::Key_VolumeDown : /* = 0x1070, */
  case Qt::Key_VolumeMute :  /* = 0x1071, */
  case Qt::Key_VolumeUp : /* = 0x1072, */
  case Qt::Key_BassBoost : /* = 0x1073, */
  case Qt::Key_BassUp : /* = 0x1074, */
  case Qt::Key_BassDown : /* = 0x1075, */
  case Qt::Key_TrebleUp : /* = 0x1076, */
  case Qt::Key_TrebleDown : /* = 0x1077, */

  case Qt::Key_MediaPlay :  /* = 0x1080, */
  case Qt::Key_MediaStop :  /* = 0x1081, */
  case Qt::Key_MediaPrev :  /* = 0x1082, */
  case Qt::Key_MediaNext :  /* = 0x1083, */
  case Qt::Key_MediaRecord : /* = 0x1084, */
    
  case Qt::Key_HomePage :  /* = 0x1090, */
  case Qt::Key_Favorites :  /* = 0x1091, */
  case Qt::Key_Search :  /* = 0x1092, */
  case Qt::Key_Standby : /* = 0x1093, */
  case Qt::Key_OpenUrl : /* = 0x1094, */
  case Qt::Key_LaunchMail :  /* = 0x10a0, */
  case Qt::Key_LaunchMedia : /* = 0x10a1, */
  case Qt::Key_Launch0 :  /* = 0x10a2, */
  case Qt::Key_Launch1 :  /* = 0x10a3, */
  case Qt::Key_Launch2 :  /* = 0x10a4, */
  case Qt::Key_Launch3 :  /* = 0x10a5, */
  case Qt::Key_Launch4 :  /* = 0x10a6, */
  case Qt::Key_Launch5 :  /* = 0x10a7, */
  case Qt::Key_Launch6 :  /* = 0x10a8, */
  case Qt::Key_Launch7 :  /* = 0x10a9, */
  case Qt::Key_Launch8 :  /* = 0x10aa, */
  case Qt::Key_Launch9 :  /* = 0x10ab, */
  case Qt::Key_LaunchA :  /* = 0x10ac, */
  case Qt::Key_LaunchB :  /* = 0x10ad, */
  case Qt::Key_LaunchC :  /* = 0x10ae, */
  case Qt::Key_LaunchD :  /* = 0x10af, */
  case Qt::Key_LaunchE :  /* = 0x10b0, */
  case Qt::Key_LaunchF :  /* = 0x10b1, */

  case Qt::Key_MediaLast : /* = 0x1fff, */
  case Qt::Key_Backtab : /* = 0x1002, */
    //case Qt::Key_BackTab : /* = case Key_Backtab, : */
  case Qt::Key_SysReq : /* = 0x100a, */
    //case Qt::Key_Prior : /* = 0x1016, */
    //case Qt::Key_Next : /* = 0x1017, */
  case Qt::Key_Super_L : /* = 0x1053, */ 		// extra keys
  case Qt::Key_Super_R : /* = 0x1054, */
  case Qt::Key_Menu : /* = 0x1055, */
  case Qt::Key_Hyper_L : /* = 0x1056, */
  case Qt::Key_Hyper_R : /* = 0x1057, */
  case Qt::Key_Direction_L : /* = 0x1059, */
  case Qt::Key_Direction_R : /* = 0x1060, */
  case Qt::Key_Multi_key :   /* = 0x1120, */  // Multi-key character compose

    // International input method support (X keycode - 0xEE00)
    // Only interesting if you are writing your own input method

    // International & multi-key character composition
#if 0
  case Qt::Key_Codeinput :           /* = 0x1137, */
    return IIIMF_KEYCODE_UNDEFINED;

  case Qt::Key_SingleCandidate :     /* = 0x113c, */
    return IIIMF_KEYCODE_UNDEFINED;

  case Qt::Key_MultipleCandidate :   /* = 0x113d, */
    return IIIMF_KEYCODE_UNDEFINED;
  case Qt::Key_PreviousCandidate :   /* = 0x113e, */
    return IIIMF_KEYCODE_UNDEFINED;
#endif
  case Qt::Key_unknown :/* = 0xffff*/
    return IIIMF_KEYCODE_UNDEFINED;
  default:
    return IIIMF_KEYCODE_UNDEFINED;
  }
}


int
KeyMapper::modifier (Qt::ButtonState st)
{
  int mod = 0;
  
  if (st & Qt::ShiftButton) {
    DEBUG_DO(qDebug ("**IIIMQCF: modifier():Shift button pressed"));
    mod |= IIIMF_SHIFT_MODIFIER;
  }
  if (st & Qt::ControlButton) {
    DEBUG_DO(qDebug ("**IIIMQCF: modifier():Control button pressed"));
    mod |= IIIMF_CONTROL_MODIFIER;
  }
  if (st & Qt::MetaButton) {
    DEBUG_DO(qDebug ("**IIIMQCF: modifier():Meta button pressed"));
    mod |= IIIMF_META_MODIFIER;
  }
  /*
  if (st & GDK_MOD1_MASK)    {
    mod |= IIIMF_ALT_MODIFIER;
  }
  */

  return mod;
}
#if 0
int
KeyMapper::i2q (int kv, int kc)
#endif
int
KeyMapper::i2q (int kv)
{
#if 0
  /* treat special case */
  switch (kc)    {
  case '?':
    return Qt::Key_Question;
  case '%':
    return GDK_percent;
  default:
    break;
  }
#endif
  
  switch (kv){
    /* case IIIMF_KEYCODE_UNDEFINED */
#if 0
  case IIIMF_KEYCODE_CANCEL:
    return GDK_Cancel;
#endif
  case IIIMF_KEYCODE_BACK_SPACE:
    return Qt::Key_Backspace;
  case IIIMF_KEYCODE_TAB:
    return Qt::Key_Tab;
  case IIIMF_KEYCODE_ENTER:
    return Qt::Key_Enter;
#if 0
  case IIIMF_KEYCODE_CLEAR:
    return GDK_Clear;
#endif
  case IIIMF_KEYCODE_SHIFT:
    return Qt::Key_Shift;	/* ... */
  case IIIMF_KEYCODE_CONTROL:
    return Qt::Key_Control;	/* ... */
  case IIIMF_KEYCODE_ALT:
    return Qt::Key_Alt;
  case IIIMF_KEYCODE_PAUSE:
    return Qt::Key_Pause;
  case IIIMF_KEYCODE_CAPS_LOCK:
    return Qt::Key_CapsLock;
#if 0
  case IIIMF_KEYCODE_KANJI:
    return GDK_Kanji;
#endif

  case IIIMF_KEYCODE_ESCAPE:
    return Qt::Key_Escape;
#if 0
  case IIIMF_KEYCODE_CONVERT:
    return GDK_Henkan_Mode;

  case IIIMF_KEYCODE_NONCONVERT:
    return GDK_Muhenkan;
    /* case IIIMF_KEYCODE_ACCEPT */
  case IIIMF_KEYCODE_MODECHANGE:
    return GDK_Mode_switch;
#endif
  case IIIMF_KEYCODE_SPACE:
    return Qt::Key_Space;
  case IIIMF_KEYCODE_PAGE_UP:
    return Qt::Key_PageUp;
  case IIIMF_KEYCODE_PAGE_DOWN:
    return Qt::Key_PageDown;;
  case IIIMF_KEYCODE_END:
    return Qt::Key_End;
  case IIIMF_KEYCODE_HOME:
    return Qt::Key_Home;
  case IIIMF_KEYCODE_LEFT:
    return Qt::Key_Left;
  case IIIMF_KEYCODE_UP:
    return Qt::Key_Up;
  case IIIMF_KEYCODE_RIGHT:
    return Qt::Key_Right;
  case IIIMF_KEYCODE_DOWN:
    return Qt::Key_Down;
  case IIIMF_KEYCODE_COMMA:
    return Qt::Key_Comma;
  case IIIMF_KEYCODE_MINUS:
    return Qt::Key_Minus;
  case IIIMF_KEYCODE_PERIOD:
    return Qt::Key_Period;
  case IIIMF_KEYCODE_SLASH:
    return Qt::Key_Slash;
    
  case IIIMF_KEYCODE_0:
  case IIIMF_KEYCODE_NUMPAD0:
    return Qt::Key_0;
    
  case IIIMF_KEYCODE_1:
  case IIIMF_KEYCODE_NUMPAD1:
    return Qt::Key_1;
  case IIIMF_KEYCODE_2:
  case IIIMF_KEYCODE_NUMPAD2:
    return Qt::Key_2;
  case IIIMF_KEYCODE_3:
  case IIIMF_KEYCODE_NUMPAD3:
    return Qt::Key_3;
  case IIIMF_KEYCODE_4:
  case IIIMF_KEYCODE_NUMPAD4:
    return Qt::Key_4;
  case IIIMF_KEYCODE_5:
  case IIIMF_KEYCODE_NUMPAD5:
    return Qt::Key_5;
  case IIIMF_KEYCODE_6:
  case IIIMF_KEYCODE_NUMPAD6:
    return Qt::Key_6;
  case IIIMF_KEYCODE_7:
  case IIIMF_KEYCODE_NUMPAD7:
    return Qt::Key_7;
  case IIIMF_KEYCODE_8:
  case IIIMF_KEYCODE_NUMPAD8:
    return Qt::Key_8;
  case IIIMF_KEYCODE_9:
  case IIIMF_KEYCODE_NUMPAD9:
    return Qt::Key_9;
    
  case IIIMF_KEYCODE_SEMICOLON:
    return Qt::Key_Semicolon;
  case IIIMF_KEYCODE_EQUALS:
    return Qt::Key_Equal;
  case IIIMF_KEYCODE_A:
    return Qt::Key_A;
  case IIIMF_KEYCODE_B:
    return Qt::Key_B;
  case IIIMF_KEYCODE_C:
    return Qt::Key_C;
  case IIIMF_KEYCODE_D:
    return Qt::Key_D;
  case IIIMF_KEYCODE_E:
    return Qt::Key_E;
  case IIIMF_KEYCODE_F:
    return Qt::Key_F;
  case IIIMF_KEYCODE_G:
    return Qt::Key_G;
  case IIIMF_KEYCODE_H:
    return Qt::Key_H;
  case IIIMF_KEYCODE_I:
    return Qt::Key_I;
  case IIIMF_KEYCODE_J:
    return Qt::Key_J;
  case IIIMF_KEYCODE_K:
    return Qt::Key_K;
  case IIIMF_KEYCODE_L:
    return Qt::Key_L;
  case IIIMF_KEYCODE_M:
    return Qt::Key_M;
  case IIIMF_KEYCODE_N:
    return Qt::Key_N;
  case IIIMF_KEYCODE_O:
    return Qt::Key_O;
  case IIIMF_KEYCODE_P:
    return Qt::Key_P;
  case IIIMF_KEYCODE_Q:
    return Qt::Key_Q;
  case IIIMF_KEYCODE_R:
    return Qt::Key_R;
  case IIIMF_KEYCODE_S:
    return Qt::Key_S;
  case IIIMF_KEYCODE_T:
    return Qt::Key_T;
  case IIIMF_KEYCODE_U:
    return Qt::Key_U;
  case IIIMF_KEYCODE_V:
    return Qt::Key_V;
  case IIIMF_KEYCODE_W:
    return Qt::Key_W;
  case IIIMF_KEYCODE_X:
    return Qt::Key_X;
  case IIIMF_KEYCODE_Y:
    return Qt::Key_Y;
  case IIIMF_KEYCODE_Z:
    return Qt::Key_Z;
  case IIIMF_KEYCODE_OPEN_BRACKET:
    return Qt::Key_BracketLeft;
  case IIIMF_KEYCODE_BACK_SLASH:
    return Qt::Key_Backslash;
  case IIIMF_KEYCODE_CLOSE_BRACKET:
    return Qt::Key_BracketRight;
  case IIIMF_KEYCODE_MULTIPLY:
    return Qt::Key_multiply;
#if 0
  case IIIMF_KEYCODE_ADD:
    return GDK_KP_Add;
  case IIIMF_KEYCODE_SEPARATOR:
    return GDK_KP_Separator;
  case IIIMF_KEYCODE_SUBTRACT:
    return GDK_KP_Subtract;
  case IIIMF_KEYCODE_DECIMAL:
    return GDK_KP_Decimal;
  case IIIMF_KEYCODE_DIVIDE:
    return GDK_KP_Divide;
#endif
  case IIIMF_KEYCODE_F1:
    return Qt::Key_F1;
  case IIIMF_KEYCODE_F2:
    return Qt::Key_F2;
  case IIIMF_KEYCODE_F3:
    return Qt::Key_F3;
  case IIIMF_KEYCODE_F4:
    return Qt::Key_F4;
  case IIIMF_KEYCODE_F5:
    return Qt::Key_F5;
  case IIIMF_KEYCODE_F6:
    return Qt::Key_F6;
  case IIIMF_KEYCODE_F7:
    return Qt::Key_F7;
  case IIIMF_KEYCODE_F8:
    return Qt::Key_F8;
  case IIIMF_KEYCODE_F9:
    return Qt::Key_F9;
  case IIIMF_KEYCODE_F10:
    return Qt::Key_F10;
  case IIIMF_KEYCODE_F11:
    return Qt::Key_F11;
  case IIIMF_KEYCODE_F12:
    return Qt::Key_F12;
  case IIIMF_KEYCODE_DELETE:
    return Qt::Key_Delete;
#if 0
  case IIIMF_KEYCODE_DEAD_GRAVE:
    return GDK_dead_grave;
  case IIIMF_KEYCODE_DEAD_ACUTE:
    return GDK_dead_acute;
  case IIIMF_KEYCODE_DEAD_CIRCUMFLEX:
    return GDK_dead_circumflex;

  case IIIMF_KEYCODE_DEAD_TILDE:
    return GDK_dead_tilde;
  case IIIMF_KEYCODE_DEAD_MACRON:
    return GDK_dead_macron;
  case IIIMF_KEYCODE_DEAD_BREVE:
    return GDK_dead_breve;
  case IIIMF_KEYCODE_DEAD_ABOVEDOT:
    return GDK_dead_abovedot;
  case IIIMF_KEYCODE_DEAD_DIAERESIS:
    return GDK_dead_diaeresis;
  case IIIMF_KEYCODE_DEAD_ABOVERING:
    return GDK_dead_abovering;
  case IIIMF_KEYCODE_DEAD_DOUBLEACUTE:
    return GDK_dead_doubleacute;
  case IIIMF_KEYCODE_DEAD_CARON:
    return GDK_dead_caron;
  case IIIMF_KEYCODE_DEAD_CEDILLA:
    return GDK_dead_cedilla;
  case IIIMF_KEYCODE_DEAD_OGONEK:
    return GDK_dead_ogonek;
  case IIIMF_KEYCODE_DEAD_IOTA:
    return GDK_dead_iota;
  case IIIMF_KEYCODE_DEAD_VOICED_SOUND:
    return GDK_dead_voiced_sound;
  case IIIMF_KEYCODE_DEAD_SEMIVOICED_SOUND:
    return GDK_dead_semivoiced_sound;
#endif
  case IIIMF_KEYCODE_NUM_LOCK:
    return Qt::Key_NumLock;
  case IIIMF_KEYCODE_SCROLL_LOCK:
    return Qt::Key_ScrollLock;
  case IIIMF_KEYCODE_AMPERSAND:
    return Qt::Key_Ampersand;
  case IIIMF_KEYCODE_ASTERISK:
    return Qt::Key_Asterisk;
  case IIIMF_KEYCODE_QUOTEDBL:
    return Qt::Key_QuoteDbl;
#if 0
  case IIIMF_KEYCODE_LESS:
    return GDK_less;
  case IIIMF_KEYCODE_PRINTSCREEN:
    return GDK_Print;
  case IIIMF_KEYCODE_INSERT:
    return GDK_Insert;
  case IIIMF_KEYCODE_HELP:
    return GDK_Help;
  case IIIMF_KEYCODE_META:
    return GDK_Meta_L;
  case IIIMF_KEYCODE_GREATER:
    return GDK_greater;
  case IIIMF_KEYCODE_BRACELEFT:
    return GDK_braceleft;
  case IIIMF_KEYCODE_BRACERIGHT:
    return GDK_braceright;
  case IIIMF_KEYCODE_BACK_QUOTE:
    return GDK_grave;
  case IIIMF_KEYCODE_QUOTE:
    return GDK_apostrophe;
  case IIIMF_KEYCODE_KP_UP:
    return GDK_KP_Up;
  case IIIMF_KEYCODE_KP_DOWN:
    return GDK_KP_Down;
  case IIIMF_KEYCODE_KP_LEFT:
    return GDK_KP_Left;
  case IIIMF_KEYCODE_KP_RIGHT:
    return GDK_KP_Right;
    /* case IIIMF_KEYCODE_ALPHANUMERIC */
  case IIIMF_KEYCODE_KATAKANA:
    return GDK_Katakana;
  case IIIMF_KEYCODE_HIRAGANA:
    return GDK_Hiragana;
  case IIIMF_KEYCODE_FULL_WIDTH:
    return GDK_Zenkaku;
  case IIIMF_KEYCODE_HALF_WIDTH:
    return GDK_Hankaku;
  case IIIMF_KEYCODE_ROMAN_CHARACTERS:
    return GDK_Romaji;
    /* case IIIMF_KEYCODE_ALL_CANDIDATES */
  case IIIMF_KEYCODE_PREVIOUS_CANDIDATE:
    return GDK_PreviousCandidate;
  case IIIMF_KEYCODE_CODE_INPUT:
    return GDK_Codeinput;
  case IIIMF_KEYCODE_JAPANESE_KATAKANA:
    return GDK_Katakana;
  case IIIMF_KEYCODE_JAPANESE_HIRAGANA:
    return GDK_Hiragana;
    /*	case IIIMF_KEYCODE_JAPANESE_ROMAN */
  case IIIMF_KEYCODE_KANA_LOCK:
    return GDK_Kana_Lock;
    /* case IIIMF_KEYCODE_INPUT_METHOD_ON_OFF */
  case IIIMF_KEYCODE_AT:
    return GDK_at;
  case IIIMF_KEYCODE_COLON:
    return GDK_colon;
  case IIIMF_KEYCODE_CIRCUMFLEX:
    return GDK_asciicircum;
  case IIIMF_KEYCODE_DOLLAR:
    return GDK_dollar;
  case IIIMF_KEYCODE_EURO_SIGN:
    return GDK_EuroSign;
  case IIIMF_KEYCODE_EXCLAMATION_MARK:
    return GDK_exclam;
  case IIIMF_KEYCODE_INVERTED_EXCLAMATION_MARK:
    return GDK_exclamdown;
  case IIIMF_KEYCODE_LEFT_PARENTHESIS:
    return GDK_parenleft;
  case IIIMF_KEYCODE_NUMBER_SIGN:
    return GDK_numbersign;
  case IIIMF_KEYCODE_PLUS:
    return GDK_plus;
  case IIIMF_KEYCODE_RIGHT_PARENTHESIS:
    return GDK_parenright;
  case IIIMF_KEYCODE_UNDERSCORE:
    return GDK_underscore;
  case IIIMF_KEYCODE_F13:
    return GDK_F13;
  case IIIMF_KEYCODE_F14:
    return GDK_F14;
  case IIIMF_KEYCODE_F15:
    return GDK_F15;
  case IIIMF_KEYCODE_F16:
    return GDK_F16;
  case IIIMF_KEYCODE_F17:
    return GDK_F17;
  case IIIMF_KEYCODE_F18:
    return GDK_F18;
  case IIIMF_KEYCODE_F19:
    return GDK_F19;
  case IIIMF_KEYCODE_F20:
    return GDK_F20;
  case IIIMF_KEYCODE_F21:
    return GDK_F21;
  case IIIMF_KEYCODE_F22:
    return GDK_F22;
  case IIIMF_KEYCODE_F23:
    return GDK_F23;
  case IIIMF_KEYCODE_F24:
    return GDK_F24;
    /*
      case IIIMF_KEYCODE_COMPOSE:
      case IIIMF_KEYCODE_ALT_GRAPH
      case IIIMF_KEYCODE_STOP
      case IIIMF_KEYCODE_AGAIN
      case IIIMF_KEYCODE_PROPS
    */
  case IIIMF_KEYCODE_UNDO:
    return GDK_Undo;
    /*
      case IIIMF_KEYCODE_COPY
      case IIIMF_KEYCODE_PASTE
    */
  case IIIMF_KEYCODE_FIND:
    return GDK_Find;
    /* case IIIMF_KEYCODE_CUT */
  default:
    return (guint) (kv & 0xff);
#endif
  default:
    return 0;

  }
  return 0;
}
