/*
 * fop_test_client.c: client to test iml_fop
 */


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <locale.h>

#include <iiimcf.h>


void
status_verify(const char * name, IIIMF_status st)
{
    if (IIIMF_STATUS_SUCCESS == st) {
	printf("%s: %d: success\n", name, st);
	return;
    } else {
	printf("%s: %d: fail\n", name, st);
	exit(1);
    }
}


int
main(int argc, char ** argv)
{
    IIIMCF_handle	handle;
    IIIMCF_attr		attr;
    IIIMCF_attr		attr1;
    IIIMF_status	st;
    IIIMCF_context	context;
    IIIMCF_event	ev;
    IIIMCF_keyevent	kev;
    char *		addr;

    setlocale(LC_ALL, "");

    addr = getenv("IIIMD_OPTION_UDSFILE");

    st = iiimcf_initialize(IIIMCF_ATTR_NULL);
    status_verify("iiimcf_initialize", st);

    st = iiimcf_create_attr(&attr);
    status_verify("iiimcf_create_attr", st);
    st = iiimcf_attr_put_string_value(attr, IIIMCF_ATTR_CLIENT_TYPE,
				      "fop test");
    status_verify("iiimcf_attr_put_string_value", st);
    st = iiimcf_attr_put_string_value(attr, IIIMCF_ATTR_SERVER_ADDRESS,
				      addr);
    status_verify("iiimcf_attr_put_string_value", st);
    st = iiimcf_attr_put_string_value(attr, IIIMCF_ATTR_SERVER_SERVICE,
				      "");
    status_verify("iiimcf_attr_put_string_value", st);

    st = iiimcf_create_handle(attr, &handle);
    status_verify("iiimcf_create_handle", st);

    st = iiimcf_create_context(handle, IIIMCF_ATTR_NULL, &context);
    status_verify("iiimcf_create_context", st);

    st = iiimcf_create_attr(&attr1);
    status_verify("iiimcf_create_attr", st);


    st = iiimcf_attr_put_string_value(attr1, IIIMCF_ATTR_INPUT_LANGUAGE,
				      "ja");
    status_verify("iiimcf_attr_put_string_value", st);
    st = iiimcf_attr_put_string_value(attr1, IIIMCF_ATTR_INPUT_METHOD,
				      "fop_test");
    status_verify("iiimcf_attr_put_string_value", st);

    iiimcf_context_set_attr(context, attr1);
    status_verify("iiimcf_context_set_attr", st);

    st = iiimcf_create_seticfocus_event(&ev);
    status_verify("iiimcf_create_seticfocus_event", st);

    st = iiimcf_forward_event(context, ev);
    status_verify("iiimcf_forward_event", st);

    kev.keycode = 0;
    kev.keychar = 0;
    kev.modifier = 0;
    kev.time_stamp = time(NULL);
    st = iiimcf_create_keyevent(&kev, &ev);
    status_verify("iiimcf_create_keyevent", st);

#if 0
    st = iiimcf_forward_event(context, ev);
    status_verify("iiimcf_forward_event", st);
#endif
    st = iiimcf_destroy_context(context);
    status_verify("iiimcf_destroy_context", st);

    return 0;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */

