/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _UNITINPUT_H_
#define _UNITINPUT_H_

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <dirent.h>     /* for #define NAME_MAX 255  */
#include <fcntl.h>      /* for mode_t */
#include <sys/param.h>  /* for #define PATH_MAX 4096 */
#include <X11/Xmd.h>
#include "SunIM.h"
#include "logf.h"

#ifndef NAME_MAX
#define NAME_MAX 255
#endif
    /***************************************************************************/
    /*                          Key  Definition                                */
    /***************************************************************************/

    /* Key Used by Input Method Manager */
#define IMM_NOT_USED_KEY		0
#define IMM_USED_KEY			1
#define ENGLISH_NONENGLISH_SWITCH_KEY 4
#define ROUND_SWITCH_KEY		5  

#define SWITCH_F1_KEY			6
#define SWITCH_F2_KEY			(SWITCH_F1_KEY+1)
#define SWITCH_F3_KEY			(SWITCH_F1_KEY+2)
#define SWITCH_F4_KEY			(SWITCH_F1_KEY+3)
#define SWITCH_F5_KEY			(SWITCH_F1_KEY+4)
#define SWITCH_F6_KEY			(SWITCH_F1_KEY+5)
#define SWITCH_F7_KEY			(SWITCH_F1_KEY+6)
#define SWITCH_F8_KEY			(SWITCH_F1_KEY+7)
#define SWITCH_F9_KEY			(SWITCH_F1_KEY+8)
#define SWITCH_F10_KEY			(SWITCH_F1_KEY+9)
#define SWITCH_F11_KEY			(SWITCH_F1_KEY+10)
#define SWITCH_F12_KEY			(SWITCH_F1_KEY+11)

    /* Key Used by Input Method Entry */
#define IME_NOT_USED_KEY		0
#define IME_USED_KEY			1
#define ESC_KEY               		2
#define BACKSPACE_KEY        		3
#define RETURN_KEY            		4
#define INSERT_KEY			5
#define DELETE_KEY			6
#define HOME_KEY			7
#define END_KEY				8
#define PAGEUP_KEY             		9
#define PAGEDOWN_KEY           		10
#define TAB_KEY           		11
#define IME_DEADKEY_AS_HOTKEY  	12
#define IME_COMPOSE_KEY_AS_HOTKEY	13
#define IME_EURO_KEY_AS_HOTKEY		14
#define SPACE_KEY           		0x20
#define IME_QUOTE           		0x27
#define IME_BACK_QUOTE           	0x60
#define IME_ASCIICIRCUM           	0x5e
#define IME_GREATER	           	0x3e
#define IME_QUOTEDBL	           	0x22
#define IME_ASCIITILDE	           	0x7e

    /***************************************************************************/
    /*                    Input Method Engine  Definition                      */
    /***************************************************************************/
#define	MAX_CANDIDATES_NUM		16
#define MAX_INPUT_KEY_NUM		256
#define MAX_PREEDIT_CHAR_NUM		256
#define MAX_CANDIDATE_CHAR_NUM 		256
#define MAX_STATUS_CHAR_NUM    		256
#define MAX_COMMIT_CHAR_NUM    		512
#define MAX_LINE_LEN    		1024

#define MAX_KEYMAP_KEY_NUM		95

#define IME_PREEDIT_AREA 		1
#define IME_LOOKUP_AREA  		2
#define IME_STATUS_AREA  		4
#define IME_COMMIT       		8

#define ENGINE_NOT_INSTALLED 		1
#define ENGINE_NOT_INITIATED 		2
#define ENGINE_INITIATED     		3

#define DEFAULT_ENGINE_PATH		IIIMLEDIR
#define DEFAULT_DICT_PATH		"data"
#define COMMON_ENGINE_PATH		"common"
#define DEFAULT_LOCALE_PATH		"locale"
#define GENERIC_IM_TABLE_NAME    "GENERIC_IM_TABLE"
#define SWITCH_TO_NEXT_LOCALE    "SWITCH_TO_NEXT_LOCALE"
#define SWITCH_TO_PREV_LOCALE    "SWITCH_TO_PREV_LOCALE"
#define SWITCH_LAYOUT_NAME    "SWITCH_LAYOUT"
#define CODETABLE_ENGINE_NAME    	"ctim"
#define USER_PROFILE_PATH      		".Xlocale"
#define USER_PROFILE_NAME      		"ime.cfg"
#define SYSTEM_PROFILE_NAME      	"sysime.cfg"
#define HOTKEY_CONFIG_FILE      	"hotkey_config.xml"
#define USER_OPTION_FILE_NAME      	"options.cfg"
#define VAR_LE_DIR      		"/var/lib/iiim/le"

#define NUMERIC_LABEL			0
#define LOWER_LABEL			1
#define UPPER_LABEL			2

#define MAX_ENGINE_NUM			127
#define MAX_NAME_LEN			16

#define MAX_ARGS_NUM			10

    /***************************************************************************/
    /*         Protocol used by Auxiliary window and Language Engine           */
    /***************************************************************************/
    /* Conversion Status */
#define CONVERSION_OFF 			0
#define CONVERSION_ON 			1

    /* Types of Input Method Switching */
#define IME_ROUND_SWITCH  		0
#define IME_SELECT_SWITCH		1

    /* Protocol Number between Auxiliary Window and Language Engine */
    /* For PaletteAux */
#define PALETTEAUX_CONNECT			1
#define PALETTEAUX_SWITCH_CONVERSION		2
#define PALETTEAUX_SWITCH_IME			3
#define PALETTEAUX_CHANGE_POSITION		6
#define PALETTEAUX_SHOW_OPTIONAUX		7
#define PALETTEAUX_SHOW_SELECTAUX		8
#define PALETTEAUX_SHOW_KEYBOARDAUX		9
#define PALETTEAUX_SHOW_LOOKUPAUX		10
#define PALETTEAUX_START_ACTION			11

#define PALETTEAUX_UPDATE_IMEINFO_NOTIFY	12
#define PALETTEAUX_SWITCH_CONVERSION_NOTIFY	13
#define PALETTEAUX_SWITCH_IME_NOTIFY		14

    /* For Common used protocol */
#define COMMONAUX_COMMIT_KEY			20
#define COMMONAUX_COMMIT_STRING			21
#define COMMONAUX_UPDATE_OPTIONSINFO		22
#define COMMONAUX_LOST_FOCUS			23

#define COMMONAUX_CHANGE_FOCUS_NOTIFY		24
#define COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY	25
#define COMMONAUX_SET_IME_NEW_NOTIFY		26
#define COMMONAUX_SET_IME_INFO_NOTIFY		27
#define COMMONAUX_SET_IME_END_NOTIFY		28

    /* For OptionAux */
#define OPTIONAUX_CONNECT			30
#define OPTIONAUX_CHANGE_STATUS			31

#define OPTIONAUX_SHOW_NOTIFY			32
#define OPTIONAUX_HIDE_NOTIFY			33
#define OPTIONAUX_UPDATE_ARGS_NEW_NOTIFY	34
#define OPTIONAUX_UPDATE_ARGS_INFO_NOTIFY	35

    /* For SelectAux */
#define SELECTAUX_CONNECT			40
#define SELECTAUX_UPDATE_IMEINFO		41
#define SELECTAUX_CHANGE_STATUS			42

#define SELECTAUX_SHOW_NOTIFY			43
#define SELECTAUX_HIDE_NOTIFY			44

    /* For KeyboardAux */
#define KEYBOARDAUX_CONNECT			50
#define KEYBOARDAUX_CHANGE_POSITION		51
#define KEYBOARDAUX_CHANGE_KEY_STATUS		52

#define KEYBOARDAUX_SHOW_NOTIFY			53
#define KEYBOARDAUX_HIDE_NOTIFY			54
#define KEYBOARDAUX_PRESS_KEY_NOTIFY		55

    /* For LookupAux */
#define LOOKUPAUX_CONNECT			60
#define LOOKUPAUX_CHANGE_STATUS			61
#define LOOKUPAUX_CHANGE_POSITION		62

#define LOOKUPAUX_SHOW_NOTIFY			63
#define LOOKUPAUX_HIDE_NOTIFY			64

    /* For ActionAux */
#define ACTIONAUX_CONNECT			70
#define ACTIONAUX_START_ACTION_NOTIFY		71

enum IME_HOTKEY_STATUS {
  IME_HOTKEY_START = 0,
  IME_HOTKEY_END,
  IME_HOTKEY_NOT_IN_USE,
  IME_HOTKEY_COMMIT,
};

enum IME_HOTKEY_PROFILE_ID {
  IME_HOTKEY_PROFILE_ONE = 1,
  IME_HOTKEY_PROFILE_TWO,
  IME_HOTKEY_PROFILE_THREE,
  IME_HOTKEY_PROFILE_NUM,
};

    /***************************************************************************/
    /*                 IME structure used by Language Engine                   */
    /***************************************************************************/
    typedef struct {
      int 		encode;
      int		inputkey_len;
      int		preedit_len;
      int		lookup_num;
      int		commit_len;
      int		status_len;
      int 		*inputkey_buf;  	/* buffer for input keys */
      unsigned char 	*commit_buf;		/* buffer for commit string */
      unsigned char  	*preedit_buf;		/* buffer for preedit area */
      unsigned char  	*prev_preedit_buf;		/* temporary preedit buffer */
      unsigned char 	*status_buf;		/* buffer for status area  */
      unsigned char 	**lookup_buf;		/* buffer for lookup area  */
      unsigned char 	**candidates_buf;  	/* buffer for candidates strings    */
      unsigned char 	**additions_buf;	/* buffer for candidates additions  */

      int		preedit_caretpos;
      int		cur_lookup_pos;
      CARD8		lookup_label_type;
      CARD8 		return_status;

      unsigned short	session_id;    
      int		hotkey_flag;
      int		conv_flag;
    } IMEBufferRec, *IMEBuffer;
	
/* IMEBaseRec that shared between Language Engine and Auxiliary WIndow. */
typedef struct {
  CARD8 		engine_id;		/* engine identity */
  CARD8 		locale_id;		/* supported locale idendity */
  CARD8 		encode_id;		/* encode that dictionary used */
  CARD8 		status;			/* engine status: initialized or installed */
  char		*ename; 		/* English name of this engine */
  char    *lname;
  char 		*cname;			/* Name of this engine */
} IMEBaseRec, *IMEBase;

/* Arguments:
   system arguments ---> IMECoreRec
   user defined arguments   ---> Desktop_data
*/
typedef struct {
  char		*name;
  CARD8		type;
  CARD8 		value;
} IMEArgRec, *IMEArg;
	
typedef struct { 
  int 		args_num;
  IMEArgRec	args[MAX_ARGS_NUM];
} IMEArgListRec, *IMEArgList;

/* Runtime Environment */
typedef struct { 
  CARD8 		output_encode_id;	/* encode that IME need output */
  char 		*lang_name;		
  char 		*locale_name;		/* locale name defined in config file */
  char 		*data_path;		/* directory for dictionary */
  char 		*data_ptr;		/* memory pointer for dictionary data */
} IMEEnvListRec, *IMEEnvList;

/* Keymap Information */
typedef struct {
  char 		bSet;			/* whether be set by IM engine */
  char 		*keymap[MAX_KEYMAP_KEY_NUM];
} IMEKeyMapRec, *IMEKeyMap;

/* IME Core Information */
typedef struct {
  IMEBaseRec	baseinfo;		/* Input Method Entry information */
  IMEEnvListRec	envinfo;		/* runtime environment of IME engine */
  IMEArgListRec	argsinfo;		/* system arguments setting */
  IMEKeyMapRec	keymapinfo;		/* key mapping for the IM */
} IMECoreRec, *IMECore;

typedef struct {
  int  		keyCode;
  int 		keyChar;
  int 		modifier;
} IMEKeyRec, *IMEKey;

typedef struct _method_t {
  int  (*IME_SetOptions)(IMECore, char *);
  int  (*IME_SetValues)(IMECore, IMEArgList, int);
  int  (*IME_Init)(IMECore);
  int  (*IME_Open)(IMECore, IMEBuffer, void *);
  int  (*IME_Filter)(IMECore, IMEKey, IMEArgList, IMEBuffer);
  void (*IME_Close)(IMECore);
} IMEMethodsRec, *IMEMethods;

typedef struct {
  IMECoreRec	core;
  IMEMethods	so_methods;
  void		*so_handler;
} IMEEngineRec, *IMEEngine;

typedef struct {
  int 		nIME_Num;
  IMEBaseRec	*arrIME_Base[MAX_ENGINE_NUM];
} IMEListRec;

typedef struct {
  char *locale_name;
  int firstEngineId;
  int lastEngineId;
  int nEngineId;
}LocaleList;

/* Mode List */
typedef struct {
  char *locale_name;
  char *nlocale_name;
  char *nlayout_name;
  char *engine_name;
  int engine_id;
  char	*default_state;	
}IMEModeList;

typedef struct KEY_VALUE_PAIR_ {
  char *key_name;
  int value;
}keyvalue_pair;

/* UNIT DESKTOP DATA STRUCTURE */

typedef struct _unit_desktop_t {
  /* public */
  void (*unit_desktop_init) ();
  int (*unit_desktop_add_listener) ();
  int (*unit_desktop_load_engines) ();
  void (*unit_desktop_set_curr_profile_id) ();
  int (*unit_desktop_get_curr_profile_id) ();
  void (*unit_desktop_switch_hotkey_profile) ();
  void (*unit_desktop_done) ();

  /* private */ 
  iml_session_t   *s;
  int             gEngine_Num;
  int             locale_Num;
  int             nextLocaleKeycode;
  int             nextLocaleModifier;
  int             prevLocaleKeycode;
  int             prevLocaleModifier;
  int             layoutNameKeyCode;
  int             layoutNameModifier;
  int             curr_hotkey_profile_id;
  IMEEngineRec    *gEngine_Info[MAX_ENGINE_NUM];
  IMEModeList     *modeList[MAX_ENGINE_NUM];
  LocaleList      *localeList; 
  struct _unit_desktop_t *next;
} unit_desktop_t;

typedef unit_desktop_t *unit_desktop_list;

/* UNIT INTERFACE DATA STRUCTURE */

typedef struct _unit_if_t {
  /* public */
  unit_desktop_t * (*get_current_unit_desktop) ();
  unit_desktop_t * (*create_unit_desktop) ();
  int (*destory_unit_desktop) (unit_desktop_t *);
  void (*add_unit_desktop) (unit_desktop_t *);
  unit_desktop_t * (*find_unit_desktop_by_sc) (iml_session_t *);

  /* private */ 
  unit_desktop_list ud_list;
  int ud_count;
  void *ptr;
} unit_if_t;

#endif   /* _UNITINPUT_H_  */
