#include <qpainter.h>
#include "IIIMText.hh"
#include "IIIMStatus.hh"

void
IIIMStatusWidget::drawContents(
    QPainter *p
)
{
    IIIMCF_text text;
    IIIMF_status st;

    if (!ctx) return;
    st = iiimcf_get_status_text(ctx, &text);
    if (st != IIIMF_STATUS_SUCCESS) return;
    IIIMText imt(text);
    currentsize = imt.draw(p, this, contentsRect());

    adjustSize();
}

void
IIIMStatusWidget::adjust_location(
    const QSize& size
)
{
    if (pwlocref) {
	QPoint pt;
	QRect wrec = pwlocref->frameGeometry();
	switch (locref) {
	  case TOP_LEFT:
	   pt = wrec.topLeft();
	   pt.setY(pt.y() - size.height());
	   move(pt);
	   break;
	  case TOP_RIGHT:
	   pt = wrec.topRight();
	   pt.setX(pt.x() - size.width());
	   pt.setY(pt.y() - size.height());
	   move(pt);
	   break;
	  case BOTTOM_LEFT:
	   pt = wrec.bottomLeft();
	   move(pt);
	   break;
	  case BOTTOM_RIGHT:
	   pt = wrec.bottomRight();
	   pt.setX(pt.x() - size.width());
	   move(pt);
	   break;
	}
    }
}

void
IIIMStatusWidget::resizeEvent(
    QResizeEvent *pre
)
{
    adjust_location(pre->size());

    QWidget::resizeEvent(pre);
    return;
}

void
IIIMStatusWidget::ref_change()
{
    adjust_location(size());
}

void
IIIMStatusWidget::place(
    QWidget *plocation_reference,
    enum LOCATION_REFERENCE ref
)
{
    pwlocref = plocation_reference;
    locref = ref;
    if (isShown()) {
	adjust_location(size());
    }
}

QSize
IIIMStatusWidget::sizeHint() const
{
    return minimumSizeHint();
}

QSize
IIIMStatusWidget::minimumSizeHint() const
{
    int plus = (frameWidth() + margin()) * 2;
    return QSize(currentsize.width() + plus, currentsize.height() + plus);
}

void
IIIMStatusWidget::update_im()
{
    IIIMF_status st;
    IIIMCF_text text;

    st = iiimcf_get_status_text(ctx, &text);
    if (st == IIIMF_STATUS_SUCCESS) {
	if (!currentsize.isValid()) {
	    IIIMText imt(text);
	    QPainter painter(this);
	    currentsize = imt.get_size(&painter, this);
	}
	repaint();
	show();
    } else {
	hide();
    }
}

IIIMStatusWidget::IIIMStatusWidget(
    IIIMCF_context x_ctx,
    QWidget *parent,
    const char *name,
    WFlags f
) : QFrame(parent, name, f)
{
    ctx = x_ctx;
    //setBackgroundMode(Qt::PaletteBase);
    setFrameShape(QFrame::WinPanel);
    setSizePolicy(QSizePolicy(QSizePolicy::Minimum,
			      QSizePolicy::Minimum));
    pwlocref = NULL;
}

IIIMStatusWidget::~IIIMStatusWidget()
{
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
