#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_geticvalues_reply_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_icattribute *	attr_list)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_GETICVALUES_REPLY;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.geticvalues_reply.attr_list = attr_list;
    return m;
}


void
iiimp_geticvalues_reply_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_icattribute_list_delete(data_s, m->v.geticvalues_reply.attr_list);
    free(m);
    return;
}


uchar_t *
iiimp_geticvalues_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_icattribute *	attr_list,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;
    size_t		attr_list_nbyte;
    IIIMP_icattribute *	a;

    nbyte = 0;
    nbyte += 2;			/* input method id */
    nbyte += 2;			/* input context id */
    nbyte += 2;			/* byte length of ic-attribute */
    for (attr_list_nbyte = 0, a = attr_list; NULL != a; a = a->next) {
	attr_list_nbyte += a->nbyte;
    }
    nbyte += attr_list_nbyte;	/* ic-attributes */
    nbyte += PAD(nbyte);

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_GETICVALUES_REPLY, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU16(attr_list_nbyte, rest, p, data_s->byte_swap);
    iiimp_icattribute_list_pack(data_s, attr_list, &rest, &p);
    while (0 < rest) {
	PUTU16(0, rest, p, data_s->byte_swap);
    }

    return buf;
}


IIIMP_message *
iiimp_geticvalues_reply_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *		m;
    IIIMP_geticvalues_reply_v *	v;
    size_t			rest;
    const uchar_t *		p;
    int				len;
    int				pad;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 2 + 2)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.geticvalues_reply);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);
    GET16(len, rest, p, data_s->byte_swap);

    pad = PAD(len);

    if ((len < 0) || (rest < (len + pad)) || (0 != (len & 0x01))) {
	free(m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    if (0 < len) {
	v->attr_list = iiimp_icattribute_list_unpack(data_s, &rest, &p, len);
	if (NULL == v->attr_list) {
	    free(m);
	    return NULL;
	}
    } else {
	v->attr_list = NULL;
    }

    *nbyte = (rest - pad);
    *ptr = (p + pad);

    return m;
}


void
iiimp_geticvalues_reply_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    iiimp_icattribute_list_print(data_s, m->v.geticvalues_reply.attr_list);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
