import sys
import traceback
import operator
import time

class awaylogmodule:
  def __init__(self, confignode):
    self.messageQueue=[]


  def registerCallbacks(self, cli):
    self.cli = cli
    cli.registerCallback("handleMessageReceive", cli.PRE, self.myHandleMessageReceivePRE)
    cli.registerCallback("handleUserPresenceChange", cli.PRE, self.myHandleUserPresenceChange)
    cli.registerCommand("/awaylog","awaylogcommand","Displays the list of messages received while last away.",self.awaylogCommand)


  def unRegisterCallbacks(self, cli):
    cli.unRegisterCallback("handleMessageReceive", cli.PRE, self.myHandleMessageReceivePRE)
    cli.unRegisterCallback("handleUserPresenceChange", cli.PRE, self.myHandleUserPresenceChange)
    cli.unRegisterCommand("awaylogcommand")


  def getName(self):
    return "awaylogmodule"

  def printShortDescription(self):
    print "Away Log Module loaded. -- /awaylog now available."

  def getConfigurationString(self, prependString):
    return None

  def configureModuleCLI(self, cli):
    print "No configuration required"

  def awaylogCommand(self, line):
    #print "This is an example command (args: ", line, ")"
    if len(self.messageQueue) == 0:
      print "No entries queued in away log."
      return
    print "Printing and removing messages from the queue."
    while len(self.messageQueue) > 0:
      entry = self.messageQueue.pop(0)
      ffrom, body, thread, delay, resource = entry
      # don't display messages from people who belong to the ignore
      # group.
      if self.cli.imcom.gjidhash.has_key(ffrom) and operator.contains(self.cli.imcom.gjidhash[ffrom],"ignore"):
        continue

      # try and get their nickname. otherwise their nickname is
      # their jid.
      try:
        nick = self.cli.imcom.jidhash[ffrom]
      except:
        nick = ffrom

      ttime = None
      ddate = None
      towrite = None
      towrite = self.cli.colorscheme["usercolor"] + nick + self.cli.colorscheme["defaultcolor"]

      if resource != "":
        towrite = towrite + "/" + self.cli.colorscheme["keycolor"] + resource + self.cli.colorscheme["defaultcolor"]

      # if the delay timestamp exists, format it properly, otherwise
      # the current time.
      if delay != None:
        # parse the delay, attach the timestamp in good format.
        # tuple is (year, month, day, hour, minutes, seconds,
        #           daysintotheyear, dst)
        mytup = (int(delay[:4]),int(delay[4:6]),int(delay[6:8]), int(delay[9:11]),int(delay[12:14]),int(delay[15:17]),0,0,0)
        thet = time.localtime( time.mktime(mytup) - time.timezone)
        ttime = time.strftime('%H:%M:%S',thet)
        ddate = time.strftime('%m/%d/%Y',thet)
        towrite = towrite + " - " + self.cli.colorscheme["errorcolor"] + "DELAYED " + self.cli.colorscheme["defaultcolor"] + "Message - "
      else:
        ttime = self.cli.getTime()
        ddate = self.cli.getDate()
        towrite = towrite + " - Message - "

      # append the timestamp and the rest of the information
      towrite = towrite + self.cli.colorscheme["timecolor"] + ttime + self.cli.colorscheme["defaultcolor"]
      if delay != None:
        towrite = towrite + " on " + self.cli.colorscheme["timecolor"] + ddate

      towrite = towrite + "\n" + self.cli.colorscheme["messagebodycolor"] + body + self.cli.colorscheme["defaultcolor"]
      self.cli.output(towrite)

  def myHandleMessageReceivePRE(self, cli, ffrom, body, thread, delay, resource):
    try:
      if delay == None:
        delay = time.strftime("%Y%m%dT%H:%M:%S", time.gmtime())
      self.messageQueue.append((ffrom, body, thread, delay, resource,))
    except:
      traceback.print_exc()

  def myHandleUserPresenceChange(self, cli, oldStatus, oldReason, newStatus, newReason):
    try:
      onlineStatus = ["chat", "online"]
      if oldStatus in onlineStatus and not newStatus in onlineStatus:
        cli.output("Clearing the awaylog queue. Will record messages for playback later.")
        self.messageQueue = []
      if not oldStatus in onlineStatus and newStatus in onlineStatus:
        cli.output("I can print out stored messages from while you were away now: /awaylog")
    except:
      traceback.print_exc()
