""" Settings module

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: Settings.py,v 1.46 2004/06/28 23:11:52 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.46 $"

from string import *
import ConfigParser
import sys,os
import imghdr                       # to determine image type
import Error

class intDict(dict):
    """subclasses dict just to make sure internal values like 'True' are returned as '1'
    """
    def __init__(self):
        dict.__init__(self)

    def __getitem__(self, key):
        val = dict.__getitem__(self, key)
        if type(val) == str:
            if val.strip().lower() == 'true':   val = '1'
            if val.strip().lower() == 'false':  val = '0'
        return val

    def copy(self):
        a = intDict()
        for k in self.keys(): a[k] = self[k]
        return a

ConfigDefaultTemplate = {
    "browse.showdotfiles":        "0",
    "browse.shownormalfiles":        "0",
    "browse.thumbsingleclick":    "0",
    "browse.showgrouprecursive":    "0",
    "browse.showmetadialog":      "0",
    "browse.groupthreshold":      "50",
    "browse.dragpopup":           "1",
    "browse.askbeforehugethumb":      "1",
    "database.extractexif":      "1",
    "database.extractiptc":      "0",
    "database.recursiveadd":      "1",
    "database.agressive":         "0",
    "database.beep":               "0",
    "database.alwayssave":        "1",
    "database.autoopen":          "~/.imgseek/img-db.iqd",
    "database.autoscannew":          "0",
    "database.hideprogress"    :  "1",
    "database.alwayssave"    :  "1",
    "view.mainwidth":             "700",
    "view.mainheight":            "600",
    "view.maintab":               "0",
    "view.browsetab":               "0",
    "view.vsplit1":               "170",
    "view.vsplit2":               "236",
    "view.hsplit1":               "144",
    "view.hsplit2":               "144",
    "view.slidedelay":            "3",
    "view.autofit":               "0",
    "view.recurseslide":           "1",
    "view.smoothscale":               "1",
    "view.ssplit1":               "356",
    "view.ssplit2":               "324",
    "view.s2split1":               "244",
    "view.s2split2":               "279",
    "query.realtimesketch":       "1"
    }

ConfigDefault = intDict()

for k in ConfigDefaultTemplate.keys():
    ConfigDefault[k] = ConfigDefaultTemplate[k]

class Env:
    """This class will hold all enviroment settings, and global vars """
    def __init__(self,wnd = None):
        """ init environment. Wnd is a pointer to the main dialog """
        print "Checking environment..."
        # default stuff
        self.imgseekdatadir = ""
        self.options = {}                 # will hold all app preferences
        self.hasImMagick = 0              # if imageMagick C++ support is being used.
        self.hasPIL =0                  # if PIL module was found.
        self.hasIPTC = 0                  # if PIL iptc module was found
        self.hasExport = 0                # if export (dsv/xml) modules where found
        self.hasJpegtran = None           # if jpegtran was found (lossless transforms). If non-null, will hold the full path to the executable
        self.verbose = 0
        self.wnd = wnd                    # main dialog
        self.curdb = None                 # current db
        ### parse command line options
        # I could/should use getopt here, just like it's done on imgSeekCmd, but i don't want to import another module and harm startup time just to parse a few CLI opts.
        self.verbose = ("-v" in sys.argv)
        ### Import some modules and see if they are available
        try:
            import imgdb
        except:
            Error.PrintTB("Warning: Unable to load the C++ extension \"imgdb.so\" module. Make sure you installed imgSeek correctly, and email any install bug to \"imgseek-devel@lists.sourceforge.net\".")
        try:
            from qt import QT_VERSION_STR
        except:
            Error.PrintTB("You system doesn't seem to have PyQT installed. Please install it before running this application. See http://www.riverbankcomputing.co.uk/pyqt/download.php and http://imgseek.sourceforge.net/requirements.html")
        try:
            if int(QT_VERSION_STR[0]) >=3:   # guess qt version.
                self.qtv = 3
            else:
                print "\n\nWARNING ---- This QT version is no longer supported !\n\n"
                self.qtv = 2
        except:
            Error.PrintTB("Error detecting PyQt/Qt version on Settings module")
            self.qtv = 3
        try:
            import IptcExtract
            self.hasIPTC = 1
            self.log("IPTC extraction","detected")
        except:
            self.hasIPTC = 0
            self.log("IPTC extraction","not found. Install PIL.")
        self.hasExport = 1
        try:
            import Image
            self.hasPIL = 1
            self.log("Python Imaging Library","detected")
        except:
            self.log("Python Imaging Library","not found. Please install it if you want to enable related features. (Check http://imgseek.sf.net/requirements.html)")
            self.hasPIL = 0

        ####### Detect supported image formats
        self.exif_ext = ["jpeg","jpe","jpg"]
        self.iptc_ext = ["tif","tiff","jpeg","jpe","jpg"]
        self.qt_ext = ["jpeg","jpe","jpg","gif","bmp","png","xbm","pnm"]
        self.magick_ext = ["tiff","tif","tiff","tga","targa","jpeg","jpe","jpg","gif","bmp","png","xbm","pnm",
        "art","avs","cgm","cmyk","cut","dcm","dcx","dib","dpx","ept","fig","fpx","gplt","gray","hpgl","html","ico","jbig","jp2","jpc","mat","miff","mono",
        "mng","otb","p7","pbm","pcd","pcx","pdf","pgm","pix","ppm","ps","rad","rgb","sct","sgi","sun","txt","xbm","xcf","avi","psd"]
        self.pil_ext = ["jpeg","jpe","jpg","gif","bmp","png","xbm","pnm"]
        self.doc_ext = ["txt","pdf","ps","htm","html"]

        # set supported extensions
        if imgdb.hasImageMagick():
            self.hasImMagick = 1
            self.supported_ext = self.qt_ext+self.magick_ext
        else:
            self.hasImMagick = 0
            self.magick_ext = []
            self.supported_ext = self.qt_ext
        if self.hasPIL:
            self.supported_ext = self.supported_ext+self.pil_ext
        if self.verbose: self.log("Supported formats",str(self.supported_ext))

        # run some tests in order to detect run-time features, set paths, etc """
        #### guess imgSeekLib data dir
        if sys.platform.find('darwin') != -1:  #Mac OS X platform
            self.imgseekdatadir = sys.exec_prefix + "/share/imgSeek/"
        elif sys.platform.find('win') != -1:  #windows platform
            self.imgseekdatadir = sys.path[0] + "\\resources\\" #TODO3: add failovers here            
        else:                           # *NIX platform
            #TODO3: improve this detection, this is nasty. Check code from treeShare or imgSeekNet
            self.imgseekdatadir = sys.exec_prefix + "/share/imgSeek/"
            if not os.path.exists(self.imgseekdatadir):
                self.imgseekdatadir = sys.exec_prefix + "/share/imgseek/"
            if not os.path.exists(self.imgseekdatadir):
                self.imgseekdatadir = sys.exec_prefix + "/share/imgSeekLib/"
            if not os.path.exists(self.imgseekdatadir):
                self.imgseekdatadir = sys.exec_prefix + "/imgSeekLib/"
            if not os.path.exists(self.imgseekdatadir):
                print "[Error] Unable to detect imgSeekLib data directory. Make sure imgSeek was installed properly, and report your linux distribution and installation method to nieder at mail dot ru"
                self.imgseekdatadir = sys.exec_prefix + "/share/imgSeek/" # get back to default value
        self.log("imgSeek data dir",self.imgseekdatadir)
        #### check if jpegtran is found
        self.hasJpegtran = binpathfinder("jpegtran")
        if self.hasJpegtran:
            self.log("jpegtran","detected")
        else:
            self.log("jpegtran","not found")

    def log(self,who,what):
        """ will wrap any output message during this env init """
        print "[%s] %s" %(who,what)

    def extIsImg(self,file,probe = 0):
        """tests if this file has a supported image format extension or is an image.

        @param file: full filename
        @type file: string
        @param probe: if true, makes it check even if file has no extension
        @type probe: int
        """
        ext = rfind(file,".")
        if ext == -1:
            if not probe:
                return 0
            else:
                try:
                    return imghdr.what(file)
                except:
                    return None
        ext = lower(file[ext+1:])
        if ext in self.supported_ext:  # if it is a supported image filetype
            return ext
        if probe:
            try:
                return imghdr.what(file)
            except:
                return 0
        return 0

def binpathfinder(prog):
    """ returns the full path for a program binary"""
    ret = None
    pathvar = os.environ["PATH"]
    for pv in split(pathvar,':'):
        if os.path.exists(pv+os.sep+prog):
            ret = pv+os.sep+prog
            break
        if os.path.exists(pv+prog):
            ret = pv+prog
            break
    return ret

def uniquer(seq, idfun = None):
    """helper function for WriteConfig """
    if idfun is None:
        def idfun(x): return x
    seen = {}
    result = []
    for item in seq:
        marker = idfun(item)
        if marker in seen: continue
        seen[marker] = 1
        result.append(item)
    return result

def LoadConfig(file, config = {}):
    """
    returns a dictionary with key's of the form
    <section>.<option> and the values
    """
    config = config.copy()
    cp = ConfigParser.ConfigParser()
    cp.read(file)
    for sec in cp.sections():
        name = lower(sec)
        for opt in cp.options(sec):
            val = cp.get(sec, opt)
            if type(val) == str:
                val = strip(val)
                if val.lower() == 'true':
                    val = '1'
                if val.lower() == 'false':
                    val = '0'
            config[name + "." + lower(opt)] = val
    return config

def WriteConfig(file, config):
    """
    given a dictionary with key's of the form 'section.option: value'
    write() generates a list of unique section names
    creates sections based that list
    use config.set to add entries to each section
    """
    f= open(file,'w')
    cp = ConfigParser.ConfigParser()
    #a little string hacking because our section names are un-normalized
    #this builds a list of all the sections names
    sectionslst = []
    sections = []
    for k in config.keys():
        sectionslst.append(split(k,".")[0])
    #get unique entries
    sections = uniquer(sectionslst)
    for sec in sections:
        #make the headers
        cp.add_section(sec)
        #for each item in my dictionary
        #it splits the key in two and uses that for the first and second "set" args
        #then it uses the item.value for the 3rd arg
        # from 'section.option:value'
    for k in config.items():
        cp.set(split(k[0],".")[0],split(k[0],".")[1] ,k[1] )
    cp.write(f)
    f.close()
