<?php
/* Grab some default values from the preferred or otherwise default
 * server. */
$server_key = IMP::getAutoLoginServer(true);
$server_value = $servers[$server_key]['server'];
$protocol_value = $servers[$server_key]['protocol'];
$port_value = $servers[$server_key]['port'];
$folders_value = $servers[$server_key]['folders'];
$namespace_value = $servers[$server_key]['namespace'];
$maildomain_value = $servers[$server_key]['maildomain'];
$realm_value = $servers[$server_key]['realm'];

/* Build the <select> widget for the servers and hordeauth servers
 * lists. */
if ($conf['server']['server_list'] == 'shown') {
    $servers_list = '';
    $hordeauth_servers_list = '';

    foreach ($servers as $key => $curServer) {
        $sel = (IMP::isPreferredServer($curServer, $key)) ? ' selected="selected"' : '';
        $servers_option  = "<option value=\"$key\"$sel>";
        $servers_option .= $curServer['name'] . '</option>';

        if (empty($curServer['hordeauth']) || !Auth::isAuthenticated()) {
            $servers_list   .= $servers_option;
        } else {
            if (Auth::isAuthenticated()) {
                $hordeauth_servers_list .= $servers_option;
            }
        }
    }
}

/* Build the <select> widget containing the available languages. */
if (!$prefs->isLocked('language')) {
    $_SESSION['horde_language'] = NLS::select();
    $langs = '';
    foreach ($nls['languages'] as $key => $val) {
        $sel = ($key == $_SESSION['horde_language']) ? ' selected="selected"' : '';
        $langs .= "<option value=\"$key\"$sel>$val</option>";
    }
}
?>

<script language="JavaScript" type="text/javascript">
<!--

function setFocus()
{
    if (document.imp_login.imapuser.value == "") {
        document.imp_login.imapuser.focus();
    } else {
        document.imp_login.pass.focus();
    }
}

<?php if ($conf['server']['server_list'] == 'shown' && !empty($hordeauth_servers_list)): ?>
<?php $reloadurl = Util::addParameter(Horde::selfUrl(), 'autologin', $autologin); ?>
function imp_reload()
{
    window.top.document.location = '<?php echo $reloadurl ?>&server_key=' + document.imp_login.server_key[document.imp_login.server_key.selectedIndex].value;
}
<?php endif; ?>

function submit_login(e)
{
    if (typeof e != 'undefined' && !enter_key_trap(e)) {
        return;
    }

<?php if ($conf['server']['server_list'] == 'shown'): ?>
    if (document.imp_login.server[document.imp_login.server.selectedIndex].value.substr(0, 1) == "_") {
        return false;
    }
<?php endif; ?>
    if (document.imp_login.imapuser.value == "") {
        alert('<?php echo addslashes(_("Please provide your username.")) ?>');
        document.imp_login.imapuser.focus();
        return false;
    } else if (document.imp_login.pass.value == "") {
        alert('<?php echo addslashes(_("Please provide your password.")) ?>');
        document.imp_login.pass.focus();
        return false;
    } else {
        document.imp_login.loginButton.disabled = true;
<?php if (!empty($ie_clientcaps)): ?>
        document.imp_login.ie_version.value = objCCaps.getComponentVersion("{89820200-ECBD-11CF-8B85-00AA005B4383}","componentid");
<?php endif; ?>
        document.imp_login.submit();
        return true;
    }
}
//-->
</script>

<form name="imp_login" action="<?php echo $formAction ?>" method="post"<?php echo $imp_auth ? ' target="_parent"' : '' ?>>
<?php Util::pformInput() ?>
<input type="hidden" name="actionID" value="<?php echo $actionID ?>" />
<input type="hidden" name="url" value="<?php echo htmlspecialchars(Util::getFormData('url')) ?>" />
<input type="hidden" name="mailbox" value="<?php echo $prefs->getValue('mailbox') ?>" />
<input type="hidden" name="load_frameset" value="<?php echo $imp_auth ? 1 : 0 ?>" />
<input type="hidden" name="autologin" value="<?php echo $autologin ? 1 : 0 ?>" />
<?php if (!empty($formData)): ?>
<input type="hidden" name="formData" value="<?php echo htmlspecialchars($formData) ?>" />
<?php endif; ?>
<?php if (!empty($ie_clientcaps)): ?>
<input type="hidden" name="ie_version" value="" />
<?php endif; ?>
<?php $args = IMP::getComposeArgs(); foreach ($args as $arg => $value): ?>
<input type="hidden" name="<?php echo htmlspecialchars($arg) ?>" value="<?php echo htmlspecialchars($value) ?>" />
<?php endforeach; ?>

<div id="menu">
 <span style="float:right">
  <?php
  $menu = &new Menu(HORDE_MENU_MASK_NONE);
  echo $menu->render();
  ?>
 </span>
 <h1 align="center"><?php echo $title ?></h1>
</div>

<br class="spacer" />
<?php $notification->notify(array('listeners' => 'status')) ?>

<table width="100%"><tr><td align="center"><table width="300" align="center">

<?php if (!empty($reason)): ?>
<tr>
  <td colspan="2" class="tooltip"><?php echo $reason ?></td>
</tr>
<?php
endif;

$tabindex = 1;
if ($conf['server']['server_list'] == 'shown' && !empty($hordeauth_servers_list)): ?>
<tr>
  <td align="right" class="light"><b><?php echo _("Server") ?></b></td>
  <td class="light" align="left">
    <select tabindex="<?php echo $tabindex++ ?>" name="server_key" onchange="imp_reload();">
      <?php echo $hordeauth_servers_list ?>
    </select><input tabindex="<?php echo $tabindex++ ?>" type="button" class="button" onclick="imp_reload();" value="<?php echo _("Login") ?>" />
  </td>
</tr>
<?php endif; ?>
<?php if ($conf['server']['server_list'] == 'hidden'): ?>
<tr>
    <td colspan="2"><input type="hidden" name="server" value="<?php echo $server_key ?>" /></td>
</tr>
<?php elseif ($conf['server']['server_list'] == 'shown' && !empty($servers_list)): ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Server") ?></b></td>
    <td class="light" align="left">
        <select tabindex="<?php echo $tabindex++ ?>" name="server"><?php echo $servers_list ?></select>
    </td>
</tr>
<?php elseif ($conf['server']['change_server']): ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Server") ?></b></td>
    <td align="left" class="light">
        <input type="hidden" name="namespace" value="<?php echo $namespace_value ?>" />
        <input type="hidden" name="maildomain" value="<?php echo $maildomain_value ?>" />
        <input type="text" tabindex="3" name="server" value="<?php echo Util::getFormData('server', $server_value) ?>" />
        <?php if ($conf['server']['change_port']): ?>
        <input type="text" size="4" name="port" tabindex="<?php echo $tabindex++ ?>" value="<?php echo Util::getFormData('port', $port_value) ?>" />
        <?php else: ?>
        <input type="hidden" name="port" value="<?php echo $port_value ?>" />
        <?php endif; ?>
        <?php if ($conf['server']['change_protocol']): ?>
        <select tabindex="<?php echo $tabindex++ ?>" name="protocol" onchange="updatePort();">
            <?php $protocol = Util::getFormData('protocol', $protocol_value) ?>
            <option value="imap"<?php if ($protocol == 'imap') echo ' selected="selected"' ?>>IMAP</option>
            <option value="imap/notls"<?php if ($protocol == 'imap/notls') echo ' selected="selected"' ?>><?php echo _("IMAP, no TLS") ?></option>
            <option value="imap/ssl"<?php if ($protocol == 'imap/ssl') echo ' selected="selected"' ?>><?php echo _("IMAP over SSL") ?></option>
            <option value="imap/ssl/novalidate-cert"<?php if ($protocol == 'imap/ssl/novalidate-cert') echo ' selected="selected"' ?>><?php echo _("IMAP over SSL (self-signed)") ?></option>
            <option value="pop3"<?php if ($protocol == 'pop3') echo ' selected="selected"' ?>>POP3</option>
            <option value="pop3/ssl/novalidate-cert"<?php if ($protocol == 'pop3/ssl/novalidate-cert') echo ' selected="selected"' ?>><?php echo _("POP3 over SSL (self-signed)") ?></option>
        </select>
        <?php else: ?>
        <input type="hidden" name="protocol" value="<?php echo $protocol_value ?>" />
        <?php endif; ?>
    </td>
</tr>
<?php else: ?>
<tr>
    <td colspan="2">
        <input type="hidden" name="server" value="<?php echo $server_value ?>" />
        <input type="hidden" name="port" value="<?php echo $port_value ?>" />
        <input type="hidden" name="namespace" value="<?php echo $namespace_value ?>" />
        <input type="hidden" name="maildomain" value="<?php echo $maildomain_value ?>" />
        <input type="hidden" name="protocol" value="<?php echo $protocol_value ?>" />
        <input type="hidden" name="realm" value="<?php echo $realm_value ?>" />
    </td>
</tr>
<?php endif; ?>

<?php if ($conf['server']['change_folders'] && $conf['server']['server_list'] == 'none'): ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Folder Prefix") ?></b></td>
    <td align="left"><input type="text" tabindex="<?php echo $tabindex++ ?>" name="folders" value="<?php echo Util::getFormData('folders', $folders_value) ?>" /></td>
</tr>
<?php else: ?>
<tr>
    <td colspan="2"><input type="hidden" name="folders" value="<?php echo $folders_value ?>" /></td>
</tr>
<?php endif; ?>

<tr>
    <td align="right" class="light"><b><?php echo _("Username") ?></b></td>
    <td align="left" class="light" nowrap="nowrap">
      <input type="text" tabindex="<?php echo $tabindex++ ?>" name="imapuser" value="<?php echo htmlspecialchars(Util::getFormData('imapuser')) ?>" />
    <?php
        if (!empty($conf['hooks']['vinfo'])) {
            @include_once HORDE_BASE . '/config/hooks.php';
            if (function_exists('_imp_hook_vinfo')) { ?>
      <b>@<?php echo call_user_func('_imp_hook_vinfo', 'vdomain') ?></b>
    <?php } } ?>
    </td>
</tr>
<tr>
    <td align="right" class="light"><b><?php echo _("Password") ?></b></td>
    <td align="left"><input type="password" tabindex="<?php echo $tabindex++ ?>" name="pass" /></td>
</tr>

<?php if (!$prefs->isLocked('language')): ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Language") ?></b></td>
    <td align="left" class="light"><select tabindex="<?php echo $tabindex++ ?>" name="new_lang" onchange="selectLang()"><?php echo $langs ?></select>
    </td>
</tr>
<?php endif; ?>

<tr>
    <td>&nbsp;</td>
    <td align="left" class="light"><input type="submit" class="button" name="loginButton" tabindex="<?php echo $tabindex++ ?>" value="<?php echo _("Log in") ?>" onclick="return submit_login();" /></td>
</tr>

<?php if ($conf['signup']['allow'] && isset($auth) && $auth->hasCapability('add')): ?>
<tr>
    <td>&nbsp;</td>
    <td class="light"><?php echo Horde::link(Util::addParameter(Horde::url($registry->get('webroot', 'horde') . '/signup.php'), 'url', Util::getFormData('url')), _("Sign up if not registered"), 'light') . _("Sign up if not registered") ?></a></td>
</tr>
<?php endif; ?>

</table></td></tr></table>
</form>

<script language="JavaScript" type="text/javascript">
<!--

function updatePort()
{
<?php if ($conf['server']['change_port']): ?>
    if (document.imp_login.protocol.options[document.imp_login.protocol.selectedIndex].value == 'imap') {
        document.imp_login.port.value = 143;
    } else if (document.imp_login.protocol.options[document.imp_login.protocol.selectedIndex].value == 'imap/ssl') {
        document.imp_login.port.value = 993;
    } else if (document.imp_login.protocol.options[document.imp_login.protocol.selectedIndex].value == 'imap/ssl/novalidate-cert') {
        document.imp_login.port.value = 993;
    } else if (document.imp_login.protocol.options[document.imp_login.protocol.selectedIndex].value == 'pop3') {
        document.imp_login.port.value = 110;
    } else if (document.imp_login.protocol.options[document.imp_login.protocol.selectedIndex].value == 'pop3/ssl') {
        document.imp_login.port.value = 995;
    } else if (document.imp_login.protocol.options[document.imp_login.protocol.selectedIndex].value == 'pop3/ssl/novalidate-cert') {
        document.imp_login.port.value = 995;
    }
<?php endif; ?>
}

<?php if (!$prefs->isLocked('language')): ?>
function selectLang()
{
    // We need to reload the login page here, but only if the user hasn't
    // already entered a username and password.
    if (document.imp_login.imapuser.value == '' &&
        document.imp_login.pass.value == '') {
        var lang_page = 'login.php?new_lang=' + document.imp_login.new_lang[document.imp_login.new_lang.selectedIndex].value;
<?php
$url = Util::getFormData('url');
if (!empty($url)):
?>
        lang_page += '&url=<?php echo urlencode($url) ?>';
<?php endif; ?>
        self.location = lang_page;
    }
}
<?php endif; ?>

<?php
if ($imp_auth): ?>
if (parent.frames.horde_main) {
    document.imp_login.target = '_parent';
}
<?php endif; ?>
//-->
</script>
<script language="JavaScript1.2" type="text/javascript">
<!--
// Setup the enter keytrap code.
if (window.document.captureEvents != null) {
    window.document.captureEvents(Event.KEYPRESS);
    window.document.onkeypress = submit_login;
}
//-->
</script>
