/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pin-dialog.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <locale.h>

#include "ofono.h"

G_DEFINE_TYPE(PinDialog, pin_dialog, GTK_TYPE_DIALOG);

typedef struct _PinDialogPrivate PinDialogPrivate;

struct _PinDialogPrivate
{
  GtkWidget *entry;
  ask_pin_cb cb;
  gpointer cb_data;
};

#define PIN_DIALOG_GET_PRIVATE(o)					\
  (G_TYPE_INSTANCE_GET_PRIVATE((o), PIN_DIALOG_TYPE, PinDialogPrivate))


static void pin_dialog_init(PinDialog *self)
{
  PinDialogPrivate *priv = PIN_DIALOG_GET_PRIVATE(self);

  priv->entry = NULL;
  priv->cb = NULL;
  priv->cb_data = NULL;

  return;
}

static void pin_dialog_dispose(GObject *object)
{
  G_OBJECT_CLASS(pin_dialog_parent_class)->dispose(object);
}

static void pin_dialog_finalize(GObject *object)
{
  G_OBJECT_CLASS(pin_dialog_parent_class)->finalize(object);
}

static void pin_dialog_class_init(PinDialogClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private(object_class, sizeof(PinDialogPrivate));

  object_class->dispose = pin_dialog_dispose;
  object_class->finalize = pin_dialog_finalize;

  g_assert(klass != NULL);
}

static void responded(GtkDialog *dialog, gint response_id, gpointer user_data)
{
  PinDialog *self = user_data;
  PinDialogPrivate *priv = PIN_DIALOG_GET_PRIVATE(self);
  const gchar *pin;

  g_debug("%s(): response_id %d", __func__, response_id);

  gtk_widget_hide_all(GTK_WIDGET(self));

  if (response_id != GTK_RESPONSE_ACCEPT)
    return;

  pin = gtk_entry_get_text(GTK_ENTRY(priv->entry));

  priv->cb(pin, priv->cb_data);
  priv->cb = NULL;
  priv->cb_data = NULL;
}

void pin_dialog_ask_pin(PinDialog *self, const gchar *type, ask_pin_cb cb,
			gpointer user_data)
{
  PinDialogPrivate *priv = PIN_DIALOG_GET_PRIVATE(self);

  g_debug("%s()", __func__);

  g_return_if_fail(self != NULL);
  g_return_if_fail(priv != NULL);

  priv->cb = cb;
  priv->cb_data = user_data;

  gtk_entry_set_text(GTK_ENTRY(priv->entry), "");

  gtk_widget_show_all(GTK_WIDGET(self));
}

PinDialog *pin_dialog_new(void)
{
  GtkWidget *vbox;
  PinDialogPrivate *priv;
  PinDialog *self;

  self = g_object_new(PIN_DIALOG_TYPE, NULL);
  priv = PIN_DIALOG_GET_PRIVATE(self);

  gtk_window_set_title(GTK_WINDOW(self), _("Modem PIN query"));

  gtk_dialog_add_buttons(GTK_DIALOG(self),
			 GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
			 GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
			 NULL);

  priv->entry = gtk_entry_new();
  vbox = gtk_dialog_get_content_area(GTK_DIALOG(self));
  gtk_box_pack_start(GTK_BOX(vbox), priv->entry, TRUE, TRUE, 5);

  g_signal_connect(G_OBJECT(self), "response", G_CALLBACK(responded),
		   self);

  return self;
}
