/* cellrenderers.c generated by valac 0.11.6, the Vala compiler
 * generated from cellrenderers.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdio.h>


#define TYPE_PIN_CELL_RENDERER (pin_cell_renderer_get_type ())
#define PIN_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_CELL_RENDERER, PinCellRenderer))
#define PIN_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_CELL_RENDERER, PinCellRendererClass))
#define IS_PIN_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_CELL_RENDERER))
#define IS_PIN_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_CELL_RENDERER))
#define PIN_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_CELL_RENDERER, PinCellRendererClass))

typedef struct _PinCellRenderer PinCellRenderer;
typedef struct _PinCellRendererClass PinCellRendererClass;
typedef struct _PinCellRendererPrivate PinCellRendererPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_SIGNAL_STRENGTH_CELL_RENDERER (signal_strength_cell_renderer_get_type ())
#define SIGNAL_STRENGTH_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIGNAL_STRENGTH_CELL_RENDERER, SignalStrengthCellRenderer))
#define SIGNAL_STRENGTH_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIGNAL_STRENGTH_CELL_RENDERER, SignalStrengthCellRendererClass))
#define IS_SIGNAL_STRENGTH_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIGNAL_STRENGTH_CELL_RENDERER))
#define IS_SIGNAL_STRENGTH_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIGNAL_STRENGTH_CELL_RENDERER))
#define SIGNAL_STRENGTH_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIGNAL_STRENGTH_CELL_RENDERER, SignalStrengthCellRendererClass))

typedef struct _SignalStrengthCellRenderer SignalStrengthCellRenderer;
typedef struct _SignalStrengthCellRendererClass SignalStrengthCellRendererClass;
typedef struct _SignalStrengthCellRendererPrivate SignalStrengthCellRendererPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PinCellRenderer {
	GtkCellRenderer parent_instance;
	PinCellRendererPrivate * priv;
};

struct _PinCellRendererClass {
	GtkCellRendererClass parent_class;
};

struct _PinCellRendererPrivate {
	gchar* _color;
};

struct _SignalStrengthCellRenderer {
	GtkCellRenderer parent_instance;
	SignalStrengthCellRendererPrivate * priv;
};

struct _SignalStrengthCellRendererClass {
	GtkCellRendererClass parent_class;
};

struct _SignalStrengthCellRendererPrivate {
	gdouble _strength;
	GtkWidget* style_widget;
	GtkWidget* state_widget;
};


static gpointer pin_cell_renderer_parent_class = NULL;
static gpointer signal_strength_cell_renderer_parent_class = NULL;

#define PI 3.1415926535897931
#define PI_OVER_180 0.017453292519943295
GType pin_cell_renderer_get_type (void) G_GNUC_CONST;
#define PIN_CELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIN_CELL_RENDERER, PinCellRendererPrivate))
enum  {
	PIN_CELL_RENDERER_DUMMY_PROPERTY,
	PIN_CELL_RENDERER_COLOR
};
#define PIN_CELL_RENDERER_RED_FILL "#ef2929"
#define PIN_CELL_RENDERER_RED_STROKE "#a40000"
#define PIN_CELL_RENDERER_GREEN_FILL "#8ae234"
#define PIN_CELL_RENDERER_GREEN_STROKE "#4e9a06"
#define PIN_CELL_RENDERER_YELLOW_FILL "#fce94f"
#define PIN_CELL_RENDERER_YELLOW_STROKE "#c4a000"
#define PIN_CELL_RENDERER_GREY_FILL "#d3d7cf"
#define PIN_CELL_RENDERER_GREY_STROKE "#555753"
#define PIN_CELL_RENDERER_MIN_CELL_WIDTH (8 + (4 * 2))
#define PIN_CELL_RENDERER_MIN_CELL_HEIGHT (8 + (4 * 2))
#define PIN_CELL_RENDERER_PIN_RADIUS 0.5
PinCellRenderer* pin_cell_renderer_new (void);
PinCellRenderer* pin_cell_renderer_construct (GType object_type);
static void pin_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void pin_cell_renderer_real_render (GtkCellRenderer* base, GdkWindow* window, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GdkRectangle* expose_area, GtkCellRendererState flags);
static gfloat pin_cell_renderer_get_lower_dimension (PinCellRenderer* self, gfloat n1, gfloat n2);
const gchar* pin_cell_renderer_get_color (PinCellRenderer* self);
void pin_cell_renderer_set_color (PinCellRenderer* self, const gchar* value);
static void pin_cell_renderer_finalize (GObject* obj);
static void _vala_pin_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_pin_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType signal_strength_cell_renderer_get_type (void) G_GNUC_CONST;
#define SIGNAL_STRENGTH_CELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIGNAL_STRENGTH_CELL_RENDERER, SignalStrengthCellRendererPrivate))
enum  {
	SIGNAL_STRENGTH_CELL_RENDERER_DUMMY_PROPERTY,
	SIGNAL_STRENGTH_CELL_RENDERER_STRENGTH
};
#define SIGNAL_STRENGTH_CELL_RENDERER_MIN_CELL_WIDTH (20 + (5 * 2))
#define SIGNAL_STRENGTH_CELL_RENDERER_MIN_CELL_HEIGHT (8 + (6 * 2))
#define SIGNAL_STRENGTH_CELL_RENDERER_BAR_WIDTH 0.8
#define SIGNAL_STRENGTH_CELL_RENDERER_BAR_HEIGHT 0.45
#define SIGNAL_STRENGTH_CELL_RENDERER_CORNER_RADIUS 3
SignalStrengthCellRenderer* signal_strength_cell_renderer_new (GtkWidget* style_widget, GtkWidget* state_widget);
SignalStrengthCellRenderer* signal_strength_cell_renderer_construct (GType object_type, GtkWidget* style_widget, GtkWidget* state_widget);
static void signal_strength_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void signal_strength_cell_renderer_real_render (GtkCellRenderer* base, GdkWindow* window, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GdkRectangle* expose_area, GtkCellRendererState flags);
static void signal_strength_cell_renderer_draw_rounded_rectangle (SignalStrengthCellRenderer* self, cairo_t* cr, gint x, gint y, gint w, gint h, GdkColor* fill, GdkColor* stroke);
gdouble signal_strength_cell_renderer_get_strength (SignalStrengthCellRenderer* self);
static void signal_strength_cell_renderer_layout_rounded_rectangle (SignalStrengthCellRenderer* self, cairo_t* cr, gint x, gint y, gint w, gint h);
void signal_strength_cell_renderer_set_strength (SignalStrengthCellRenderer* self, gdouble value);
static void signal_strength_cell_renderer_finalize (GObject* obj);
static void _vala_signal_strength_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_signal_strength_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


PinCellRenderer* pin_cell_renderer_construct (GType object_type) {
	PinCellRenderer * self = NULL;
	self = (PinCellRenderer*) g_object_new (object_type, NULL);
	return self;
}


PinCellRenderer* pin_cell_renderer_new (void) {
	return pin_cell_renderer_construct (TYPE_PIN_CELL_RENDERER);
}


static void pin_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	PinCellRenderer * self;
	gint _x_offset = 0;
	gint _y_offset = 0;
	gint _width = 0;
	gint _height = 0;
	self = (PinCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	if ((&_x_offset) != NULL) {
		_x_offset = 0;
	}
	if ((&_y_offset) != NULL) {
		_y_offset = 0;
	}
	if ((&_width) != NULL) {
		_width = PIN_CELL_RENDERER_MIN_CELL_WIDTH;
	}
	if ((&_height) != NULL) {
		_height = PIN_CELL_RENDERER_MIN_CELL_HEIGHT;
	}
	if (x_offset) {
		*x_offset = _x_offset;
	}
	if (y_offset) {
		*y_offset = _y_offset;
	}
	if (width) {
		*width = _width;
	}
	if (height) {
		*height = _height;
	}
}


static void pin_cell_renderer_real_render (GtkCellRenderer* base, GdkWindow* window, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GdkRectangle* expose_area, GtkCellRendererState flags) {
	PinCellRenderer * self;
	cairo_t* _tmp0_ = NULL;
	cairo_t* cr;
	gint x;
	gint y;
	gint width;
	gint height;
	gfloat _tmp1_;
	gfloat lower_dimension;
	gdouble pin_radius;
	gfloat x_offset;
	gfloat y_offset;
	gchar* _tmp2_;
	gchar* stroke_string;
	gchar* _tmp3_;
	gchar* fill_string;
	const gchar* _tmp4_;
	GQuark _tmp5_;
	static GQuark _tmp5__label0 = 0;
	static GQuark _tmp5__label1 = 0;
	static GQuark _tmp5__label2 = 0;
	static GQuark _tmp5__label3 = 0;
	GdkColor stroke = {0};
	GdkColor _tmp22_ = {0};
	GdkColor fill = {0};
	GdkColor _tmp23_ = {0};
	self = (PinCellRenderer*) base;
	g_return_if_fail (window != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gdk_cairo_create ((GdkDrawable*) window);
	cr = _tmp0_;
	x = (*cell_area).x;
	y = (*cell_area).y;
	width = (*cell_area).width;
	height = (*cell_area).height;
	_tmp1_ = pin_cell_renderer_get_lower_dimension (self, (gfloat) width, (gfloat) height);
	lower_dimension = _tmp1_;
	pin_radius = ((gint) lower_dimension) * PIN_CELL_RENDERER_PIN_RADIUS;
	x_offset = (width - lower_dimension) / 2;
	y_offset = (height - lower_dimension) / 2;
	cairo_arc (cr, (x + x_offset) + pin_radius, (y + y_offset) + pin_radius, pin_radius / 2, (gdouble) 0, 2 * G_PI);
	_tmp2_ = g_strdup ("");
	stroke_string = _tmp2_;
	_tmp3_ = g_strdup ("");
	fill_string = _tmp3_;
	_tmp4_ = self->priv->_color;
	_tmp5_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp5_ == ((0 != _tmp5__label0) ? _tmp5__label0 : (_tmp5__label0 = g_quark_from_static_string ("red")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp6_ = g_strdup (PIN_CELL_RENDERER_RED_STROKE);
				_tmp7_ = _tmp6_;
				_g_free0 (stroke_string);
				stroke_string = _tmp7_;
				_tmp8_ = g_strdup (PIN_CELL_RENDERER_RED_FILL);
				_tmp9_ = _tmp8_;
				_g_free0 (fill_string);
				fill_string = _tmp9_;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp5__label1) ? _tmp5__label1 : (_tmp5__label1 = g_quark_from_static_string ("green")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp10_ = g_strdup (PIN_CELL_RENDERER_GREEN_STROKE);
				_tmp11_ = _tmp10_;
				_g_free0 (stroke_string);
				stroke_string = _tmp11_;
				_tmp12_ = g_strdup (PIN_CELL_RENDERER_GREEN_FILL);
				_tmp13_ = _tmp12_;
				_g_free0 (fill_string);
				fill_string = _tmp13_;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp5__label2) ? _tmp5__label2 : (_tmp5__label2 = g_quark_from_static_string ("yellow")))) {
		switch (0) {
			default:
			{
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp14_ = g_strdup (PIN_CELL_RENDERER_YELLOW_STROKE);
				_tmp15_ = _tmp14_;
				_g_free0 (stroke_string);
				stroke_string = _tmp15_;
				_tmp16_ = g_strdup (PIN_CELL_RENDERER_YELLOW_FILL);
				_tmp17_ = _tmp16_;
				_g_free0 (fill_string);
				fill_string = _tmp17_;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp5__label3) ? _tmp5__label3 : (_tmp5__label3 = g_quark_from_static_string ("grey")))) {
		switch (0) {
			default:
			{
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp18_ = g_strdup (PIN_CELL_RENDERER_GREY_STROKE);
				_tmp19_ = _tmp18_;
				_g_free0 (stroke_string);
				stroke_string = _tmp19_;
				_tmp20_ = g_strdup (PIN_CELL_RENDERER_GREY_FILL);
				_tmp21_ = _tmp20_;
				_g_free0 (fill_string);
				fill_string = _tmp21_;
				break;
			}
		}
	}
	memset (&stroke, 0, sizeof (GdkColor));
	gdk_color_parse (stroke_string, &_tmp22_);
	stroke = _tmp22_;
	memset (&fill, 0, sizeof (GdkColor));
	gdk_color_parse (fill_string, &_tmp23_);
	fill = _tmp23_;
	cairo_set_source_rgb (cr, ((gdouble) stroke.red) / 65535.0, ((gdouble) stroke.green) / 65535.0, ((gdouble) stroke.blue) / 65535.0);
	cairo_stroke_preserve (cr);
	cairo_set_source_rgb (cr, ((gdouble) fill.red) / 65535.0, ((gdouble) fill.green) / 65535.0, ((gdouble) fill.blue) / 65535.0);
	cairo_fill (cr);
	_g_free0 (fill_string);
	_g_free0 (stroke_string);
	_cairo_destroy0 (cr);
}


static gfloat pin_cell_renderer_get_lower_dimension (PinCellRenderer* self, gfloat n1, gfloat n2) {
	gfloat result = 0.0F;
	g_return_val_if_fail (self != NULL, 0.0F);
	if (n1 > n2) {
		result = n2;
		return result;
	}
	result = n1;
	return result;
}


const gchar* pin_cell_renderer_get_color (PinCellRenderer* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_color;
	return result;
}


void pin_cell_renderer_set_color (PinCellRenderer* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_color);
	self->priv->_color = _tmp1_;
	g_object_notify ((GObject *) self, "color");
}


static void pin_cell_renderer_class_init (PinCellRendererClass * klass) {
	pin_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PinCellRendererPrivate));
	GTK_CELL_RENDERER_CLASS (klass)->get_size = pin_cell_renderer_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = pin_cell_renderer_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_pin_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pin_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = pin_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PIN_CELL_RENDERER_COLOR, g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void pin_cell_renderer_instance_init (PinCellRenderer * self) {
	self->priv = PIN_CELL_RENDERER_GET_PRIVATE (self);
}


static void pin_cell_renderer_finalize (GObject* obj) {
	PinCellRenderer * self;
	self = PIN_CELL_RENDERER (obj);
	_g_free0 (self->priv->_color);
	G_OBJECT_CLASS (pin_cell_renderer_parent_class)->finalize (obj);
}


GType pin_cell_renderer_get_type (void) {
	static volatile gsize pin_cell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&pin_cell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PinCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pin_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PinCellRenderer), 0, (GInstanceInitFunc) pin_cell_renderer_instance_init, NULL };
		GType pin_cell_renderer_type_id;
		pin_cell_renderer_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "PinCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&pin_cell_renderer_type_id__volatile, pin_cell_renderer_type_id);
	}
	return pin_cell_renderer_type_id__volatile;
}


static void _vala_pin_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PinCellRenderer * self;
	self = PIN_CELL_RENDERER (object);
	switch (property_id) {
		case PIN_CELL_RENDERER_COLOR:
		g_value_set_string (value, pin_cell_renderer_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_pin_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PinCellRenderer * self;
	self = PIN_CELL_RENDERER (object);
	switch (property_id) {
		case PIN_CELL_RENDERER_COLOR:
		pin_cell_renderer_set_color (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SignalStrengthCellRenderer* signal_strength_cell_renderer_construct (GType object_type, GtkWidget* style_widget, GtkWidget* state_widget) {
	SignalStrengthCellRenderer * self = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_val_if_fail (style_widget != NULL, NULL);
	g_return_val_if_fail (state_widget != NULL, NULL);
	self = (SignalStrengthCellRenderer*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (style_widget);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->style_widget);
	self->priv->style_widget = _tmp1_;
	_tmp2_ = _g_object_ref0 (state_widget);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->state_widget);
	self->priv->state_widget = _tmp3_;
	return self;
}


SignalStrengthCellRenderer* signal_strength_cell_renderer_new (GtkWidget* style_widget, GtkWidget* state_widget) {
	return signal_strength_cell_renderer_construct (TYPE_SIGNAL_STRENGTH_CELL_RENDERER, style_widget, state_widget);
}


static void signal_strength_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	SignalStrengthCellRenderer * self;
	gint _x_offset = 0;
	gint _y_offset = 0;
	gint _width = 0;
	gint _height = 0;
	self = (SignalStrengthCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	if ((&_x_offset) != NULL) {
		_x_offset = 0;
	}
	if ((&_y_offset) != NULL) {
		_y_offset = 0;
	}
	if ((&_width) != NULL) {
		_width = SIGNAL_STRENGTH_CELL_RENDERER_MIN_CELL_WIDTH;
	}
	if ((&_height) != NULL) {
		_height = SIGNAL_STRENGTH_CELL_RENDERER_MIN_CELL_HEIGHT;
	}
	if (x_offset) {
		*x_offset = _x_offset;
	}
	if (y_offset) {
		*y_offset = _y_offset;
	}
	if (width) {
		*width = _width;
	}
	if (height) {
		*height = _height;
	}
}


static void signal_strength_cell_renderer_real_render (GtkCellRenderer* base, GdkWindow* window, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GdkRectangle* expose_area, GtkCellRendererState flags) {
	SignalStrengthCellRenderer * self;
	cairo_t* _tmp0_ = NULL;
	cairo_t* cr;
	gint x;
	gint y;
	gint width;
	gint height;
	gint bar_width;
	gint bar_height;
	gint x_offset;
	gint y_offset;
	guchar state;
	GtkStyle* _tmp1_ = NULL;
	GdkColor bg_fill;
	GtkStyle* _tmp2_ = NULL;
	GdkColor bg_stroke;
	GtkStyle* _tmp3_ = NULL;
	GdkColor fg_fill;
	GtkStyle* _tmp4_ = NULL;
	GdkColor fg_stroke;
	self = (SignalStrengthCellRenderer*) base;
	g_return_if_fail (window != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gdk_cairo_create ((GdkDrawable*) window);
	cr = _tmp0_;
	x = (gint) (*cell_area).x;
	y = (gint) (*cell_area).y;
	width = (gint) (*cell_area).width;
	height = (gint) (*cell_area).height;
	bar_width = (gint) (width * SIGNAL_STRENGTH_CELL_RENDERER_BAR_WIDTH);
	bar_height = (gint) (height * SIGNAL_STRENGTH_CELL_RENDERER_BAR_HEIGHT);
	x_offset = (gint) ((width - bar_width) / 2);
	y_offset = (gint) ((height - bar_height) / 2);
	state = self->priv->state_widget->state;
	_tmp1_ = gtk_widget_get_style (self->priv->style_widget);
	bg_fill = _tmp1_->bg[state];
	_tmp2_ = gtk_widget_get_style (self->priv->style_widget);
	bg_stroke = _tmp2_->dark[state];
	_tmp3_ = gtk_widget_get_style (self->priv->style_widget);
	fg_fill = _tmp3_->mid[state];
	_tmp4_ = gtk_widget_get_style (self->priv->style_widget);
	fg_stroke = _tmp4_->dark[state];
	signal_strength_cell_renderer_draw_rounded_rectangle (self, cr, x + x_offset, y + y_offset, (x + x_offset) + bar_width, (y + y_offset) + bar_height, &bg_fill, &bg_stroke);
	if (self->priv->_strength == 0) {
		fprintf (stdout, "strength = 0\n\n");
	}
	signal_strength_cell_renderer_draw_rounded_rectangle (self, cr, x + x_offset, y + y_offset, (x + x_offset) + ((gint) (bar_width * self->priv->_strength)), (y + y_offset) + bar_height, &fg_fill, &fg_stroke);
	_cairo_destroy0 (cr);
}


static void signal_strength_cell_renderer_draw_rounded_rectangle (SignalStrengthCellRenderer* self, cairo_t* cr, gint x, gint y, gint w, gint h, GdkColor* fill, GdkColor* stroke) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	signal_strength_cell_renderer_layout_rounded_rectangle (self, cr, x, y, w, h);
	cairo_set_source_rgb (cr, ((gdouble) (*stroke).red) / 65535.0, ((gdouble) (*stroke).green) / 65535.0, ((gdouble) (*stroke).blue) / 65535.0);
	cairo_stroke_preserve (cr);
	cairo_set_source_rgb (cr, ((gdouble) (*fill).red) / 65535.0, ((gdouble) (*fill).green) / 65535.0, ((gdouble) (*fill).blue) / 65535.0);
	cairo_fill (cr);
}


static void signal_strength_cell_renderer_layout_rounded_rectangle (SignalStrengthCellRenderer* self, cairo_t* cr, gint x, gint y, gint w, gint h) {
	gint r;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	r = SIGNAL_STRENGTH_CELL_RENDERER_CORNER_RADIUS;
	cairo_new_sub_path (cr);
	cairo_arc (cr, (gdouble) (r + x), (gdouble) (r + y), (gdouble) r, PI, 270 * PI_OVER_180);
	cairo_arc (cr, (gdouble) (w - r), (gdouble) (r + y), (gdouble) r, 270 * PI_OVER_180, (gdouble) 0);
	cairo_arc (cr, (gdouble) (w - r), (gdouble) (h - r), (gdouble) r, (gdouble) 0, 90 * PI_OVER_180);
	cairo_arc (cr, (gdouble) (r + x), (gdouble) (h - r), (gdouble) r, 90 * PI_OVER_180, PI);
	cairo_close_path (cr);
}


gdouble signal_strength_cell_renderer_get_strength (SignalStrengthCellRenderer* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_strength;
	return result;
}


void signal_strength_cell_renderer_set_strength (SignalStrengthCellRenderer* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_strength = value;
	g_object_notify ((GObject *) self, "strength");
}


static void signal_strength_cell_renderer_class_init (SignalStrengthCellRendererClass * klass) {
	signal_strength_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SignalStrengthCellRendererPrivate));
	GTK_CELL_RENDERER_CLASS (klass)->get_size = signal_strength_cell_renderer_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = signal_strength_cell_renderer_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_signal_strength_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_signal_strength_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = signal_strength_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIGNAL_STRENGTH_CELL_RENDERER_STRENGTH, g_param_spec_double ("strength", "strength", "strength", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void signal_strength_cell_renderer_instance_init (SignalStrengthCellRenderer * self) {
	self->priv = SIGNAL_STRENGTH_CELL_RENDERER_GET_PRIVATE (self);
}


static void signal_strength_cell_renderer_finalize (GObject* obj) {
	SignalStrengthCellRenderer * self;
	self = SIGNAL_STRENGTH_CELL_RENDERER (obj);
	_g_object_unref0 (self->priv->style_widget);
	_g_object_unref0 (self->priv->state_widget);
	G_OBJECT_CLASS (signal_strength_cell_renderer_parent_class)->finalize (obj);
}


GType signal_strength_cell_renderer_get_type (void) {
	static volatile gsize signal_strength_cell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&signal_strength_cell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SignalStrengthCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) signal_strength_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SignalStrengthCellRenderer), 0, (GInstanceInitFunc) signal_strength_cell_renderer_instance_init, NULL };
		GType signal_strength_cell_renderer_type_id;
		signal_strength_cell_renderer_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "SignalStrengthCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&signal_strength_cell_renderer_type_id__volatile, signal_strength_cell_renderer_type_id);
	}
	return signal_strength_cell_renderer_type_id__volatile;
}


static void _vala_signal_strength_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SignalStrengthCellRenderer * self;
	self = SIGNAL_STRENGTH_CELL_RENDERER (object);
	switch (property_id) {
		case SIGNAL_STRENGTH_CELL_RENDERER_STRENGTH:
		g_value_set_double (value, signal_strength_cell_renderer_get_strength (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_signal_strength_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SignalStrengthCellRenderer * self;
	self = SIGNAL_STRENGTH_CELL_RENDERER (object);
	switch (property_id) {
		case SIGNAL_STRENGTH_CELL_RENDERER_STRENGTH:
		signal_strength_cell_renderer_set_strength (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



