/* wireless.c generated by valac 0.11.6, the Vala compiler
 * generated from wireless.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <connman-manager.h>
#include <float.h>
#include <math.h>
#include <connman-service.h>


#define TYPE_DEVICE_BOX (device_box_get_type ())
#define DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE_BOX, DeviceBox))
#define DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE_BOX, DeviceBoxClass))
#define IS_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE_BOX))
#define IS_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE_BOX))
#define DEVICE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE_BOX, DeviceBoxClass))

typedef struct _DeviceBox DeviceBox;
typedef struct _DeviceBoxClass DeviceBoxClass;
typedef struct _DeviceBoxPrivate DeviceBoxPrivate;

#define TYPE_WIRELESS_BOX (wireless_box_get_type ())
#define WIRELESS_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRELESS_BOX, WirelessBox))
#define WIRELESS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRELESS_BOX, WirelessBoxClass))
#define IS_WIRELESS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRELESS_BOX))
#define IS_WIRELESS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRELESS_BOX))
#define WIRELESS_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRELESS_BOX, WirelessBoxClass))

typedef struct _WirelessBox WirelessBox;
typedef struct _WirelessBoxClass WirelessBoxClass;
typedef struct _WirelessBoxPrivate WirelessBoxPrivate;

#define TYPE_INFO_BOX (info_box_get_type ())
#define INFO_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INFO_BOX, InfoBox))
#define INFO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INFO_BOX, InfoBoxClass))
#define IS_INFO_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INFO_BOX))
#define IS_INFO_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INFO_BOX))
#define INFO_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INFO_BOX, InfoBoxClass))

typedef struct _InfoBox InfoBox;
typedef struct _InfoBoxClass InfoBoxClass;

#define TYPE_TOGGLE_SWITCH (toggle_switch_get_type ())
#define TOGGLE_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_SWITCH, ToggleSwitch))
#define TOGGLE_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_SWITCH, ToggleSwitchClass))
#define IS_TOGGLE_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_SWITCH))
#define IS_TOGGLE_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_SWITCH))
#define TOGGLE_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_SWITCH, ToggleSwitchClass))

typedef struct _ToggleSwitch ToggleSwitch;
typedef struct _ToggleSwitchClass ToggleSwitchClass;

#define TYPE_WIRELESS_CONNECTION_VIEW (wireless_connection_view_get_type ())
#define WIRELESS_CONNECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRELESS_CONNECTION_VIEW, WirelessConnectionView))
#define WIRELESS_CONNECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRELESS_CONNECTION_VIEW, WirelessConnectionViewClass))
#define IS_WIRELESS_CONNECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRELESS_CONNECTION_VIEW))
#define IS_WIRELESS_CONNECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRELESS_CONNECTION_VIEW))
#define WIRELESS_CONNECTION_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRELESS_CONNECTION_VIEW, WirelessConnectionViewClass))

typedef struct _WirelessConnectionView WirelessConnectionView;
typedef struct _WirelessConnectionViewClass WirelessConnectionViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_WIRELESS_CONNECTION_STORE (wireless_connection_store_get_type ())
#define WIRELESS_CONNECTION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRELESS_CONNECTION_STORE, WirelessConnectionStore))
#define WIRELESS_CONNECTION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRELESS_CONNECTION_STORE, WirelessConnectionStoreClass))
#define IS_WIRELESS_CONNECTION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRELESS_CONNECTION_STORE))
#define IS_WIRELESS_CONNECTION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRELESS_CONNECTION_STORE))
#define WIRELESS_CONNECTION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRELESS_CONNECTION_STORE, WirelessConnectionStoreClass))

typedef struct _WirelessConnectionStore WirelessConnectionStore;
typedef struct _WirelessConnectionStoreClass WirelessConnectionStoreClass;

#define TYPE_EDIT_CONNECTION_DIALOG (edit_connection_dialog_get_type ())
#define EDIT_CONNECTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialog))
#define EDIT_CONNECTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialogClass))
#define IS_EDIT_CONNECTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDIT_CONNECTION_DIALOG))
#define IS_EDIT_CONNECTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDIT_CONNECTION_DIALOG))
#define EDIT_CONNECTION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialogClass))

typedef struct _EditConnectionDialog EditConnectionDialog;
typedef struct _EditConnectionDialogClass EditConnectionDialogClass;

struct _DeviceBox {
	GtkVBox parent_instance;
	DeviceBoxPrivate * priv;
};

struct _DeviceBoxClass {
	GtkVBoxClass parent_class;
};

struct _WirelessBox {
	DeviceBox parent_instance;
	WirelessBoxPrivate * priv;
};

struct _WirelessBoxClass {
	DeviceBoxClass parent_class;
};

struct _WirelessBoxPrivate {
	gchar* datadir;
	ConnmanManager* connman;
	InfoBox* infobox;
	ToggleSwitch* toggleswitch;
	GtkLabel* label_status;
	GtkBuilder* builder;
	WirelessConnectionView* treeview_connections;
	GtkVBox* vbox_connections;
	GtkButton* button_connect;
	GtkButton* button_forget;
	GtkButton* button_edit;
	GtkScrolledWindow* scrolledwindow_connections;
};


static gpointer wireless_box_parent_class = NULL;

GType device_box_get_type (void) G_GNUC_CONST;
GType wireless_box_get_type (void) G_GNUC_CONST;
GType info_box_get_type (void) G_GNUC_CONST;
GType toggle_switch_get_type (void) G_GNUC_CONST;
GType wireless_connection_view_get_type (void) G_GNUC_CONST;
#define WIRELESS_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WIRELESS_BOX, WirelessBoxPrivate))
enum  {
	WIRELESS_BOX_DUMMY_PROPERTY
};
WirelessBox* wireless_box_new (ConnmanManager* connman, const gchar* datadir);
WirelessBox* wireless_box_construct (GType object_type, ConnmanManager* connman, const gchar* datadir);
DeviceBox* device_box_construct (GType object_type);
static void wireless_box_wifi_state_changed (WirelessBox* self, GParamSpec* p);
static void _wireless_box_wifi_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
InfoBox* info_box_new (gboolean homogeneous, gint spacing);
InfoBox* info_box_construct (GType object_type, gboolean homogeneous, gint spacing);
ToggleSwitch* toggle_switch_new (void);
ToggleSwitch* toggle_switch_construct (GType object_type);
static void wireless_box_on_toggleswitch_toggled (WirelessBox* self);
static void _wireless_box_on_toggleswitch_toggled_toggle_switch_toggled (ToggleSwitch* _sender, gpointer self);
GtkBuilder* utils_gui_new_builder (const gchar* path);
static void wireless_box_get_widgets (WirelessBox* self);
static void wireless_box_connect_signals (WirelessBox* self);
WirelessConnectionStore* wireless_connection_store_new (void);
WirelessConnectionStore* wireless_connection_store_construct (GType object_type);
GType wireless_connection_store_get_type (void) G_GNUC_CONST;
WirelessConnectionView* wireless_connection_view_new (WirelessConnectionStore* store, GtkWidget* style_widget);
WirelessConnectionView* wireless_connection_view_construct (GType object_type, WirelessConnectionStore* store, GtkWidget* style_widget);
static void wireless_box_on_treeview_connections_selection_changed (WirelessBox* self);
static void _wireless_box_on_treeview_connections_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static ConnmanService** _vala_array_dup4 (ConnmanService** self, int length);
static void wireless_box_add_service (WirelessBox* self, ConnmanService* service);
static void wireless_box_update_widget_states (WirelessBox* self, ConnmanTechnologyState state);
static void wireless_box_on_button_connect_clicked (WirelessBox* self);
static void _wireless_box_on_button_connect_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void wireless_box_on_button_edit_clicked (WirelessBox* self);
static void _wireless_box_on_button_edit_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void toggle_switch_set_active (ToggleSwitch* self, gboolean active);
void wireless_connection_store_add_service (WirelessConnectionStore* self, ConnmanService* service, const gchar* network, gdouble signal, const gchar* last_used);
gboolean toggle_switch_get_active (ToggleSwitch* self);
ConnmanService* wireless_connection_view_get_selected_connection (WirelessConnectionView* self);
EditConnectionDialog* edit_connection_dialog_new (ConnmanService* connection, const gchar* datadir);
EditConnectionDialog* edit_connection_dialog_construct (GType object_type, ConnmanService* connection, const gchar* datadir);
GType edit_connection_dialog_get_type (void) G_GNUC_CONST;
gint edit_connection_dialog_run (EditConnectionDialog* self);
static void wireless_box_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _wireless_box_wifi_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	wireless_box_wifi_state_changed (self, pspec);
}


static void _wireless_box_on_toggleswitch_toggled_toggle_switch_toggled (ToggleSwitch* _sender, gpointer self) {
	wireless_box_on_toggleswitch_toggled (self);
}


static void _wireless_box_on_treeview_connections_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	wireless_box_on_treeview_connections_selection_changed (self);
}


static ConnmanService** _vala_array_dup4 (ConnmanService** self, int length) {
	ConnmanService** result;
	int i;
	result = g_new0 (ConnmanService*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


WirelessBox* wireless_box_construct (GType object_type, ConnmanManager* connman, const gchar* datadir) {
	WirelessBox * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	ConnmanManager* _tmp2_;
	ConnmanManager* _tmp3_;
	InfoBox* _tmp4_ = NULL;
	InfoBox* _tmp5_;
	ToggleSwitch* _tmp6_ = NULL;
	ToggleSwitch* _tmp7_;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	gchar* _tmp10_;
	GtkBuilder* _tmp11_ = NULL;
	GtkBuilder* _tmp12_;
	WirelessConnectionStore* _tmp13_ = NULL;
	WirelessConnectionStore* connection_store;
	WirelessConnectionView* _tmp14_ = NULL;
	WirelessConnectionView* _tmp15_;
	GtkTreeSelection* _tmp16_ = NULL;
	ConnmanService** _tmp17_;
	ConnmanService** _tmp18_ = NULL;
	ConnmanService** _tmp19_;
	ConnmanService** _tmp20_;
	ConnmanService** services;
	gint services_length1;
	gint _services_size_;
	ConnmanTechnologyState _tmp23_;
	g_return_val_if_fail (connman != NULL, NULL);
	g_return_val_if_fail (datadir != NULL, NULL);
	self = (WirelessBox*) device_box_construct (object_type);
	gtk_box_set_spacing ((GtkBox*) self, 12);
	_tmp0_ = g_strdup (datadir);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->datadir);
	self->priv->datadir = _tmp1_;
	_tmp2_ = _g_object_ref0 (connman);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->connman);
	self->priv->connman = _tmp3_;
	g_signal_connect_object ((GObject*) self->priv->connman, "notify::wifi-state", (GCallback) _wireless_box_wifi_state_changed_g_object_notify, self, 0);
	_tmp4_ = info_box_new (FALSE, 12);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->infobox);
	self->priv->infobox = _tmp5_;
	_tmp6_ = toggle_switch_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->toggleswitch);
	self->priv->toggleswitch = _tmp7_;
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->label_status);
	self->priv->label_status = _tmp9_;
	gtk_misc_set_alignment ((GtkMisc*) self->priv->label_status, (gfloat) 0, 0.5f);
	gtk_container_set_border_width ((GtkContainer*) self->priv->infobox, (guint) 10);
	gtk_box_pack_start ((GtkBox*) self->priv->infobox, (GtkWidget*) self->priv->label_status, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->infobox, (GtkWidget*) self->priv->toggleswitch, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->infobox, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (self->priv->toggleswitch, "toggled", (GCallback) _wireless_box_on_toggleswitch_toggled_toggle_switch_toggled, self, 0);
	_tmp10_ = g_strconcat (datadir, "ui/wireless_box.ui", NULL);
	_tmp11_ = utils_gui_new_builder (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp12_;
	_g_free0 (_tmp10_);
	wireless_box_get_widgets (self);
	wireless_box_connect_signals (self);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->vbox_connections, TRUE, TRUE, (guint) 0);
	_tmp13_ = wireless_connection_store_new ();
	connection_store = _tmp13_;
	_tmp14_ = wireless_connection_view_new (connection_store, (GtkWidget*) self->priv->button_connect);
	_tmp15_ = g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->treeview_connections);
	self->priv->treeview_connections = _tmp15_;
	gtk_container_add ((GtkContainer*) self->priv->scrolledwindow_connections, (GtkWidget*) self->priv->treeview_connections);
	_tmp16_ = gtk_tree_view_get_selection ((GtkTreeView*) self->priv->treeview_connections);
	g_signal_connect_object (_tmp16_, "changed", (GCallback) _wireless_box_on_treeview_connections_selection_changed_gtk_tree_selection_changed, self, 0);
	_tmp18_ = _tmp17_ = connman_manager_get_services (connman);
	_tmp19_ = (_tmp20_ = _tmp18_, (_tmp20_ == NULL) ? ((gpointer) _tmp20_) : _vala_array_dup4 (_tmp20_, _vala_array_length (_tmp17_)));
	services = _tmp19_;
	services_length1 = _vala_array_length (_tmp17_);
	_services_size_ = _vala_array_length (_tmp17_);
	{
		ConnmanService** service_collection;
		int service_collection_length1;
		int service_it;
		service_collection = services;
		service_collection_length1 = services_length1;
		for (service_it = 0; service_it < services_length1; service_it = service_it + 1) {
			ConnmanService* _tmp21_;
			ConnmanService* service;
			_tmp21_ = _g_object_ref0 (service_collection[service_it]);
			service = _tmp21_;
			{
				ConnmanServiceType _tmp22_;
				_tmp22_ = connman_service_get_service_type (service);
				if (_tmp22_ == CONNMAN_SERVICE_TYPE_WIFI) {
					wireless_box_add_service (self, service);
				}
				_g_object_unref0 (service);
			}
		}
	}
	_tmp23_ = connman_manager_get_wifi_state (self->priv->connman);
	wireless_box_update_widget_states (self, _tmp23_);
	wireless_box_on_treeview_connections_selection_changed (self);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (connection_store);
	return self;
}


WirelessBox* wireless_box_new (ConnmanManager* connman, const gchar* datadir) {
	return wireless_box_construct (TYPE_WIRELESS_BOX, connman, datadir);
}


static void wireless_box_get_widgets (WirelessBox* self) {
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_;
	GtkVBox* _tmp2_;
	GtkVBox* _tmp3_;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GObject* _tmp12_ = NULL;
	GObject* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GObject* _tmp16_ = NULL;
	GObject* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GtkScrolledWindow* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "vbox_connections");
	_tmp2_ = _g_object_ref0 ((_tmp1_ = _tmp0_, GTK_IS_VBOX (_tmp1_) ? ((GtkVBox*) _tmp1_) : NULL));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->vbox_connections);
	self->priv->vbox_connections = _tmp3_;
	_tmp4_ = gtk_builder_get_object (self->priv->builder, "button_connect");
	_tmp6_ = _g_object_ref0 ((_tmp5_ = _tmp4_, GTK_IS_BUTTON (_tmp5_) ? ((GtkButton*) _tmp5_) : NULL));
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->button_connect);
	self->priv->button_connect = _tmp7_;
	_tmp8_ = gtk_builder_get_object (self->priv->builder, "button_forget");
	_tmp10_ = _g_object_ref0 ((_tmp9_ = _tmp8_, GTK_IS_BUTTON (_tmp9_) ? ((GtkButton*) _tmp9_) : NULL));
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->priv->button_forget);
	self->priv->button_forget = _tmp11_;
	_tmp12_ = gtk_builder_get_object (self->priv->builder, "button_edit");
	_tmp14_ = _g_object_ref0 ((_tmp13_ = _tmp12_, GTK_IS_BUTTON (_tmp13_) ? ((GtkButton*) _tmp13_) : NULL));
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->button_edit);
	self->priv->button_edit = _tmp15_;
	_tmp16_ = gtk_builder_get_object (self->priv->builder, "scrolledwindow_connections");
	_tmp18_ = _g_object_ref0 ((_tmp17_ = _tmp16_, GTK_IS_SCROLLED_WINDOW (_tmp17_) ? ((GtkScrolledWindow*) _tmp17_) : NULL));
	_tmp19_ = _tmp18_;
	_g_object_unref0 (self->priv->scrolledwindow_connections);
	self->priv->scrolledwindow_connections = _tmp19_;
}


static void _wireless_box_on_button_connect_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	wireless_box_on_button_connect_clicked (self);
}


static void _wireless_box_on_button_edit_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	wireless_box_on_button_edit_clicked (self);
}


static void wireless_box_connect_signals (WirelessBox* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->priv->button_connect, "clicked", (GCallback) _wireless_box_on_button_connect_clicked_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->button_edit, "clicked", (GCallback) _wireless_box_on_button_edit_clicked_gtk_button_clicked, self, 0);
}


static void wireless_box_update_widget_states (WirelessBox* self, ConnmanTechnologyState state) {
	gboolean device_editable;
	gboolean settings_editable;
	gboolean toggleswitch_state;
	gchar* _tmp0_;
	gchar* status_text;
	g_return_if_fail (self != NULL);
	device_editable = FALSE;
	settings_editable = FALSE;
	toggleswitch_state = FALSE;
	_tmp0_ = g_strdup ("");
	status_text = _tmp0_;
	switch (state) {
		case CONNMAN_TECHNOLOGY_STATE_ENABLED:
		{
			gchar* _tmp1_;
			gchar* _tmp2_;
			device_editable = TRUE;
			settings_editable = TRUE;
			toggleswitch_state = TRUE;
			_tmp1_ = g_strdup ("Wi-fi is on but not connected to the Internet.");
			_tmp2_ = _tmp1_;
			_g_free0 (status_text);
			status_text = _tmp2_;
			break;
		}
		case CONNMAN_TECHNOLOGY_STATE_CONNECTED:
		{
			gchar* _tmp3_;
			gchar* _tmp4_;
			device_editable = TRUE;
			settings_editable = TRUE;
			toggleswitch_state = TRUE;
			_tmp3_ = g_strdup ("Wi-fi is on and connected to the Internet.");
			_tmp4_ = _tmp3_;
			_g_free0 (status_text);
			status_text = _tmp4_;
			break;
		}
		case CONNMAN_TECHNOLOGY_STATE_AVAILABLE:
		{
			gchar* _tmp5_;
			gchar* _tmp6_;
			device_editable = TRUE;
			settings_editable = FALSE;
			toggleswitch_state = FALSE;
			_tmp5_ = g_strdup ("The Wi-fi device is powered off.");
			_tmp6_ = _tmp5_;
			_g_free0 (status_text);
			status_text = _tmp6_;
			break;
		}
		case CONNMAN_TECHNOLOGY_STATE_OFFLINE:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			device_editable = TRUE;
			settings_editable = FALSE;
			toggleswitch_state = FALSE;
			_tmp7_ = g_strdup ("Wi-fi is offline.");
			_tmp8_ = _tmp7_;
			_g_free0 (status_text);
			status_text = _tmp8_;
			break;
		}
		default:
		break;
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->vbox_connections, settings_editable);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->toggleswitch, device_editable);
	toggle_switch_set_active (self->priv->toggleswitch, toggleswitch_state);
	gtk_label_set_text (self->priv->label_status, status_text);
	_g_free0 (status_text);
}


static void wireless_box_add_service (WirelessBox* self, ConnmanService* service) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* name;
	guint _tmp2_;
	gfloat signal;
	gchar* _tmp3_;
	gchar* last_used;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_;
	WirelessConnectionStore* _tmp6_;
	WirelessConnectionStore* liststore;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	_tmp0_ = connman_service_get_name (service);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp2_ = connman_service_get_strength (service);
	signal = ((gfloat) _tmp2_) / 100;
	_tmp3_ = g_strdup ("N/A");
	last_used = _tmp3_;
	_tmp4_ = gtk_tree_view_get_model ((GtkTreeView*) self->priv->treeview_connections);
	_tmp6_ = _g_object_ref0 ((_tmp5_ = _tmp4_, IS_WIRELESS_CONNECTION_STORE (_tmp5_) ? ((WirelessConnectionStore*) _tmp5_) : NULL));
	liststore = _tmp6_;
	wireless_connection_store_add_service (liststore, service, name, (gdouble) signal, last_used);
	_g_object_unref0 (liststore);
	_g_free0 (last_used);
	_g_free0 (name);
}


static void wireless_box_wifi_state_changed (WirelessBox* self, GParamSpec* p) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_wifi_state (self->priv->connman);
	wireless_box_update_widget_states (self, _tmp0_);
}


static void wireless_box_on_toggleswitch_toggled (WirelessBox* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = toggle_switch_get_active (self->priv->toggleswitch);
	if (_tmp0_) {
		connman_manager_enable_technology (self->priv->connman, CONNMAN_TECHNOLOGY_TYPE_WIFI, NULL, NULL, NULL);
	} else {
		connman_manager_disable_technology (self->priv->connman, CONNMAN_TECHNOLOGY_TYPE_WIFI, NULL, NULL, NULL);
	}
}


static void wireless_box_on_button_connect_clicked (WirelessBox* self) {
	g_return_if_fail (self != NULL);
}


static void wireless_box_on_button_edit_clicked (WirelessBox* self) {
	ConnmanService* _tmp0_ = NULL;
	ConnmanService* connection;
	EditConnectionDialog* _tmp1_ = NULL;
	EditConnectionDialog* dialog;
	g_return_if_fail (self != NULL);
	_tmp0_ = wireless_connection_view_get_selected_connection (self->priv->treeview_connections);
	connection = _tmp0_;
	_tmp1_ = edit_connection_dialog_new (connection, self->priv->datadir);
	dialog = _tmp1_;
	edit_connection_dialog_run (dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (connection);
}


static void wireless_box_on_treeview_connections_selection_changed (WirelessBox* self) {
	ConnmanService* _tmp0_ = NULL;
	ConnmanService* _tmp1_;
	gboolean _tmp2_;
	gboolean path_is_selected;
	g_return_if_fail (self != NULL);
	_tmp0_ = wireless_connection_view_get_selected_connection (self->priv->treeview_connections);
	_tmp1_ = _tmp0_;
	path_is_selected = (_tmp2_ = _tmp1_ != NULL, _g_object_unref0 (_tmp1_), _tmp2_);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_connect, path_is_selected);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_forget, path_is_selected);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_edit, path_is_selected);
}


static void wireless_box_class_init (WirelessBoxClass * klass) {
	wireless_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (WirelessBoxPrivate));
	G_OBJECT_CLASS (klass)->finalize = wireless_box_finalize;
}


static void wireless_box_instance_init (WirelessBox * self) {
	self->priv = WIRELESS_BOX_GET_PRIVATE (self);
}


static void wireless_box_finalize (GObject* obj) {
	WirelessBox * self;
	self = WIRELESS_BOX (obj);
	_g_free0 (self->priv->datadir);
	_g_object_unref0 (self->priv->connman);
	_g_object_unref0 (self->priv->infobox);
	_g_object_unref0 (self->priv->toggleswitch);
	_g_object_unref0 (self->priv->label_status);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->treeview_connections);
	_g_object_unref0 (self->priv->vbox_connections);
	_g_object_unref0 (self->priv->button_connect);
	_g_object_unref0 (self->priv->button_forget);
	_g_object_unref0 (self->priv->button_edit);
	_g_object_unref0 (self->priv->scrolledwindow_connections);
	G_OBJECT_CLASS (wireless_box_parent_class)->finalize (obj);
}


GType wireless_box_get_type (void) {
	static volatile gsize wireless_box_type_id__volatile = 0;
	if (g_once_init_enter (&wireless_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WirelessBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wireless_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WirelessBox), 0, (GInstanceInitFunc) wireless_box_instance_init, NULL };
		GType wireless_box_type_id;
		wireless_box_type_id = g_type_register_static (TYPE_DEVICE_BOX, "WirelessBox", &g_define_type_info, 0);
		g_once_init_leave (&wireless_box_type_id__volatile, wireless_box_type_id);
	}
	return wireless_box_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



